/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DefaultNSObject;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespaceException;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import java.util.Enumeration;
import java.util.Vector;

public class NDSObject
extends DefaultNSObject {
    private static final int CANT_SET_AUX_CLASSDEF = 1;

    public boolean addAuxiliaryClassDefinition(ClassDefinition classDefinition, ObjectAttribute[] objectAttributeArray) throws NamespaceException {
        boolean bl = super.addAuxiliaryClassDefinition(classDefinition, objectAttributeArray);
        ObjectAttribute objectAttribute = this.getAttribute("Object Class");
        if (objectAttribute == null) {
            throw NDSNamespaceException.NO_RIGHTS_TO_ADD_AUXILIARY_CLASS;
        }
        objectAttribute.addComponent(new StringValue(NDSSyntax.SYN_CLASS_NAME, classDefinition.getName()));
        return bl;
    }

    public boolean deleteAuxiliaryClassDefinition(ClassDefinition classDefinition) throws NamespaceException {
        boolean bl = super.deleteAuxiliaryClassDefinition(classDefinition);
        if (bl) {
            ObjectAttribute objectAttribute = this.getAttribute("Object Class");
            if (objectAttribute == null) {
                throw NDSNamespaceException.NO_RIGHTS_TO_REMOVE_AUXILIARY_CLASS;
            }
            objectAttribute.removeComponent(new StringValue(NDSSyntax.SYN_CLASS_NAME, classDefinition.getName()));
        }
        return bl;
    }

    public NSObject clone(ObjectEntry objectEntry) throws NamespaceException {
        ObjectType[] objectTypeArray;
        ObjectType[] objectTypeArray2;
        NDSObject nDSObject = null;
        if (objectEntry.getObjectType() == this.objectEntry.getObjectType() && (objectTypeArray2 = this.objectEntry.getSubTypes()).length == (objectTypeArray = objectEntry.getSubTypes()).length) {
            Vector<ObjectType> vector = new Vector<ObjectType>(objectTypeArray2.length);
            int n = 0;
            while (n < objectTypeArray2.length) {
                vector.addElement(objectTypeArray2[n]);
                ++n;
            }
            n = 0;
            while (n < objectTypeArray2.length) {
                if (!vector.contains(objectTypeArray[n])) {
                    throw NamespaceException.OBJECTTYPE_NOT_VALID;
                }
                ++n;
            }
            nDSObject = (NDSObject)this.clone();
            nDSObject.objectEntry = objectEntry;
            Enumeration enumeration = nDSObject.attributes.elements();
            while (enumeration.hasMoreElements()) {
                ObjectAttribute objectAttribute = (ObjectAttribute)enumeration.nextElement();
                NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)objectAttribute.getAttributeDefinition();
                if (!nDSAttributeDefinition.getAttributeFlag().isFlagSet(8)) continue;
                nDSObject.attributes.remove(nDSAttributeDefinition.getName());
            }
            ObjectAttribute objectAttribute = (ObjectAttribute)nDSObject.attributes.get("Object Class");
            String string = objectEntry.getObjectType().getName();
            StringValue stringValue = null;
            Enumeration enumeration2 = objectAttribute.getValueComponents();
            while (enumeration2.hasMoreElements()) {
                stringValue = (StringValue)enumeration2.nextElement();
                if (stringValue.getValue().equals(string)) break;
            }
            objectAttribute.removeAllComponents();
            objectAttribute.addComponent(stringValue);
        }
        if (nDSObject == null) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        return nDSObject;
    }

    protected void setClassDefinition() {
        if (this.classDefinition != null) {
            return;
        }
        try {
            this.classDefinition = new Vector(10);
            this.classDefinition.addElement(this.namespace.getClassDefinition(this.objectEntry, this.objectEntry.getObjectType().getName()));
            ObjectAttribute objectAttribute = this.getAttribute("Object Class");
            if (objectAttribute != null) {
                Enumeration enumeration = objectAttribute.getValueComponents();
                while (enumeration.hasMoreElements()) {
                    ClassDefinition classDefinition = this.namespace.getClassDefinition(this.objectEntry, enumeration.nextElement().toString());
                    if (!classDefinition.isAuxiliary()) continue;
                    this.classDefinition.addElement(classDefinition);
                }
            }
        }
        catch (SPIException sPIException) {
            throw new AdminError(1, this.getClass());
        }
        catch (NamespaceException namespaceException) {
            throw new AdminError(1, this.getClass());
        }
    }

    static /* synthetic */ ObjectEntry access$0(NDSObject nDSObject) {
        return nDSObject.objectEntry;
    }

    protected NDSObject(ObjectEntry objectEntry, Vector vector, long l) {
        super(objectEntry, vector, l);
    }
}

