/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.nds.NDSReplicaInfo;
import com.novell.admin.ns.nds.NDSReplicaType;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class NDSPartitionInfo {
    private String partitionFDN;
    private String servReadFDN;
    private String masterReplicaFDN;
    private Date lastSuccessfulSync;
    private Date lastAttemptSync;
    private int numReps = 0;
    private int numSubRefs = 0;
    private Vector repInfos;

    public String getPartitionFDN() {
        return this.partitionFDN;
    }

    public String getServerReadFDN() {
        return this.servReadFDN;
    }

    public String getMasterReplicaFDN() {
        return this.masterReplicaFDN;
    }

    public int getNumOfReplicas() {
        return this.numReps;
    }

    public int getNumOfSubRefs() {
        return this.numSubRefs;
    }

    public Date getLastSuccessfulSyncTime() {
        return this.lastSuccessfulSync;
    }

    public Date getLastAttemptedSyncTime() {
        return this.lastAttemptSync;
    }

    public Vector getNDSReplicas() {
        return (Vector)this.repInfos.clone();
    }

    public NDSPartitionInfo(String string, String string2, String string3, Date date, Date date2, Vector vector) {
        if (string != null && string2 != null && string3 != null && date != null && date2 != null && vector != null) {
            this.partitionFDN = string;
            this.servReadFDN = string2;
            this.masterReplicaFDN = string3;
            this.lastSuccessfulSync = date;
            this.lastAttemptSync = date2;
            this.repInfos = vector;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                NDSReplicaType nDSReplicaType = ((NDSReplicaInfo)enumeration.nextElement()).getReplicaType();
                if (nDSReplicaType == NDSReplicaType.SUBREF) {
                    ++this.numSubRefs;
                    continue;
                }
                if (nDSReplicaType != NDSReplicaType.MASTER && nDSReplicaType != NDSReplicaType.RO && nDSReplicaType != NDSReplicaType.RW) continue;
                ++this.numReps;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }
}

