/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DefaultSchemaDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSNamespaceException;
import com.novell.admin.ns.nds.NDSSchema;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.Vector;

public final class NDSSchemaDefinition
extends DefaultSchemaDefinition {
    private NDSSchema schema = null;
    private PropertyChangeSupport changeSupporter;
    private VetoableChangeSupport vetoSupporter;

    public void refreshSchema() throws PropertyVetoException {
        this.vetoSupporter.fireVetoableChange(null, this.schema, null);
        this.attributes.clear();
        this.classes.clear();
        this.schema.refreshSchema();
        this.changeSupporter.firePropertyChange(null, null, this.schema);
    }

    public void putAttributeDefinition(AttributeDefinition attributeDefinition) throws NDSNamespaceException, SPIException, PropertyVetoException {
        String string = attributeDefinition.getName();
        NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)this.attributes.get(string);
        if (nDSAttributeDefinition != null) {
            throw NDSNamespaceException.CANT_MODIFY_EXISTING_ATTRIBUTE;
        }
        this.vetoSupporter.fireVetoableChange(string, nDSAttributeDefinition, attributeDefinition);
        if (this.schema != null) {
            this.schema.writeAttributeDefinition((NDSAttributeDefinition)attributeDefinition);
        }
        this.attributes.put(string, attributeDefinition);
        this.changeSupporter.firePropertyChange(string, nDSAttributeDefinition, attributeDefinition);
    }

    public void putClassDefinition(ClassDefinition classDefinition) throws NamespaceException, SPIException, PropertyVetoException {
        NDSClassDefinition nDSClassDefinition = (NDSClassDefinition)classDefinition;
        AttributeDefinition[] attributeDefinitionArray = null;
        String string = classDefinition.getName();
        NDSClassDefinition nDSClassDefinition2 = (NDSClassDefinition)this.classes.get(string);
        String[] stringArray = nDSClassDefinition.getSuperClasses();
        int n = 0;
        while (n < stringArray.length) {
            if (!this.classes.containsKey(stringArray[n])) {
                throw NDSNamespaceException.SUPERCLASS_NOT_DEFINED;
            }
            ++n;
        }
        attributeDefinitionArray = classDefinition.getMandatoryAttributes();
        n = 0;
        while (n < attributeDefinitionArray.length) {
            if (!this.attributes.containsKey(attributeDefinitionArray[n].getName())) {
                throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
            }
            ++n;
        }
        if (nDSClassDefinition2 != null) {
            AttributeDefinition[] attributeDefinitionArray2 = nDSClassDefinition2.getMandatoryAttributes();
            if (attributeDefinitionArray.length == attributeDefinitionArray2.length) {
                Vector<AttributeDefinition> vector = new Vector<AttributeDefinition>(attributeDefinitionArray2.length);
                int n2 = 0;
                while (n2 < attributeDefinitionArray2.length) {
                    vector.addElement(attributeDefinitionArray2[n2]);
                    ++n2;
                }
                n2 = 0;
                while (n2 < attributeDefinitionArray2.length) {
                    if (!vector.contains(attributeDefinitionArray[n2])) {
                        throw NamespaceException.MODIFYING_MANDATORY_ATTRIBUTES_NOT_ALLOWED;
                    }
                    ++n2;
                }
            } else {
                throw NamespaceException.MODIFYING_MANDATORY_ATTRIBUTES_NOT_ALLOWED;
            }
        }
        attributeDefinitionArray = classDefinition.getOptionalAttributes();
        int n3 = 0;
        while (n3 < attributeDefinitionArray.length) {
            if (!this.attributes.containsKey(attributeDefinitionArray[n3].getName())) {
                throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
            }
            ++n3;
        }
        if (nDSClassDefinition2 != null && nDSClassDefinition2.getClassFlags().getFlags() != ((NDSClassDefinition)classDefinition).getClassFlags().getFlags()) {
            throw NamespaceException.MODIFY_CLASS_FLAGS_NOT_ALLOWED;
        }
        this.vetoSupporter.fireVetoableChange(string, nDSClassDefinition2, nDSClassDefinition);
        if (this.schema != null) {
            if (nDSClassDefinition2 != null) {
                this.schema.modifyClassDefinition((NDSClassDefinition)classDefinition);
            } else {
                this.schema.writeClassDefinition((NDSClassDefinition)classDefinition);
            }
        }
        this.classes.put(string, classDefinition);
        this.changeSupporter.firePropertyChange(string, nDSClassDefinition2, classDefinition);
    }

    public void removeAttributeDefinition(String string) throws NamespaceException, SPIException, PropertyVetoException {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(string);
        if (attributeDefinition == null) {
            return;
        }
        ClassDefinition[] classDefinitionArray = this.getClassesUsingAttribute(string);
        if (classDefinitionArray.length != 0) {
            throw NamespaceException.ATTRIBUTE_IN_USE;
        }
        this.vetoSupporter.fireVetoableChange(string, attributeDefinition, null);
        if (this.schema != null) {
            this.schema.deleteAttributeDefinition((NDSAttributeDefinition)attributeDefinition);
        }
        this.attributes.remove(string);
        this.changeSupporter.firePropertyChange(string, attributeDefinition, null);
    }

    public void removeClassDefinition(String string) throws NamespaceException, SPIException, PropertyVetoException {
        ClassDefinition[] classDefinitionArray = this.getSubClasses(string);
        NDSClassDefinition nDSClassDefinition = this.getUnexpandedClassDefinition(string);
        if (classDefinitionArray.length != 0) {
            throw NamespaceException.CLASS_IN_USE;
        }
        this.vetoSupporter.fireVetoableChange(string, nDSClassDefinition, null);
        if (this.schema != null) {
            this.schema.deleteClassDefinition(nDSClassDefinition);
        }
        this.classes.remove(string);
        this.changeSupporter.firePropertyChange(string, nDSClassDefinition, null);
    }

    public ClassDefinition[] getEffectiveClasses(String string) {
        Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
        try {
            if (this.getUnexpandedClassDefinition(string).isContainer()) {
                Enumeration enumeration = this.classes.elements();
                while (enumeration.hasMoreElements()) {
                    NDSClassDefinition nDSClassDefinition = (NDSClassDefinition)enumeration.nextElement();
                    if (!nDSClassDefinition.isEffective() || !this.canContain(string, nDSClassDefinition.getName()) && (!nDSClassDefinition.getClassFlags().isFlagSet(16) || nDSClassDefinition.getName().equals("Top"))) continue;
                    try {
                        vector.addElement(this.getClassDefinition(nDSClassDefinition.getName()));
                    }
                    catch (NamespaceException namespaceException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        Object[] objectArray = new ClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NDSClassDefinition getUnexpandedClassDefinition(String string) throws NamespaceException {
        NDSClassDefinition nDSClassDefinition = (NDSClassDefinition)this.classes.get(string);
        if (nDSClassDefinition != null) {
            return nDSClassDefinition;
        }
        throw NamespaceException.CLASS_NOT_DEFINED;
    }

    public ClassDefinition getClassDefinition(String string) throws NamespaceException {
        NDSClassDefinition nDSClassDefinition = this.getUnexpandedClassDefinition(string);
        ClassDefinition[] classDefinitionArray = this.getSuperClasses(string);
        ClassDefinition[] classDefinitionArray2 = this.getContainmentClasses(string);
        AttributeDefinition[] attributeDefinitionArray = this.getOptionalAttributes(string);
        AttributeDefinition[] attributeDefinitionArray2 = this.getMandatoryAttributes(string);
        AttributeDefinition[] attributeDefinitionArray3 = this.getNamingAttributes(string);
        String[] stringArray = new String[classDefinitionArray.length];
        String[] stringArray2 = new String[classDefinitionArray2.length];
        int n = 0;
        while (n < classDefinitionArray.length) {
            stringArray[n] = classDefinitionArray[n].getName();
            ++n;
        }
        n = 0;
        while (n < classDefinitionArray2.length) {
            stringArray2[n] = classDefinitionArray2[n].getName();
            ++n;
        }
        NDSClassDefinition nDSClassDefinition2 = new NDSClassDefinition(nDSClassDefinition.getName(), nDSClassDefinition.getClassFlags(), stringArray2, stringArray, attributeDefinitionArray2, attributeDefinitionArray3, attributeDefinitionArray, nDSClassDefinition.getASN1Data());
        nDSClassDefinition2.setExpanded(true);
        return nDSClassDefinition2;
    }

    public ClassDefinition[] getSuperClasses(String string) throws NamespaceException {
        NDSClassDefinition nDSClassDefinition = this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllSuperClassesOf(nDSClassDefinition, vector);
        Object[] objectArray = new ClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ClassDefinition[] getContainmentClasses(String string) throws NamespaceException {
        NDSClassDefinition nDSClassDefinition = this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllContainmentClassesOf(nDSClassDefinition, vector);
        Object[] objectArray = new ClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ClassDefinition[] getSubClasses(String string) {
        Vector<NDSClassDefinition> vector = new Vector<NDSClassDefinition>(10, 10);
        Object[] objectArray = null;
        ClassDefinition[] classDefinitionArray = this.getClassDefinitions();
        int n = 0;
        while (n < classDefinitionArray.length) {
            NDSClassDefinition nDSClassDefinition = (NDSClassDefinition)classDefinitionArray[n];
            if (nDSClassDefinition.isInheritedFrom(string)) {
                vector.addElement(nDSClassDefinition);
            }
            ++n;
        }
        objectArray = new NDSClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getNamingAttributes(String string) throws NamespaceException {
        NDSClassDefinition nDSClassDefinition = this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllNamingAttributes(nDSClassDefinition, vector);
        Object[] objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getOptionalAttributes(String string) throws NamespaceException {
        NDSClassDefinition nDSClassDefinition = this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllOptionalAttributes(nDSClassDefinition, vector);
        Object[] objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getMandatoryAttributes(String string) throws NamespaceException {
        NDSClassDefinition nDSClassDefinition = this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllMandatoryAttributes(nDSClassDefinition, vector);
        Object[] objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object clone() {
        NDSSchemaDefinition nDSSchemaDefinition = (NDSSchemaDefinition)super.clone();
        nDSSchemaDefinition.schema = null;
        nDSSchemaDefinition.changeSupporter = new PropertyChangeSupport(nDSSchemaDefinition);
        nDSSchemaDefinition.vetoSupporter = new VetoableChangeSupport(nDSSchemaDefinition);
        return nDSSchemaDefinition;
    }

    public void addAttributeDefinition(AttributeDefinition attributeDefinition) {
        String string = attributeDefinition.getName();
        this.attributes.put(string, attributeDefinition);
    }

    public void addClassDefinition(ClassDefinition classDefinition) {
        String string = classDefinition.getName();
        this.classes.put(string, classDefinition);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoSupporter.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoSupporter.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupporter.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupporter.removePropertyChangeListener(propertyChangeListener);
    }

    private void getAllSuperClassesOf(NDSClassDefinition nDSClassDefinition, Vector vector) throws NamespaceException {
        String[] stringArray = nDSClassDefinition.getSuperClasses();
        int n = 0;
        while (n < stringArray.length) {
            NDSClassDefinition nDSClassDefinition2 = this.getUnexpandedClassDefinition(stringArray[n]);
            vector.addElement(nDSClassDefinition2);
            this.getAllSuperClassesOf(nDSClassDefinition2, vector);
            ++n;
        }
    }

    private void getAllContainmentClassesOf(NDSClassDefinition nDSClassDefinition, Vector vector) throws NamespaceException {
        String[] stringArray = nDSClassDefinition.getContainmentClasses();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(this.getUnexpandedClassDefinition(stringArray[n]));
            ++n;
        }
        if (stringArray.length > 0) {
            return;
        }
        String[] stringArray2 = nDSClassDefinition.getSuperClasses();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.getAllContainmentClassesOf(this.getUnexpandedClassDefinition(stringArray2[n2]), vector);
            ++n2;
        }
    }

    private void getAllNamingAttributes(NDSClassDefinition nDSClassDefinition, Vector vector) throws NamespaceException {
        AttributeDefinition[] attributeDefinitionArray = nDSClassDefinition.getNamingAttributes();
        int n = 0;
        while (n < attributeDefinitionArray.length) {
            vector.addElement(attributeDefinitionArray[n]);
            ++n;
        }
        if (attributeDefinitionArray.length > 0) {
            return;
        }
        String[] stringArray = nDSClassDefinition.getSuperClasses();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.getAllNamingAttributes(this.getUnexpandedClassDefinition(stringArray[n2]), vector);
            ++n2;
        }
    }

    private void getAllOptionalAttributes(NDSClassDefinition nDSClassDefinition, Vector vector) throws NamespaceException {
        Vector<NDSClassDefinition> vector2 = new Vector<NDSClassDefinition>();
        vector2.addElement(nDSClassDefinition);
        this.getAllSuperClassesOf(nDSClassDefinition, vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            NDSClassDefinition nDSClassDefinition2 = (NDSClassDefinition)enumeration.nextElement();
            AttributeDefinition[] attributeDefinitionArray = nDSClassDefinition2.getOptionalAttributes();
            int n = 0;
            while (n < attributeDefinitionArray.length) {
                vector.addElement(attributeDefinitionArray[n]);
                ++n;
            }
        }
    }

    private void getAllMandatoryAttributes(NDSClassDefinition nDSClassDefinition, Vector vector) throws NamespaceException {
        Vector<NDSClassDefinition> vector2 = new Vector<NDSClassDefinition>();
        vector2.addElement(nDSClassDefinition);
        this.getAllSuperClassesOf(nDSClassDefinition, vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            NDSClassDefinition nDSClassDefinition2 = (NDSClassDefinition)enumeration.nextElement();
            AttributeDefinition[] attributeDefinitionArray = nDSClassDefinition2.getMandatoryAttributes();
            int n = 0;
            while (n < attributeDefinitionArray.length) {
                vector.addElement(attributeDefinitionArray[n]);
                ++n;
            }
        }
    }

    public NDSSchemaDefinition(NDSSchema nDSSchema) {
        this.schema = nDSSchema;
        this.changeSupporter = new PropertyChangeSupport(this);
        this.vetoSupporter = new VetoableChangeSupport(this);
    }
}

