/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class OctetListFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;
    private static final int ADD_OCTET_1 = 2;
    private static final int ADD_OCTET_2 = 3;
    private static final int REMOVE_OCTET = 4;

    public static ValueList createValueList(byte[][] byArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        while (n < byArray.length) {
            vector.addElement(byArray[n]);
            ++n;
        }
        try {
            ValueComponent valueComponent = NDSSyntax.SYN_OCTET_LIST.createValueComponent(vector);
            return (ValueList)valueComponent;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.nds.OctetListFacade");
        }
    }

    public byte[][] getOctets() {
        int n = this.valueList.getComponentCount();
        byte[][] byArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            HexValue hexValue = (HexValue)this.valueList.getElementAt(n2);
            byArray[n2] = hexValue.getValue();
            ++n2;
        }
        return byArray;
    }

    public byte[] getOctet(int n) throws ArrayIndexOutOfBoundsException {
        HexValue hexValue = (HexValue)this.valueList.getElementAt(n);
        return hexValue.getValue();
    }

    public void setOctet(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        this.replaceHexValue(byArray, n);
    }

    public void addOctet(byte[] byArray) {
        try {
            ValueComponent valueComponent = NDSSyntax.SYN_OCTET_STRING.createValueComponent(byArray);
            if (!this.valueList.insertComponent(valueComponent)) {
                throw new AdminError(2, this.getClass());
            }
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(3, this.getClass());
        }
    }

    public void removeOctet(int n) throws ArrayIndexOutOfBoundsException {
        ValueComponent valueComponent = this.valueList.getElementAt(n);
        if (!this.valueList.removeComponent(valueComponent)) {
            throw new AdminError(4, this.getClass());
        }
    }

    public void replaceOctet(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        this.replaceHexValue(byArray, n);
    }

    public OctetListFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != NDSSyntax.SYN_OCTET_LIST) {
            throw new IncompatibleComponentException();
        }
    }
}

