/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.directory;

import com.novell.gw.directory.ChkOpts;
import com.novell.gw.directory.FFilter;
import com.novell.gw.directory.FKey;
import com.novell.gw.directory.FObj;
import com.novell.gw.directory.FObjIterator;
import com.novell.gw.directory.FView;
import com.novell.gw.directory.GWInformation;
import com.novell.gw.directory.GwCallBack;
import com.novell.gw.directory.util.PathException;
import com.novell.gw.directory.util1.Data;
import com.novell.gw.util.Debug;
import com.novell.gw.util.EngineResource;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class FDoc {
    private boolean finalizeFlag = false;
    private int ptr;
    private int deleteError = 0;
    private String systemGUID;
    private String gwEngineDir;
    private String linuxMountDir;
    private static final int[] data;

    private native void cleanup();

    private native void init(String var1, String var2, String var3);

    private native boolean open(String var1, String var2, boolean var3, boolean var4, boolean var5) throws PathException;

    private native int turnCallBacksOn(GwCallBack var1);

    private native void turnCallBacksOff();

    private native int deleteObject(FObj var1);

    private native int deleteDirStruct(FObj var1, String var2) throws PathException;

    private native FObjIterator elements(int var1, int var2, FKey var3, FView var4, FFilter var5, int var6);

    private native FObj getObject(String var1, String var2, String var3, int var4);

    private native FObj getObject(int var1, FKey var2, FView var3, int var4);

    private native FObj getObject(int var1, FKey var2, FView var3, int var4, FFilter var5);

    private native FObj getObjectByDRN(int var1, int var2);

    public native FObj getEmptyLabelObject();

    public native FKey getKey();

    public native FView getView();

    public native FFilter getFilter();

    private native int canDelete(FObj var1);

    private native int getIndexCount(int var1, int var2, FKey var3);

    public native int getVersion();

    private native boolean getAdminPreference(String var1);

    private native void setAdminPreference(String var1, boolean var2);

    private native int syncRecord(FObj var1);

    private native int sendRestoreTask(String var1, String var2, String var3);

    public static native ChkOpts getChkOpts();

    public native ChkOpts getChkOpts(String var1);

    public native String getLanguageString(int var1);

    public native String getRestoreAreaPath(int var1, String var2, String var3, String var4);

    public native String getRestoreAreaName(String var1, String var2, String var3);

    public native int replaceDomainDB(String var1, String var2);

    public native int validateDB(String var1, int var2);

    public native int recoverDB(String var1, String var2, String var3, int var4);

    public native int rebuildDB(String var1, String var2, String var3);

    public native int reclaimDBSpace(String var1, String var2, String var3);

    public native int resetAdminDBIndexes(String var1, String var2, String var3);

    public native int syncPrimaryWithSecondary(String var1, String var2);

    public native int mergeSystem(String var1, String var2, boolean var3);

    public native int releaseDomain(String var1, String var2, String var3);

    public native int changePrimary(String var1, String var2);

    public native int sendSetTimestampTask(String var1, String var2, String var3, int var4, int var5);

    public native String testCustomAddress(String var1, String[] var2, String[] var3);

    private native int requestAllExtSysInfo(String var1);

    public native void loadEngResource(String var1);

    public native String loadEngErrStr(int var1);

    public native String loadMoveUserStatusStr(int var1);

    private native void checkAgentRestart();

    private native boolean doesMailIDExist(String var1);

    private native FObj getAddressBookView(int var1, String var2);

    private native int putAddressBookView(FObj var1, int var2, String var3);

    private native String[] getNdsDsFieldMap();

    private native int gwSystemDefinition(int var1, int var2, int var3, int var4, int var5, boolean var6);

    private native boolean canCreate(int var1, String var2, String var3);

    private native FObj getObjectByEMailAddress(String var1);

    private native GWInformation getGWInformation(FObj var1);

    public static native boolean isNameValid(String var0, int var1);

    public native String authenticateUser(String var1, String var2, String var3, String var4);

    public native String getCurrentDomainName();

    public native String getCurrentAdminVersion();

    public native String getPrimaryDomainName();

    private native int clearCompletedMoveStatus();

    private native int clearSingleCompletedMoveStatus(String var1, String var2, String var3);

    private native int sendMoveForceComplete(String var1, String var2, String var3);

    private native int sendMoveRestart(String var1, String var2, String var3);

    private native int sendMoveRetry(String var1, String var2, String var3);

    private native int sendMoveInhibit(String var1, String var2, String var3);

    private native int sendMoveUpdate(String var1, String var2, String var3);

    private native int sendMovePending(String var1, String var2, String var3);

    public native int checkAdminVersion(String var1);

    private native int compareCurrentAdminDate(String var1, int var2);

    private native int compareCurrentAdminVersion(String var1);

    private native String getSystemGUID();

    public static native String getPlatformStr();

    private static native void initIDs();

    private native int getIOStatus();

    public native void setAdminName(String var1, String var2);

    private native String getGlobalSignature(String var1, String var2);

    private native String[] getGlobalSignatures(String var1, String var2);

    private native String[] getGlobalSignatureList();

    private native int putGlobalSignature(String var1, String var2, String var3, String var4);

    private native int deleteGlobalSignature(String var1);

    private native int sendRefreshViewsTask(String var1, String var2);

    private native String getPOSoftwareAreaName(String var1, String var2);

    public native boolean isIDomainLocal(String var1);

    FDoc(String string, String string2, String string3, String string4) {
        this.gwEngineDir = string3;
        this.linuxMountDir = string4;
        this.init(string, string2, string3);
        Debug.trace((String)("Platform = " + FDoc.getPlatformStr()));
    }

    private void checkIOStatus() throws CommunicationException {
        int n = this.getIOStatus();
        if ((n & 0xFF00) == 33280) {
            String string = Integer.toHexString(n).toUpperCase();
            String string2 = this.loadEngErrStr(n) + "  (0x" + string + ")";
            throw new CommunicationException(string2);
        }
    }

    public String getTheSystemGUID() throws CommunicationException {
        if (this.systemGUID == null || this.systemGUID.length() == 0) {
            this.systemGUID = this.getSystemGUID();
            this.checkIOStatus();
        }
        return this.systemGUID;
    }

    public FObjIterator getElements(int n, int n2, FKey fKey, FView fView, FFilter fFilter) throws CommunicationException {
        FObjIterator fObjIterator = this.elements(n, n2, fKey, fView, fFilter, 0);
        fObjIterator.setFDoc(this);
        this.checkIOStatus();
        return fObjIterator;
    }

    public FObjIterator getElements(int n, int n2, FKey fKey, FView fView, FFilter fFilter, int n3) throws CommunicationException {
        FObjIterator fObjIterator = this.elements(n, n2, fKey, fView, fFilter, n3);
        fObjIterator.setFDoc(this);
        this.checkIOStatus();
        return fObjIterator;
    }

    public String getGWGlobalSignature(String string) throws CommunicationException {
        String string2 = null;
        String string3 = System.getProperty("java.io.tmpdir");
        Debug.trace((String)"FDoc.getGWGlobalSignature");
        if (string3 == null) {
            string3 = System.getProperty("user.dir");
            Debug.trace((String)" using user.dir");
        }
        Debug.trace((String)(" tempDirPath: " + string3));
        string2 = this.getGlobalSignature(string3, string);
        this.checkIOStatus();
        return string2;
    }

    public String[] getGWGlobalSignatures(String string) throws CommunicationException {
        String[] stringArray = null;
        String string2 = System.getProperty("java.io.tmpdir");
        Debug.trace((String)"FDoc.getGWGlobalSignatures");
        if (string2 == null) {
            string2 = System.getProperty("user.dir");
            Debug.trace((String)" using user.dir");
        }
        Debug.trace((String)(" tempDirPath: " + string2));
        stringArray = this.getGlobalSignatures(string2, string);
        this.checkIOStatus();
        return stringArray;
    }

    public String[] getGWGlobalSignatureList() throws CommunicationException {
        String[] stringArray = null;
        stringArray = this.getGlobalSignatureList();
        this.checkIOStatus();
        return stringArray;
    }

    public String getGWPOSoftwareAreaName(String string, String string2) throws CommunicationException {
        String string3 = null;
        string3 = this.getPOSoftwareAreaName(string, string2);
        this.checkIOStatus();
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (!this.finalizeFlag) {
            this.finalizeFlag = true;
            System.runFinalization();
            try {
                this.cleanup();
                Object var2_1 = null;
                this.ptr = 0;
                this.systemGUID = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.ptr = 0;
                this.systemGUID = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
            {
            }
        }
    }

    public boolean openDB(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CommunicationException, PathException {
        boolean bl5 = false;
        bl5 = this.open(string, this.linuxMountDir, bl, bl3, bl4);
        if (bl5 && !bl3) {
            int n = this.gwSystemDefinition(data[0], data[1], data[2], data[3], data[4], bl2);
            this.checkIOStatus();
        }
        return bl5;
    }

    public int compareAdminDate(int n) {
        return this.compareCurrentAdminDate(this.gwEngineDir, n);
    }

    public int compareAdminVersion(String string) {
        return this.compareCurrentAdminVersion(string);
    }

    public int callBacksOn(GwCallBack gwCallBack) {
        return this.turnCallBacksOn(gwCallBack);
    }

    public void callBacksOff() {
        this.turnCallBacksOff();
    }

    public boolean canDeleteObject(FObj fObj) throws CommunicationException {
        boolean bl = false;
        if (fObj.getNewObjectType() < 30100) {
            this.deleteError = this.canDelete(fObj);
            this.checkIOStatus();
            if (this.deleteError == 0) {
                bl = true;
            }
        }
        return bl;
    }

    public int deleteObj(FObj fObj) throws CommunicationException {
        int n = this.deleteObject(fObj);
        this.checkIOStatus();
        return n;
    }

    public int deleteGWDirStruct(FObj fObj) throws CommunicationException, PathException {
        int n = 55047;
        n = this.deleteDirStruct(fObj, this.linuxMountDir);
        this.checkIOStatus();
        return n;
    }

    public int getDeleteError() {
        return this.deleteError;
    }

    public int clearGWCompletedMoveStatus() throws CommunicationException {
        int n = this.clearCompletedMoveStatus();
        this.checkIOStatus();
        return n;
    }

    public int clearGWSingleCompletedMoveStatus(String string, String string2, String string3) throws CommunicationException {
        int n = this.clearSingleCompletedMoveStatus(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public void checkSendAgentRestart() throws CommunicationException {
        this.checkAgentRestart();
        this.checkIOStatus();
    }

    public boolean doesGWMailIDExist(String string) throws CommunicationException {
        boolean bl = this.doesMailIDExist(string);
        this.checkIOStatus();
        return bl;
    }

    public GWInformation getGWInfo(FObj fObj) throws CommunicationException {
        GWInformation gWInformation = this.getGWInformation(fObj);
        this.checkIOStatus();
        return gWInformation;
    }

    public FObj getGWObject(String string, String string2, String string3, int n) throws CommunicationException {
        FObj fObj = this.getObject(string, string2, string3, n);
        this.checkIOStatus();
        return fObj;
    }

    public FObj getGWObject(int n, FKey fKey, FView fView, int n2) throws CommunicationException {
        FObj fObj = this.getObject(n, fKey, fView, n2);
        this.checkIOStatus();
        return fObj;
    }

    public FObj getGWObject(int n, FKey fKey, FView fView, int n2, FFilter fFilter) throws CommunicationException {
        FObj fObj = this.getObject(n, fKey, fView, n2, fFilter);
        this.checkIOStatus();
        return fObj;
    }

    public FObj getGWObjectByDRN(int n, int n2) throws CommunicationException {
        FObj fObj = this.getObjectByDRN(n, n2);
        this.checkIOStatus();
        return fObj;
    }

    public FObj getGWObjectByEMailAddress(String string) throws CommunicationException {
        FObj fObj = this.getObjectByEMailAddress(string);
        this.checkIOStatus();
        return fObj;
    }

    public FObj getGWAddressBookView(int n, String string) throws CommunicationException {
        FObj fObj = this.getAddressBookView(n, string);
        this.checkIOStatus();
        return fObj;
    }

    public int putGWAddressBookView(FObj fObj, int n, String string) throws CommunicationException {
        int n2 = this.putAddressBookView(fObj, n, string);
        this.checkIOStatus();
        return n2;
    }

    public int putGWGlobalSignature(String string, String string2, String string3) throws CommunicationException {
        String string4 = System.getProperty("java.io.tmpdir");
        if (string4 == null) {
            string4 = System.getProperty("user.dir");
        }
        int n = this.putGlobalSignature(string4, string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int deleteGWGlobalSignature(String string) throws CommunicationException {
        int n = this.deleteGlobalSignature(string);
        this.checkIOStatus();
        return n;
    }

    public boolean getGWAdminPreference(String string) throws CommunicationException {
        boolean bl = this.getAdminPreference(string);
        this.checkIOStatus();
        return bl;
    }

    public int requestAllGWExtSysInfo(String string) throws CommunicationException {
        int n = this.requestAllExtSysInfo(string);
        this.checkIOStatus();
        return n;
    }

    public int sendGWMoveForceComplete(String string, String string2, String string3) throws CommunicationException {
        int n = this.sendMoveForceComplete(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int sendGWMoveRestart(String string, String string2, String string3) throws CommunicationException {
        int n = this.sendMoveRestart(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int sendGWMoveRetry(String string, String string2, String string3) throws CommunicationException {
        int n = this.sendMoveRetry(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int sendGWMoveInhibit(String string, String string2, String string3) throws CommunicationException {
        int n = this.sendMoveInhibit(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int sendGWMoveUpdate(String string, String string2, String string3) throws CommunicationException {
        int n = this.sendMoveUpdate(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int sendGWMovePending(String string, String string2, String string3) throws CommunicationException {
        int n = this.sendMovePending(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int sendGWRefreshViewsTask(String string, String string2) throws CommunicationException {
        int n = this.sendRefreshViewsTask(string, string2);
        this.checkIOStatus();
        return n;
    }

    public int sendGWRestoreTask(String string, String string2, String string3) throws CommunicationException {
        int n = this.sendRestoreTask(string, string2, string3);
        this.checkIOStatus();
        return n;
    }

    public int syncGWRecord(FObj fObj) throws CommunicationException {
        int n = this.syncRecord(fObj);
        this.checkIOStatus();
        return n;
    }

    public void setGWAdminPreference(String string, boolean bl) throws CommunicationException {
        this.setAdminPreference(string, bl);
        this.checkIOStatus();
    }

    public String[] getGWNdsDsFieldMap() throws CommunicationException {
        String[] stringArray = this.getNdsDsFieldMap();
        this.checkIOStatus();
        return stringArray;
    }

    public boolean canGWCreate(int n, String string, String string2) throws CommunicationException {
        boolean bl = this.canCreate(n, string, string2);
        this.checkIOStatus();
        return bl;
    }

    public FObj getObjectInstance(Name name, int n) throws NamingException {
        int n2 = name.size();
        if (n2 < 1 || n2 > 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + name);
        }
        if (n == 0) {
            switch (n2) {
                case 1: {
                    n = 101;
                    break;
                }
                case 2: {
                    n = 122;
                    break;
                }
                case 3: {
                    n = 106;
                    break;
                }
                default: {
                    throw new NameNotFoundException();
                }
            }
        }
        FObj fObj = this.getObject(name.get(0), n2 > 1 ? name.get(1) : "", n2 > 2 ? name.get(2) : "", n);
        this.checkIOStatus();
        return fObj;
    }

    public boolean doesObjectExist(Name name) throws NamingException {
        int n = 0;
        int n2 = name.size();
        if (n2 < 1) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + name);
        }
        if (name.get(0).equals("{SYSTEM RECORDS}")) {
            if (name.size() == 1) {
                n = 1;
            } else {
                FKey fKey = this.getKey();
                if (name.get(1).equals("{TIME ZONE RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50088, name.get(2));
                        int n3 = 103;
                        int n4 = 238;
                        n = this.getIndexCount(n3, n4, fKey);
                    }
                } else if (name.get(1).equals("{RESTORE AREA RECORDS}") || name.get(1).equals("{SOFTWARE AREA RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50073, name.get(2));
                        int n5 = 109;
                        int n6 = 293;
                        n = this.getIndexCount(n5, n6, fKey);
                    }
                } else if (name.get(1).equals("{ACTION RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50155, name.get(2));
                        int n7 = 131;
                        int n8 = 288;
                        n = this.getIndexCount(n7, n8, fKey);
                    }
                } else if (name.get(1).equals("{CUSTOM ADDRESS RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50125, name.get(2));
                        int n9 = 129;
                        int n10 = 290;
                        n = this.getIndexCount(n9, n10, fKey);
                    }
                } else if (name.get(1).equals("{EVENT RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50155, name.get(2));
                        int n11 = 130;
                        int n12 = 289;
                        n = this.getIndexCount(n11, n12, fKey);
                    }
                } else if (name.get(1).equals("{IDOMAIN RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50155, name.getSuffix(2).toString());
                        int n13 = 146;
                        int n14 = 371;
                        n = this.getIndexCount(n13, n14, fKey);
                    }
                } else if (name.get(1).equals("{MTA PROFILE RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50155, name.getSuffix(2).toString());
                        int n15 = 138;
                        int n16 = 351;
                        n = this.getIndexCount(n15, n16, fKey);
                    }
                } else if (name.get(1).equals("{TRUSTED APPLICATION RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50155, name.get(2));
                        int n17 = 147;
                        int n18 = 380;
                        n = this.getIndexCount(n17, n18, fKey);
                    }
                } else if (name.get(1).equals("{LDAP SERVER RECORDS}")) {
                    if (name.size() == 2) {
                        n = 1;
                    } else {
                        fKey.add(50155, name.get(2));
                        int n19 = 148;
                        int n20 = 383;
                        n = this.getIndexCount(n19, n20, fKey);
                    }
                } else {
                    fKey.add(50155, name.get(1));
                    int n21 = 145;
                    int n22 = 366;
                    n = this.getIndexCount(n21, n22, fKey);
                }
            }
        } else {
            if (n2 > 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + name);
            }
            FKey fKey = this.getKey();
            fKey.add(50035, name.get(0));
            int n23 = 101;
            int n24 = 232;
            if (n2 > 1) {
                fKey.add(50062, name.get(1));
                n23 = 122;
                n24 = 233;
            }
            if (n2 > 2) {
                fKey.add(50073, name.get(2));
                n23 = 106;
                n24 = 231;
            }
            if ((n = this.getIndexCount(n23, n24, fKey)) == 0) {
                fKey = this.getKey();
                fKey.add(50035, name.get(0));
                if (n2 == 2) {
                    fKey.add(50162, name.get(1));
                    n23 = 127;
                    n24 = 265;
                    n = this.getIndexCount(n23, n24, fKey);
                } else if (n2 > 2) {
                    fKey.add(50062, name.get(1));
                    fKey.add(50012, name.get(2));
                    n23 = 117;
                    n24 = 239;
                    n = this.getIndexCount(n23, n24, fKey);
                    if (n == 0) {
                        fKey = this.getKey();
                        fKey.add(50035, name.get(0));
                        fKey.add(50062, name.get(1));
                        fKey.add(50073, name.get(2));
                        n23 = 109;
                        n24 = 293;
                        n = this.getIndexCount(n23, n24, fKey);
                    }
                }
            }
        }
        this.checkIOStatus();
        return n > 0;
    }

    static {
        int[] nArray = null;
        try {
            System.loadLibrary("gwadj2");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary("gwadj1");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                throw unsatisfiedLinkError;
            }
        }
        FDoc.initIDs();
        try {
            nArray = Data.getData();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            try {
                nArray = com.novell.gw.directory.util3.Data.getData();
            }
            catch (NoClassDefFoundError noClassDefFoundError2) {
                nArray = new int[]{1, 1, 2, 0, 2};
            }
        }
        data = nArray;
    }
}

