/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.ConsoleShell;
import com.novell.application.console.shell.D;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.Stoppable;
import com.novell.application.console.snapin.ViewSnapin;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;

class ActivityBar {
    private JButton stopButton;
    private ConsoleShell m_console;
    private boolean bBusy = false;
    private ViewSnapin currentBusyView = null;
    private ArrayList busyList = new ArrayList();

    synchronized void setBusy(Object object, boolean bl, int n) {
        if (n == 1 && object != this.m_console.getViewManager().getCurrentBusyView()) {
            D.out("Trying to set activity indicator busy with an inactive view " + object);
            return;
        }
        this.updateStopButtonState();
    }

    void setStopButton(JButton jButton) {
        this.stopButton = NConeFactory.novellJButton(jButton, jButton.getName(), "");
    }

    void updateStopButtonState() {
        if (this.stopButton != null) {
            this.stopButton.setEnabled(this.enableStop());
        }
    }

    public boolean isBusy() {
        return this.bBusy;
    }

    public synchronized void changedView(ViewSnapin viewSnapin) {
        int n = 0;
        while (n < this.busyList.size()) {
            BusyListItem busyListItem = (BusyListItem)this.busyList.get(n);
            if (busyListItem.isThisItem(viewSnapin)) {
                this.busyList.remove(n);
                break;
            }
            ++n;
        }
    }

    public synchronized void updateBusyObjects(Object object, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < this.busyList.size()) {
            BusyListItem busyListItem = (BusyListItem)this.busyList.get(n);
            if (busyListItem.isThisItem(object)) {
                int n2 = bl ? busyListItem.incCount() : busyListItem.decCount();
                if (n2 == 0) {
                    this.busyList.remove(n);
                }
                bl2 = true;
                break;
            }
            ++n;
        }
        if (!bl2 && bl) {
            ActivityBar activityBar = this;
            if (activityBar == null) {
                throw null;
            }
            this.busyList.add(activityBar.new BusyListItem(object));
        }
    }

    public void setBusyView(ViewSnapin viewSnapin) {
        this.currentBusyView = viewSnapin;
    }

    public synchronized void stop() {
        ViewSnapin viewSnapin = this.m_console.getViewManager().getCurrentBusyView();
        boolean bl = false;
        int n = 0;
        while (n < this.busyList.size()) {
            BusyListItem busyListItem = (BusyListItem)this.busyList.get(n);
            if (busyListItem.getComponent() instanceof Stoppable) {
                Stoppable stoppable = (Stoppable)busyListItem.getComponent();
                stoppable.stop();
                if (stoppable == viewSnapin) {
                    bl = true;
                }
            }
            ++n;
        }
        if (!bl && viewSnapin != null && viewSnapin instanceof Stoppable) {
            ((Stoppable)((Object)viewSnapin)).stop();
        }
        this.updateStopButtonState();
    }

    public boolean enableStop() {
        int n = 0;
        while (n < this.busyList.size()) {
            Stoppable stoppable;
            BusyListItem busyListItem = (BusyListItem)this.busyList.get(n);
            if (busyListItem.getComponent() instanceof Stoppable && (stoppable = (Stoppable)busyListItem.getComponent()).canStopNow()) {
                return true;
            }
            ++n;
        }
        ViewSnapin viewSnapin = this.m_console.getViewManager().getCurrentBusyView();
        return viewSnapin != null && viewSnapin instanceof Stoppable && ((Stoppable)((Object)viewSnapin)).canStopNow();
    }

    ActivityBar(ConsoleShell consoleShell) {
        this.m_console = consoleShell;
    }

    class NonFocusButton
    extends JButton {
        public boolean isFocusTraversable() {
            return false;
        }

        NonFocusButton() {
            this.setFocusPainted(false);
        }

        NonFocusButton(Icon icon) {
            super(icon);
            this.setFocusPainted(false);
        }
    }

    private class BusyListItem {
        Object component = null;
        int count = 1;

        public boolean isThisItem(Object object) {
            return this.component == object;
        }

        public int incCount() {
            ++this.count;
            return this.count;
        }

        public int decCount() {
            if (this.count > 0) {
                --this.count;
            }
            return this.count;
        }

        public Object getComponent() {
            return this.component;
        }

        public BusyListItem(Object object) {
            this.component = object;
        }
    }
}

