/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.ConsoleShell;
import com.novell.application.console.shell.ShellStubs;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Stack;
import javax.swing.FocusManager;
import javax.swing.JComponent;

public class ConsoleFocusManager
extends FocusManager {
    Stack history = new Stack();
    private ConsoleShell console;

    public void processKeyEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t') {
            JComponent jComponent;
            if (component instanceof JComponent && (jComponent = (JComponent)component).isManagingFocus() && (keyEvent.getModifiers() & 2) != 2) {
                return;
            }
            if (keyEvent.getID() != 401) {
                keyEvent.consume();
                return;
            }
            if ((keyEvent.getModifiers() & 1) == 1) {
                this.focusPreviousComponent(component);
            } else {
                this.focusNextComponent(component);
            }
            keyEvent.consume();
        }
    }

    public void focusNextComponent(Component component) {
        if (component instanceof JComponent) {
            Component component2;
            JComponent jComponent = (JComponent)component;
            Container container = this.getFocusRoot(jComponent);
            if (!this.history.empty() && this.history.peek() != component) {
                this.history.removeAllElements();
            }
            if (container != null && (component2 = this.getFocusableComponentAfter(jComponent, container, true)) != null) {
                if (this.history.empty() || this.history.peek() == component) {
                    this.history.push(component2);
                }
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).grabFocus();
                } else {
                    component2.requestFocus();
                }
            }
        }
    }

    public void focusPreviousComponent(Component component) {
        if (component instanceof JComponent) {
            Component component2;
            JComponent jComponent = (JComponent)component;
            Container container = this.getFocusRoot(jComponent);
            if (!this.history.empty() && this.history.peek() == component) {
                this.history.pop();
                if (!this.history.empty()) {
                    Component component3 = (Component)this.history.peek();
                    if (component3 instanceof JComponent) {
                        ((JComponent)component3).grabFocus();
                    } else {
                        component3.requestFocus();
                    }
                    return;
                }
            }
            this.history.removeAllElements();
            if (container != null && (component2 = this.getFocusableComponentAfter(jComponent, container, false)) != null) {
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).grabFocus();
                } else {
                    component2.requestFocus();
                }
            }
        }
    }

    Container getFocusRoot(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof JComponent && ((JComponent)container).isFocusCycleRoot() || container instanceof Window || container instanceof Dialog) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    private Component getFocusableComponentAfter(Component component, Container container, boolean bl) {
        Component component2;
        Component component3 = component;
        if (this.console != null && this.console.getTree() != null && component3 == this.console.getTree().getTree()) {
            Component component4 = ShellStubs.getCurrentView();
            return component4;
        }
        Component component5 = ShellStubs.getCurrentView();
        boolean bl2 = false;
        Component component6 = component3;
        while (component6 != null) {
            if (component6 == component5) {
                bl2 = true;
                component6 = null;
                break;
            }
            if (component6 instanceof Window || component6 instanceof Dialog) {
                component6 = null;
                break;
            }
            component6 = component6.getParent();
        }
        if (bl2) {
            return this.console.getTree().getTree();
        }
        component6 = component2 = component;
        while (!((component6 = bl ? this.getNextComponent(component6, container, true) : this.getPreviousComponent(component6, container)) == null || component6 == component2 || component6.isVisible() && component6.isFocusTraversable() && component6.isEnabled())) {
        }
        return component6;
    }

    private Component getNextComponent(Component component, Container container, boolean bl) {
        Component component2 = null;
        if (bl && component.isVisible() && (!(component instanceof JComponent) || !((JComponent)component).isManagingFocus()) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return this.getFirstComponent((Container)component);
        }
        Container container2 = component.getParent();
        component2 = this.getComponentAfter(container2, component);
        if (component2 != null) {
            return component2;
        }
        if (container2 == container) {
            return container;
        }
        return this.getNextComponent(container2, container, false);
    }

    private Component getPreviousComponent(Component component, Container container) {
        Container container2 = component.getParent();
        if (component == container) {
            return this.getDeepestLastComponent(container);
        }
        Component component2 = this.getComponentBefore(container2, component);
        if (component2 != null) {
            return this.getDeepestLastComponent(component2);
        }
        return container2;
    }

    private Component getDeepestLastComponent(Component component) {
        if (component.isVisible() && (component instanceof JComponent && !((JComponent)component).isManagingFocus() || !(component instanceof JComponent)) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return this.getDeepestLastComponent(this.getLastComponent((Container)component));
        }
        return component;
    }

    public Component getFirstComponent(Container container) {
        Component[] componentArray = this.childrenTabOrder(container);
        if (componentArray.length > 0) {
            return componentArray[0];
        }
        return null;
    }

    public Component getLastComponent(Container container) {
        Component[] componentArray = this.childrenTabOrder(container);
        if (componentArray.length > 0) {
            return componentArray[componentArray.length - 1];
        }
        return null;
    }

    public Component getComponentBefore(Container container, Component component) {
        Component component2 = this.inverseGetNextFocusable(container, component);
        if (component2 != null) {
            return component2;
        }
        return this.tabOrderPreviousComponent(container, component);
    }

    public Component getComponentAfter(Container container, Component component) {
        Component component2;
        if (component instanceof JComponent && (component2 = ((JComponent)component).getNextFocusableComponent()) != null) {
            return component2;
        }
        return this.tabOrderNextComponent(container, component);
    }

    public boolean compareTabOrder(Component component, Component component2) {
        int n;
        int n2;
        Rectangle rectangle;
        int n3;
        int n4;
        if (component instanceof JComponent) {
            n4 = ((JComponent)component).getY();
            n3 = ((JComponent)component).getX();
        } else {
            rectangle = component.getBounds();
            n4 = rectangle.y;
            n3 = rectangle.x;
        }
        if (component2 instanceof JComponent) {
            n2 = ((JComponent)component2).getY();
            n = ((JComponent)component2).getX();
        } else {
            rectangle = component2.getBounds();
            n2 = rectangle.y;
            n = rectangle.x;
        }
        if (Math.abs(n4 - n2) < 10) {
            return n3 < n;
        }
        return n4 < n2;
    }

    private Component tabOrderNextComponent(Container container, Component component) {
        Component[] componentArray = this.childrenTabOrder(container);
        int n = componentArray.length;
        if (n == 1) {
            return null;
        }
        int n2 = 0;
        while (n2 < n - 1) {
            if (componentArray[n2] == component) {
                return componentArray[n2 + 1];
            }
            ++n2;
        }
        return null;
    }

    private Component tabOrderPreviousComponent(Container container, Component component) {
        Component[] componentArray = this.childrenTabOrder(container);
        int n = componentArray.length;
        if (n == 1) {
            return null;
        }
        int n2 = 1;
        while (n2 < n) {
            if (componentArray[n2] == component) {
                return componentArray[n2 - 1];
            }
            ++n2;
        }
        return null;
    }

    private Component inverseGetNextFocusable(Container container, Component component) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            if (componentArray[n] instanceof JComponent && ((JComponent)componentArray[n]).getNextFocusableComponent() == component) {
                return componentArray[n];
            }
            ++n;
        }
        return null;
    }

    Component[] childrenTabOrder(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            int n3 = n;
            while (n3 < n2) {
                if (n != n3 && this.compareTabOrder(componentArray[n3], componentArray[n])) {
                    Component component = componentArray[n];
                    componentArray[n] = componentArray[n3];
                    componentArray[n3] = component;
                }
                ++n3;
            }
            ++n;
        }
        return componentArray;
    }

    void clearHistory() {
        this.history.removeAllElements();
    }

    public ConsoleFocusManager(ConsoleShell consoleShell) {
        this.console = consoleShell;
    }
}

