/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.RegistryContainer;
import com.novell.application.console.shell.SnapinCollectionInfo;
import com.novell.application.console.shell.SnapinLister;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.RegistrationItem;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.Snapin;
import com.novell.application.console.snapin.scope.Scope;
import com.objectspace.jgl.Array;
import java.util.Enumeration;
import java.util.Hashtable;

public class Registry {
    private static Hashtable m_registry = new Hashtable();
    private static Array m_snapinPackages = new Array();

    public static Hashtable getRegistry() {
        return m_registry;
    }

    public static Enumeration getSnapinPackages() {
        return m_snapinPackages.elements();
    }

    public static Enumeration getRegistryContainers(Object object) {
        Hashtable hashtable = (Hashtable)m_registry.get(object);
        if (hashtable != null) {
            return hashtable.elements();
        }
        return null;
    }

    public static RegistryContainer getRegistryContainer(Object object, String string) {
        Hashtable hashtable = (Hashtable)m_registry.get(object);
        return (RegistryContainer)hashtable.get(string);
    }

    public static void removeLowPriorityNamespaces() {
        Hashtable hashtable = (Hashtable)m_registry.get(Shell.SNAPIN_NAMESPACE);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                RegistryContainer registryContainer = (RegistryContainer)enumeration.nextElement();
                Array array = registryContainer.m_prioritizedItems;
                int n = 0;
                while (n < array.size()) {
                    RegistrationItem registrationItem = (RegistrationItem)array.at(n);
                    String string = registrationItem.getNamespaceUniqueID();
                    if (string != null) {
                        int n2 = array.size() - 1;
                        while (n2 > n) {
                            RegistrationItem registrationItem2 = (RegistrationItem)array.at(n2);
                            String string2 = registrationItem2.getNamespaceUniqueID();
                            if (string2 != null && string2.equals(string)) {
                                if (registrationItem.getNamespacePriority() >= registrationItem2.getNamespacePriority()) {
                                    array.remove(n2);
                                } else {
                                    array.remove(n);
                                    --n;
                                    break;
                                }
                            }
                            --n2;
                        }
                    }
                    ++n;
                }
            }
        }
    }

    static void registerSnapins(SnapinLister[] snapinListerArray) {
        Object object;
        SnapinCollectionInfo[] snapinCollectionInfoArray;
        int n = 0;
        while (n < snapinListerArray.length) {
            D.out("\nRegistering snapin packages for snapinlister[" + n + "]");
            snapinCollectionInfoArray = snapinListerArray[n].getSnapinCollections();
            int n2 = 0;
            while (n2 < snapinCollectionInfoArray.length) {
                object = snapinCollectionInfoArray[n2].getPackageName();
                if (object != null && object != "") {
                    D.out("    Registering snapin package -> " + (String)object);
                    m_snapinPackages.add((Object)snapinCollectionInfoArray[n2]);
                }
                RegistrationItem[] registrationItemArray = snapinCollectionInfoArray[n2].getRegistrationItems();
                int n3 = 0;
                while (n3 < registrationItemArray.length) {
                    Registry.registerSnapin(registrationItemArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        RegistryContainer registryContainer = null;
        snapinCollectionInfoArray = null;
        object = m_registry.elements();
        while (object.hasMoreElements()) {
            snapinCollectionInfoArray = (SnapinCollectionInfo[])object.nextElement();
            Enumeration enumeration = snapinCollectionInfoArray.elements();
            while (enumeration.hasMoreElements()) {
                registryContainer = (RegistryContainer)enumeration.nextElement();
                registryContainer.configureSnapins();
            }
        }
    }

    static void registerSnapin(RegistrationItem registrationItem) {
        if (registrationItem != null) {
            Scope scope = registrationItem.getScope();
            Object object = scope.getSnapinType();
            String string = scope.getScopeKey();
            Hashtable hashtable = null;
            if (m_registry.containsKey(object)) {
                hashtable = (Hashtable)m_registry.get(object);
            } else {
                hashtable = new Hashtable();
                m_registry.put(object, hashtable);
            }
            RegistryContainer registryContainer = null;
            if (hashtable.containsKey(string)) {
                registryContainer = (RegistryContainer)hashtable.get(string);
            } else {
                registryContainer = new RegistryContainer(scope);
                hashtable.put(string, registryContainer);
            }
            registryContainer.addRI(registrationItem);
        } else {
            D.out("registerSnapin: Registration failed (ri was null).");
        }
    }

    static Array getSnapins(Scope scope) {
        Scope[] scopeArray = new Scope[]{scope};
        return Registry.getSnapins(scopeArray, null);
    }

    static Array getSnapins(Scope scope, InitSnapinInfo initSnapinInfo) {
        Scope[] scopeArray = new Scope[]{scope};
        return Registry.getSnapins(scopeArray, initSnapinInfo);
    }

    static Array getSnapins(Scope[] scopeArray, InitSnapinInfo initSnapinInfo) {
        Shell shell = MainShell.getInstance();
        Object object = null;
        String string = null;
        RegistryContainer registryContainer = null;
        RegistrationItem registrationItem = null;
        Array array = new Array();
        Enumeration enumeration = null;
        Hashtable hashtable = null;
        Snapin[] snapinArray = new Snapin[]{};
        object = scopeArray[0].getSnapinType();
        hashtable = (Hashtable)m_registry.get(object);
        if (hashtable != null) {
            int n = 0;
            while (n < scopeArray.length) {
                string = scopeArray[n].getScopeKey();
                registryContainer = (RegistryContainer)hashtable.get(string);
                if (registryContainer != null) {
                    enumeration = registryContainer.getPrioritizedItems();
                    while (enumeration.hasMoreElements()) {
                        registrationItem = (RegistrationItem)enumeration.nextElement();
                        snapinArray = registrationItem.getSnapins(initSnapinInfo);
                        int n2 = 0;
                        while (n2 < snapinArray.length) {
                            if (snapinArray[n2] != null) {
                                array.add((Object)snapinArray[n2]);
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
        return array;
    }

    static boolean checkSnapins(Scope scope) {
        Scope[] scopeArray = new Scope[]{scope};
        return Registry.checkSnapins(scopeArray, null);
    }

    static boolean checkSnapins(Scope scope, InitSnapinInfo initSnapinInfo) {
        Scope[] scopeArray = new Scope[]{scope};
        return Registry.checkSnapins(scopeArray, initSnapinInfo);
    }

    static boolean checkSnapins(Scope[] scopeArray, InitSnapinInfo initSnapinInfo) {
        Object object = null;
        String string = null;
        Hashtable hashtable = null;
        Snapin[] snapinArray = new Snapin[]{};
        int n = 0;
        while (n < scopeArray.length) {
            RegistryContainer registryContainer;
            object = scopeArray[n].getSnapinType();
            string = scopeArray[n].getScopeKey();
            hashtable = (Hashtable)m_registry.get(object);
            if (hashtable != null && (registryContainer = (RegistryContainer)hashtable.get(string)) != null) {
                RegistrationItem registrationItem = null;
                Enumeration enumeration = registryContainer.getPrioritizedItems();
                while (enumeration.hasMoreElements()) {
                    registrationItem = (RegistrationItem)enumeration.nextElement();
                    if (!registrationItem.checkNonDynamicSnapins(initSnapinInfo)) continue;
                    return true;
                }
                enumeration = registryContainer.getPrioritizedItems();
                while (enumeration.hasMoreElements()) {
                    registrationItem = (RegistrationItem)enumeration.nextElement();
                    if (!registrationItem.checkDynamicSnapins(initSnapinInfo)) continue;
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    static void ShutDown() {
        Enumeration enumeration;
        Enumeration enumeration2;
        RegistryContainer registryContainer = null;
        RegistrationItem registrationItem = null;
        Hashtable hashtable = null;
        Snapin snapin = null;
        Object var4_4 = null;
        Array array = new Array();
        Enumeration enumeration3 = null;
        Enumeration enumeration4 = m_registry.elements();
        while (enumeration4.hasMoreElements()) {
            hashtable = (Hashtable)enumeration4.nextElement();
            enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                registryContainer = (RegistryContainer)enumeration2.nextElement();
                if (registryContainer.getSnapinType() == Shell.SNAPIN_SERVICE) {
                    array.add((Object)registryContainer);
                } else {
                    enumeration = registryContainer.getPrioritizedItems();
                    while (enumeration.hasMoreElements()) {
                        registrationItem = (RegistrationItem)enumeration.nextElement();
                        registrationItem.shutdownTrackedSnapins();
                        registrationItem.clearCache();
                    }
                    Enumeration enumeration5 = registryContainer.getDisabledItems();
                    while (enumeration5.hasMoreElements()) {
                        registrationItem = (RegistrationItem)enumeration5.nextElement();
                        registrationItem.shutdownTrackedSnapins();
                        registrationItem.clearCache();
                    }
                }
                registryContainer.saveConfiguration();
            }
        }
        snapin = null;
        enumeration3 = RegistrationItem.getDynamicCache().elements();
        while (enumeration3.hasMoreElements()) {
            snapin = (Snapin)enumeration3.nextElement();
            try {
                snapin.shutdownSnapin();
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
        }
        enumeration3 = array.elements();
        while (enumeration3.hasMoreElements()) {
            registryContainer = (RegistryContainer)enumeration3.nextElement();
            enumeration2 = registryContainer.getPrioritizedItems();
            while (enumeration2.hasMoreElements()) {
                registrationItem = (RegistrationItem)enumeration2.nextElement();
                registrationItem.shutdownTrackedSnapins();
                registrationItem.clearCache();
            }
            enumeration = registryContainer.getDisabledItems();
            while (enumeration.hasMoreElements()) {
                registrationItem = (RegistrationItem)enumeration.nextElement();
                registrationItem.shutdownTrackedSnapins();
                registrationItem.clearCache();
            }
        }
    }
}

