/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.ConsoleShell;
import com.novell.application.console.shell.D;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resources {
    private static ResourceBundle res;
    public static Font DEFAULT_FONT;

    public static Font getDefaultFont() {
        if (DEFAULT_FONT == null) {
            DEFAULT_FONT = new Font("Dialog", 0, 11);
        }
        return DEFAULT_FONT;
    }

    static void setBundle() {
        res = ConsoleShell.snapinBundleLoader.getBundle("com.novell.application.console.shell.resources.ConsoleOneResourceBundle");
    }

    public static Object getObject(String string) throws MissingResourceException {
        D.assert(string != null && !string.equals(""));
        Object object = null;
        try {
            object = res.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, throwing exception to caller:" + string);
            throw missingResourceException;
        }
        return object;
    }

    public static Object getObject(String string, Object object) throws MissingResourceException {
        D.assert(string != null && !string.equals(""));
        Object object2 = null;
        try {
            object2 = res.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, returning default:" + string);
            object2 = object;
        }
        return object2;
    }

    public static String getString(String string) throws MissingResourceException {
        D.assert(string != null && !string.equals(""));
        String string2 = null;
        try {
            D.assert(res.getObject(string) instanceof String);
            string2 = res.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, throwing exception to caller:" + string);
            throw missingResourceException;
        }
        return string2;
    }

    public static String getString(String string, String string2) {
        D.assert(string != null && !string.equals(""));
        String string3 = null;
        try {
            D.assert(res.getObject(string) instanceof String);
            string3 = res.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, returning default:" + string);
            string3 = string2;
        }
        return string3;
    }

    public static Image getImage(String string) {
        D.assert(string != null && !string.equals(""));
        Image image = null;
        String string2 = "/com/novell/application/console/shell/resources/images/";
        string2 = string2 + string;
        URL uRL = res.getClass().getResource(string2);
        if (uRL != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        D.assert(image != null, "Cannot load image file:" + string);
        return image;
    }

    public static Font getFont(String string) throws MissingResourceException {
        D.assert(string != null && !string.equals(""));
        Font font = null;
        try {
            D.assert(res.getObject(string) instanceof Font);
            font = (Font)res.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource:" + string);
            font = Resources.getDefaultFont();
        }
        return font;
    }

    public static Font getFont(String string, Font font) {
        D.assert(string != null && !string.equals(""));
        Font font2 = null;
        try {
            D.assert(res.getObject(string) instanceof Font);
            font2 = (Font)res.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource:" + string);
            font2 = font;
        }
        return font2;
    }

    public static int getInt(String string, int n) {
        D.assert(string != null && !string.equals(""));
        int n2 = 0;
        try {
            D.assert(res.getObject(string) instanceof Integer);
            Integer n3 = (Integer)res.getObject(string);
            n2 = n3;
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, returning default passed in:" + string);
            n2 = n;
        }
        return n2;
    }

    public static int getInt(String string) throws MissingResourceException {
        D.assert(string != null && !string.equals(""));
        int n = 0;
        try {
            D.assert(res.getObject(string) instanceof Integer);
            Integer n2 = (Integer)res.getObject(string);
            n = n2;
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, throwing exception to caller:" + string);
            throw missingResourceException;
        }
        return n;
    }

    public static float getFloat(String string, float f) {
        D.assert(string != null && !string.equals(""));
        float f2 = 0.0f;
        try {
            D.assert(res.getObject(string) instanceof Float);
            Float f3 = (Float)res.getObject(string);
            f2 = f3.floatValue();
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, returning default passed in:" + string);
            f2 = f;
        }
        return f2;
    }

    public static float getFloat(String string) throws MissingResourceException {
        D.assert(string != null && !string.equals(""));
        float f = 0.0f;
        try {
            D.assert(res.getObject(string) instanceof Float);
            Float f2 = (Float)res.getObject(string);
            f = f2.floatValue();
        }
        catch (MissingResourceException missingResourceException) {
            D.out("Missing resource, throwing exception to caller:" + string);
            throw missingResourceException;
        }
        return f;
    }

    static {
        DEFAULT_FONT = null;
    }
}

