/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.Utilities;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;
import com.novell.utility.localization.Loc;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetContextDlg
extends JDialog
implements ActionListener,
KeyListener {
    private JFrame parentFrame;
    private Shell shell;
    private NamespaceSnapin ns;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JTextField nameTF;
    private ObjectEntry resolvedOE;
    private ObjectEntry currentContextOE;
    private boolean paintCalled = false;
    private boolean focusFixed = false;

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.okPressed();
        } else if (object == this.cancelButton) {
            this.resolvedOE = null;
            this.dispose();
        } else if (object == this.helpButton) {
            this.help();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.focusFixed && this.nameTF.getText().length() == 1) {
            this.nameTF.setCaretPosition(1);
            this.focusFixed = true;
        }
        if (keyEvent.getKeyCode() == 10) {
            this.okPressed();
        } else if (keyEvent.getKeyCode() == 27) {
            this.resolvedOE = null;
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void paint(Graphics graphics) {
        if (!this.paintCalled) {
            this.nameTF.requestFocus();
            this.paintCalled = true;
        }
        super.paint(graphics);
    }

    protected void help() {
        this.shell.launchHelp("novellconsoleone", "setcontext", (Window)this);
    }

    private void okPressed() {
        if (this.nameTF.getText().equals("")) {
            this.resolvedOE = null;
            this.dispose();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.ns = this.currentContextOE.getNamespace();
        try {
            this.resolvedOE = this.ns.getObjectEntry(this.nameTF.getText());
            if (this.resolvedOE == null || !this.resolvedOE.getObjectType().isContainer()) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.getToolkit().beep();
                NMsgBox nMsgBox = new NMsgBox(this.parentFrame, Resources.getString("SetContextObjectNotFoundCaption"), Resources.getString("SetContextObjectNotFoundMsg"), 1);
                nMsgBox.setVisible(true);
                this.requestFocus();
                this.nameTF.selectAll();
                this.nameTF.requestFocus();
                return;
            }
        }
        catch (SnapinException snapinException) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.getToolkit().beep();
            NMsgBox nMsgBox = new NMsgBox(this.parentFrame, Resources.getString("SetContextObjectNotFoundCaption"), Resources.getString("SetContextObjectNotFoundMsg"), 1);
            nMsgBox.setVisible(true);
            this.requestFocus();
            this.nameTF.selectAll();
            this.nameTF.requestFocus();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dispose();
    }

    public ObjectEntry getContextOE() {
        return this.resolvedOE;
    }

    private void layoutControls() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = NConeFactory.novellJPanel(new JPanel(new BorderLayout()), "", "");
        this.nameTF = NConeFactory.novellJTextField(new JTextField(25), "", "");
        this.nameTF.setText("");
        this.nameTF.addKeyListener(this);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        jPanel.add((Component)new JLabel(""), "North");
        jPanel.add((Component)this.nameTF, "Center");
        JPanel jPanel2 = NConeFactory.novellJPanel(new JPanel(new GridLayout(1, 3, 5, 0)), "", "");
        JPanel jPanel3 = NConeFactory.novellJPanel(new JPanel(new FlowLayout(1)), "", "");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        SetContextDlg setContextDlg = this;
        if (setContextDlg == null) {
            throw null;
        }
        this.okButton = new JButton(setContextDlg, Resources.getString("SetContextOkKey")){
            private final /* synthetic */ SetContextDlg this$0;

            public boolean isDefaultButton() {
                return true;
            }
            {
                this.this$0 = setContextDlg;
                this.constructor$0(setContextDlg, string);
            }

            private final void constructor$0(SetContextDlg setContextDlg, String string) {
            }
        };
        this.okButton = NConeFactory.novellJButton(this.okButton, Loc.removeHotChar(Resources.getString("SetContextOkKey")), "");
        jPanel2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(Resources.getString("SetContextCancelKey"));
        NConeFactory.novellJButton(this.cancelButton, Loc.removeHotChar(Resources.getString("SetContextCancelKey")), "");
        this.cancelButton.setDefaultCapable(false);
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.helpButton = NConeFactory.novellJButton(new JButton(), Loc.removeHotChar(Resources.getString("SetContextHelpKey")), "");
        Loc.setText(this.helpButton, Resources.getString("SetContextHelpKey"));
        jPanel2.add(this.helpButton);
        this.helpButton.setDefaultCapable(false);
        this.helpButton.addActionListener(this);
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "South");
        container.add((Component)jPanel, "Center");
        this.nameTF.setName("Name");
        this.okButton.setName("Ok");
        this.cancelButton.setName("Cancel");
        this.helpButton.setName("Help");
    }

    public SetContextDlg(Shell shell, ObjectEntry objectEntry) {
        super(shell.getShellFrame(), Resources.getString("SetContextKey"), true);
        this.shell = shell;
        this.parentFrame = shell.getShellFrame();
        this.resolvedOE = objectEntry;
        this.currentContextOE = objectEntry;
        this.setResizable(false);
        this.layoutControls();
        this.pack();
        Utilities.centerWindow(this);
    }
}

