/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.ConsoleShell;
import com.novell.application.console.shell.D;
import com.novell.application.console.shell.EntryCache;
import com.novell.application.console.shell.GetChildrenThread;
import com.novell.application.console.shell.PlaceholderNamespace;
import com.novell.application.console.shell.ShellNamespace;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.shell.Tree;
import com.novell.application.console.shell.TreeNodeInterface;
import com.novell.application.console.shell.TreeStopper;
import com.novell.application.console.shell.Utilities;
import com.novell.application.console.snapin.GetChildrenCallback;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.widgets.WidgetsNode;
import com.objectspace.jgl.Array;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class ShellNode
extends DefaultMutableTreeNode
implements TreeNodeInterface,
WidgetsNode {
    static ConsoleShell console;
    private static final ShellNode dummyChild;
    private boolean inChildCount = false;
    private boolean initialObjectEntry = false;
    private boolean exception;
    private JTree jtree;
    private Tree tree;
    private ObjectEntry oe;
    private Icon icon;
    private String label;
    private boolean leaf = false;
    protected boolean hasLoaded = false;
    private boolean isLoading = false;
    private boolean partiallyLoaded = false;
    private boolean synchronousExpand = false;
    private boolean inGetChildren = false;
    private boolean inAsyncCollapse = false;
    private boolean waitingForExpansion = false;

    void setSyncronous(boolean bl) {
        this.synchronousExpand = bl;
    }

    boolean isInitialObjectEntry() {
        return this.initialObjectEntry;
    }

    void setInitialObjectEntry(boolean bl) {
        this.initialObjectEntry = bl;
        if (this.initialObjectEntry && this.label.equals(this.getObjectEntry().getName())) {
            this.label = this.getObjectEntry().getFullName();
        }
    }

    void refreshIcon() {
        this.icon = ShellStubs.getDisplayIcon(this.getObjectEntry());
    }

    void refreshName() {
        this.label = ShellStubs.getDisplayName(this.getObjectEntry());
        if (this.initialObjectEntry && this.label.equals(this.getObjectEntry().getName())) {
            this.label = this.getObjectEntry().getFullName();
        }
    }

    void setObjectEntry(ObjectEntry objectEntry) {
        this.oe = objectEntry;
    }

    void setJTree(JTree jTree) {
        this.jtree = jTree;
    }

    ObjectEntry getObjectEntry() {
        return this.oe;
    }

    public String getWidgetsNodeName() {
        return this.getText();
    }

    public boolean isEnabled() {
        return true;
    }

    public String getText() {
        return this.label;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public Enumeration getAllChildrenSync() {
        this.synchronousExpand = true;
        Enumeration enumeration = this.children();
        this.synchronousExpand = false;
        return enumeration;
    }

    public Enumeration children() {
        if (!this.hasLoaded && !this.exception) {
            this.loadChildren();
        }
        return super.children();
    }

    Enumeration alreadyLoadedChildren() {
        if (!this.hasLoaded) {
            return null;
        }
        return super.children();
    }

    public int getChildCount() {
        if (this.inChildCount) {
            return 0;
        }
        this.inChildCount = true;
        if (!(this.inGetChildren || this.hasLoaded || this.exception)) {
            this.loadChildren();
        }
        this.inChildCount = false;
        return super.getChildCount();
    }

    public void clearChildren() {
        this.hasLoaded = true;
        this.removeAllChildren();
        this.hasLoaded = false;
    }

    protected void loadChildren() {
        boolean bl = false;
        ObjectEntry objectEntry = this.oe;
        ObjectEntryEnumeration objectEntryEnumeration = null;
        try {
            objectEntryEnumeration = ShellStubs.getChildContainers(objectEntry, null);
            console.startWaitCursor();
            objectEntryEnumeration = ShellStubs.wrapWithHideFilterEnumeration(objectEntryEnumeration);
        }
        catch (SnapinException snapinException) {
            this.exception = true;
            Utilities.handleException(snapinException);
        }
        if (this.exception) {
            D.out("ShellNode::loadChildren.exception == true " + this.oe.getName());
            this.add(dummyChild);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.jtree.getModel();
            TreePath treePath = new TreePath(defaultTreeModel.getPathToRoot(this));
            this.jtree.collapsePath(treePath);
            this.removeAllChildren();
            defaultTreeModel.reload(this);
            this.exception = false;
        } else {
            NamespaceSnapin namespaceSnapin;
            ObjectEntry[] objectEntryArray;
            int n = 0;
            if (objectEntryEnumeration != null) {
                objectEntryArray = new Array();
                ObjectEntry objectEntry2 = null;
                try {
                    namespaceSnapin = objectEntry.getNamespace();
                    boolean bl2 = namespaceSnapin instanceof ShellNamespace || namespaceSnapin instanceof PlaceholderNamespace && objectEntry.getObjectFlags() == 1L;
                    while (objectEntryEnumeration.hasMoreElements()) {
                        try {
                            objectEntry2 = objectEntryEnumeration.next();
                        }
                        catch (Exception exception) {
                            objectEntry2 = null;
                            D.reportSnapinError(exception);
                        }
                        D.assert(objectEntry2 != null);
                        if (objectEntry2 == null) continue;
                        objectEntryArray.add((Object)objectEntry2);
                        ShellNode shellNode = new ShellNode(objectEntry2, this.tree, this.jtree);
                        boolean bl3 = ShellStubs.isContainer(objectEntry2);
                        boolean bl4 = true;
                        if (!bl4 && !bl3) continue;
                        shellNode.setLeaf(!bl3);
                        shellNode.setInitialObjectEntry(bl2);
                        this.insert(shellNode, n++);
                    }
                }
                catch (Exception exception) {
                    D.reportSnapinError(exception);
                }
            }
            this.hasLoaded = true;
            objectEntryArray = EntryCache.promoteRetrieve(objectEntry);
            if (objectEntryArray != null) {
                D.out("ShellNode:loadChildren Promoted children != null for " + objectEntry.getName());
                int n2 = 0;
                while (n2 < objectEntryArray.length) {
                    namespaceSnapin = objectEntryArray[n2];
                    this.promote((ObjectEntry)namespaceSnapin, true);
                    ++n2;
                }
            }
        }
        console.endWaitCursor();
    }

    protected synchronized void loadChildrenAsync() {
        D.out("Loading children for " + this.getObjectEntry());
        this.tree.cancelCurrentChildLoad();
        ShellNode shellNode = this;
        if (shellNode == null) {
            throw null;
        }
        TreeGetChildrenCallback treeGetChildrenCallback = shellNode.new TreeGetChildrenCallback();
        ShellNode shellNode2 = this;
        if (shellNode2 == null) {
            throw null;
        }
        CallbackData callbackData = shellNode2.new CallbackData(this, this.oe.getNamespace() instanceof PlaceholderNamespace);
        this.tree.setActiveCallback(treeGetChildrenCallback);
        boolean bl = false;
        this.inGetChildren = true;
        D.out("synchronouseExpand = " + this.synchronousExpand);
        GetChildrenThread getChildrenThread = ShellStubs.getChildContainersAsync(this.oe, null, treeGetChildrenCallback, callbackData, !this.synchronousExpand);
        this.inGetChildren = false;
        D.out("thread = " + getChildrenThread);
        if (getChildrenThread != null) {
            this.waitingForExpansion = true;
            TreeStopper treeStopper = new TreeStopper(getChildrenThread);
            treeGetChildrenCallback.setTreeStopper(treeStopper);
            this.tree.setActiveTreeStopper(treeStopper);
            ShellStubs.setBusy(treeStopper, true, 2);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.jtree.getModel();
            TreePath treePath = new TreePath(defaultTreeModel.getPathToRoot(this));
            this.inAsyncCollapse = true;
            this.jtree.collapsePath(treePath);
            this.inAsyncCollapse = false;
            this.removeAllChildren();
            defaultTreeModel.reload(this);
        }
        this.hasLoaded = true;
    }

    boolean isInAsyncCollapse() {
        return this.inAsyncCollapse;
    }

    private void setLeaf(boolean bl) {
        this.leaf = bl;
    }

    public void promote(ObjectEntry objectEntry, boolean bl) {
        ShellNode shellNode = new ShellNode(objectEntry, this.tree, this.jtree);
        boolean bl2 = ShellStubs.isContainer(objectEntry);
        shellNode.setLeaf(!bl2);
        if (bl) {
            this.insert(shellNode, super.getChildCount());
        } else {
            this.add(shellNode);
            ((DefaultTreeModel)this.jtree.getModel()).nodesWereInserted(this, new int[]{this.getChildCount() - 1});
        }
    }

    public String toString() {
        return "ShellNode:" + this.getObjectEntry().getName();
    }

    static /* synthetic */ void access$3(ShellNode shellNode, boolean bl) {
        shellNode.setLeaf(bl);
    }

    static /* synthetic */ boolean access$5(ShellNode shellNode) {
        return shellNode.exception;
    }

    ShellNode(ObjectEntry objectEntry, Tree tree, JTree jTree) {
        this.oe = objectEntry;
        this.tree = tree;
        this.jtree = jTree;
        this.label = ShellStubs.getDisplayName(objectEntry);
        this.icon = ShellStubs.getDisplayIcon(objectEntry);
    }

    ShellNode(ObjectEntry objectEntry, Tree tree, JTree jTree, boolean bl) {
        this.oe = objectEntry;
        this.jtree = jTree;
        this.tree = tree;
        if (bl) {
            this.label = ShellStubs.getDisplayName(objectEntry);
            this.icon = ShellStubs.getDisplayIcon(objectEntry);
        } else {
            this.label = objectEntry.getName();
            this.icon = null;
        }
    }

    static {
        dummyChild = new ShellNode(ShellNamespace.getShellObjectEntry(), null, null, false);
    }

    class TreeGetChildrenCallback
    implements GetChildrenCallback {
        TreeStopper treeStopper = null;
        boolean first = true;
        private String semaphore = "s";
        private Vector entriesToPost = new Vector();

        public ShellNode getShellNode() {
            return ShellNode.this;
        }

        public synchronized void gotChild(ObjectEntry objectEntry, Object object) {
            if (this == ShellNode.this.tree.getActiveCallback()) {
                String string = this.semaphore;
                synchronized (string) {
                    TreeGetChildrenCallback treeGetChildrenCallback = this;
                    if (treeGetChildrenCallback == null) {
                        throw null;
                    }
                    Runnable runnable = new Runnable(treeGetChildrenCallback, object, objectEntry){
                        private final /* synthetic */ TreeGetChildrenCallback this$0;
                        private final /* synthetic */ Object val$userData;
                        private final /* synthetic */ ObjectEntry val$entry;
                        private final /* synthetic */ ShellNode this$1;

                        public void run() {
                            if (this.this$0 == ShellNode.access$0(this.this$1).getActiveCallback()) {
                                if (!ShellNode.access$1(this.this$1) && this.this$0.first) {
                                    ShellNode.access$0(this.this$1).expand(this.this$1);
                                    this.this$0.first = false;
                                }
                                CallbackData callbackData = (CallbackData)this.val$userData;
                                ObjectEntry objectEntry = this.val$entry;
                                D.assert(objectEntry != null);
                                if (objectEntry != null) {
                                    ShellNode shellNode = new ShellNode(objectEntry, ShellNode.access$0(callbackData.node), ShellNode.access$2(callbackData.node));
                                    boolean bl = ShellStubs.isContainer(objectEntry);
                                    ShellNode.access$3(shellNode, !bl);
                                    shellNode.setInitialObjectEntry(callbackData.childrenAreInitialObjectEntries);
                                    callbackData.node.insert(shellNode, callbackData.i);
                                    int[] nArray = new int[]{callbackData.i++};
                                    ((DefaultTreeModel)ShellNode.access$2(callbackData.node).getModel()).nodesWereInserted(callbackData.node, nArray);
                                }
                            }
                        }
                        {
                            this.val$userData = object;
                            this.val$entry = objectEntry;
                            this.this$0 = treeGetChildrenCallback;
                            this.this$1 = TreeGetChildrenCallback.access$0(this.this$0);
                            this.constructor$0(treeGetChildrenCallback);
                        }

                        private final void constructor$0(TreeGetChildrenCallback treeGetChildrenCallback) {
                        }
                    };
                    if (ShellNode.this.inGetChildren && SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            }
        }

        public void doneGettingChildren(Object object) {
            if (this == ShellNode.this.tree.getActiveCallback()) {
                TreeGetChildrenCallback treeGetChildrenCallback = this;
                if (treeGetChildrenCallback == null) {
                    throw null;
                }
                Runnable runnable = new Runnable(treeGetChildrenCallback, object){
                    private final /* synthetic */ TreeGetChildrenCallback this$0;
                    private final /* synthetic */ Object val$userData;
                    private final /* synthetic */ ShellNode this$1;

                    public void run() {
                        if (this.this$0 == ShellNode.access$0(this.this$1).getActiveCallback()) {
                            if (!ShellNode.access$1(this.this$1) && this.this$0.first) {
                                ShellNode.access$0(this.this$1).expand(this.this$1);
                                this.this$0.first = false;
                            }
                            CallbackData callbackData = (CallbackData)this.val$userData;
                            callbackData.node.hasLoaded = true;
                            ObjectEntry[] objectEntryArray = EntryCache.promoteRetrieve(ShellNode.access$4(callbackData.node));
                            if (objectEntryArray != null) {
                                D.out("ShellNode:loadChildren Promoted children != null for " + ShellNode.access$4(callbackData.node).getName());
                                int n = 0;
                                while (n < objectEntryArray.length) {
                                    ObjectEntry objectEntry = objectEntryArray[n];
                                    try {
                                        ObjectEntry objectEntry2 = objectEntry.getNamespace().getObjectEntry(objectEntry.getNamespace().getFullName(objectEntry));
                                        callbackData.node.promote(objectEntry2, true);
                                    }
                                    catch (SnapinException snapinException) {
                                        Utilities.handleException(snapinException);
                                        D.out("Could not get old promoted ObjectEntry from namespace, ConsoleOne will not put " + objectEntry.getName() + " back in the tree.");
                                    }
                                    ++n;
                                }
                            }
                        }
                        if (this.this$0.treeStopper != null) {
                            D.out("Setting busy for " + this.this$0.treeStopper + " to false");
                            ShellStubs.setBusy(this.this$0.treeStopper, false, 2);
                        }
                        ShellNode.access$0(this.this$1).clearActiveTreeStopper(this.this$0.treeStopper);
                        ShellNode.access$0(this.this$1).clearActiveCallback(this.this$0);
                    }
                    {
                        this.val$userData = object;
                        this.this$0 = treeGetChildrenCallback;
                        this.this$1 = TreeGetChildrenCallback.access$0(this.this$0);
                        this.constructor$0(treeGetChildrenCallback);
                    }

                    private final void constructor$0(TreeGetChildrenCallback treeGetChildrenCallback) {
                    }
                };
                if (ShellNode.this.inGetChildren && SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }

        public void getChildrenCancelled(Object object) {
            if (this.first) {
                ShellNode.this.hasLoaded = false;
            }
            if (this.treeStopper != null) {
                ShellStubs.setBusy(this.treeStopper, false, 2);
            } else {
                D.assert(false, "TreeStopper not set");
            }
            ShellNode.this.tree.clearActiveTreeStopper(this.treeStopper);
            ShellNode.this.tree.clearActiveCallback(this);
        }

        public void exceptionWhileGettingChildren(Exception exception, Object object) {
            if (exception instanceof SnapinException) {
                Utilities.handleException((SnapinException)((Object)exception));
            }
            D.out("ShellNode::loadChildrenAsync() exception == true " + ShellNode.this.oe.getName());
            if (this.treeStopper == null) {
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)ShellNode.this.jtree.getModel();
                TreePath treePath = new TreePath(defaultTreeModel.getPathToRoot(ShellNode.this));
                ShellNode.this.jtree.collapsePath(treePath);
                ShellNode.this.removeAllChildren();
                defaultTreeModel.reload(ShellNode.this);
                ShellNode.this.exception = false;
            } else {
                ShellStubs.setBusy(this.treeStopper, false, 2);
                if (this.first) {
                    ShellNode.this.hasLoaded = false;
                }
            }
            ShellNode.this.tree.clearActiveTreeStopper(this.treeStopper);
            ShellNode.this.tree.clearActiveCallback(this);
        }

        public void setTreeStopper(TreeStopper treeStopper) {
            this.treeStopper = treeStopper;
            if (this.treeStopper.isCancelled()) {
                ShellStubs.setBusy(this.treeStopper, false, 2);
            }
        }

        public void cleanup() {
        }

        static /* synthetic */ ShellNode access$0(TreeGetChildrenCallback treeGetChildrenCallback) {
            return treeGetChildrenCallback.ShellNode.this;
        }

        TreeGetChildrenCallback() {
        }
    }

    private class CallbackData {
        public ShellNode node;
        public int i = 0;
        public boolean childrenAreInitialObjectEntries;

        public CallbackData(ShellNode shellNode2, boolean bl) {
            this.node = shellNode2;
            this.childrenAreInitialObjectEntries = bl;
        }
    }
}

