/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.Constants;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.shell.TreeNodeInterface;
import com.novell.application.console.snapin.ObjectEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

class ShellTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    public static TreeNodeInterface popupMenuNode;
    private static final Font FONT;
    private static final int rightBorder = 1;
    private static final int leftBorder = 1;
    private static final int bottomBorder = 1;
    private static final int topBorder = 0;
    private Color treeBackgroundSelectionColor;
    private Color treeTextSelectionColor;
    private Color treeBackgroundNonSelectionColor;
    private Color treeTextNonSelectionColor;
    boolean selected;
    boolean hasFocus;
    private ObjectEntry oe = null;
    private TreeNodeInterface treeNode = null;

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.treeNode = (TreeNodeInterface)object;
        String string = this.treeNode.getText();
        this.setText(string);
        Icon icon = this.treeNode.getIcon();
        this.setIcon(icon);
        this.selected = bl;
        if (bl) {
            this.hasFocus = ShellStubs.doesTreeHaveFocus();
        }
        return this;
    }

    public void paintComponent(Graphics graphics) {
        String string;
        Icon icon;
        int n;
        if (this.selected && this.hasFocus) {
            graphics.setColor(this.treeBackgroundSelectionColor);
            this.setForeground(this.treeTextSelectionColor);
            n = 0;
            icon = this.getIcon();
            if (icon != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            if ((string = this.getText()) != null) {
                graphics.fillRect(n - 1, 0, graphics.getFontMetrics().stringWidth(string) + 1 + 1, this.getHeight() - 1);
            }
        } else if (popupMenuNode != null && popupMenuNode == this.treeNode) {
            graphics.setColor(Color.gray);
            this.setForeground(this.treeTextSelectionColor);
            n = 0;
            icon = this.getIcon();
            if (icon != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            if ((string = this.getText()) != null) {
                graphics.fillRect(n - 1, 0, graphics.getFontMetrics().stringWidth(string) + 1 + 1, this.getHeight() - 1);
            }
        } else {
            graphics.setColor(this.treeBackgroundNonSelectionColor);
            this.setForeground(this.treeTextNonSelectionColor);
        }
        super.paintComponent(graphics);
        if (this.selected && !this.hasFocus) {
            n = 0;
            icon = this.getIcon();
            if (icon != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.setColor(this.treeBackgroundSelectionColor);
            string = this.getText();
            if (string != null) {
                graphics.drawRect(n - 1, 0, graphics.getFontMetrics().stringWidth(string) + 1 + 1 - 1, this.getHeight() - 2);
            }
        }
    }

    ShellTreeCellRenderer() {
        this.setFont(FONT);
        this.treeBackgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this.treeTextSelectionColor = UIManager.getColor("Tree.selectionForeground");
        this.treeBackgroundNonSelectionColor = UIManager.getColor("Tree.textBackground");
        this.treeTextNonSelectionColor = UIManager.getColor("Tree.textForeground");
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
    }

    static {
        FONT = Constants.getFont("ConsoleONEFontKey");
    }
}

