/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.CachedZipFile;
import com.novell.application.console.shell.D;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.shell.Utilities;
import com.novell.application.console.snapinresource.SnapinResourceURLStreamHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class SnapinClassLoader
extends ClassLoader
implements URLStreamHandlerFactory {
    private static Hashtable snapinclasses = new Hashtable();
    public static final String snapinResourceProtocol = "snapinresource";
    private static String[] ignoreSuffixes = null;
    private Hashtable zipCache = new Hashtable();
    private Hashtable nounsCache = new Hashtable(5000);
    private Vector snapinPathFiles = new Vector();
    private Hashtable historyFiles = new Hashtable(100);
    private ClassLoader consoleOneLoader = this.getClass().getClassLoader();
    private String thisClassName = this.getClass().getName();

    public boolean addSnapinPathFile(String string) {
        if (!this.historyFiles.containsKey(string)) {
            this.snapinPathFiles.addElement(string);
            this.historyFiles.put(string, string);
            return true;
        }
        return false;
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        if (string.equals(snapinResourceProtocol)) {
            return new SnapinResourceURLStreamHandler(this);
        }
        return null;
    }

    public URL getResource(String string) {
        URL uRL = null;
        uRL = ClassLoader.getSystemResource(string);
        if (uRL == null && this.consoleOneLoader != null) {
            uRL = this.consoleOneLoader.getResource(string);
        }
        if (uRL == null) {
            byte[] byArray = this.getSnapinEntryBytes(string);
            if (byArray != null) {
                try {
                    uRL = new URL(snapinResourceProtocol, "", -1, string);
                }
                catch (MalformedURLException malformedURLException) {
                    D.reportException("MalformedURLException trying to compose snapin resource url for " + string + ".  Returning null.", malformedURLException);
                    return null;
                }
            } else {
                D.out("SnapinClassLoader's getResource() could not load bytes for resource " + string + ".  Returning null.");
            }
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null && this.consoleOneLoader != null) {
            inputStream = this.consoleOneLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            byte[] byArray = this.getSnapinEntryBytes(string);
            if (byArray != null) {
                inputStream = new ByteArrayInputStream(byArray);
            } else if (D.getTrace()) {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    stringBuffer.setLength(n);
                }
                String string2 = stringBuffer.toString();
                this.printNotLoadedMessage(string2, "SnapinClassLoader could not load bytes for resource " + string2 + " Returning null.");
            }
        }
        return inputStream;
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object;
        if (D.visualCafeDebug) {
            return this.visualCafeDebugLoadClass(string, bl);
        }
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                D.out("NoClassDefFoundError trying to find system class " + string);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                D.reportException("ExceptionInInitializerError trying to load system class " + string + " - " + exceptionInInitializerError, exceptionInInitializerError);
                Throwable throwable = exceptionInInitializerError.getException();
                D.reportException("Real exception is - " + throwable, throwable);
                throw exceptionInInitializerError;
            }
            if (this.consoleOneLoader != null) {
                try {
                    clazz = this.consoleOneLoader.loadClass(string);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            object = string.replace('.', '/');
            byte[] byArray = this.getSnapinEntryBytes((String)(object = (String)object + ".class"));
            if (byArray == null) {
                if (D.getTrace()) {
                    this.printNotLoadedMessage(string, "SnapinClassLoader could not load bytes for class " + string + "  Throwing ClassNotFoundException.");
                }
                throw new ClassNotFoundException();
            }
            try {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                D.out("ClassFormatError class trying to define class " + string + "  Throwing ClassNotFoundException.");
                throw new ClassNotFoundException();
            }
        }
        if (bl) {
            try {
                this.resolveClass(clazz);
            }
            catch (Error error) {
                D.reportException("Error trying to resolve class " + string + "  Throwing ClassNotFoundException", error);
                throw new ClassNotFoundException();
            }
        }
        object = new Object[]{clazz};
        this.setSigners(clazz, (Object[])object);
        return clazz;
    }

    public Class visualCafeDebugLoadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object;
        if (string.equals(this.thisClassName)) {
            return this.getClass();
        }
        Class<?> clazz = (Class<?>)snapinclasses.get(string);
        if (clazz == null && (clazz = this.findLoadedClass(string)) != null) {
            snapinclasses.put(string, clazz);
        }
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
                if (clazz != null) {
                    snapinclasses.put(string, clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                D.out("NoClassDefFoundError trying to find system class " + string);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                D.reportException("ExceptionInInitializerError trying to load system class " + string + " - " + exceptionInInitializerError, exceptionInInitializerError);
                Throwable throwable = exceptionInInitializerError.getException();
                D.reportException("Real exception is - " + throwable, throwable);
                throw exceptionInInitializerError;
            }
            if (this.consoleOneLoader != null) {
                try {
                    clazz = this.consoleOneLoader.loadClass(string);
                    if (clazz != null) {
                        snapinclasses.put(string, clazz);
                    }
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            object = string.replace('.', '/');
            byte[] byArray = this.getSnapinEntryBytes((String)(object = (String)object + ".class"));
            if (byArray == null) {
                if (D.getTrace()) {
                    this.printNotLoadedMessage(string, "SnapinClassLoader could not load bytes for class " + string + "  Throwing ClassNotFoundException.");
                }
                throw new ClassNotFoundException();
            }
            try {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                if (clazz != null) {
                    snapinclasses.put(string, clazz);
                }
            }
            catch (ClassFormatError classFormatError) {
                D.out("ClassFormatError class trying to define class " + string + "  Throwing ClassNotFoundException.");
                throw new ClassNotFoundException();
            }
        }
        if (bl) {
            try {
                this.resolveClass(clazz);
            }
            catch (Error error) {
                D.reportException("Error trying to resolve class " + string + "  Throwing ClassNotFoundException", error);
                throw new ClassNotFoundException();
            }
        }
        object = new Object[]{clazz};
        this.setSigners(clazz, (Object[])object);
        return clazz;
    }

    /*
     * Loose catch block
     */
    private byte[] getSnapinEntryBytes(String string) {
        byte[] byArray;
        block29: {
            CachedZipFile cachedZipFile;
            Object object;
            Object object2;
            block28: {
                byArray = null;
                ZipFile zipFile = null;
                object2 = (String)this.nounsCache.get(string);
                if (object2 == null) {
                    int n = 0;
                    while (n < this.snapinPathFiles.size()) {
                        object = (String)this.snapinPathFiles.elementAt(n);
                        if (!Utilities.isFileZipOrJar((String)object)) {
                            byArray = this.readDirectoryFile((String)object, string);
                            if (byArray != null) {
                                return byArray;
                            }
                            ++n;
                            continue;
                        }
                        ZipFile zipFile2 = null;
                        try {
                            zipFile2 = new ZipFile(new File((String)object));
                        }
                        catch (IOException iOException) {
                            D.out("IOExcepion. Can't create zipFile for " + (String)object);
                            this.snapinPathFiles.removeElementAt(n);
                            continue;
                        }
                        cachedZipFile = new CachedZipFile(zipFile2);
                        this.zipCache.put(object, cachedZipFile);
                        this.populateNouns((String)object, zipFile2);
                        this.snapinPathFiles.removeElementAt(n);
                        ZipEntry zipEntry = zipFile2.getEntry(string);
                        if (zipEntry == null) continue;
                        zipFile = zipFile2;
                        object2 = object;
                        break;
                    }
                    if (zipFile == null) {
                        return null;
                    }
                } else {
                    CachedZipFile cachedZipFile2 = (CachedZipFile)this.zipCache.get(object2);
                    if (cachedZipFile2 == null) {
                        try {
                            zipFile = new ZipFile(new File((String)object2));
                        }
                        catch (IOException iOException) {
                            D.reportException("IOException.  Unable to reload ZipFile " + (String)object2 + ".", iOException);
                            return null;
                        }
                        cachedZipFile2 = new CachedZipFile(zipFile);
                        this.zipCache.put(object2, cachedZipFile2);
                    } else {
                        zipFile = cachedZipFile2.getZipFile();
                    }
                }
                ZipEntry zipEntry = zipFile.getEntry(string);
                object = null;
                object = zipFile.getInputStream(zipEntry);
                int n = (int)zipEntry.getSize();
                if (n > 0) {
                    int n2 = 0;
                    byArray = new byte[n];
                    int n3 = 0;
                    while (n3 != -1 && n2 < n) {
                        n3 = ((InputStream)object).read(byArray, n2, n - n2);
                        n2 += n3;
                    }
                    break block28;
                }
                D.out("Could not get size from jar entry " + string + " in jar " + (String)object2);
            }
            cachedZipFile = null;
            try {
                if (object != null) {
                    ((InputStream)object).close();
                }
                break block29;
            }
            catch (IOException iOException) {}
            break block29;
            {
                catch (ZipException zipException) {
                    D.reportException("ZipException trying to load bytes for " + string + " from " + (String)object2 + " - " + zipException, zipException);
                    cachedZipFile = null;
                    try {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                        break block29;
                    }
                    catch (IOException iOException) {}
                    break block29;
                }
                catch (IOException iOException) {
                    D.reportException("IOException error tring to load bytes for " + string + " from " + (String)object2 + " - " + iOException, iOException);
                    cachedZipFile = null;
                    try {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                        break block29;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                cachedZipFile = null;
                try {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] readDirectoryFile(String var1_1, String var2_2) {
        block13: {
            var3_3 = null;
            var4_4 = null;
            try {
                block12: {
                    var8_5 = new File(var1_1, var2_2);
                    if (!var8_5.exists()) break block12;
                    var9_9 = new FileInputStream((File)var8_5);
                    var4_4 = new BufferedInputStream(var9_9, 4096);
                    var10_10 = 0;
                    var11_11 = (int)var8_5.length();
                    var3_3 = new byte[var11_11];
                    var12_12 = 0;
                    if (true) ** GOTO lbl17
                    do {
                        var12_12 = var4_4.read(var3_3, var10_10, var11_11 - var10_10);
                        var10_10 += var12_12;
lbl17:
                        // 2 sources

                        if (var12_12 == -1) break;
                    } while (var10_10 < var11_11);
                }
                var6_13 = null;
                ** if (var4_4 == null) goto lbl-1000
            }
            catch (Throwable var5_16) {
                var6_15 = null;
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (IOException var8_8) {
                        // empty catch block
                    }
                }
                throw var5_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var4_4.close();
                }
                catch (IOException var8_5) {}
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (IOException var8_6) {
                    D.reportException("IOException trying to load bytes for " + var2_2 + " from directory " + var1_1 + " - " + var8_6, var8_6);
                    var6_14 = null;
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var8_7) {}
                    }
                }
            }
        }
        return var3_3;
    }

    private void populateNouns(String string, ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            this.nounsCache.put(string2, string);
        }
    }

    private void printNotLoadedMessage(String string, String string2) {
        boolean bl = true;
        if (ignoreSuffixes == null) {
            this.populateSuffixes();
        }
        String string3 = string.toLowerCase();
        int n = 0;
        while (n < ignoreSuffixes.length) {
            if (string3.endsWith(ignoreSuffixes[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            D.out(string2);
        }
    }

    private void populateSuffixes() {
        Vector<String> vector = new Vector<String>();
        Locale locale = ShellStubs.getLocale();
        String string = locale.toString();
        vector.addElement(string.toLowerCase());
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.toString().lastIndexOf(95);
        while (n != -1) {
            stringBuffer.setLength(n);
            vector.addElement(new String(stringBuffer).toLowerCase());
            n = stringBuffer.toString().lastIndexOf(95);
        }
        ignoreSuffixes = new String[vector.size()];
        int n2 = 0;
        while (n2 < ignoreSuffixes.length) {
            SnapinClassLoader.ignoreSuffixes[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
    }

    /*
     * Loose catch block
     */
    public synchronized Class loadClassFromClassPath(String string, boolean bl) throws ClassNotFoundException {
        Object object;
        String string2;
        Object object2 = null;
        Properties properties = System.getProperties();
        String string3 = properties.getProperty("java.class.path");
        if (string3 == null || string3.equals("")) {
            throw new ClassNotFoundException();
        }
        String string4 = string.replace('.', '/');
        string4 = string4 + ".class";
        String string5 = properties.getProperty("path.separator");
        if (string5 == null || string5.equals("")) {
            string5 = ";";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string5);
        while (stringTokenizer.hasMoreTokens()) {
            block27: {
                InputStream inputStream;
                block26: {
                    object2 = null;
                    string2 = stringTokenizer.nextToken();
                    if (!Utilities.isFileZipOrJar(string2)) {
                        object2 = this.readDirectoryFile(string2, string4);
                        if (object2 == null) continue;
                        break;
                    }
                    object = null;
                    try {
                        object = new ZipFile(new File(string2));
                    }
                    catch (IOException iOException) {
                        D.out("IOExcepion trying to load file \"" + string2 + "\"");
                        continue;
                    }
                    ZipEntry zipEntry = ((ZipFile)object).getEntry(string4);
                    if (zipEntry == null) continue;
                    inputStream = null;
                    inputStream = ((ZipFile)object).getInputStream(zipEntry);
                    int n = (int)zipEntry.getSize();
                    if (n > 0) {
                        int n2 = 0;
                        object2 = new byte[n];
                        int n3 = 0;
                        while (n3 != -1 && n2 < n) {
                            n3 = inputStream.read((byte[])object2, n2, n - n2);
                            n2 += n3;
                        }
                        break block26;
                    }
                    D.out("Could not get size for entry " + string4 + " in jar " + string2);
                }
                Object var14_15 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block27;
                }
                catch (IOException iOException) {}
                break block27;
                {
                    catch (ZipException zipException) {
                        D.reportException("ZipException trying to load bytes for " + string4 + " from zip/jar " + string2 + " - " + zipException, zipException);
                        var14_15 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block27;
                        }
                        catch (IOException iOException) {}
                        break block27;
                    }
                    catch (IOException iOException) {
                        D.reportException("IOException error tring to load bytes for " + string + " from zip/jar " + string2 + " - " + iOException, iOException);
                        var14_15 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block27;
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (object2 != null) break;
        }
        if (object2 == null) {
            D.out("SnapinClassLoader could not load bytes for class " + string + "  Throwing ClassNotFoundException.");
            throw new ClassNotFoundException();
        }
        string2 = object2;
        object = null;
        try {
            object = this.defineClass(string, (byte[])string2, 0, ((String)string2).length);
            snapinclasses.put(string, object);
        }
        catch (ClassFormatError classFormatError) {
            D.reportException("ClassFormatError class trying to define class " + string + "  Throwing ClassNotFoundException.", classFormatError);
            return null;
        }
        if (bl) {
            this.resolveClass((Class<?>)object);
        }
        return object;
    }

    public SnapinClassLoader() {
        if (this.consoleOneLoader == null) {
            D.out("consoleOneLoader = null");
        } else {
            D.out("consoleOneLoader != null");
        }
    }
}

