/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.Constants;
import com.novell.application.console.shell.D;
import com.novell.application.console.shell.Registry;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.Scopes;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultIndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.snapin.context.PageSnapinContext;
import com.novell.application.console.snapin.context.SnapinContext;
import com.objectspace.jgl.Array;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Utilities {
    private static final String[] jarExtensions = Constants.JarFileExtensionsKey;
    private static final String[] snapinExtensions = Constants.SnapinFileExtensionsKey;

    public static void dumpProperties() {
        Properties properties = System.getProperties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + "=" + ((Hashtable)properties).get(string));
        }
    }

    public static boolean isEnumVirtual(ObjectEntryEnumeration objectEntryEnumeration) {
        boolean bl = objectEntryEnumeration instanceof BrowserObjectEntryEnumeration;
        if (bl && objectEntryEnumeration instanceof DefaultIndexedObjectEntryEnumeration) {
            bl = false;
        }
        return bl;
    }

    public static boolean checkForPageSnapins(ObjectEntryCollection objectEntryCollection) {
        InitSnapinInfo initSnapinInfo = new InitSnapinInfo(MainShell.getInstance(), (Object)Shell.SNAPIN_PAGE, (SnapinContext)new PageSnapinContext(null, objectEntryCollection));
        initSnapinInfo.setTracking(false);
        boolean bl = Registry.checkSnapins(Scopes.page(objectEntryCollection.getFirstElement()), initSnapinInfo);
        return bl;
    }

    public static ObjectEntry getMappedContainer(ObjectEntry objectEntry) throws SnapinException {
        ObjectEntry[] objectEntryArray = ShellStubs.mapObjectEntry(objectEntry);
        ObjectEntry objectEntry2 = objectEntry;
        if (objectEntryArray != null && objectEntryArray.length > 0) {
            objectEntry2 = objectEntryArray[0];
        }
        return objectEntry2;
    }

    public static void runOnEventThreadAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                D.reportException("Exception trying to invoke process on event thread.", exception);
            }
        }
    }

    public static void runOnEventThreadLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void handleException(SnapinException snapinException) {
        if (snapinException.getReportFlag()) {
            int n = Utilities.reportException(snapinException);
            if (snapinException.getSeverity() == 2 && n == 1) {
                System.exit(-1);
            }
        }
        if (snapinException.getSeverity() == 3) {
            System.exit(-1);
        }
    }

    public static int reportException(SnapinException snapinException) {
        String string = Resources.getString("SnapinExceptionMessageBoxTitleKey");
        String string2 = snapinException.getLocalizedMessage();
        int n = 3;
        switch (snapinException.getSeverity()) {
            case 1: {
                n = 2;
                break;
            }
            case 0: 
            case 3: {
                n = 3;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            default: {
                n = 3;
                break;
            }
        }
        return ShellStubs.launchMsgBox(string, string2, n, snapinException.getHelpSetName(), snapinException.getHelpID());
    }

    public static void centerWindow(Window window) {
        Dimension dimension = window.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        n3 = (dimension2.width - n) / 2;
        n4 = (dimension2.height - n2) / 2;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        ((Component)window).setLocation(n3, n4);
    }

    public static void centerComponentOnComponent(Component component, Component component2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (!component.isVisible() || component.getSize().width == 0 || component.getSize().height == 0) {
            n = 0;
            n2 = 0;
            n3 = dimension.width;
            n4 = dimension.height;
        } else {
            n = component.getLocationOnScreen().x;
            n2 = component.getLocationOnScreen().y;
            n3 = component.getSize().width;
            n4 = component.getSize().height;
        }
        n = Math.max(0, n + (n3 - component2.getSize().width) / 2);
        n2 = Math.max(0, n2 + (n4 - component2.getSize().height) / 2);
        n = Math.min(n, dimension.width - component2.getSize().width);
        n2 = Math.min(n2, dimension.height - component2.getSize().height);
        component2.setLocation(n, n2);
    }

    static boolean objectEntriesEqual(ObjectEntry objectEntry, ObjectEntry objectEntry2) {
        if (!objectEntry.getName().equals(objectEntry2.getName())) {
            return false;
        }
        if (!objectEntry.getObjectType().getName().equals(objectEntry2.getObjectType().getName())) {
            return false;
        }
        if (!objectEntry.getObjectType().getNamespace().getUniqueID().equals(objectEntry2.getObjectType().getNamespace().getUniqueID())) {
            return false;
        }
        return objectEntry.getFullName().equals(objectEntry2.getFullName());
    }

    static boolean isFileZipOrJar(String string) {
        boolean bl = false;
        String string2 = string.toLowerCase();
        int n = 0;
        while (n < jarExtensions.length) {
            if (string2.endsWith(jarExtensions[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    static boolean isSnapinFile(String string) {
        boolean bl = false;
        String string2 = string.toLowerCase();
        int n = 0;
        while (n < snapinExtensions.length) {
            if (string2.endsWith(snapinExtensions[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    static Vector arrayToVector(Array array) {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < array.size()) {
            vector.addElement(array.at(n));
            ++n;
        }
        return vector;
    }

    static Array vectorToArray(Vector vector) {
        Array array = new Array();
        int n = 0;
        while (n < vector.size()) {
            array.add(vector.elementAt(n));
            ++n;
        }
        return array;
    }

    public static Object jglArrayToArray(Array array, Class clazz) {
        Object object = java.lang.reflect.Array.newInstance(clazz, array.size());
        int n = 0;
        while (n < array.size()) {
            java.lang.reflect.Array.set(object, n, array.at(n));
            ++n;
        }
        return object;
    }

    public static Array arrayToJglArray(Object object) {
        Array array = new Array();
        int n = java.lang.reflect.Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            array.add(java.lang.reflect.Array.get(object, n2));
            ++n2;
        }
        return array;
    }

    public static Hashtable combineHashtables(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = (Hashtable)hashtable.clone();
        Enumeration enumeration = hashtable2.elements();
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            hashtable3.put((String)enumeration2.nextElement(), (String)enumeration.nextElement());
        }
        return hashtable3;
    }

    public static boolean instanceOf(Object object, String string) {
        Array array = new Array();
        Utilities.getClasses(object.getClass(), array);
        return array.contains((Object)string);
    }

    private static void getClasses(Class clazz, Array array) {
        if (clazz == null) {
            return;
        }
        array.add((Object)clazz.getName());
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            Utilities.getClasses(classArray[n], array);
            ++n;
        }
        Utilities.getClasses(clazz.getSuperclass(), array);
    }

    public static void showPopup(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        jPopupMenu.show(component, n, n2);
    }

    public static void sortStrings(String[] stringArray) {
        int n;
        if (stringArray != null && (n = stringArray.length) > 1) {
            int n2 = n;
            while (n2 > 1) {
                n2 /= 2;
                int n3 = n - 1;
                while (n3 > n2) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 <= n3 - n2) {
                        int n6 = n5 + n2;
                        if (stringArray[n5].compareTo(stringArray[n6]) > 0) {
                            String string = stringArray[n5];
                            stringArray[n5] = stringArray[n6];
                            stringArray[n6] = string;
                            n4 = n5;
                        }
                        ++n5;
                    }
                    n3 = n4;
                }
            }
        }
    }

    public static Frame getParentFrame(Component component) {
        Frame frame = null;
        if (component == null) {
            frame = new Frame();
        } else if (!(component instanceof Frame)) {
            Container container = null;
            container = component.getParent();
            while (container != null) {
                if (container instanceof Frame) {
                    frame = (Frame)container;
                    break;
                }
                container = container.getParent();
            }
            if (frame == null) {
                frame = new Frame();
            }
        } else {
            frame = (Frame)component;
        }
        return frame;
    }
}

