/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.ConsoleShell;
import com.novell.application.console.shell.D;
import com.novell.application.console.shell.Menus;
import com.novell.application.console.shell.Registry;
import com.novell.application.console.shell.Scopes;
import com.novell.application.console.shell.ShellPreferences;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.shell.StatusBar;
import com.novell.application.console.shell.ToolBar;
import com.novell.application.console.snapin.ExtendedViewSnapin;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.ViewSnapin;
import com.novell.application.console.snapin.ViewSnapinRev2;
import com.novell.application.console.snapin.context.SnapinContext;
import com.novell.application.console.snapin.context.ViewSnapinContext;
import com.novell.application.console.snapin.scope.GlobalScope;
import com.novell.application.console.snapin.scope.NamespaceContainerTypesScope;
import com.novell.application.console.snapin.scope.NamespaceLeafTypesScope;
import com.novell.application.console.snapin.scope.NamespaceScope;
import com.novell.application.console.snapin.scope.NamespaceTreeObjectsScope;
import com.novell.application.console.snapin.scope.NamespaceTypeScope;
import com.novell.utility.localization.Loc;
import com.objectspace.jgl.Array;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;

class ViewManager {
    private static final String NULL_NAME = "null";
    private ConsoleShell console;
    private ViewSnapin lastViewSnapin = null;
    private ViewSnapin currentViewSnapin = null;
    private Component currentView = null;
    private ViewSnapinContext currentViewContext = null;
    private JMenu viewMenu;
    private Hashtable viewSnapins = new Hashtable();
    private ViewMenuListener viewMenuListener;
    private Array viewMenuItems;
    private Array lastViewSnapinArray;
    private ButtonGroup buttonGroup;
    private boolean bLastDisplayViewTitle;
    private String rememberedView;
    private Hashtable keyListeners;
    private Hashtable stickyViews;

    JMenu getViewMenu() {
        return this.viewMenu;
    }

    void setViewMenu(JMenu jMenu) {
        this.viewMenu = jMenu;
    }

    ViewSnapin getCurrentViewSnapin() {
        return this.currentViewSnapin;
    }

    Component getCurrentView() {
        return this.currentView;
    }

    ViewSnapin getCurrentBusyView() {
        return this.currentViewSnapin;
    }

    void selectionChanged(ObjectEntryCollection objectEntryCollection, boolean bl) {
        if (!bl) {
            this.treeItemSelected(objectEntryCollection);
        } else {
            this.switchMainUI(objectEntryCollection, ShellStubs.getTreeSelection());
        }
    }

    boolean setCurrentView(String string) {
        block6: {
            D.assert(string != null);
            if (string == null) {
                D.out("Called setCurrentView with the viewName parameter == null.  Doing nothing and returning false.");
                return false;
            }
            if (this.currentViewSnapin != null && string.equals(this.currentViewSnapin.getUniqueID())) {
                return true;
            }
            ViewSnapin viewSnapin = (ViewSnapin)this.viewSnapins.get(string);
            if (viewSnapin == null) {
                D.out("Trying to select a view which cannot be found.");
                return false;
            }
            this.console.startWaitCursor();
            try {
                this.currentViewSnapin = viewSnapin;
                this.showView();
                ObjectEntryCollection objectEntryCollection = ShellStubs.getCurrentSelections();
                ObjectEntry objectEntry = ShellStubs.getTreeSelection();
                this.stickyViews.put("DefaultViews:" + objectEntry.getNamespaceUniqueID() + ":" + objectEntry.getObjectType().getName(), this.currentViewSnapin.getUniqueID());
                if (this.console.getFocusManager().getState() == 1) {
                    this.switchMainUI(objectEntryCollection, objectEntry);
                    break block6;
                }
                ShellStubs.giveTreeFocus();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.console.endWaitCursor();
                throw throwable;
            }
        }
        Object var4_5 = null;
        this.console.endWaitCursor();
        return true;
    }

    void refreshCurrentView() {
        if (this.currentViewSnapin != null) {
            if (this.currentViewSnapin instanceof ViewSnapinRev2 && this.bLastDisplayViewTitle == ConsoleShell.getDescriptionBarState()) {
                try {
                    Object object;
                    if (this.currentViewContext != null) {
                        object = ShellStubs.getTreeSelection();
                        ResultModifier resultModifier = ShellStubs.getFilterResultModifier(object.getNamespaceUniqueID(), "Current");
                        this.currentViewContext.setResultModifier(resultModifier);
                    }
                    object = (ViewSnapinRev2)((Object)this.currentViewSnapin);
                    object.refresh();
                }
                catch (Exception exception) {
                    D.reportSnapinError(exception);
                }
            } else {
                this.showView();
            }
        }
    }

    public void rememberView() {
        this.rememberedView = this.currentViewSnapin == null ? NULL_NAME : this.currentViewSnapin.getUniqueID();
    }

    public void switchToLastRemembered() {
        D.assert(this.rememberedView != null);
        if (this.rememberedView == null) {
            return;
        }
        if (this.rememberedView.equals(NULL_NAME)) {
            D.out("Last remembered view == \"null\", cannot switch view to last remembered");
            return;
        }
        ObjectEntry objectEntry = ShellStubs.getTreeSelection();
        String string = this.getDefaultViewUniqueId("DefaultViews:Preference:", objectEntry);
        String string2 = (String)this.stickyViews.get("DefaultViews:" + objectEntry.getNamespaceUniqueID() + ":" + objectEntry.getObjectType().getName());
        if (this.viewSnapins.containsKey(this.rememberedView)) {
            this.setCurrentView(this.rememberedView);
        } else if (string2 != null && this.viewSnapins.containsKey(string2)) {
            this.setCurrentView(string2);
        } else if (string != null && this.viewSnapins.containsKey(string)) {
            this.setCurrentView(string);
        }
    }

    private void treeItemSelected(ObjectEntryCollection objectEntryCollection) {
        this.console.startWaitCursor();
        try {
            ObjectEntry objectEntry = ShellStubs.getTreeSelection();
            InitSnapinInfo initSnapinInfo = new InitSnapinInfo(null, null, (SnapinContext)this.getSnapinContext(objectEntry));
            initSnapinInfo.setTracking(false);
            Array array = Registry.getSnapins(Scopes.view(objectEntry), initSnapinInfo);
            boolean bl = false;
            if (this.lastViewSnapinArray == null || this.lastViewSnapinArray.size() != array.size()) {
                bl = true;
            } else {
                int n = 0;
                while (n < array.size()) {
                    if (this.lastViewSnapinArray.at(n) != array.at(n)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            this.lastViewSnapinArray = array;
            if (array.size() == 0) {
                this.viewMenuItems = new Array();
                this.viewSnapins = new Hashtable();
                this.buttonGroup = new ButtonGroup();
                this.currentViewSnapin = null;
                this.showView();
            } else if (bl) {
                String string = this.getDefaultViewUniqueId("DefaultViews:Preference:", objectEntry);
                String string2 = (String)this.stickyViews.get("DefaultViews:" + objectEntry.getNamespaceUniqueID() + ":" + objectEntry.getObjectType().getName());
                this.viewMenuItems = new Array();
                this.viewSnapins = new Hashtable();
                this.buttonGroup = new ButtonGroup();
                boolean bl2 = false;
                boolean bl3 = false;
                int n = 0;
                while (n < array.size()) {
                    ViewSnapin viewSnapin = (ViewSnapin)array.at(n);
                    String string3 = viewSnapin.getUniqueID();
                    if (this.viewSnapins.get(string3) == null) {
                        this.viewSnapins.put(string3, viewSnapin);
                    } else {
                        D.out("Warning: uniqueIDs of two separate views are the same, ignoring second view named " + string3);
                    }
                    String string4 = "";
                    try {
                        string4 = viewSnapin.getViewMenuName();
                    }
                    catch (Exception exception) {
                        D.reportSnapinError(exception);
                    }
                    JRadioButtonMenuItem jRadioButtonMenuItem = NConeFactory.novellJRadioButtonMenuItem(new JRadioButtonMenuItem(), Loc.removeHotChar(string4), "");
                    Loc.setText(jRadioButtonMenuItem, string4);
                    jRadioButtonMenuItem.setActionCommand(string3);
                    this.viewMenuItems.add((Object)jRadioButtonMenuItem);
                    jRadioButtonMenuItem.addItemListener(this.viewMenuListener);
                    this.buttonGroup.add(jRadioButtonMenuItem);
                    if (n == 0) {
                        this.currentViewSnapin = viewSnapin;
                    }
                    if (!bl3 && !bl2 && string != null && viewSnapin.getUniqueID().compareTo(string) == 0) {
                        this.currentViewSnapin = viewSnapin;
                    }
                    if (!bl3 && string2 != null && viewSnapin.getUniqueID().compareTo(string2) == 0) {
                        this.currentViewSnapin = viewSnapin;
                        bl2 = true;
                    }
                    if (this.lastViewSnapin != null && this.lastViewSnapin.getUniqueID() == viewSnapin.getUniqueID()) {
                        D.out("Using last view");
                        this.currentViewSnapin = viewSnapin;
                        bl3 = true;
                    }
                    ++n;
                }
                this.showView();
                if (this.currentViewSnapin != null) {
                    this.stickyViews.put("DefaultViews:" + objectEntry.getNamespaceUniqueID() + ":" + objectEntry.getObjectType().getName(), this.currentViewSnapin.getUniqueID());
                } else {
                    D.out("Could not set sticky view, currentViewSnapin == null");
                }
            } else {
                this.showView();
            }
            this.switchMainUI(objectEntryCollection, objectEntry);
        }
        finally {
            Object var3_17 = null;
            this.console.endWaitCursor();
        }
    }

    private void updateRadioButtons() {
        if (this.currentViewSnapin == null) {
            return;
        }
        boolean bl = this.viewMenuListener.blockEvents;
        this.viewMenuListener.blockEvents = true;
        int n = 0;
        while (n < this.viewMenuItems.size()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.viewMenuItems.at(n);
            if (jRadioButtonMenuItem.getActionCommand() != null && jRadioButtonMenuItem.getActionCommand().equals(this.currentViewSnapin.getUniqueID())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n;
        }
        this.viewMenuListener.blockEvents = bl;
    }

    private void populateViewMenu() {
        Menus.cleanViewMenu(this.viewMenu);
        int n = 0;
        if (this.viewMenu != null) {
            int n2 = 0;
            while (n2 < this.viewMenuItems.size()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.viewMenuItems.at(n2);
                this.viewMenu.insert(jRadioButtonMenuItem, n++);
                ++n2;
            }
            this.viewMenu.insertSeparator(n);
        }
        this.updateRadioButtons();
    }

    private void switchMainUI(ObjectEntryCollection objectEntryCollection, ObjectEntry objectEntry) {
        int n;
        this.console.startWaitCursor();
        String[] stringArray = null;
        String[] stringArray2 = null;
        ViewSnapin viewSnapin = this.currentViewSnapin;
        if (viewSnapin != null && viewSnapin instanceof ExtendedViewSnapin) {
            stringArray = ((ExtendedViewSnapin)viewSnapin).getExtendedUniqueIDs();
        }
        if (stringArray == null) {
            stringArray2 = new String[1];
            stringArray2[0] = viewSnapin == null ? null : viewSnapin.getUniqueID();
        } else {
            stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = viewSnapin.getUniqueID();
            n = 0;
            while (n < stringArray.length) {
                stringArray2[n + 1] = stringArray[n];
                ++n;
            }
        }
        if (stringArray2[0] == null) {
            stringArray2[0] = "";
        }
        n = 1;
        if (stringArray2[0].equals("")) {
            n = 0;
        }
        ToolBar.switchToolBar(objectEntryCollection, this.console.getToolBar(), stringArray2, objectEntry, n != 0);
        StatusBar.switchStatusBar(objectEntryCollection, this.console.getStatusBar(), stringArray2, objectEntry, n != 0);
        this.console.setMainMenu(Menus.getMenuBar(objectEntryCollection, this.console.getShell(), stringArray2, objectEntry));
        this.populateViewMenu();
        this.console.endWaitCursor();
    }

    private static String removeAmpersands(String string) {
        String string2 = string.trim();
        while (-1 != string2.indexOf("&")) {
            String string3 = string2.substring(0, string2.indexOf("&"));
            string2 = string3 = string3 + string2.substring(string2.indexOf("&") + 1);
        }
        return string2;
    }

    private void removeViewKeyListeners(Component component, ViewSnapin viewSnapin) {
        if (component != null && viewSnapin != null) {
            this.removeKeyListeners(component, viewSnapin.getUniqueID());
        }
    }

    private void showView() {
        ViewSnapin viewSnapin = this.lastViewSnapin;
        Component component = this.currentView;
        ViewSnapin viewSnapin2 = this.currentViewSnapin;
        Component component2 = null;
        JPanel jPanel = null;
        if (viewSnapin2 == null) {
            D.out("New snapin view does not exist or is registered incorrectly");
            this.console.setRightPane(new JPanel());
            this.removeViewKeyListeners(component, viewSnapin);
            this.viewMenu = null;
            component = null;
            this.lastViewSnapin = null;
            this.currentView = null;
            this.currentViewSnapin = null;
        } else {
            Object object;
            try {
                try {
                    if (component != null) {
                        viewSnapin.setInactive(component);
                    }
                }
                catch (Exception exception) {
                    D.reportSnapinError(exception);
                }
                if (viewSnapin != viewSnapin2) {
                    if (viewSnapin != null) {
                        try {
                            viewSnapin.shutdownSnapin();
                        }
                        catch (Exception exception) {
                            D.reportSnapinError(exception);
                        }
                    }
                    try {
                        object = new InitSnapinInfo(MainShell.getInstance(), (Object)Shell.SNAPIN_VIEW);
                        viewSnapin2.initSnapin((InitSnapinInfo)object);
                    }
                    catch (Exception exception) {
                        D.reportSnapinError(exception);
                    }
                }
                ShellStubs.setBusy(viewSnapin2, true, 1);
                this.currentViewContext = this.getSnapinContext(ShellStubs.getTreeSelection());
                component2 = viewSnapin2.getView(this.currentViewContext);
                if (component2 == null) {
                    D.out("Error: ViewSnapin returned null view.");
                }
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
                component2 = null;
            }
            try {
                jPanel = new JPanel(new BorderLayout());
                if (ConsoleShell.getDescriptionBarState()) {
                    object = new JLabel(ViewManager.removeAmpersands(viewSnapin2.getViewMenuName()), 0);
                    NConeFactory.novellJLabel((JLabel)object, Loc.removeHotChar(viewSnapin2.getViewMenuName()), "");
                    ((JComponent)object).setBorder(BorderFactory.createEtchedBorder());
                    jPanel.add((Component)object, "North");
                }
                this.bLastDisplayViewTitle = ConsoleShell.getDescriptionBarState();
                if (component2 != null) {
                    jPanel.add(component2, "Center");
                }
                ShellStubs.setBusy(viewSnapin2, false, 1);
                if (component != component2) {
                    this.removeViewKeyListeners(component, viewSnapin);
                    this.addKeyListeners(component2, viewSnapin2.getUniqueID());
                    this.console.getActivityBar().changedView(viewSnapin);
                }
                this.currentView = component2;
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            if (jPanel == null) {
                this.console.setRightPane(new JPanel());
            } else {
                this.console.setRightPane(jPanel);
            }
        }
        this.lastViewSnapin = this.currentViewSnapin;
    }

    void shutDown() {
        if (this.currentViewSnapin != null) {
            try {
                this.currentViewSnapin.setInactive(this.currentView);
                this.currentViewSnapin.shutdownSnapin();
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
        }
    }

    private ViewSnapinContext getSnapinContext(ObjectEntry objectEntry) {
        ResultModifier resultModifier = ShellStubs.getFilterResultModifier(objectEntry.getNamespaceUniqueID(), "Current");
        ViewSnapinContext viewSnapinContext = new ViewSnapinContext(objectEntry, resultModifier);
        return viewSnapinContext;
    }

    private String getDefaultViewUniqueId(String string, ObjectEntry objectEntry) {
        String string2 = objectEntry.getNamespaceUniqueID();
        String string3 = null;
        NamespaceTypeScope namespaceTypeScope = new NamespaceTypeScope(Shell.SNAPIN_VIEW, string2, objectEntry.getObjectType().getName());
        string3 = ShellPreferences.getValue(string + namespaceTypeScope.getScopeKey() + ":" + string2 + ":" + objectEntry.getObjectType().getName());
        if (string3 == null) {
            boolean bl = objectEntry.getObjectType().isContainer();
            if (bl) {
                NamespaceContainerTypesScope namespaceContainerTypesScope = new NamespaceContainerTypesScope(Shell.SNAPIN_VIEW, string2);
                string3 = ShellPreferences.getValue(string + namespaceContainerTypesScope.getScopeKey() + ":" + string2);
            } else {
                NamespaceLeafTypesScope namespaceLeafTypesScope = new NamespaceLeafTypesScope(Shell.SNAPIN_VIEW, string2);
                string3 = ShellPreferences.getValue(string + namespaceLeafTypesScope.getScopeKey() + ":" + string2);
            }
        }
        if (string3 == null && ShellStubs.isContainer(objectEntry)) {
            NamespaceTreeObjectsScope namespaceTreeObjectsScope = new NamespaceTreeObjectsScope(Shell.SNAPIN_VIEW, string2);
            string3 = ShellPreferences.getValue(string + namespaceTreeObjectsScope.getScopeKey() + ":" + string2);
        }
        if (string3 == null) {
            NamespaceScope namespaceScope = new NamespaceScope(Shell.SNAPIN_VIEW, string2);
            string3 = ShellPreferences.getValue(string + namespaceTypeScope.getScopeKey() + ":" + string2);
        }
        if (string3 == null) {
            GlobalScope globalScope = new GlobalScope(Shell.SNAPIN_VIEW);
            string3 = ShellPreferences.getValue(string + globalScope.getScopeKey());
        }
        return string3;
    }

    private void addKeyListeners(Component component, String string) {
        Array array = (Array)this.keyListeners.get(string);
        if (array != null) {
            int n = 0;
            while (n < array.size()) {
                KeyListener keyListener = (KeyListener)array.at(n);
                component.addKeyListener(keyListener);
                ++n;
            }
        }
    }

    private void removeKeyListeners(Component component, String string) {
        Array array = (Array)this.keyListeners.get(string);
        if (array != null) {
            int n = 0;
            while (n < array.size()) {
                KeyListener keyListener = (KeyListener)array.at(n);
                component.removeKeyListener(keyListener);
                ++n;
            }
        }
    }

    void addKeyListener(KeyListener keyListener, String string) {
        if (string == null || string.equals("")) {
            D.assert(false, "Passed null or \"\" for view name to addViewKeyListener");
            return;
        }
        Array array = (Array)this.keyListeners.get(string);
        if (array == null) {
            array = new Array();
            this.keyListeners.put(string, array);
        }
        boolean bl = false;
        int n = 0;
        while (n < array.size()) {
            if (keyListener == array.at(n)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            array.add((Object)keyListener);
        }
        if (this.currentViewSnapin != null && string.equals(this.currentViewSnapin.getUniqueID()) && this.currentView != null) {
            this.currentView.addKeyListener(keyListener);
        }
    }

    void removeKeyListener(KeyListener keyListener, String string) {
        if (string == null || string.equals("")) {
            D.assert(false, "Passed null or \"\" for view name to removeViewKeyListener");
            return;
        }
        Array array = (Array)this.keyListeners.get(string);
        if (array != null) {
            array.remove((Object)keyListener);
        }
        if (this.currentViewSnapin != null && string.equals(this.currentViewSnapin.getUniqueID()) && this.currentView != null) {
            this.currentView.removeKeyListener(keyListener);
        }
    }

    ViewManager(ConsoleShell consoleShell) {
        ViewManager viewManager = this;
        if (viewManager == null) {
            throw null;
        }
        this.viewMenuListener = viewManager.new ViewMenuListener();
        this.viewMenuItems = new Array();
        this.keyListeners = new Hashtable();
        this.stickyViews = new Hashtable();
        this.console = consoleShell;
        this.bLastDisplayViewTitle = this.bLastDisplayViewTitle;
    }

    private class ViewMenuListener
    implements ItemListener {
        boolean blockEvents = false;

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && !this.blockEvents) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
                ViewManager.this.setCurrentView(jRadioButtonMenuItem.getActionCommand());
            }
        }

        ViewMenuListener() {
        }
    }
}

