/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.shell.Constants;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.MenuSnapin;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.NonFocusButton;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.ToolBarSnapin;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public abstract class AbstractToolBarMenuSnapin
implements ToolBarSnapin,
MenuSnapin {
    private static final Dimension BUTTON_SIZE = Constants.SimpleToolBarMenuSnapinButtonSizeKey;
    private static final String DEFAULT_MENU = "Tools";
    private boolean noMnemonic = false;
    private boolean noToolTip = false;
    protected Component toolBarItem = null;
    protected JMenuItem menuItem = null;
    protected Shell shell = null;
    private Icon icon = null;
    private boolean enabled = true;

    public abstract String getSnapinName();

    public abstract String getSnapinDescription();

    public final boolean initSnapin(InitSnapinInfo initSnapinInfo) {
        this.shell = initSnapinInfo.getShell();
        return this.initAbstractSnapin(initSnapinInfo);
    }

    public boolean initAbstractSnapin(InitSnapinInfo initSnapinInfo) {
        return true;
    }

    public final void shutdownSnapin() {
        this.shutdownAbstractSnapin();
    }

    public void shutdownAbstractSnapin() {
    }

    public Component getToolBarItem() {
        if (this.toolBarItem == null) {
            if (this.icon == null) {
                this.icon = this.getIcon();
            }
            NonFocusButton nonFocusButton = this.icon == null ? new NonFocusButton() : new NonFocusButton(this.icon);
            nonFocusButton.setPreferredSize(BUTTON_SIZE);
            nonFocusButton.setMaximumSize(BUTTON_SIZE);
            String string = this.getToolTip();
            if (!this.noToolTip) {
                nonFocusButton.setToolTipText(Loc.removeHotChar(this.getToolTip()));
            }
            AbstractToolBarMenuSnapin abstractToolBarMenuSnapin = this;
            if (abstractToolBarMenuSnapin == null) {
                throw null;
            }
            nonFocusButton.addActionListener(new ActionListener(abstractToolBarMenuSnapin){
                private final /* synthetic */ AbstractToolBarMenuSnapin this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$0.toolBarItem || actionEvent.getSource() == this.this$0.menuItem) {
                        this.this$0.execute();
                    }
                }
                {
                    this.this$0 = abstractToolBarMenuSnapin;
                    this.constructor$0(abstractToolBarMenuSnapin);
                }

                private final void constructor$0(AbstractToolBarMenuSnapin abstractToolBarMenuSnapin) {
                }
            });
            this.toolBarItem = nonFocusButton;
        }
        if (!this.enabled) {
            this.toolBarItem.setEnabled(false);
        }
        return this.toolBarItem;
    }

    public JMenuItem[] getMenuItems() {
        JMenuItem[] jMenuItemArray = null;
        jMenuItemArray = new JMenuItem[1];
        String string = this.getMenuName();
        if (string.indexOf("&") != -1) {
            this.menuItem = NConeFactory.novellJMenuItem(new JMenuItem(), Loc.removeHotChar(string), "");
            Loc.setText(this.menuItem, string);
        } else {
            this.menuItem = NConeFactory.novellJMenuItem(new JMenuItem(this.getMenuName()), Loc.removeHotChar(string), "");
            char c = this.getMenuMnemonic();
            if (!this.noMnemonic) {
                this.menuItem.setMnemonic(c);
            }
        }
        AbstractToolBarMenuSnapin abstractToolBarMenuSnapin = this;
        if (abstractToolBarMenuSnapin == null) {
            throw null;
        }
        this.menuItem.addActionListener(new ActionListener(abstractToolBarMenuSnapin){
            private final /* synthetic */ AbstractToolBarMenuSnapin this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.this$0.toolBarItem || actionEvent.getSource() == this.this$0.menuItem) {
                    this.this$0.execute();
                }
            }
            {
                this.this$0 = abstractToolBarMenuSnapin;
                this.constructor$0(abstractToolBarMenuSnapin);
            }

            private final void constructor$0(AbstractToolBarMenuSnapin abstractToolBarMenuSnapin) {
            }
        });
        jMenuItemArray[0] = this.menuItem;
        if (!this.enabled) {
            this.menuItem.setEnabled(false);
        }
        return jMenuItemArray;
    }

    public String getMenuLocation() {
        return DEFAULT_MENU;
    }

    public abstract void execute();

    public abstract Icon getIcon();

    public abstract String getMenuName();

    public String getToolTip() {
        this.noToolTip = true;
        return "";
    }

    public char getMenuMnemonic() {
        this.noMnemonic = true;
        return 'a';
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.menuItem != null) {
            this.menuItem.setEnabled(bl);
        }
        if (this.toolBarItem != null) {
            this.toolBarItem.setEnabled(bl);
        }
    }
}

