/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.ShellNamespace;
import com.novell.application.console.snapin.DynamicSnapin;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.Snapin;
import com.novell.application.console.snapin.Template;
import com.novell.application.console.snapin.context.SnapinContext;
import com.novell.application.console.snapin.scope.Scope;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class RegistrationItem
implements Serializable {
    private static Hashtable dynamicCache = new Hashtable();
    private Scope theScope = null;
    private String className = null;
    private Object instanceData = null;
    private String uniqueID = null;
    private String registrarName = null;
    private String namespaceUniqueID = null;
    private boolean export = false;
    private transient String snapinName = null;
    private transient String snapinDescription = null;
    private transient boolean everBeenLoaded = false;
    private transient ClassLoader classLoader = null;
    private transient Snapin cacheSnapin = null;
    private transient boolean cacheNeedsShutdown = false;
    private transient Vector trackedList = new Vector();
    private boolean isEnabled = false;
    private int priority = 0;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.snapinName = null;
        this.snapinDescription = null;
        this.everBeenLoaded = false;
        this.classLoader = null;
        this.cacheSnapin = null;
        this.cacheNeedsShutdown = false;
        this.trackedList = new Vector();
    }

    public void setExport(boolean bl) {
        this.export = bl;
    }

    public boolean getExport() {
        return this.export;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public Scope getScope() {
        return this.theScope;
    }

    public String getClassName() {
        return this.className;
    }

    public void setRegistrarName(String string) {
        this.registrarName = string;
    }

    public String getRegistrarName() {
        return this.registrarName;
    }

    public void setNamespacePriority(int n) {
        this.priority = n;
    }

    public int getNamespacePriority() {
        return this.priority;
    }

    public static Hashtable getDynamicCache() {
        return dynamicCache;
    }

    public Object getInstanceData() {
        return this.instanceData;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void clearCache() {
        if (this.cacheSnapin != null) {
            if (this.cacheNeedsShutdown) {
                try {
                    this.cacheSnapin.shutdownSnapin();
                }
                catch (Exception exception) {
                    D.reportSnapinError(exception);
                }
            }
            this.cacheNeedsShutdown = false;
            this.cacheSnapin = null;
        }
    }

    public void shutdownTrackedSnapins() {
        if (this.trackedList == null) {
            return;
        }
        Snapin snapin = null;
        Enumeration enumeration = this.trackedList.elements();
        while (enumeration.hasMoreElements()) {
            snapin = (Snapin)enumeration.nextElement();
            try {
                snapin.shutdownSnapin();
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
        }
        this.trackedList = new Vector();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getNamespaceUniqueID() {
        return this.namespaceUniqueID;
    }

    private Snapin loadSnapin() {
        Snapin snapin = null;
        snapin = (Snapin)dynamicCache.get(this.uniqueID);
        if (snapin == null) {
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            try {
                snapin = (Snapin)this.classLoader.loadClass(this.className).newInstance();
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                D.reportException("ExceptionInInitializerError while loading snapin " + this.className + " - " + exceptionInInitializerError, exceptionInInitializerError);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                D.reportException("NoSuchMethodError while loading snapin " + this.className + " - " + noSuchMethodError, noSuchMethodError);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    snapin = (Snapin)Beans.instantiate(this.classLoader, this.className);
                }
                catch (Exception exception) {
                    D.out("Exception while loading snapin " + this.className + " - " + exception);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    D.out("NoSuchMethodError while loading snapin " + this.className + " - " + noSuchMethodError);
                }
            }
            catch (InstantiationException instantiationException) {
                D.reportException("InstantiationException while loading snapin " + this.className + " - " + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                D.reportException("IllegalAccessException while loading snapin " + this.className + " - " + illegalAccessException, illegalAccessException);
            }
            catch (Exception exception) {
                D.reportException("Exception while loading snapin " + this.className + " - " + exception, exception);
            }
            catch (Error error) {
                D.reportException("Error while loading snapin " + this.className + " - " + error, error);
            }
        }
        if (snapin instanceof Template) {
            ((Template)snapin).setInstanceData(this.instanceData);
        }
        if (!this.everBeenLoaded) {
            this.everBeenLoaded = true;
            try {
                this.snapinName = snapin.getSnapinName();
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            if (this.snapinName == null) {
                this.snapinName = this.uniqueID;
            }
            try {
                this.snapinDescription = snapin.getSnapinDescription();
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            if (this.snapinDescription == null) {
                this.snapinDescription = new String(Resources.getString("NoDescriptionString"));
            }
        }
        return snapin;
    }

    private Snapin loadAndCache(InitSnapinInfo initSnapinInfo) {
        Snapin snapin = null;
        if (this.cacheSnapin == null) {
            if (this.theScope.getSnapinType().equals(Shell.SNAPIN_NAMESPACE)) {
                snapin = (Snapin)ShellNamespace.getNamespaceCache().get(this.uniqueID);
                if (snapin == null) {
                    snapin = this.loadSnapin();
                    if (snapin != null) {
                        try {
                            if (!snapin.initSnapin(initSnapinInfo)) {
                                return null;
                            }
                        }
                        catch (Exception exception) {
                            D.reportSnapinError(exception);
                            return null;
                        }
                    }
                    ShellNamespace.getNamespaceCache().put(this.uniqueID, snapin);
                }
            } else {
                snapin = this.loadSnapin();
            }
        } else {
            snapin = this.cacheSnapin;
        }
        if (snapin != null) {
            Object object = this.theScope.getSnapinType();
            if (snapin instanceof DynamicSnapin && !dynamicCache.containsKey(this.uniqueID)) {
                if (snapin.initSnapin(new InitSnapinInfo(MainShell.getInstance(), (Object)Shell.SNAPIN_DYNAMIC))) {
                    dynamicCache.put(this.uniqueID, snapin);
                } else {
                    return null;
                }
            }
            if ((object.equals(Shell.SNAPIN_VIEW) || object.equals(Shell.SNAPIN_MAP_OBJECTENTRY) || object.equals(Shell.SNAPIN_DISPLAYICON) || object.equals(Shell.SNAPIN_DISPLAYNAME) || object.equals(Shell.SNAPIN_TOOLBARITEM) || object.equals(Shell.SNAPIN_STATUSBARITEM) || object.equals(Shell.SNAPIN_MENU) || object.equals(Shell.SNAPIN_MAP_OBJECTENTRY)) && this.cacheSnapin == null && !(snapin instanceof DynamicSnapin)) {
                if (initSnapinInfo != null) {
                    if (initSnapinInfo.getTracking()) {
                        try {
                            if (!snapin.initSnapin(initSnapinInfo)) {
                                return null;
                            }
                            this.cacheSnapin = snapin;
                            this.cacheNeedsShutdown = true;
                        }
                        catch (Exception exception) {
                            D.reportSnapinError(exception);
                            return null;
                        }
                    } else {
                        this.cacheSnapin = snapin;
                    }
                } else {
                    this.cacheSnapin = snapin;
                }
            }
        }
        return snapin;
    }

    public boolean checkNonDynamicSnapins(InitSnapinInfo initSnapinInfo) {
        if (initSnapinInfo != null && initSnapinInfo.exportMapping && !this.export) {
            return false;
        }
        Snapin snapin = null;
        snapin = this.loadAndCache(initSnapinInfo);
        if (snapin == null) {
            return false;
        }
        return !(snapin instanceof DynamicSnapin);
    }

    public boolean checkDynamicSnapins(InitSnapinInfo initSnapinInfo) {
        if (initSnapinInfo != null && initSnapinInfo.exportMapping && !this.export) {
            return false;
        }
        Snapin snapin = null;
        snapin = this.loadAndCache(initSnapinInfo);
        if (snapin == null) {
            return false;
        }
        if (snapin instanceof DynamicSnapin) {
            SnapinContext snapinContext = null;
            if (initSnapinInfo != null) {
                snapinContext = initSnapinInfo.getSnapinContext();
            }
            return ((DynamicSnapin)snapin).doSnapinsExist(this.theScope, snapinContext);
        }
        return false;
    }

    public Snapin[] getSnapins(InitSnapinInfo initSnapinInfo) {
        if (initSnapinInfo != null && initSnapinInfo.exportMapping && !this.export) {
            return new Snapin[0];
        }
        Snapin snapin = null;
        Snapin[] snapinArray = new Snapin[]{};
        Object object = this.theScope.getSnapinType();
        snapin = this.loadAndCache(initSnapinInfo);
        if (snapin == null) {
            return snapinArray;
        }
        boolean bl = snapin instanceof DynamicSnapin;
        if (bl) {
            try {
                SnapinContext snapinContext = null;
                if (initSnapinInfo != null) {
                    snapinContext = initSnapinInfo.getSnapinContext();
                }
                try {
                    snapinArray = ((DynamicSnapin)snapin).getSnapins(this.theScope, snapinContext);
                }
                catch (Exception exception) {
                    D.reportException("Exception while calling getSnapins() for snapin " + snapin.getClass().getName() + " - " + exception, exception);
                }
                catch (Error error) {
                    D.reportException("Error while calling getSnapins() for snapin " + snapin.getClass().getName() + " - " + error, error);
                }
                if (snapinArray == null) {
                    snapinArray = new Snapin[]{};
                }
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
        } else {
            snapinArray = new Snapin[]{snapin};
        }
        if (initSnapinInfo != null && initSnapinInfo.getTracking()) {
            this.shutdownTrackedSnapins();
            if (this.cacheSnapin == null || bl) {
                int n = 0;
                while (n < snapinArray.length) {
                    D.assert(snapinArray[n] != null);
                    if (snapinArray[n] != null) {
                        try {
                            if (snapinArray[n].initSnapin(initSnapinInfo)) {
                                this.trackedList.addElement(snapinArray[n]);
                            } else {
                                snapinArray[n] = null;
                            }
                        }
                        catch (Exception exception) {
                            D.reportSnapinError(exception);
                            snapinArray[n] = null;
                        }
                    }
                    ++n;
                }
            }
        }
        return snapinArray;
    }

    public String getSnapinName() {
        if (!this.everBeenLoaded) {
            this.loadSnapin();
        }
        return this.snapinName;
    }

    public String getSnapinDescription() {
        if (!this.everBeenLoaded) {
            this.loadSnapin();
        }
        return this.snapinDescription;
    }

    public void setSnapinName(String string) {
        this.everBeenLoaded = true;
        this.snapinName = string;
    }

    public void setSnapinDescription(String string) {
        this.everBeenLoaded = true;
        this.snapinDescription = string;
    }

    public RegistrationItem(Scope scope, String string) {
        this(scope, string, null);
    }

    public RegistrationItem(Scope scope, String string, boolean bl) {
        this(scope, string, null);
        this.setExport(bl);
    }

    public RegistrationItem(Scope scope, String string, Object object) {
        this.theScope = scope;
        this.className = string;
        this.instanceData = object;
        this.uniqueID = string;
        if (object != null) {
            this.uniqueID = this.uniqueID + object;
        }
    }

    public RegistrationItem(Scope scope, String string, Object object, String string2) {
        this.theScope = scope;
        this.className = string;
        this.instanceData = object;
        this.uniqueID = new String(string + object);
        this.namespaceUniqueID = string2;
    }
}

