/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.objectentryselector;

import com.novell.application.console.shell.Constants;
import com.novell.application.console.shell.ShellNamespace;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.util.objectentryselector.EmptyIcon;
import com.novell.application.console.util.objectentryselector.ObjectEntryFilter;
import com.novell.application.console.util.objectentryselector.PseudoRootNamespace;
import com.novell.application.console.util.vlist.VListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

class OERenderer
extends JLabel
implements VListCellRenderer {
    protected static Border noFocusBorder;
    protected static Border focusBorder;
    protected static Border focusSelectedBorder;
    private boolean isSelected;
    private Color listSelectionBackground;
    private Color listSelectionForeground;
    private Color listForeground;
    private Color listBackground;
    private Color bColor;
    private Color fColor;
    ObjectEntryFilter filter;
    ObjectEntry objectEntry;
    EmptyIcon emptyIcon;
    Shell m_oeshell = MainShell.getInstance();

    public Component getVListCellRendererComponent(ObjectEntry objectEntry, int n, boolean bl, boolean bl2, String string, Icon icon) {
        this.isSelected = bl;
        this.objectEntry = objectEntry;
        this.bColor = bl ? this.listSelectionBackground : this.listBackground;
        try {
            if (bl && this.filter.isSelectable(this.objectEntry)) {
                this.fColor = this.listSelectionForeground;
            } else if (bl && !this.filter.isSelectable(this.objectEntry)) {
                this.bColor = Color.lightGray;
                this.fColor = Color.white;
            } else {
                this.fColor = !bl && this.filter.isSelectable(this.objectEntry) ? this.listForeground : SystemColor.textInactiveText;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.fColor = bl ? this.listSelectionForeground : this.listForeground;
        }
        this.setBackground(this.bColor);
        this.setForeground(this.fColor);
        if (this.objectEntry.getObjectType().getNamespace() instanceof PseudoRootNamespace) {
            this.setText(this.objectEntry.getName());
            ShellNamespace.getShellNamespace();
            this.setIcon(ShellNamespace.getTopIcon());
        } else if (this.objectEntry.getObjectType().getNamespace() instanceof ShellNamespace) {
            this.setText(this.objectEntry.getName());
            if (this.objectEntry.getName().equals("")) {
                this.setIcon(this.emptyIcon);
            } else {
                this.setIcon(this.m_oeshell.getDisplayIcon(this.objectEntry));
            }
        } else {
            this.setText(this.m_oeshell.getDisplayName(this.objectEntry));
            this.setIcon(this.m_oeshell.getDisplayIcon(this.objectEntry));
        }
        if (bl && bl2) {
            this.setBorder(focusSelectedBorder);
        } else if (bl2) {
            this.setBorder(focusBorder);
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }

    void setFilter(ObjectEntryFilter objectEntryFilter) {
        this.filter = objectEntryFilter;
    }

    OERenderer() {
        this.setFont(Constants.getFont("ConsoleONEFontKey"));
        this.emptyIcon = new EmptyIcon();
        this.setOpaque(true);
        this.listSelectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.listSelectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.listForeground = UIManager.getColor("Tree.foreground");
        this.listBackground = UIManager.getColor("Tree.background");
        noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        focusBorder = new LineBorder(this.listSelectionBackground, 1);
        focusSelectedBorder = new LineBorder(this.listSelectionBackground.brighter(), 1);
    }
}

