/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.objectentryselector;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.Utilities;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.util.objectentryselector.OESUtilities;
import com.objectspace.jgl.Array;

class ObjectEntryFilter {
    String m_nameFilterCriteria = null;
    String[] m_typesFilterCriteria = null;
    ObjectType[] m_selectableTypes = null;
    Array m_nonSelectableTypes = new Array();
    String m_currentType = null;
    ObjectEntry m_nonselectableRootEntry = null;
    ObjectType[] m_allObjectTypes = null;
    ObjectEntry m_contextForAllObjectTypes = null;
    NamespaceSnapin m_namespaceForAllObjectTypes = null;
    String m_strNsUniqueIDForAllObjectTypes = null;
    private static /* synthetic */ Class class$Ljava$lang$String;

    void setNonSelectableRootEntry(ObjectEntry objectEntry) {
        this.m_nonselectableRootEntry = objectEntry;
    }

    Array getNonSelectableTypes() {
        return this.m_nonSelectableTypes;
    }

    ObjectType[] getAllObjectTypes() {
        return this.m_allObjectTypes;
    }

    void setCurrentSelectedType(String string) {
        this.m_nonSelectableTypes.clear();
        this.m_currentType = string;
    }

    void setSelectableFilterTypes(ObjectType[] objectTypeArray) {
        this.m_selectableTypes = objectTypeArray;
    }

    ObjectType[] getSelectableFilterTypes() {
        return this.m_selectableTypes;
    }

    int getSelectableFilterTypesLength() {
        int n = 0;
        if (this.m_selectableTypes != null) {
            n = this.m_selectableTypes.length;
        }
        return n;
    }

    String[] getTypesFilterCriteria() {
        return this.m_typesFilterCriteria;
    }

    int getTypesFilterCriteriaLength() {
        int n = 0;
        if (this.m_typesFilterCriteria != null) {
            n = this.m_typesFilterCriteria.length;
        }
        return n;
    }

    void setNameFilterCriteria(String string) {
        this.m_nameFilterCriteria = string == null || string.equals("") ? null : string;
    }

    String getNameFilterCriteria() {
        return this.m_nameFilterCriteria;
    }

    ObjectEntry getAllObjectTypesContext() {
        return this.m_contextForAllObjectTypes;
    }

    NamespaceSnapin getAllObjectTypesNamespace() {
        return this.m_namespaceForAllObjectTypes;
    }

    boolean isSelectable(ObjectEntry objectEntry) {
        if (objectEntry == null) {
            return false;
        }
        if (this.m_nonselectableRootEntry != null && objectEntry.equals((Object)this.m_nonselectableRootEntry)) {
            return false;
        }
        String string = null;
        ObjectType objectType = objectEntry.getObjectType();
        if (objectType == null) {
            return false;
        }
        string = objectType.getName();
        if (this.m_currentType != null) {
            return string.equals(this.m_currentType);
        }
        if (this.m_selectableTypes != null && this.m_selectableTypes.length != 0) {
            int n = 0;
            while (n < this.m_selectableTypes.length) {
                if (string.equals(this.m_selectableTypes[n].getName())) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    void updateAllObjectTypes(NamespaceSnapin namespaceSnapin, ObjectEntry objectEntry) {
        if (namespaceSnapin == null) {
            D.assert(namespaceSnapin != null, "updateAllObjectTypes: namespace must not null");
            return;
        }
        boolean bl = false;
        if (this.m_allObjectTypes == null) {
            bl = true;
        } else {
            String string = namespaceSnapin.getUniqueID();
            if (string == null || this.m_strNsUniqueIDForAllObjectTypes == null || !string.equals(this.m_strNsUniqueIDForAllObjectTypes)) {
                bl = true;
            } else if (!(objectEntry == this.m_contextForAllObjectTypes || objectEntry != null && this.m_contextForAllObjectTypes != null && objectEntry.equals((Object)this.m_contextForAllObjectTypes))) {
                bl = true;
            }
        }
        if (bl) {
            this.m_strNsUniqueIDForAllObjectTypes = namespaceSnapin.getUniqueID();
            this.m_contextForAllObjectTypes = objectEntry;
            this.m_namespaceForAllObjectTypes = namespaceSnapin;
            try {
                this.m_allObjectTypes = namespaceSnapin.getObjectTypes(objectEntry);
            }
            catch (SnapinException snapinException) {
                this.m_allObjectTypes = null;
                Utilities.handleException(snapinException);
            }
        }
    }

    void calculateTypesFilterCriteria() {
        this.m_typesFilterCriteria = null;
        if (this.m_currentType == null || this.m_currentType.equals(Resources.getString("OESAvailableTypesKey")) || this.m_currentType.equals(Resources.getString("OESSelectableTypesKey"))) {
            String[] stringArray;
            if (this.m_selectableTypes != null && (stringArray = OESUtilities.createStringArrayFromObjectTypes(this.m_selectableTypes)) != null) {
                Array array = new Array();
                int n = 0;
                while (n < stringArray.length) {
                    if (this.isTypeInAllTypesArray(stringArray[n])) {
                        array.add((Object)stringArray[n]);
                    }
                    ++n;
                }
                this.m_typesFilterCriteria = (String[])Utilities.jglArrayToArray(array, class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ObjectEntryFilter.class$("java.lang.String")));
            }
        } else {
            this.m_typesFilterCriteria = new String[1];
            this.m_typesFilterCriteria[0] = this.m_currentType;
        }
    }

    void calculateNonSelectableTypes() {
        this.m_nonSelectableTypes = new Array();
        if (this.m_typesFilterCriteria != null) {
            this.m_nonSelectableTypes = OESUtilities.removeNonContainerTypes(this.m_allObjectTypes);
            OESUtilities.removeSpecifiedTypes(this.m_nonSelectableTypes, this.m_typesFilterCriteria);
        }
    }

    boolean isTypeInAllTypesArray(String string) {
        boolean bl = false;
        if (this.m_allObjectTypes != null) {
            int n = 0;
            while (n < this.m_allObjectTypes.length) {
                if (this.m_allObjectTypes[n].getName().equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    ObjectEntryFilter() {
    }
}

