/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.objectentryselector;

import com.novell.application.console.shell.Constants;
import com.novell.application.console.shell.D;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.SetContextDlg;
import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.DefaultObjectEntryEnumeration;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.util.objectentryselector.OESEntryTextAddin;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelector;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelectorEvent;
import com.novell.application.console.util.objectentryselector.ObjectEntrySelectorListener;
import com.novell.application.console.util.objectentryselector.SelectorListView;
import com.novell.application.console.util.objectentryselector.TreeCombo;
import com.novell.application.console.util.vlist.VList;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public final class ObjectEntrySelectorPanel
extends JPanel {
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int SINGLE_LIST = 1;
    public static final int DUAL_LIST = 2;
    public static final int SINGLE_CONTEXT = 1;
    public static final int MULTIPLE_CONTEXT = 2;
    public static final int NO_FEDERATION = 0;
    public static final int CHILD_FEDERATION = 1;
    static final int PARENT_FEDERATION = 2;
    static final int FULL_FEDERATION = 3;
    public static final int NO_NAVIGATION = 0;
    public static final int UP_NAVIGATION = 1;
    static final int DOWN_NAVIGATION = 2;
    static final int FULL_NAVIGATION = 3;
    static final int INSET_TOP = 3;
    static final int INSET_BOTTOM = 3;
    static final int INSET_LEFT = 3;
    static final int INSET_RIGHT = 3;
    static final String UP_ONE_LEVEL = Resources.getString("UpOneContextLevelKey");
    static final String CHANGE_CONTEXT = Resources.getString("ChangeContextKey");
    private int m_federationMode;
    private int m_dialogMode;
    private int m_collectionMode;
    private int m_navigationMode;
    private int m_selectionMode;
    private boolean m_bRootSelectable;
    Shell m_shell = MainShell.getInstance();
    ObjectEntry m_context;
    SelectorListView m_listView;
    JLabel m_soLabel;
    VList m_selectedObjectsList;
    TreeCombo m_treeChoice;
    JComboBox m_objectType;
    JButton m_hoistButton;
    JButton m_setContextButton;
    JButton m_parentDlgOKButton;
    JButton m_dlgSelectButton;
    JButton m_dlgUnselectButton;
    JTextField m_objectName;
    DefaultObjectEntryCollection m_selectedObjects = new DefaultObjectEntryCollection();
    EventListenerList m_listenerList = new EventListenerList();
    private static /* synthetic */ Class class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener;

    public void setInitialContext(ObjectEntry objectEntry) {
        this.m_context = objectEntry;
    }

    public void init() {
        if (this.m_context != null) {
            this.m_listView.setInitialContext(this.m_context);
        } else {
            this.m_listView.setInitialContext(this.m_shell.getTreeSelection());
        }
    }

    public ObjectEntry getContext() {
        return this.m_listView.getContext();
    }

    public void setSelectionMode(int n) {
        this.m_selectionMode = n;
        this.m_listView.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.m_selectionMode;
    }

    public void setDialogMode(int n) {
        this.m_dialogMode = n;
        this.m_listView.setDialogMode(n);
        if (this.m_dialogMode == 2) {
            this.m_soLabel.setVisible(true);
            this.m_selectedObjectsList.setVisible(true);
        } else {
            this.m_soLabel.setVisible(false);
            this.m_selectedObjectsList.setVisible(false);
        }
    }

    public int getDialogMode() {
        return this.m_dialogMode;
    }

    public void setCollectionMode(int n) {
        this.m_collectionMode = n;
        if (n == 2) {
            this.m_selectedObjectsList.setVListEntryTextSnapin(new OESEntryTextAddin(this.m_shell, 2));
        } else {
            this.m_selectedObjectsList.setVListEntryTextSnapin(new OESEntryTextAddin(this.m_shell, 1));
        }
    }

    public int getCollectionMode() {
        return this.m_collectionMode;
    }

    public void setFederationMode(int n) {
        this.m_federationMode = n;
    }

    public int getFederationMode() {
        return this.m_federationMode;
    }

    public void setNavigationMode(int n) {
        this.m_navigationMode = n;
        switch (this.m_navigationMode) {
            case 0: {
                this.m_hoistButton.setVisible(false);
                this.m_setContextButton.setVisible(false);
                this.m_treeChoice.setEnabled(false);
                break;
            }
            default: {
                this.m_hoistButton.setVisible(true);
                this.m_setContextButton.setVisible(true);
                this.m_treeChoice.setEnabled(true);
            }
        }
    }

    public int getNavigationMode() {
        return this.m_navigationMode;
    }

    public void setRootSelectable(boolean bl) {
        this.m_bRootSelectable = bl;
        this.m_listView.setRootSelectable(bl);
    }

    public boolean isRootSelectable() {
        return this.m_bRootSelectable;
    }

    public void setOKButton(JButton jButton) {
        this.m_parentDlgOKButton = jButton;
    }

    public void setSelectButton(JButton jButton) {
        this.m_dlgSelectButton = jButton;
    }

    public void setUnselectButton(JButton jButton) {
        this.m_dlgUnselectButton = jButton;
    }

    public void setFilter(String string, ObjectType[] objectTypeArray) {
        this.m_listView.setFilter(string, objectTypeArray);
    }

    public void setFilter(String string, String[] stringArray) {
        ObjectType[] objectTypeArray = null;
        if (this.m_context != null) {
            objectTypeArray = new ObjectType[stringArray.length];
            NamespaceSnapin namespaceSnapin = this.m_context.getObjectType().getNamespace();
            int n = 0;
            while (n < objectTypeArray.length) {
                objectTypeArray[n] = new ObjectType(stringArray[n], namespaceSnapin, false);
                ++n;
            }
        } else {
            D.out("ObjectEntrySelectorPanel.setFilter:  Can't set type filter; OES context is null.");
        }
        this.setFilter(string, objectTypeArray);
    }

    public void setSpecialCaseObjectEntries(ObjectEntry[] objectEntryArray) {
        this.m_listView.setSpecialCaseObjectEntries(objectEntryArray);
    }

    public ObjectEntryCollection getSelectedObjects() {
        if (this.m_dialogMode == 1) {
            this.addSelection();
        }
        return this.m_selectedObjects;
    }

    public void clearHighlightedEntries() {
        this.m_listView.clearSelection();
        this.enableSelectButton(false);
        this.updateOKButtonStatus();
    }

    public void clearSelectedObjects() {
        if (this.m_selectedObjects.hasSomeElements()) {
            this.m_selectedObjects = new DefaultObjectEntryCollection();
            this.m_selectedObjectsList.setModel(this.m_selectedObjects.elements());
        }
        this.enableUnselectButton(false);
        this.updateOKButtonStatus();
    }

    public void requestFocus() {
        if (this.m_listView != null) {
            this.m_listView.requestFocus();
        }
    }

    public SelectorListView getListView() {
        return this.m_listView;
    }

    void addSelection() {
        ObjectEntryCollection objectEntryCollection;
        if (this.m_listView == null) {
            D.out("ObjectEntrySelectorPanel.addSelection: m_listView is null.");
            return;
        }
        if (this.m_selectedObjects == null || this.m_listView.getSelectionMode() == 0 && this.m_selectedObjects.hasSomeElements()) {
            this.m_selectedObjects = new DefaultObjectEntryCollection();
        }
        if ((objectEntryCollection = this.m_listView.getSelectedObjects()) != null) {
            ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
            boolean bl = false;
            while (objectEntryEnumeration.hasMoreElements()) {
                ObjectEntry objectEntry = objectEntryEnumeration.next();
                if (!this.m_listView.m_filterManager.isSelectable(objectEntry)) continue;
                this.m_selectedObjects.addEntry(objectEntry, false);
                this.fireObjectEntrySelectorEvent(this, objectEntry, 1);
                bl = true;
            }
            if (bl) {
                this.m_selectedObjectsList.setModel(this.m_selectedObjects.elements());
                this.updateOKButtonStatus();
            }
        }
    }

    void addOneSelection(ObjectEntry objectEntry) {
        if (this.m_listView == null) {
            D.out("ObjectEntrySelectorPanel.addOneSelection: m_listView is null.");
            return;
        }
        if (objectEntry == null) {
            D.out("ObjectEntrySelectorPanel.addOneSelection: oe is null.");
            return;
        }
        if (this.m_selectedObjects == null || this.m_listView.getSelectionMode() == 0 && this.m_selectedObjects.hasSomeElements()) {
            this.m_selectedObjects = new DefaultObjectEntryCollection();
        }
        boolean bl = false;
        if (this.m_listView.m_filterManager.isSelectable(objectEntry)) {
            this.m_selectedObjects.addEntry(objectEntry, false);
            this.fireObjectEntrySelectorEvent(this, objectEntry, 1);
            bl = true;
        }
        if (bl) {
            this.m_selectedObjectsList.setModel(this.m_selectedObjects.elements());
            this.updateOKButtonStatus();
        }
    }

    void removeSelection() {
        if (this.m_selectedObjectsList == null) {
            D.out("ObjectEntrySelectorPanel.removeSelection: m_selectedObjectsList is null.");
            return;
        }
        if (this.m_selectedObjects == null) {
            return;
        }
        ObjectEntryCollection objectEntryCollection = this.m_selectedObjectsList.getSelectedObjects();
        if (objectEntryCollection != null) {
            ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
            boolean bl = false;
            while (objectEntryEnumeration.hasMoreElements()) {
                ObjectEntry objectEntry = objectEntryEnumeration.next();
                this.m_selectedObjects.removeEntry(objectEntry, false);
                this.fireObjectEntrySelectorEvent(this, objectEntry, 2);
                bl = true;
            }
            if (bl) {
                this.m_selectedObjectsList.setModel(null);
                this.m_selectedObjectsList.setModel(this.m_selectedObjects.elements());
                this.updateOKButtonStatus();
                this.updateUnselectButtonStatus();
            }
        }
    }

    private boolean isFederationAllowed() {
        return this.m_federationMode == 1 || this.m_federationMode == 3;
    }

    private void enableOKButton(boolean bl) {
        if (this.m_parentDlgOKButton != null) {
            this.m_parentDlgOKButton.setEnabled(bl);
        }
    }

    private void enableSelectButton(boolean bl) {
        if (this.m_dlgSelectButton != null) {
            this.m_dlgSelectButton.setEnabled(bl);
        }
    }

    private void enableUnselectButton(boolean bl) {
        if (this.m_dlgUnselectButton != null) {
            this.m_dlgUnselectButton.setEnabled(bl);
        }
    }

    void updateOKButtonStatus() {
        boolean bl = false;
        if (this.m_selectedObjects != null && this.m_selectedObjects.hasSomeElements()) {
            bl = true;
        } else if (this.m_listView != null && this.m_dialogMode == 1) {
            ObjectEntryCollection objectEntryCollection = this.m_listView.getSelectedObjects();
            ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
            while (objectEntryEnumeration.hasMoreElements()) {
                ObjectEntry objectEntry = objectEntryEnumeration.next();
                if (this.m_listView.m_filterManager == null || !this.m_listView.m_filterManager.isSelectable(objectEntry)) continue;
                bl = true;
                break;
            }
        }
        this.enableOKButton(bl);
    }

    void updateSelectButtonStatus() {
        boolean bl = false;
        if (this.m_listView != null && this.m_dlgSelectButton != null) {
            ObjectEntryCollection objectEntryCollection = this.m_listView.getSelectedObjects();
            ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
            while (objectEntryEnumeration.hasMoreElements()) {
                ObjectEntry objectEntry = objectEntryEnumeration.next();
                if (this.m_listView.m_filterManager == null || !this.m_listView.m_filterManager.isSelectable(objectEntry)) continue;
                bl = true;
                break;
            }
            this.enableSelectButton(bl);
        }
    }

    void updateUnselectButtonStatus() {
        boolean bl = false;
        if (this.m_dlgUnselectButton != null && this.m_dialogMode == 2) {
            if (this.m_selectedObjects != null && this.m_selectedObjects.hasSomeElements()) {
                bl = true;
            }
            this.enableUnselectButton(bl);
        }
    }

    public void addObjectEntrySelectorListener(ObjectEntrySelectorListener objectEntrySelectorListener) {
        this.m_listenerList.add(class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener != null ? class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener : (class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener = ObjectEntrySelectorPanel.class$("com.novell.application.console.util.objectentryselector.ObjectEntrySelectorListener")), objectEntrySelectorListener);
    }

    public void removeObjectEntrySelectorListener(ObjectEntrySelectorListener objectEntrySelectorListener) {
        this.m_listenerList.remove(class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener != null ? class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener : (class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener = ObjectEntrySelectorPanel.class$("com.novell.application.console.util.objectentryselector.ObjectEntrySelectorListener")), objectEntrySelectorListener);
    }

    protected void fireObjectEntrySelectorEvent(Object object, ObjectEntry objectEntry, int n) {
        ObjectEntrySelectorEvent objectEntrySelectorEvent = null;
        Object[] objectArray = this.m_listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener != null ? class$Lcom$novell$application$console$util$objectentryselector$ObjectEntrySelectorListener : ObjectEntrySelectorPanel.class$("com.novell.application.console.util.objectentryselector.ObjectEntrySelectorListener"))) {
                if (objectEntrySelectorEvent == null) {
                    objectEntrySelectorEvent = new ObjectEntrySelectorEvent(object, objectEntry, n);
                }
                ((ObjectEntrySelectorListener)objectArray[n2 + 1]).selectionChanged(objectEntrySelectorEvent);
            }
            n2 -= 2;
        }
    }

    JPanel createJPanel() {
        JPanel jPanel = NConeFactory.novellJPanel(new JPanel(), "", "");
        jPanel.setBackground(UIManager.getColor("JPanel.background"));
        jPanel.setForeground(UIManager.getColor("JPanel.foreground"));
        jPanel.setLayout(new GridBagLayout());
        return jPanel;
    }

    void setAnchorFill(GridBagConstraints gridBagConstraints, int n, int n2) {
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = n2;
    }

    void setGridWeight(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = n3;
        gridBagConstraints.weighty = n4;
    }

    void setInsets(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5) {
        gridBagConstraints.ipadx = n;
        gridBagConstraints.insets.top = n2;
        gridBagConstraints.insets.bottom = n3;
        gridBagConstraints.insets.left = n4;
        gridBagConstraints.insets.right = n5;
    }

    public void setContextNavigationMode(int n) {
        this.m_collectionMode = n;
        if (n == 2) {
            this.m_selectedObjectsList.setVListEntryTextSnapin(new OESEntryTextAddin(this.m_shell, 2));
        } else {
            this.m_selectedObjectsList.setVListEntryTextSnapin(new OESEntryTextAddin(this.m_shell, 1));
        }
    }

    public void setContext(ObjectEntry objectEntry) {
        this.setInitialContext(objectEntry);
    }

    static /* synthetic */ void access$0(ObjectEntrySelectorPanel objectEntrySelectorPanel, boolean bl) {
        objectEntrySelectorPanel.enableUnselectButton(bl);
    }

    static /* synthetic */ boolean access$1(ObjectEntrySelectorPanel objectEntrySelectorPanel) {
        return objectEntrySelectorPanel.isFederationAllowed();
    }

    static /* synthetic */ void access$2(ObjectEntrySelectorPanel objectEntrySelectorPanel, boolean bl) {
        objectEntrySelectorPanel.enableSelectButton(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ObjectEntrySelectorPanel() {
        this(null, null, null, true);
    }

    public ObjectEntrySelectorPanel(ObjectEntrySelector objectEntrySelector, boolean bl) {
        this(objectEntrySelector.getOKButton(), objectEntrySelector.getSelectButton(), objectEntrySelector.getUnselectButton(), bl);
    }

    public ObjectEntrySelectorPanel(JButton jButton, JButton jButton2, JButton jButton3, boolean bl) {
        JLabel jLabel;
        Accessible accessible;
        JLabel jLabel2;
        D.setStackTrace(true);
        this.m_parentDlgOKButton = jButton;
        this.m_dlgSelectButton = jButton2;
        this.m_dlgUnselectButton = jButton3;
        this.setBackground(UIManager.getColor("JPanel.background"));
        this.setForeground(UIManager.getColor("JPanel.foreground"));
        this.setLayout(new GridBagLayout());
        JPanel jPanel = this.createJPanel();
        JPanel jPanel2 = this.createJPanel();
        JPanel jPanel3 = this.createJPanel();
        JPanel jPanel4 = this.createJPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        this.setAnchorFill(gridBagConstraints, 10, 2);
        this.setGridWeight(gridBagConstraints, 0, 0, 0, 0);
        this.setInsets(gridBagConstraints, 0, 0, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.setAnchorFill(gridBagConstraints, 10, 1);
        this.setGridWeight(gridBagConstraints, 0, -1, 1, 1);
        this.setInsets(gridBagConstraints, 0, 0, 0, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        this.setAnchorFill(gridBagConstraints, 16, 2);
        this.setGridWeight(gridBagConstraints, 0, -1, 0, 0);
        this.setInsets(gridBagConstraints, 0, 0, 0, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        this.setAnchorFill(gridBagConstraints2, 18, 0);
        this.setGridWeight(gridBagConstraints2, 0, 0, 0, 0);
        this.setInsets(gridBagConstraints2, 0, 3, 3, 3, 3);
        this.m_treeChoice = new TreeCombo(new DefaultTreeModel(new DefaultMutableTreeNode(null)));
        try {
            jLabel2 = new JLabel();
            jLabel2.setText(Resources.getString("OESLookinKey"));
            this.m_treeChoice.labelStr = jLabel2.getText();
            NConeFactory.makeRelation(jLabel2, this.m_treeChoice);
        }
        catch (Exception exception) {
            jLabel2 = new JLabel();
            jLabel2.setText(Resources.getString("-Look &in:"));
            this.m_treeChoice.labelStr = jLabel2.getText();
            NConeFactory.makeRelation(jLabel2, this.m_treeChoice);
        }
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.insets.top = 1;
        this.setAnchorFill(gridBagConstraints2, 11, 2);
        gridBagConstraints2.gridx = -1;
        gridBagConstraints2.weightx = 2.0;
        jPanel.add((Component)this.m_treeChoice, gridBagConstraints2);
        this.setAnchorFill(gridBagConstraints2, 12, 0);
        gridBagConstraints2.weightx = 0.0;
        this.setInsets(gridBagConstraints2, 0, 3, 3, 0, 3);
        try {
            accessible = new ImageIcon(Resources.getImage("ObjectEntrySelectorUpImage.gif"));
            this.m_hoistButton = NConeFactory.novellJButton(new JButton((Icon)((Object)accessible)), UP_ONE_LEVEL, "This is a button");
            this.m_hoistButton.setPreferredSize(new Dimension(accessible.getIconWidth() + 2, accessible.getIconHeight() + 2));
            this.m_hoistButton.setMinimumSize(this.m_hoistButton.getPreferredSize());
            this.m_hoistButton.setMaximumSize(this.m_hoistButton.getPreferredSize());
        }
        catch (Exception exception) {
            this.m_hoistButton = NConeFactory.novellJButton(new JButton("-Up-"), UP_ONE_LEVEL, "This is a button");
        }
        this.m_hoistButton.setDefaultCapable(false);
        this.m_hoistButton.setToolTipText(UP_ONE_LEVEL);
        jPanel.add((Component)this.m_hoistButton, gridBagConstraints2);
        try {
            accessible = new ImageIcon(Resources.getImage("ObjectEntrySelectorSetContextImage.gif"));
            this.m_setContextButton = NConeFactory.novellJButton(new JButton((Icon)((Object)accessible)), CHANGE_CONTEXT, "This is a button");
            this.m_setContextButton.setPreferredSize(new Dimension(accessible.getIconWidth() + 2, accessible.getIconHeight() + 2));
            this.m_setContextButton.setMinimumSize(this.m_setContextButton.getPreferredSize());
            this.m_setContextButton.setMaximumSize(this.m_setContextButton.getPreferredSize());
        }
        catch (Exception exception) {
            this.m_setContextButton = NConeFactory.novellJButton(new JButton("-Set-"), CHANGE_CONTEXT, "This is a button");
        }
        this.m_setContextButton.setDefaultCapable(false);
        this.m_setContextButton.setToolTipText(CHANGE_CONTEXT);
        jPanel.add((Component)this.m_setContextButton, gridBagConstraints2);
        this.m_listView = new SelectorListView();
        this.m_listView.requestFocus();
        ObjectEntrySelectorPanel objectEntrySelectorPanel = this;
        if (objectEntrySelectorPanel == null) {
            throw null;
        }
        this.m_listView.addFocusListener(new FocusAdapter(objectEntrySelectorPanel){
            private final /* synthetic */ ObjectEntrySelectorPanel this$0;

            public void focusGained(FocusEvent focusEvent) {
                this.this$0.updateSelectButtonStatus();
                ObjectEntrySelectorPanel.access$0(this.this$0, false);
            }
            {
                this.this$0 = objectEntrySelectorPanel;
                this.constructor$0(objectEntrySelectorPanel);
            }

            private final void constructor$0(ObjectEntrySelectorPanel objectEntrySelectorPanel) {
            }
        });
        ObjectEntrySelectorPanel objectEntrySelectorPanel2 = this;
        if (objectEntrySelectorPanel2 == null) {
            throw null;
        }
        this.m_listView.addMouseListener(new MouseAdapter(objectEntrySelectorPanel2){
            private final /* synthetic */ ObjectEntrySelectorPanel this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                ObjectEntry objectEntry = this.this$0.m_listView.getSelectedObject();
                if (!(objectEntry == null || mouseEvent.getClickCount() != 2 || objectEntry.getObjectType().isContainer() || ObjectEntrySelectorPanel.access$1(this.this$0) && this.this$0.m_shell.isContainer(objectEntry))) {
                    this.this$0.addSelection();
                }
            }
            {
                this.this$0 = objectEntrySelectorPanel;
                this.constructor$0(objectEntrySelectorPanel);
            }

            private final void constructor$0(ObjectEntrySelectorPanel objectEntrySelectorPanel) {
            }
        });
        this.setAnchorFill(gridBagConstraints3, 18, 1);
        this.setGridWeight(gridBagConstraints3, 0, 0, 1, 1);
        this.setInsets(gridBagConstraints3, 0, 3, 3, 3, 3);
        jPanel2.add((Component)this.m_listView, gridBagConstraints3);
        try {
            this.m_soLabel = NConeFactory.novellJLabel(new JLabel(Resources.getString("OESSelectedObjectsKey")), Resources.getString("OESSelectedObjectsKey"), "This is a label");
        }
        catch (Exception exception) {
            this.m_soLabel = new JLabel("-Selected Objects:");
            NConeFactory.novellJLabel(new JLabel("-Selected Objects:"), this.m_soLabel.getText(), "");
        }
        this.setAnchorFill(gridBagConstraints3, 17, 2);
        this.setGridWeight(gridBagConstraints3, 0, -1, 0, 0);
        this.setInsets(gridBagConstraints3, 0, 3, 0, 3, 3);
        jPanel2.add((Component)this.m_soLabel, gridBagConstraints3);
        this.m_selectedObjectsList = new VList();
        this.m_selectedObjectsList.setShell(this.m_shell);
        this.m_selectedObjectsList.enableStatusBarFilterIndicator(false);
        this.m_selectedObjectsList.setModel((ObjectEntryEnumeration)new DefaultObjectEntryEnumeration());
        ObjectEntrySelectorPanel objectEntrySelectorPanel3 = this;
        if (objectEntrySelectorPanel3 == null) {
            throw null;
        }
        this.m_selectedObjectsList.addFocusListener(new FocusAdapter(objectEntrySelectorPanel3){
            private final /* synthetic */ ObjectEntrySelectorPanel this$0;

            public void focusGained(FocusEvent focusEvent) {
                this.this$0.updateUnselectButtonStatus();
                ObjectEntrySelectorPanel.access$2(this.this$0, false);
            }
            {
                this.this$0 = objectEntrySelectorPanel;
                this.constructor$0(objectEntrySelectorPanel);
            }

            private final void constructor$0(ObjectEntrySelectorPanel objectEntrySelectorPanel) {
            }
        });
        ObjectEntrySelectorPanel objectEntrySelectorPanel4 = this;
        if (objectEntrySelectorPanel4 == null) {
            throw null;
        }
        this.m_selectedObjectsList.addMouseListener(new MouseAdapter(objectEntrySelectorPanel4){
            private final /* synthetic */ ObjectEntrySelectorPanel this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                ObjectEntry objectEntry = this.this$0.m_selectedObjectsList.getSelectedObject();
                if (objectEntry != null && mouseEvent.getClickCount() == 2) {
                    this.this$0.removeSelection();
                }
            }
            {
                this.this$0 = objectEntrySelectorPanel;
                this.constructor$0(objectEntrySelectorPanel);
            }

            private final void constructor$0(ObjectEntrySelectorPanel objectEntrySelectorPanel) {
            }
        });
        this.setAnchorFill(gridBagConstraints3, 16, 1);
        this.setGridWeight(gridBagConstraints3, 0, -1, 1, 1);
        this.setInsets(gridBagConstraints3, 0, 3, 3, 3, 3);
        jPanel2.add((Component)this.m_selectedObjectsList, gridBagConstraints3);
        try {
            accessible = NConeFactory.novellJLabel(new JLabel(), Resources.getString("OESFindLabel"), "This is a label");
            Loc.setText((JLabel)accessible, this.m_objectName, Resources.getString("OESFindLabel"));
        }
        catch (Exception exception) {
            accessible = NConeFactory.novellJLabel(new JLabel(), "Find objects that match this criteria", "This is a label");
            Loc.setText((JLabel)accessible, this.m_objectName, "-Find objects that match this criteria:");
        }
        this.setAnchorFill(gridBagConstraints4, 17, 2);
        this.setGridWeight(gridBagConstraints4, 0, -1, 0, 0);
        this.setInsets(gridBagConstraints4, 0, 3, 0, 3, 3);
        jPanel2.add((Component)((Object)accessible), gridBagConstraints4);
        this.setAnchorFill(gridBagConstraints4, 17, 0);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = -1;
        this.setInsets(gridBagConstraints4, 0, 3, 3, 3, 3);
        if (bl) {
            this.m_objectName = NConeFactory.novellJTextField(new JTextField(), Loc.removeHotChar(Resources.getString("OESObjectNameKey")), "a textcomponent");
            try {
                jLabel = NConeFactory.novellJLabel(new JLabel(), Resources.getString("OESObjectNameKey"), "This is a label");
                Loc.setText(jLabel, this.m_objectName, Resources.getString("OESObjectNameKey"));
                jPanel3.add((Component)jLabel, gridBagConstraints4);
            }
            catch (Exception exception) {
                jLabel = NConeFactory.novellJLabel(new JLabel(), "Object Name", "This is a label");
                Loc.setText(jLabel, this.m_objectName, "-Object &Name:");
                jPanel3.add((Component)jLabel, gridBagConstraints4);
            }
            gridBagConstraints4.insets.top = 3;
            this.setAnchorFill(gridBagConstraints4, 10, 2);
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            jPanel3.add((Component)this.m_objectName, gridBagConstraints4);
        }
        this.setAnchorFill(gridBagConstraints4, 17, 0);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = -1;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.insets.top = -1;
        this.m_objectType = NConeFactory.novellJComboBox(new JComboBox(), Loc.removeHotChar(Resources.getString("OESObjectTypeKey")), "This is a combo box");
        try {
            jLabel = NConeFactory.novellJLabel(new JLabel(), Resources.getString("OESObjectTypeKey"), "This is a label");
            Loc.setText(jLabel, this.m_objectType, Resources.getString("OESObjectTypeKey"));
            jPanel3.add((Component)jLabel, gridBagConstraints4);
        }
        catch (Exception exception) {
            jLabel = NConeFactory.novellJLabel(new JLabel(), "Object Type", "This is a label");
            Loc.setText(jLabel, this.m_objectType, "-Object &Type:");
            jPanel3.add((Component)jLabel, gridBagConstraints4);
        }
        gridBagConstraints4.insets.top = 3;
        this.setAnchorFill(gridBagConstraints4, 15, 2);
        gridBagConstraints4.gridx = -1;
        gridBagConstraints4.gridy = bl ? 1 : 0;
        gridBagConstraints4.weightx = 1.0;
        this.m_objectType.setFont(Constants.getFont("ConsoleONEFontKey"));
        jPanel3.add((Component)this.m_objectType, gridBagConstraints4);
        this.m_listView.init(this);
        if (this.m_objectName != null) {
            this.m_objectName.setFont(Constants.getFont("ConsoleONEFontKey"));
        }
        this.m_treeChoice.init(this.m_listView);
        ObjectEntrySelectorPanel objectEntrySelectorPanel5 = this;
        if (objectEntrySelectorPanel5 == null) {
            throw null;
        }
        this.m_hoistButton.addActionListener(new ActionListener(objectEntrySelectorPanel5){
            private final /* synthetic */ ObjectEntrySelectorPanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.this$0.m_listView.isToppedOut()) {
                    this.this$0.m_listView.upOneContext();
                    if (this.this$0.m_listView.isToppedOut()) {
                        this.this$0.m_hoistButton.setEnabled(false);
                    }
                }
            }
            {
                this.this$0 = objectEntrySelectorPanel;
                this.constructor$0(objectEntrySelectorPanel);
            }

            private final void constructor$0(ObjectEntrySelectorPanel objectEntrySelectorPanel) {
            }
        });
        ObjectEntrySelectorPanel objectEntrySelectorPanel6 = this;
        if (objectEntrySelectorPanel6 == null) {
            throw null;
        }
        this.m_setContextButton.addActionListener(new ActionListener(objectEntrySelectorPanel6){
            private final /* synthetic */ ObjectEntrySelectorPanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectEntry objectEntry = null;
                SetContextDlg setContextDlg = new SetContextDlg(this.this$0.m_shell, this.this$0.m_context);
                ((Component)setContextDlg).setVisible(true);
                objectEntry = setContextDlg.getContextOE();
                if (objectEntry != null) {
                    this.this$0.setInitialContext(objectEntry);
                    this.this$0.init();
                }
                setContextDlg.dispose();
                setContextDlg = null;
            }
            {
                this.this$0 = objectEntrySelectorPanel;
                this.constructor$0(objectEntrySelectorPanel);
            }

            private final void constructor$0(ObjectEntrySelectorPanel objectEntrySelectorPanel) {
            }
        });
        if (this.m_context == null) {
            this.m_context = this.m_shell.getTreeSelection();
        }
        if (jButton2 == null || jButton3 == null) {
            this.setSelectionMode(0);
            this.setFederationMode(0);
            this.setDialogMode(1);
            this.setCollectionMode(1);
            this.setNavigationMode(3);
        } else {
            this.setSelectionMode(2);
            this.setFederationMode(0);
            this.setDialogMode(2);
            this.setCollectionMode(2);
            this.setNavigationMode(3);
        }
        this.setRootSelectable(false);
        this.m_treeChoice.setName("LookInCombo");
        this.m_hoistButton.setName("BackOneLevel");
        this.m_setContextButton.setName("SetContext");
        this.m_listView.setName("ListView");
        this.m_selectedObjectsList.setName("SelectedObjectsView");
        this.m_objectName.setName("NameField");
        this.m_objectType.setName("TypeCombo");
    }

    public ObjectEntrySelectorPanel(ObjectEntrySelector objectEntrySelector, boolean bl, boolean bl2) {
        this(objectEntrySelector.getOKButton(), objectEntrySelector.getSelectButton(), objectEntrySelector.getUnselectButton(), bl);
        if (bl2) {
            this.init();
        }
    }

    public ObjectEntrySelectorPanel(boolean bl, JButton jButton, boolean bl2) {
        this(jButton, null, null, bl);
        if (bl2) {
            this.init();
        }
    }

    public ObjectEntrySelectorPanel(boolean bl) {
        this(null, null, null, bl);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry) {
        this(null, null, null, true);
        this.setInitialContext(objectEntry);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry, int n) {
        this(null, null, null, true);
        this.setSelectionMode(n);
        this.setInitialContext(objectEntry);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry, int n, int n2, int n3, int n4, boolean bl) {
        this(null, null, null, true);
        this.setSelectionMode(n);
        this.setFederationMode(n2);
        this.setDialogMode(n3);
        this.setCollectionMode(n4);
        this.setRootSelectable(bl);
        this.setInitialContext(objectEntry);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry, String string, ObjectType[] objectTypeArray) {
        this(null, null, null, true);
        this.setFilter(string, objectTypeArray);
        this.setInitialContext(objectEntry);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry, String string, String[] stringArray) {
        this(null, null, null, true);
        ObjectType[] objectTypeArray = new ObjectType[stringArray.length];
        NamespaceSnapin namespaceSnapin = objectEntry.getObjectType().getNamespace();
        int n = 0;
        while (n < objectTypeArray.length) {
            objectTypeArray[n] = new ObjectType(stringArray[n], namespaceSnapin, false);
            ++n;
        }
        this.setFilter(string, objectTypeArray);
        this.setInitialContext(objectEntry);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry, ObjectEntry[] objectEntryArray) {
        this(null, null, null, true);
        this.setSpecialCaseObjectEntries(objectEntryArray);
        this.setInitialContext(objectEntry);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry, String string, ObjectType[] objectTypeArray, ObjectEntry[] objectEntryArray) {
        this(null, null, null, true);
        this.setFilter(string, objectTypeArray);
        this.setSpecialCaseObjectEntries(objectEntryArray);
        this.setInitialContext(objectEntry);
        this.init();
    }

    public ObjectEntrySelectorPanel(ObjectEntry objectEntry, String string, String[] stringArray, ObjectEntry[] objectEntryArray) {
        this(null, null, null, true);
        ObjectType[] objectTypeArray = new ObjectType[stringArray.length];
        NamespaceSnapin namespaceSnapin = objectEntry.getObjectType().getNamespace();
        if (this.m_federationMode == 0) {
            int n = 0;
            while (n < objectTypeArray.length) {
                objectTypeArray[n] = new ObjectType(stringArray[n], namespaceSnapin, false);
                ++n;
            }
        }
        this.setFilter(string, objectTypeArray);
        this.setSpecialCaseObjectEntries(objectEntryArray);
        this.setInitialContext(objectEntry);
        this.init();
    }
}

