/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultIndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;
import java.util.NoSuchElementException;

public class BListDataModel {
    BrowserObjectEntryEnumeration vEnum = null;
    ObjectEntry[] globalEntries = null;
    int iGlobalIndex = -1;
    private long m_lActivityIndicator = 0L;
    private int m_iLastBlockSize = -1;

    public ObjectEntryEnumeration getBaseModel() {
        return this.vEnum;
    }

    public void setGlobalEntries(ObjectEntry[] objectEntryArray) {
        this.incActivityIndicator();
        if (objectEntryArray.length == 0) {
            objectEntryArray = null;
        }
        int n = 0;
        while (n < objectEntryArray.length) {
            if (objectEntryArray[n] == null) {
                objectEntryArray = null;
                break;
            }
            ++n;
        }
        this.globalEntries = objectEntryArray;
        this.iGlobalIndex = -1;
    }

    public void moveFirst() {
        this.incActivityIndicator();
        if (this.getGlobalEntryCount() != 0) {
            this.iGlobalIndex = 0;
        }
        try {
            this.vEnum.moveFirst();
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
    }

    public void moveLast() {
        this.incActivityIndicator();
        this.iGlobalIndex = -1;
        try {
            this.vEnum.moveLast();
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
    }

    public boolean moveTo(String string) {
        boolean bl = false;
        this.incActivityIndicator();
        try {
            int n = this.vEnum.moveTo(string);
            if (1 == n) {
                bl = true;
            }
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        this.iGlobalIndex = -1;
        return bl;
    }

    public ObjectEntry next() {
        this.incActivityIndicator();
        ObjectEntry objectEntry = null;
        try {
            if (-2 == this.iGlobalIndex) {
                this.iGlobalIndex = 0;
            }
            if (-1 == this.iGlobalIndex) {
                objectEntry = this.vEnum.next();
            } else {
                objectEntry = this.globalEntries[this.iGlobalIndex];
                ++this.iGlobalIndex;
                if (this.iGlobalIndex >= this.globalEntries.length) {
                    this.iGlobalIndex = -1;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            objectEntry = null;
        }
        return objectEntry;
    }

    public ObjectEntry previous() {
        this.incActivityIndicator();
        ObjectEntry objectEntry = null;
        if (-2 == this.iGlobalIndex || this.iGlobalIndex == 0) {
            return null;
        }
        if (-1 != this.iGlobalIndex) {
            --this.iGlobalIndex;
            objectEntry = this.globalEntries[this.iGlobalIndex];
        } else {
            try {
                objectEntry = this.vEnum.previous();
            }
            catch (SnapinException snapinException) {
                return null;
            }
            catch (NoSuchElementException noSuchElementException) {
                objectEntry = null;
            }
            if (objectEntry == null && this.getGlobalEntryCount() != 0) {
                this.iGlobalIndex = this.getGlobalEntryCount() - 1;
                objectEntry = this.globalEntries[this.iGlobalIndex];
                if (this.iGlobalIndex == 0) {
                    this.iGlobalIndex = -2;
                }
            }
        }
        return objectEntry;
    }

    public void setBlockSize(int n) {
        if (n != this.m_iLastBlockSize) {
            this.vEnum.setBlockSize(n);
            this.m_iLastBlockSize = n;
        }
    }

    public ObjectEntry getCurrent() {
        ObjectEntry objectEntry = this.next();
        if (objectEntry != null) {
            this.previous();
        }
        return objectEntry;
    }

    private int getGlobalEntryCount() {
        if (this.globalEntries == null) {
            return 0;
        }
        return this.globalEntries.length;
    }

    public int moveModelRight(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ObjectEntry objectEntry = this.next();
            if (objectEntry == null) break;
            ++n2;
            ++n3;
        }
        return n2;
    }

    public int moveModelLeft(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ObjectEntry objectEntry = this.previous();
            if (objectEntry == null) break;
            ++n2;
            ++n3;
        }
        return n2;
    }

    public ObjectEntry[] peekAtModelRightEntries(int n, int n2) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        int n3 = 0;
        if (n2 > 0) {
            n3 = this.moveModelRight(n2);
        }
        objectEntryArray = this.getModelNextBlock(n);
        this.moveModelLeft(objectEntryArray.length + n3);
        return objectEntryArray;
    }

    public ObjectEntry[] peekAtModelLeftEntries(int n, int n2) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        int n3 = this.moveModelLeft(n2 + n);
        if (n3 != n2 + n) {
            if (n3 <= n2) {
                this.moveModelRight(n3);
            } else {
                objectEntryArray = this.getModelNextBlock(n3 - n2);
                this.moveModelLeft(objectEntryArray.length);
                this.moveModelRight(n3);
            }
        } else {
            objectEntryArray = this.getModelNextBlock(n);
            this.moveModelLeft(objectEntryArray.length);
            this.moveModelRight(n3);
        }
        return objectEntryArray;
    }

    private ObjectEntry[] getModelNextBlock(int n) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[n];
        int n2 = 0;
        while (n2 < n) {
            objectEntryArray[n2] = this.next();
            if (objectEntryArray[n2] == null) {
                ObjectEntry[] objectEntryArray2 = new ObjectEntry[n2];
                int n3 = 0;
                while (n3 < n2) {
                    objectEntryArray2[n3] = objectEntryArray[n3];
                    ++n3;
                }
                objectEntryArray = objectEntryArray2;
                break;
            }
            ++n2;
        }
        return objectEntryArray;
    }

    public boolean sameActivityIndicator(long l) {
        return l == this.m_lActivityIndicator;
    }

    public long setActivityIndicatorDifferent() {
        this.m_lActivityIndicator = 1L;
        return 0L;
    }

    public long getActivityIndicator() {
        return this.m_lActivityIndicator;
    }

    private void incActivityIndicator() {
        ++this.m_lActivityIndicator;
    }

    public BListDataModel(ObjectEntryEnumeration objectEntryEnumeration, Shell shell) {
        this.vEnum = objectEntryEnumeration instanceof BrowserObjectEntryEnumeration ? (BrowserObjectEntryEnumeration)objectEntryEnumeration : new DefaultIndexedObjectEntryEnumeration(objectEntryEnumeration, shell);
    }
}

