/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryChangeEvent;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.util.vlist.DefaultSListSelectionModel;
import com.novell.application.console.util.vlist.SListCachedDataModel;
import com.novell.application.console.util.vlist.SListSelectionEvent;
import com.novell.application.console.util.vlist.SelectionInfo;
import com.novell.application.console.util.vlist.VList;
import com.novell.application.console.util.vlist.VListContentPanel;
import com.novell.application.console.util.vlist.VListContentUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BoundedRangeModel;
import javax.swing.CellRendererPane;
import javax.swing.JScrollBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SListContentUI
implements VListContentUI,
AdjustmentListener {
    static final int QUICKPAINT_LIMIT = 5;
    private static final int UNKNOWN = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private VListContentPanel contentPanel = null;
    private SListCachedDataModel listModel = null;
    private DefaultSListSelectionModel selections = new DefaultSListSelectionModel();
    JScrollBar theScrollBar = NConeFactory.novellJScrollBar(new JScrollBar(0), "", "");
    ObjectEntry[] oeScreenArray = null;
    CellRendererPane rendererPane = new CellRendererPane();
    int currentAdjustmentValue = 0;
    int iEntriesPerColumn;
    int iColumnsVisible;
    int iWholeColumnsVisible;
    int m_iLastEntryPosition = 1;
    long lLastActivityIndicator = -1L;
    boolean bRecalcMetrics = false;
    boolean bIgnoreAdjustments = false;
    boolean bMouseMovingScrollBar = false;
    boolean m_bForceScrollBarSetup = true;
    boolean bFirstEntryIsOnScreen = false;
    boolean bLastEntryIsOnScreen = false;
    boolean bSuppressPaint = false;
    private int m_currentSelection = 0;
    int m_selectionDirection = 0;

    public void processObjectEntryChangeEvent(ObjectEntryChangeEvent objectEntryChangeEvent) {
    }

    public void cleanUp() {
        if (this.contentPanel != null) {
            VList vList = (VList)this.contentPanel.getParent();
            vList.removeScrollBar(this.theScrollBar);
        }
    }

    public void setComponent(VListContentPanel vListContentPanel) {
        this.contentPanel = vListContentPanel;
    }

    public void setModel(ObjectEntryEnumeration objectEntryEnumeration) {
        this.listModel = new SListCachedDataModel(objectEntryEnumeration, this.contentPanel.getShell());
        ObjectEntry[] objectEntryArray = this.contentPanel.getGlobalEntries();
        if (objectEntryArray != null) {
            this.listModel.setGlobalEntries(objectEntryArray);
        }
        this.m_iLastEntryPosition = this.listModel.getLastEntryPosition();
        this.lLastActivityIndicator = this.listModel.setActivityIndicatorDifferent();
        this.listModel.moveFirst();
        this.recalcAndPaintNow();
    }

    public boolean isModelEmpty() {
        if (this.listModel == null) {
            return true;
        }
        ObjectEntry objectEntry = this.listModel.getCurrent();
        if (objectEntry != null) {
            return false;
        }
        ObjectEntry[] objectEntryArray = this.listModel.getPrev(1);
        if (objectEntryArray != null && objectEntryArray.length != 0 && objectEntryArray[0] != null) {
            this.listModel.getNext(1);
            return false;
        }
        return true;
    }

    public int getCount() {
        int n = -1;
        if (this.listModel != null) {
            n = this.listModel.getCount();
        }
        return n;
    }

    public void setGlobalEntries(ObjectEntry[] objectEntryArray) {
        this.listModel.setGlobalEntries(objectEntryArray);
        this.listModel.moveFirst();
        this.clearSelection();
        this.recalcAndPaintNow();
    }

    public ObjectEntry locationToObject(Point point) {
        ListEntryInfo listEntryInfo = this.getObjectAtScreenPos(point.x, point.y);
        return listEntryInfo.getObjectEntry();
    }

    public void setSelectionMode(int n) {
        this.selections.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.selections.getSelectionMode();
    }

    public void entryMetricsChanged() {
        this.lLastActivityIndicator = this.listModel.setActivityIndicatorDifferent();
        this.recalcAndPaintNow();
    }

    public synchronized void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selections.addListSelectionListener(listSelectionListener);
    }

    public synchronized void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selections.removeListSelectionListener(listSelectionListener);
    }

    public ObjectEntry getSelectedObject() {
        ObjectEntry objectEntry = this.selections.getLeadSelectionObject();
        return objectEntry;
    }

    public ObjectEntryCollection getSelectedObjects() {
        ObjectEntry[] objectEntryArray = this.selections.getSelectedObjects();
        return new DefaultObjectEntryCollection(objectEntryArray);
    }

    public void setSelectedObject(ObjectEntry objectEntry) {
        this.selections.setSelectionInterval(objectEntry);
    }

    public void setSelectedObjects(ObjectEntryCollection objectEntryCollection) {
        boolean bl = true;
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        this.selections.setValueIsAdjusting(true);
        this.bSuppressPaint = true;
        while (objectEntryEnumeration.hasMoreElements()) {
            ObjectEntry objectEntry = objectEntryEnumeration.next();
            if (bl) {
                this.selections.setSelectionInterval(objectEntry);
                bl = false;
                continue;
            }
            this.selections.addSelectionInterval(objectEntry);
        }
        this.selections.setValueIsAdjusting(false);
        this.bSuppressPaint = false;
        this.recalcAndPaintNow();
    }

    public void addSelectedObjects(ObjectEntryCollection objectEntryCollection) {
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        while (objectEntryEnumeration.hasMoreElements()) {
            ObjectEntry objectEntry = objectEntryEnumeration.next();
            this.selections.addSelectionInterval(objectEntry);
        }
    }

    public SelectionInfo getSelectionInfoBeforeRefresh() {
        return new SelectionInfo(this.getSelectedObjects(), null);
    }

    public boolean setSelectedObjectsAfterRefresh(SelectionInfo selectionInfo) {
        this.setSelectedObjects(selectionInfo.getSelectedObjects());
        return true;
    }

    private void ensureCurrentObjectIsVisible() {
        ObjectEntry objectEntry = this.listModel.getCurrent();
        if (!(objectEntry == null || this.bFirstEntryIsOnScreen && this.bLastEntryIsOnScreen)) {
            int n;
            if (this.iWholeColumnsVisible == 0) {
                n = this.iEntriesPerColumn / 2;
            } else {
                n = this.iEntriesPerColumn * this.iWholeColumnsVisible / 2;
                if (this.iWholeColumnsVisible % 2 == 0) {
                    n += this.iEntriesPerColumn / 2;
                }
            }
            if (n != 0) {
                this.listModel.getPrev(n);
            }
            this.populateScreenCache();
            this.calcScrollBarMetrics();
            this.contentPanel.invalidate();
            this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
            this.currentAdjustmentValue = this.theScrollBar.getValue();
        }
    }

    public void ensureObjectIsVisible(ObjectEntry objectEntry) {
        if (objectEntry != null) {
            this.contentPanel.setBusy(true);
            this.listModel.moveTo(this.contentPanel.getDisplayNameForObject(objectEntry));
            this.ensureCurrentObjectIsVisible();
            this.contentPanel.setBusy(false);
        }
    }

    public void clearSelection() {
        this.selections.clearSelection();
    }

    public void selectAll() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void moveTo(int n) {
        boolean bl = false;
        this.listModel.moveTo(n);
        ObjectEntry objectEntry = this.listModel.getCurrent();
        if (objectEntry != null) {
            this.setSelectedObject(objectEntry);
        }
        this.ensureCurrentObjectIsVisible();
    }

    public void moveTo(String string) {
        if (string != null) {
            this.contentPanel.setBusy(true);
            this.listModel.moveTo(string);
            ObjectEntry objectEntry = this.listModel.getCurrent();
            if (objectEntry != null) {
                this.setSelectedObject(objectEntry);
            }
            this.ensureCurrentObjectIsVisible();
            this.contentPanel.setBusy(false);
        }
    }

    public void quickPaint(Rectangle rectangle) {
        Graphics graphics = this.contentPanel.getGraphics();
        if (graphics != null) {
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.paintContent(graphics);
        }
    }

    public void paintContent(Graphics graphics) {
        if (this.bSuppressPaint) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (this.bRecalcMetrics) {
            this.calcColumnMetrics();
            this.setModelBlockSize();
            this.populateScreenCache();
            this.calcScrollBarMetrics();
            this.bRecalcMetrics = false;
        }
        int n = 0;
        int n2 = this.contentPanel.getContentUITopLeftX();
        int n3 = this.contentPanel.getContentUITopLeftY();
        int n4 = this.contentPanel.getEntryWidth();
        int n5 = this.contentPanel.getEntryHeight();
        int n6 = 0;
        while (n6 < this.iColumnsVisible) {
            int n7 = 0;
            while (n7 < this.iEntriesPerColumn) {
                Rectangle rectangle2 = new Rectangle(n2, n3, n4, n5);
                if (this.oeScreenArray.length > n && this.oeScreenArray[n] != null) {
                    if (rectangle2.intersects(rectangle)) {
                        this.paintCell(graphics, rectangle2, this.oeScreenArray[n]);
                    }
                } else {
                    graphics.setColor(this.contentPanel.getBackground());
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                n3 += n5;
                ++n;
                ++n7;
            }
            n2 += n4;
            n3 = this.contentPanel.getContentUITopLeftY();
            ++n6;
        }
        n3 = n5 * this.iEntriesPerColumn;
        if (n3 < this.contentPanel.getContentUIHeight()) {
            graphics.setColor(this.contentPanel.getBackground());
            graphics.fillRect(this.contentPanel.getContentUITopLeftX(), n3 + this.contentPanel.getContentUITopLeftY(), this.contentPanel.getContentUIWidth(), this.contentPanel.getContentUIHeight() - n3);
        }
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, ObjectEntry objectEntry) {
        ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
        boolean bl = this.contentPanel.doesListHaveFocus();
        boolean bl2 = false;
        bl2 = bl ? objectEntry2 != null && objectEntry2.equals((Object)objectEntry) : this.selections.isSelectedObject(objectEntry);
        boolean bl3 = this.contentPanel.getDisplaySelectionOnlyIfFocus() ? bl && this.selections.isSelectedObject(objectEntry) : this.selections.isSelectedObject(objectEntry);
        Component component = this.contentPanel.getCellRenderer().getVListCellRendererComponent(objectEntry, -1, bl3, bl2, this.contentPanel.getDisplayNameForObject(objectEntry), this.contentPanel.getDisplayIconForObject(objectEntry));
        this.rendererPane.paintComponent(graphics, component, null, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void populateScreenCache() {
        boolean bl = false;
        if (this.listModel.sameActivityIndicator(this.lLastActivityIndicator)) {
            return;
        }
        this.bFirstEntryIsOnScreen = false;
        this.bLastEntryIsOnScreen = false;
        if (this.iEntriesPerColumn == 0) {
            this.bFirstEntryIsOnScreen = true;
            this.bLastEntryIsOnScreen = true;
            this.oeScreenArray = new ObjectEntry[0];
            return;
        }
        ObjectEntry[] objectEntryArray = this.listModel.getPrev(1);
        if (objectEntryArray == null || objectEntryArray.length == 0 || objectEntryArray[0] == null) {
            this.bFirstEntryIsOnScreen = true;
        } else {
            this.listModel.getNext(1);
        }
        this.oeScreenArray = this.listModel.getNext(this.iColumnsVisible * this.iEntriesPerColumn);
        if (this.oeScreenArray.length != this.iColumnsVisible * this.iEntriesPerColumn) {
            bl = true;
        }
        if (!bl) {
            ObjectEntry[] objectEntryArray2 = this.listModel.getNext(1);
            if (objectEntryArray2 != null && objectEntryArray2.length != 0 && objectEntryArray2[0] != null) {
                this.listModel.getPrev(1);
            } else {
                bl = true;
            }
        }
        if (bl) {
            int n = this.iWholeColumnsVisible * this.iEntriesPerColumn;
            if (n == 0) {
                n = this.iEntriesPerColumn;
            }
            if (this.oeScreenArray.length - 1 <= n) {
                this.bLastEntryIsOnScreen = true;
            }
        }
        this.listModel.moveLeft(this.oeScreenArray.length);
        this.lLastActivityIndicator = this.listModel.getActivityIndicator();
    }

    public void onHome() {
        this.contentPanel.setBusy(true);
        this.listModel.moveFirst();
        this.recalcAndPaintNow();
        this.contentPanel.setBusy(false);
    }

    public void onEnd() {
        this.contentPanel.setBusy(true);
        this.listModel.moveLast();
        int n = 0;
        if (this.iEntriesPerColumn > 0 && this.iWholeColumnsVisible > 0) {
            n = this.iEntriesPerColumn * this.iWholeColumnsVisible - 1;
        } else if (this.iEntriesPerColumn > 0) {
            n = this.iEntriesPerColumn - 1;
        }
        this.listModel.moveLeft(n);
        this.recalcAndPaintNow();
        this.contentPanel.setBusy(false);
    }

    public void onUpArrow() {
        this.clearShiftSelection();
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (-1 != n && 1 <= n) {
                this.selections.setSelectionInterval(this.oeScreenArray[listEntryInfo.getScreenIndex() - 1]);
            } else if (n == 0) {
                ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(this.iEntriesPerColumn, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    int n2 = this.getArrayIndexForObjectEntry(objectEntryArray, objectEntry);
                    if (n2 != 0 || objectEntryArray.length != 1) {
                        this.listModel.moveLeft(this.iEntriesPerColumn);
                        if (-1 == n2) {
                            this.selections.setSelectionInterval(objectEntryArray[objectEntryArray.length - 1]);
                        } else {
                            this.selections.setSelectionInterval(objectEntryArray[n2 - 1]);
                        }
                        this.recalcAndPaintNow();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry2);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(1, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    this.listModel.moveLeft(1);
                    objectEntry2 = objectEntryArray[0];
                    this.selections.setSelectionInterval(objectEntryArray[0]);
                }
                this.ensureObjectIsVisible(objectEntry2);
            }
        }
    }

    public void onDownArrow() {
        ListEntryInfo listEntryInfo;
        this.clearShiftSelection();
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null && -1 != (listEntryInfo = this.calcScreenPositionForObject(objectEntry)).getScreenIndex()) {
            if (this.oeScreenArray.length - 1 > listEntryInfo.getScreenIndex()) {
                ObjectEntry objectEntry2 = this.oeScreenArray[listEntryInfo.getScreenIndex() + 1];
                if (!this.isIndexWhollyVisible(listEntryInfo.getScreenIndex() + 1) && !this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex() + 1)) {
                    this.listModel.moveRight(this.iEntriesPerColumn);
                    this.recalcAndPaintNow();
                }
                this.selections.setSelectionInterval(objectEntry2);
            } else if (this.oeScreenArray.length - 1 == listEntryInfo.getScreenIndex()) {
                ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(this.iEntriesPerColumn, this.oeScreenArray.length);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    int n = this.getArrayIndexForObjectEntry(objectEntryArray, objectEntry);
                    if (n != 0 || objectEntryArray.length != 1) {
                        this.listModel.moveRight(this.iEntriesPerColumn);
                        if (-1 == n) {
                            this.selections.setSelectionInterval(objectEntryArray[0]);
                        } else {
                            this.selections.setSelectionInterval(objectEntryArray[n + 1]);
                        }
                        this.recalcAndPaintNow();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry3);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(2, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    if (2 == objectEntryArray.length) {
                        this.listModel.moveRight(1);
                        this.selections.setSelectionInterval(objectEntryArray[1]);
                        this.ensureObjectIsVisible(objectEntryArray[1]);
                    } else if (1 == objectEntryArray.length) {
                        this.selections.setSelectionInterval(objectEntryArray[0]);
                        this.ensureObjectIsVisible(objectEntryArray[0]);
                    }
                }
            }
        }
    }

    public void onLeftArrow() {
        this.clearShiftSelection();
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            if (-1 != listEntryInfo.getScreenIndex()) {
                if (!this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex())) {
                    this.selections.setSelectionInterval(this.oeScreenArray[listEntryInfo.getScreenIndex() - this.iEntriesPerColumn]);
                } else {
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(this.iEntriesPerColumn, 0);
                    if (objectEntryArray == null || objectEntryArray.length == 0) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    this.listModel.moveLeft(objectEntryArray.length);
                    this.populateScreenCache();
                    this.selections.setSelectionInterval(this.oeScreenArray[listEntryInfo.getScreenIndex()]);
                    this.recalcAndPaintNow();
                }
            } else {
                ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry2);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(this.iEntriesPerColumn, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    this.listModel.moveLeft(objectEntryArray.length);
                    this.selections.setSelectionInterval(objectEntryArray[0]);
                    this.ensureObjectIsVisible(objectEntryArray[0]);
                }
            }
        }
    }

    public void onRightArrow() {
        this.clearShiftSelection();
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            if (-1 != listEntryInfo.getScreenIndex()) {
                int n = listEntryInfo.getScreenIndex() + this.iEntriesPerColumn;
                int n2 = 0;
                while (!this.isIndexInLeftmostColumn(n) && !this.isIndexWhollyVisible(n)) {
                    n -= this.iEntriesPerColumn;
                    ++n2;
                }
                if (n2 == 0) {
                    if (n < this.oeScreenArray.length) {
                        this.selections.setSelectionInterval(this.oeScreenArray[n]);
                    }
                } else {
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(this.iEntriesPerColumn * this.iColumnsVisible, this.iEntriesPerColumn * n2);
                    if (objectEntryArray != null && n < objectEntryArray.length) {
                        this.listModel.moveRight(this.iEntriesPerColumn * n2);
                        this.populateScreenCache();
                        this.recalcAndPaintNow();
                        this.selections.setSelectionInterval(objectEntryArray[n]);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            } else {
                ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry2);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(this.iEntriesPerColumn + 1, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    this.listModel.moveRight(objectEntryArray.length);
                    this.selections.setSelectionInterval(objectEntryArray[objectEntryArray.length - 1]);
                    this.ensureObjectIsVisible(objectEntryArray[objectEntryArray.length - 1]);
                }
            }
        }
    }

    public void onPageUp() {
        this.contentPanel.setBusy(true);
        this.clearShiftSelection();
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (n != -1) {
                int n2 = Math.max(this.iEntriesPerColumn * this.iWholeColumnsVisible, this.iEntriesPerColumn);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(n2, 0);
                if (objectEntryArray == null || objectEntryArray.length == 0) {
                    if (n == 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        this.selections.setSelectionInterval(this.oeScreenArray[0]);
                    }
                } else {
                    this.listModel.moveLeft(objectEntryArray.length);
                    this.populateScreenCache();
                    if (objectEntryArray.length < n2) {
                        n = 0;
                    }
                    this.selections.setSelectionInterval(this.oeScreenArray[n]);
                    this.recalcAndPaintNow();
                }
            } else {
                ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry2);
                this.ensureCurrentObjectIsVisible();
                this.onPageUp();
            }
        }
        this.contentPanel.setBusy(false);
    }

    public void onPageDown() {
        this.contentPanel.setBusy(true);
        this.clearShiftSelection();
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (-1 != n) {
                int n2 = Math.max(this.iEntriesPerColumn * this.iColumnsVisible, this.iEntriesPerColumn);
                int n3 = Math.max(this.iEntriesPerColumn * this.iWholeColumnsVisible, this.iEntriesPerColumn);
                int n4 = this.oeScreenArray.length;
                if (n4 != n2) {
                    if (n != n4 - 1) {
                        this.selections.setSelectionInterval(this.oeScreenArray[n4 - 1]);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    this.listModel.moveRight(n3);
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(n3, 0);
                    if (objectEntryArray == null || objectEntryArray.length == 0) {
                        this.listModel.moveLeft(n3);
                        if (n != n4 - 1) {
                            this.selections.setSelectionInterval(this.oeScreenArray[n4 - 1]);
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else {
                        this.populateScreenCache();
                        this.recalcAndPaintNow();
                        n = Math.min(n, objectEntryArray.length - 1);
                        this.selections.setSelectionInterval(this.oeScreenArray[n]);
                    }
                }
            } else {
                ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry2);
                this.ensureCurrentObjectIsVisible();
                this.onPageDown();
            }
        }
        this.contentPanel.setBusy(false);
    }

    private void initShiftSelection(int n) {
        if (this.m_selectionDirection == 0) {
            this.m_currentSelection = 1;
            this.m_selectionDirection = n;
        }
    }

    private void clearShiftSelection() {
        this.m_currentSelection = 0;
        this.m_selectionDirection = 0;
    }

    private void shiftSelectRange(int n, ObjectEntry objectEntry, ObjectEntry objectEntry2) {
        if (objectEntry == null || objectEntry2 == null || objectEntry.equals((Object)objectEntry2)) {
            return;
        }
        boolean bl = false;
        this.bSuppressPaint = true;
        this.selections.setValueIsAdjusting(true);
        int n2 = this.calcScreenPositionForObject(objectEntry2).getScreenIndex();
        if (n2 == -1) {
            System.out.println("SListContentUI:shiftSelectRange():  WARNING - Previous oe (" + objectEntry2.getName() + ") not currently on screen...");
            switch (n) {
                case 1: {
                    this.moveRightOneColumn();
                    break;
                }
                case 2: {
                    this.moveLeftOneColumn();
                    break;
                }
            }
            n2 = this.calcScreenPositionForObject(objectEntry2).getScreenIndex();
            if (n2 == -1) {
                System.out.println("SListContentUI:shiftSelectRange():  ERROR - Couldn't find previous oe (" + objectEntry2.getName() + ") just off screen!");
                return;
            }
        }
        switch (n) {
            case 1: {
                int n3 = n2 - 1;
                while (n2 > 0) {
                    this.shiftSelect(n, this.oeScreenArray[n3], this.oeScreenArray[n2]);
                    if (objectEntry.equals((Object)this.oeScreenArray[n3])) {
                        bl = true;
                        break;
                    }
                    --n3;
                    --n2;
                }
                if (bl) break;
                ObjectEntry objectEntry3 = this.oeScreenArray[0];
                int n4 = this.moveLeftOneColumn();
                if (n4 <= 0) break;
                ObjectEntry objectEntry4 = this.oeScreenArray[n4 - 1];
                this.shiftSelect(n, objectEntry4, objectEntry3);
                this.shiftSelectRange(n, objectEntry, objectEntry4);
                break;
            }
            case 2: {
                int n5 = n2 + 1;
                while (n2 >= 0 && n2 < this.oeScreenArray.length - 1) {
                    this.shiftSelect(n, this.oeScreenArray[n5], this.oeScreenArray[n2]);
                    if (objectEntry.equals((Object)this.oeScreenArray[n5])) {
                        bl = true;
                        break;
                    }
                    ++n5;
                    ++n2;
                }
                if (bl) break;
                ObjectEntry objectEntry5 = this.oeScreenArray[this.oeScreenArray.length - 1];
                int n6 = this.moveRightOneColumn();
                if (n6 <= 0) break;
                ObjectEntry objectEntry6 = this.oeScreenArray[this.oeScreenArray.length - n6];
                this.shiftSelect(n, objectEntry6, objectEntry5);
                this.shiftSelectRange(n, objectEntry, objectEntry6);
                break;
            }
        }
        this.bSuppressPaint = false;
        this.selections.setValueIsAdjusting(false);
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    private void shiftSelect(int n, ObjectEntry objectEntry, ObjectEntry objectEntry2) {
        if (n == this.m_selectionDirection) {
            ++this.m_currentSelection;
            if (this.selections.isSelectedObject(objectEntry)) {
                boolean bl = this.bSuppressPaint;
                this.bSuppressPaint = true;
                this.selections.removeSelectionInterval(objectEntry);
                this.bSuppressPaint = bl;
            }
            this.selections.addSelectionInterval(objectEntry);
        } else if (this.m_currentSelection == 1) {
            this.clearShiftSelection();
            this.initShiftSelection(n);
            this.shiftSelect(n, objectEntry, objectEntry2);
        } else {
            this.selections.removeSelectionInterval(objectEntry2);
            --this.m_currentSelection;
        }
    }

    private int moveLeftOneColumn() {
        int n = 0;
        ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(this.iEntriesPerColumn, 0);
        if (objectEntryArray != null && objectEntryArray.length != 0) {
            n = this.listModel.moveLeft(objectEntryArray.length);
            this.populateScreenCache();
        }
        return n;
    }

    private int moveRightOneColumn() {
        int n = 0;
        ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(this.iEntriesPerColumn, this.iEntriesPerColumn * this.iColumnsVisible);
        if (objectEntryArray != null && objectEntryArray.length != 0) {
            n = this.listModel.moveRight(objectEntryArray.length);
            this.populateScreenCache();
        }
        return n;
    }

    public void onShiftUpArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            this.initShiftSelection(1);
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (n != -1 && n >= 1) {
                this.shiftSelect(1, this.oeScreenArray[n - 1], objectEntry);
                return;
            }
            if (n == 0) {
                if (this.listModel.atFirst()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.listModel.moveLeft(this.iEntriesPerColumn);
                    this.recalcAndPaintNow();
                    listEntryInfo = this.calcScreenPositionForObject(objectEntry);
                    n = listEntryInfo.getScreenIndex();
                    if (n == -1) {
                        this.shiftSelect(1, this.oeScreenArray[Math.min(this.iEntriesPerColumn - 1, this.oeScreenArray.length)], objectEntry);
                    } else {
                        this.onShiftUpArrow();
                    }
                }
                return;
            }
            ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
            this.moveToObject(objectEntry2);
            ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(1, 0);
            if (objectEntryArray != null && objectEntryArray.length != 0) {
                this.listModel.moveLeft(1);
                objectEntry2 = objectEntryArray[0];
                this.shiftSelect(1, objectEntry2, objectEntry);
            }
            this.ensureCurrentObjectIsVisible();
            return;
        }
    }

    public void onShiftDownArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            this.initShiftSelection(2);
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (-1 != n) {
                if (this.oeScreenArray.length - 1 > n) {
                    ObjectEntry objectEntry2 = this.oeScreenArray[n + 1];
                    if (!this.isIndexWhollyVisible(n + 1) && !this.isIndexInLeftmostColumn(n + 1)) {
                        this.listModel.moveRight(this.iEntriesPerColumn);
                        this.recalcAndPaintNow();
                    }
                    this.shiftSelect(2, objectEntry2, objectEntry);
                } else if (this.oeScreenArray.length - 1 == n) {
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(this.iEntriesPerColumn, this.oeScreenArray.length);
                    if (objectEntryArray != null && objectEntryArray.length != 0) {
                        int n2 = this.getArrayIndexForObjectEntry(objectEntryArray, objectEntry);
                        if (n2 != 0 || objectEntryArray.length != 1) {
                            this.listModel.moveRight(this.iEntriesPerColumn);
                            if (-1 == n2) {
                                this.shiftSelect(2, objectEntryArray[0], objectEntry);
                            } else {
                                this.shiftSelect(2, objectEntryArray[n2 + 1], objectEntry);
                            }
                            this.recalcAndPaintNow();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                    this.moveToObject(objectEntry3);
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(2, 0);
                    if (objectEntryArray != null && objectEntryArray.length != 0) {
                        if (2 == objectEntryArray.length) {
                            this.listModel.moveRight(1);
                            this.shiftSelect(2, objectEntryArray[1], objectEntry);
                        } else if (1 == objectEntryArray.length) {
                            this.shiftSelect(2, objectEntryArray[0], objectEntry);
                        }
                    }
                    this.ensureCurrentObjectIsVisible();
                }
            }
        }
    }

    public void onShiftLeftArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            this.initShiftSelection(1);
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (n != -1) {
                if (!this.isIndexInLeftmostColumn(n)) {
                    this.shiftSelectRange(1, this.oeScreenArray[n - this.iEntriesPerColumn], objectEntry);
                } else {
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(this.iEntriesPerColumn, 0);
                    if (objectEntryArray == null || objectEntryArray.length == 0) {
                        if (n == 0) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                        this.shiftSelectRange(1, this.oeScreenArray[0], objectEntry);
                    }
                    int n2 = this.listModel.moveLeft(objectEntryArray.length);
                    this.populateScreenCache();
                    n = Math.min(n, this.oeScreenArray.length - 1);
                    ObjectEntry objectEntry2 = this.oeScreenArray[n];
                    this.listModel.moveRight(n2);
                    this.populateScreenCache();
                    this.shiftSelectRange(1, objectEntry2, objectEntry);
                    this.recalcAndPaintNow();
                }
            } else {
                ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry3);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(this.iEntriesPerColumn, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    this.listModel.moveLeft(objectEntryArray.length);
                    this.populateScreenCache();
                    this.shiftSelectRange(1, objectEntryArray[0], objectEntry);
                }
                this.ensureCurrentObjectIsVisible();
            }
        }
    }

    public void onShiftRightArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            this.initShiftSelection(2);
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (-1 != n) {
                int n2 = n + this.iEntriesPerColumn;
                int n3 = 0;
                while (!this.isIndexInLeftmostColumn(n2) && !this.isIndexWhollyVisible(n2)) {
                    n2 -= this.iEntriesPerColumn;
                    ++n3;
                }
                if (n3 == 0) {
                    if (n2 < this.oeScreenArray.length) {
                        this.shiftSelectRange(2, this.oeScreenArray[n2], objectEntry);
                    } else {
                        this.shiftSelectRange(2, this.oeScreenArray[this.oeScreenArray.length - 1], objectEntry);
                    }
                } else {
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(this.iEntriesPerColumn * this.iColumnsVisible, this.iEntriesPerColumn * n3);
                    if (objectEntryArray != null && n2 < objectEntryArray.length) {
                        int n4 = this.listModel.moveRight(this.iEntriesPerColumn * n3);
                        this.populateScreenCache();
                        n = Math.min(n, this.oeScreenArray.length - 1);
                        ObjectEntry objectEntry2 = this.oeScreenArray[n];
                        this.listModel.moveLeft(n4);
                        this.populateScreenCache();
                        this.shiftSelectRange(2, objectEntry2, objectEntry);
                        this.recalcAndPaintNow();
                    } else if (n != this.oeScreenArray.length - 1) {
                        this.shiftSelectRange(2, this.oeScreenArray[this.oeScreenArray.length - 1], objectEntry);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            } else {
                ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry3);
                this.populateScreenCache();
                ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(this.iEntriesPerColumn + 1, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    this.listModel.moveRight(objectEntryArray.length);
                    this.shiftSelectRange(2, objectEntryArray[objectEntryArray.length - 1], objectEntry);
                }
                this.ensureCurrentObjectIsVisible();
            }
        }
    }

    public void onShiftPageUp() {
        this.contentPanel.setBusy(true);
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            this.initShiftSelection(1);
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (n != -1) {
                int n2 = Math.max(this.iEntriesPerColumn * this.iWholeColumnsVisible, this.iEntriesPerColumn);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtLeftEntries(n2, 0);
                if (objectEntryArray == null || objectEntryArray.length == 0) {
                    if (n == 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        this.shiftSelectRange(1, this.oeScreenArray[0], objectEntry);
                    }
                } else {
                    int n3 = this.listModel.moveLeft(objectEntryArray.length);
                    this.populateScreenCache();
                    n = Math.min(n, objectEntryArray.length - 1);
                    ObjectEntry objectEntry2 = this.oeScreenArray[n];
                    this.listModel.moveRight(n3);
                    this.populateScreenCache();
                    this.shiftSelectRange(1, objectEntry2, objectEntry);
                    if (objectEntryArray.length < n2) {
                        n = 0;
                    }
                    this.recalcAndPaintNow();
                }
            } else {
                ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry3);
                this.ensureCurrentObjectIsVisible();
                this.onShiftPageUp();
            }
        }
        this.contentPanel.setBusy(false);
    }

    public void onShiftPageDown() {
        this.contentPanel.setBusy(true);
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            this.initShiftSelection(2);
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            int n = listEntryInfo.getScreenIndex();
            if (-1 != n) {
                int n2 = Math.max(this.iEntriesPerColumn * this.iColumnsVisible, this.iEntriesPerColumn);
                int n3 = Math.max(this.iEntriesPerColumn * this.iWholeColumnsVisible, this.iEntriesPerColumn);
                int n4 = this.oeScreenArray.length;
                if (n4 != n2) {
                    if (n != n4 - 1) {
                        this.shiftSelectRange(2, this.oeScreenArray[n4 - 1], objectEntry);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    int n5 = this.listModel.moveRight(n3);
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtRightEntries(n3, 0);
                    if (objectEntryArray == null || objectEntryArray.length == 0) {
                        this.listModel.moveLeft(n5);
                        if (n != n4 - 1) {
                            this.shiftSelectRange(2, this.oeScreenArray[n4 - 1], objectEntry);
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else {
                        this.populateScreenCache();
                        n = Math.min(n, this.oeScreenArray.length - 1);
                        ObjectEntry objectEntry2 = this.oeScreenArray[n];
                        this.listModel.moveLeft(n5);
                        this.populateScreenCache();
                        this.shiftSelectRange(2, objectEntry2, objectEntry);
                        this.recalcAndPaintNow();
                    }
                }
            } else {
                ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry3);
                this.ensureCurrentObjectIsVisible();
                this.onShiftPageDown();
            }
        }
        this.contentPanel.setBusy(false);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if (this.contentPanel.isCellWidthAdjustmentActive()) {
            return;
        }
        ListEntryInfo listEntryInfo = this.getObjectAtScreenPos(mouseEvent.getX(), mouseEvent.getY());
        ObjectEntry objectEntry = listEntryInfo.getObjectEntry();
        if (objectEntry == null) {
            return;
        }
        this.clearShiftSelection();
        ObjectEntry objectEntry2 = this.selections.getAnchorSelectionObject();
        if ((mouseEvent.getModifiers() & 4) == 0 || !this.selections.isSelectedObject(objectEntry)) {
            if (mouseEvent.isControlDown()) {
                if (this.selections.isSelectedObject(objectEntry)) {
                    this.selections.removeSelectionInterval(objectEntry);
                } else {
                    this.selections.addSelectionInterval(objectEntry);
                }
            } else if (mouseEvent.isShiftDown() && objectEntry2 != null) {
                ListEntryInfo listEntryInfo2 = this.calcScreenPositionForObject(objectEntry2);
                int n = listEntryInfo2.getScreenIndex();
                int n2 = listEntryInfo.getScreenIndex();
                if (-1 != n && -1 != n2) {
                    if (n > n2) {
                        int n3 = n;
                        n = n2;
                        n2 = n3;
                    }
                    ObjectEntry[] objectEntryArray = new ObjectEntry[n2 - n + 1];
                    int n4 = 0;
                    while (n4 < n2 - n + 1) {
                        objectEntryArray[n4] = this.oeScreenArray[n + n4];
                        ++n4;
                    }
                    this.selections.setValueIsAdjusting(true);
                    this.bSuppressPaint = true;
                    this.selections.addSelectionInterval(objectEntryArray);
                    this.selections.setValueIsAdjusting(false);
                    this.bSuppressPaint = false;
                    this.recalcAndPaintNow();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                this.selections.setValueIsAdjusting(true);
                this.bSuppressPaint = true;
                this.selections.setSelectionInterval(objectEntry);
                this.selections.setValueIsAdjusting(false);
                this.bSuppressPaint = false;
                this.recalcAndPaintNow();
            }
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void onComponentResized(ComponentEvent componentEvent) {
        this.contentPanel.setBusy(true);
        this.calcColumnMetrics();
        this.setModelBlockSize();
        this.lLastActivityIndicator = this.listModel.setActivityIndicatorDifferent();
        this.populateScreenCache();
        if (this.bFirstEntryIsOnScreen && this.bLastEntryIsOnScreen) {
            this.listModel.moveFirst();
        }
        this.calcScrollBarMetrics();
        this.currentAdjustmentValue = this.theScrollBar.getValue();
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
        this.contentPanel.setBusy(false);
    }

    public void onFocusGained(FocusEvent focusEvent) {
        this.repaintCellFocus();
    }

    public void onFocusLost(FocusEvent focusEvent) {
        this.repaintCellFocus();
    }

    protected void repaintCellFocus() {
        if (this.oeScreenArray != null && this.oeScreenArray.length != 0) {
            if (this.oeScreenArray.length < 5) {
                int n = 0;
                while (n < this.oeScreenArray.length) {
                    Rectangle rectangle;
                    ListEntryInfo listEntryInfo;
                    if (this.oeScreenArray[n] != null && this.selections.isSelectedObject(this.oeScreenArray[n]) && -1 != (listEntryInfo = this.calcScreenPositionForObject(this.oeScreenArray[n])).getScreenIndex() && (rectangle = listEntryInfo.getRectangle()) != null) {
                        this.quickPaint(rectangle);
                    }
                    ++n;
                }
            } else {
                this.recalcAndPaintNow();
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.bIgnoreAdjustments || this.bMouseMovingScrollBar) {
            return;
        }
        if (this.currentAdjustmentValue == adjustmentEvent.getValue()) {
            return;
        }
        this.contentPanel.setBusy(true);
        if (adjustmentEvent.getValue() == this.m_iLastEntryPosition) {
            this.listModel.moveLast();
            int n = 0;
            if (this.iEntriesPerColumn > 0 && this.iWholeColumnsVisible > 0) {
                n = this.iEntriesPerColumn * this.iWholeColumnsVisible - 1;
            } else if (this.iEntriesPerColumn > 0) {
                n = this.iEntriesPerColumn - 1;
            }
            this.listModel.moveLeft(n);
        } else if (this.currentAdjustmentValue + 1 == adjustmentEvent.getValue()) {
            this.listModel.moveRight(this.iEntriesPerColumn);
        } else if (this.currentAdjustmentValue - 1 == adjustmentEvent.getValue()) {
            this.listModel.moveLeft(this.iEntriesPerColumn);
        } else if (this.currentAdjustmentValue + this.iWholeColumnsVisible == adjustmentEvent.getValue()) {
            this.listModel.moveRight(this.iEntriesPerColumn * this.iWholeColumnsVisible);
        } else if (this.currentAdjustmentValue - this.iWholeColumnsVisible == adjustmentEvent.getValue()) {
            this.listModel.moveLeft(this.iEntriesPerColumn * this.iWholeColumnsVisible);
        } else {
            this.listModel.moveTo(adjustmentEvent.getValue());
        }
        this.populateScreenCache();
        this.calcScrollBarMetrics();
        this.currentAdjustmentValue = this.theScrollBar.getValue();
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
        this.contentPanel.setBusy(false);
    }

    private void recalcAndPaintNow() {
        this.bRecalcMetrics = true;
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
        this.currentAdjustmentValue = this.listModel.getCurrentPosition();
    }

    private void calcColumnMetrics() {
        int n = this.contentPanel.getEntryWidth();
        int n2 = this.contentPanel.getEntryHeight();
        this.iEntriesPerColumn = this.contentPanel.getContentUIHeight() / n2;
        if (this.iEntriesPerColumn < 0) {
            this.iEntriesPerColumn = 0;
        }
        this.iColumnsVisible = this.contentPanel.getContentUIWidth() / n;
        if (this.iColumnsVisible < 0) {
            this.iColumnsVisible = 0;
        }
        this.iWholeColumnsVisible = this.iColumnsVisible;
        if (this.iColumnsVisible * n != this.contentPanel.getContentUIWidth()) {
            ++this.iColumnsVisible;
        }
    }

    private void calcScrollBarMetrics() {
        BoundedRangeModel boundedRangeModel;
        int n = this.listModel.getCurrentPosition();
        if (n == 0) {
            if (!this.listModel.atFirst()) {
                n = 1;
            }
        } else if (this.bLastEntryIsOnScreen && this.oeScreenArray.length != 0 && (this.isEntryWhollyVisible((ObjectEntry)(boundedRangeModel = this.oeScreenArray[this.oeScreenArray.length - 1])) || this.isEntryInLeftmostColumn((ObjectEntry)boundedRangeModel))) {
            n = this.m_iLastEntryPosition;
        }
        boundedRangeModel = this.theScrollBar.getModel();
        if (this.m_bForceScrollBarSetup || boundedRangeModel.getValue() != n) {
            this.m_bForceScrollBarSetup = false;
            boolean bl = this.bIgnoreAdjustments;
            this.bIgnoreAdjustments = true;
            boundedRangeModel.setValue(0);
            boundedRangeModel.setMinimum(0);
            boundedRangeModel.setMaximum(this.m_iLastEntryPosition);
            boundedRangeModel.setExtent(0);
            boundedRangeModel.setValue(n);
            this.theScrollBar.setUnitIncrement(1);
            this.theScrollBar.setBlockIncrement(this.iWholeColumnsVisible > 0 ? this.iWholeColumnsVisible : 1);
            this.bIgnoreAdjustments = bl;
            this.theScrollBar.setModel(boundedRangeModel);
        }
        VList vList = (VList)this.contentPanel.getParent();
        boolean bl = false;
        bl = this.bFirstEntryIsOnScreen && this.bLastEntryIsOnScreen ? vList.removeScrollBar(this.theScrollBar) : vList.addScrollBar(this.theScrollBar);
        if (bl) {
            this.calcColumnMetrics();
            this.contentPanel.invalidate();
            this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
        }
    }

    private int moveToObject(ObjectEntry objectEntry) {
        String string = this.contentPanel.getDisplayNameForObject(objectEntry);
        this.contentPanel.setBusy(true);
        int n = this.listModel.moveTo(string);
        this.contentPanel.setBusy(false);
        return n;
    }

    private ListEntryInfo getObjectAtScreenPos(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.contentPanel.getEntryWidth();
        int n6 = this.contentPanel.getEntryHeight();
        if (n < this.contentPanel.getContentUITopLeftX() || n2 < this.contentPanel.getContentUITopLeftY() || n2 > this.contentPanel.getContentUITopLeftY() + this.iEntriesPerColumn * n6) {
            SListContentUI sListContentUI = this;
            if (sListContentUI == null) {
                throw null;
            }
            return sListContentUI.new ListEntryInfo(null, 0, 0, 0, 0, -1);
        }
        int n7 = n5 + this.contentPanel.getContentUITopLeftX();
        while (n > n7) {
            n7 += n5;
            ++n3;
        }
        int n8 = n6 + this.contentPanel.getContentUITopLeftY();
        while (n2 > n8) {
            n8 += n6;
            ++n4;
        }
        int n9 = n3 * this.iEntriesPerColumn;
        if ((n9 += n4) >= this.oeScreenArray.length) {
            SListContentUI sListContentUI = this;
            if (sListContentUI == null) {
                throw null;
            }
            return sListContentUI.new ListEntryInfo(null, 0, 0, 0, 0, -1);
        }
        int n10 = n3 * n5 + this.contentPanel.getContentUITopLeftX();
        int n11 = n4 * n6 + this.contentPanel.getContentUITopLeftY();
        SListContentUI sListContentUI = this;
        if (sListContentUI == null) {
            throw null;
        }
        ListEntryInfo listEntryInfo = sListContentUI.new ListEntryInfo(this.oeScreenArray[n9], n10, n11, n5, n6, n9);
        return listEntryInfo;
    }

    private int getArrayIndexForObjectEntry(ObjectEntry[] objectEntryArray, ObjectEntry objectEntry) {
        int n = -1;
        if (objectEntryArray != null) {
            int n2 = 0;
            while (n2 < objectEntryArray.length) {
                if (objectEntry.equals((Object)objectEntryArray[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private ListEntryInfo calcScreenPositionForObject(ObjectEntry objectEntry) {
        int n = this.contentPanel.getEntryWidth();
        int n2 = this.contentPanel.getEntryHeight();
        int n3 = this.getArrayIndexForObjectEntry(this.oeScreenArray, objectEntry);
        if (n3 == -1) {
            SListContentUI sListContentUI = this;
            if (sListContentUI == null) {
                throw null;
            }
            return sListContentUI.new ListEntryInfo(null, 0, 0, 0, 0, -1);
        }
        int n4 = n3;
        int n5 = n4 / this.iEntriesPerColumn;
        int n6 = n4 - n5 * this.iEntriesPerColumn;
        int n7 = n5 * n + this.contentPanel.getContentUITopLeftX();
        int n8 = n6 * n2 + this.contentPanel.getContentUITopLeftY();
        SListContentUI sListContentUI = this;
        if (sListContentUI == null) {
            throw null;
        }
        return sListContentUI.new ListEntryInfo(objectEntry, n7, n8, n, n2, n3);
    }

    private boolean isEntryInLeftmostColumn(ObjectEntry objectEntry) {
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            return this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex());
        }
        return false;
    }

    private boolean isEntryInRightmostColumn(ObjectEntry objectEntry) {
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            return this.isIndexInRightmostColumn(listEntryInfo.getScreenIndex());
        }
        return false;
    }

    private boolean isEntryInLeftmostColumn(ListEntryInfo listEntryInfo) {
        return this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex());
    }

    private boolean isEntryInRightmostColumn(ListEntryInfo listEntryInfo) {
        return this.isIndexInRightmostColumn(listEntryInfo.getScreenIndex());
    }

    private boolean isIndexInLeftmostColumn(int n) {
        return n < this.iEntriesPerColumn;
    }

    private boolean isIndexInRightmostColumn(int n) {
        if (this.iColumnsVisible == 0) {
            return false;
        }
        return n >= (this.iColumnsVisible - 1) * this.iEntriesPerColumn;
    }

    private boolean isEntryWhollyVisible(ObjectEntry objectEntry) {
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            return this.isEntryWhollyVisible(listEntryInfo);
        }
        return false;
    }

    private boolean isEntryWhollyVisible(ListEntryInfo listEntryInfo) {
        return this.isIndexWhollyVisible(listEntryInfo.getScreenIndex());
    }

    private boolean isIndexWhollyVisible(int n) {
        return n < this.iEntriesPerColumn * this.iWholeColumnsVisible;
    }

    private void setModelBlockSize() {
        this.listModel.setBlockSize(this.iColumnsVisible * this.iEntriesPerColumn + 2);
    }

    private void setInitialEntryHeight() {
        ObjectEntry[] objectEntryArray = this.listModel.getNext(5);
        this.listModel.getPrev(objectEntryArray.length);
        this.contentPanel.setEntryHeightFromEntries(objectEntryArray);
    }

    public SListContentUI() {
        this.theScrollBar.addAdjustmentListener(this);
        SListContentUI sListContentUI = this;
        if (sListContentUI == null) {
            throw null;
        }
        this.theScrollBar.addMouseListener(sListContentUI.new ScrollBarMouseListener());
        SListContentUI sListContentUI2 = this;
        if (sListContentUI2 == null) {
            throw null;
        }
        this.selections.addListSelectionListener(sListContentUI2.new SelectionListener());
    }

    public class ListEntryInfo {
        public Rectangle rect;
        public ObjectEntry obj;
        public int iScreenIndex;

        Rectangle getRectangle() {
            return this.rect;
        }

        ObjectEntry getObjectEntry() {
            return this.obj;
        }

        int getScreenIndex() {
            return this.iScreenIndex;
        }

        public ListEntryInfo(ObjectEntry objectEntry, int n, int n2, int n3, int n4, int n5) {
            this.rect = new Rectangle(n, n2, n3, n4);
            this.obj = objectEntry;
            this.iScreenIndex = n5;
        }
    }

    public class SelectionListener
    implements ListSelectionListener,
    Serializable {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent instanceof SListSelectionEvent && !SListContentUI.this.bSuppressPaint) {
                SListSelectionEvent sListSelectionEvent = (SListSelectionEvent)listSelectionEvent;
                ObjectEntry[] objectEntryArray = sListSelectionEvent.getChangedObjects();
                if (objectEntryArray.length < 5) {
                    int n = 0;
                    while (n < objectEntryArray.length) {
                        ListEntryInfo listEntryInfo = SListContentUI.this.calcScreenPositionForObject(objectEntryArray[n]);
                        ObjectEntry objectEntry = listEntryInfo.getObjectEntry();
                        if (objectEntry != null) {
                            Rectangle rectangle = listEntryInfo.getRectangle();
                            SListContentUI.this.quickPaint(rectangle);
                        }
                        ++n;
                    }
                } else {
                    SListContentUI.this.recalcAndPaintNow();
                }
            }
        }
    }

    public class ScrollBarMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            SListContentUI.this.bMouseMovingScrollBar = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SListContentUI.this.bMouseMovingScrollBar = false;
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(SListContentUI.this.theScrollBar, 601, 5, SListContentUI.this.theScrollBar.getValue());
            SListContentUI.this.adjustmentValueChanged(adjustmentEvent);
        }
    }
}

