/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.mpec;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NJTree;
import com.novell.utility.layouts.VerticalFlowLayout;
import com.novell.utility.localization.Loc;
import com.novell.utility.mpec.MPEC;
import com.novell.utility.mpec.MyButton;
import com.novell.utility.mpec.MyRenderer;
import com.novell.utility.mpec.PropertyBookModel;
import com.novell.utility.mpec.PropertyBookNode;
import com.novell.utility.mpec.PropertyBookPage;
import com.novell.utility.mpec.PropertyBookTab;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

class PageOptions
extends JDialog
implements ActionListener,
TreeSelectionListener,
KeyListener {
    private static int TREE_PANEL_HEIGHT;
    private static int TREE_PANEL_WIDTH;
    public static final int OK_BUTTON = 0;
    public static final int CANCEL_BUTTON = 1;
    private static final String IMAGE_PATH = "/com/novell/utility/mpec/images/";
    private NJTree tabsTree = null;
    private JLabel tabsTreeLabel = null;
    private MyButton disableButton = null;
    private MyButton enableButton = null;
    private MyButton moveUpButton = null;
    private MyButton moveDownButton = null;
    private MyButton okButton = null;
    private MyButton cancelButton = null;
    private MyButton helpButton = null;
    private PropertyBookModel thePBModel = null;
    private boolean dirty = false;
    private int result = 0;

    private void layoutControls() {
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 5));
        TREE_PANEL_HEIGHT = 550;
        TREE_PANEL_WIDTH = 300;
        JPanel jPanel = NConeFactory.novellJPanel(new JPanel(new BorderLayout(5, 5)), "", "");
        VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout();
        JPanel jPanel2 = NConeFactory.novellJPanel(new JPanel(verticalFlowLayout), "", "");
        this.disableButton = new MyButton();
        NConeFactory.novellJButton(this.disableButton, Loc.removeHotChar(MPEC.res.getString("DisableKey")), "");
        Loc.setText(this.disableButton, MPEC.res.getString("DisableKey"));
        this.disableButton.addActionListener(this);
        this.enableButton = new MyButton();
        NConeFactory.novellJButton(this.enableButton, Loc.removeHotChar(MPEC.res.getString("EnableKey")), "");
        Loc.setText(this.enableButton, MPEC.res.getString("EnableKey"));
        this.enableButton.addActionListener(this);
        this.moveUpButton = new MyButton();
        NConeFactory.novellJButton(this.moveUpButton, Loc.removeHotChar(MPEC.res.getString("MoveUpKey")), "");
        Loc.setText(this.moveUpButton, MPEC.res.getString("MoveUpKey"));
        this.moveUpButton.addActionListener(this);
        this.moveDownButton = new MyButton();
        NConeFactory.novellJButton(this.moveDownButton, Loc.removeHotChar(MPEC.res.getString("MoveDownKey")), "");
        Loc.setText(this.moveDownButton, MPEC.res.getString("MoveDownKey"));
        this.moveDownButton.addActionListener(this);
        this.okButton = new MyButton();
        NConeFactory.novellJButton(this.okButton, Loc.removeHotChar(MPEC.res.getString("OKKey")), "");
        Loc.setText(this.okButton, MPEC.res.getString("OKKey"));
        this.okButton.addActionListener(this);
        this.cancelButton = new MyButton();
        NConeFactory.novellJButton(this.cancelButton, Loc.removeHotChar(MPEC.res.getString("CancelKey")), "");
        Loc.setText(this.cancelButton, MPEC.res.getString("CancelKey"));
        this.cancelButton.addActionListener(this);
        this.helpButton = new MyButton();
        NConeFactory.novellJButton(this.helpButton, Loc.removeHotChar(MPEC.res.getString("HelpKey")), "");
        Loc.setText(this.helpButton, MPEC.res.getString("HelpKey"));
        this.helpButton.addActionListener(this);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        jPanel2.add(new JLabel("   "));
        jPanel2.add(this.disableButton);
        jPanel2.add(this.enableButton);
        jPanel2.add(this.moveUpButton);
        jPanel2.add(this.moveDownButton);
        jPanel2.add(new JLabel("   "));
        jPanel2.add(this.helpButton);
        PageOptions pageOptions = this;
        if (pageOptions == null) {
            throw null;
        }
        this.tabsTree = new NJTree(pageOptions){
            private final /* synthetic */ PageOptions this$0;

            public Dimension getPreferredSize() {
                return new Dimension(PageOptions.access$0(), PageOptions.access$1());
            }
            {
                this.this$0 = pageOptions;
                this.constructor$0(pageOptions);
            }

            private final void constructor$0(PageOptions pageOptions) {
            }
        };
        MyRenderer myRenderer = new MyRenderer();
        myRenderer.setLeafIcon(new ImageIcon(this.getImage("Page.gif")));
        myRenderer.setOpenIcon(new ImageIcon(this.getImage("Tab.gif")));
        myRenderer.setClosedIcon(new ImageIcon(this.getImage("Tab.gif")));
        this.tabsTree.setCellRenderer(myRenderer);
        this.tabsTree.addTreeSelectionListener(this);
        this.tabsTree.setEditable(false);
        this.tabsTree.setShowsRootHandles(false);
        PageOptions pageOptions2 = this;
        if (pageOptions2 == null) {
            throw null;
        }
        JScrollPane jScrollPane = new JScrollPane(pageOptions2, 22, 30){
            private final /* synthetic */ PageOptions this$0;

            public float getAlignmentX() {
                return 0.0f;
            }
            {
                this.this$0 = pageOptions;
                this.constructor$0(pageOptions, n, n2);
            }

            private final void constructor$0(PageOptions pageOptions, int n, int n2) {
            }
        };
        jScrollPane = NConeFactory.novellJScrollPane(jScrollPane, "", "");
        jScrollPane.getViewport().add((Component)this.tabsTree);
        this.tabsTreeLabel = NConeFactory.novellJLabel(new JLabel(), Loc.removeHotChar(MPEC.res.getString("TreeTitleKey")), "");
        Loc.setText(this.tabsTreeLabel, (Component)this.tabsTree, MPEC.res.getString("TreeTitleKey"));
        jPanel.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.tabsTreeLabel, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "East");
        this.tabsTree.requestFocus();
        this.pack();
    }

    private void populateTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        PropertyBookTab propertyBookTab = null;
        Enumeration enumeration = this.thePBModel.getTabs();
        while (enumeration.hasMoreElements()) {
            propertyBookTab = (PropertyBookTab)enumeration.nextElement();
            if (!propertyBookTab.isAvailable()) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(propertyBookTab);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            DefaultMutableTreeNode defaultMutableTreeNode3 = null;
            PropertyBookPage propertyBookPage = null;
            Enumeration enumeration2 = propertyBookTab.getPages();
            while (enumeration2.hasMoreElements()) {
                propertyBookPage = (PropertyBookPage)enumeration2.nextElement();
                if (!propertyBookPage.isAvailable()) continue;
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(propertyBookPage);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            }
        }
        this.tabsTree.setModel(defaultTreeModel);
        this.tabsTree.setShowsRootHandles(true);
        this.tabsTree.setRootVisible(false);
        this.tabsTree.setSelectionRow(0);
        this.tabsTree.getSelectionModel().setSelectionMode(1);
        this.tabsTree.requestFocus();
    }

    public PropertyBookModel getPBModel() {
        return this.thePBModel;
    }

    private Image getImage(String string) {
        Image image = null;
        String string2 = IMAGE_PATH + string;
        URL uRL = MPEC.res.getClass().getResource(string2);
        if (uRL != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        if (image == null) {
            // empty if block
        }
        return image;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        D.out("Key pressed...");
        if (keyEvent.getKeyCode() == 27) {
            this.onCancel();
            this.getParent().requestFocus();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PropertyBookNode propertyBookNode = (PropertyBookNode)defaultMutableTreeNode.getUserObject();
        if (this.tabsTree.getSelectionPath() == null) {
            this.tabsTree.setSelectionPath(treePath);
        }
        if (defaultMutableTreeNode.getPreviousSibling() == null) {
            this.moveUpButton.setEnabled(false);
        } else {
            this.moveUpButton.setEnabled(true);
        }
        if (defaultMutableTreeNode.getNextSibling() == null) {
            this.moveDownButton.setEnabled(false);
        } else {
            this.moveDownButton.setEnabled(true);
        }
        if (propertyBookNode.isEnabled()) {
            this.disableButton.setEnabled(true);
            this.enableButton.setEnabled(false);
        } else {
            this.disableButton.setEnabled(false);
            this.enableButton.setEnabled(true);
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.helpButton) {
            this.onHelp();
        } else if (actionEvent.getSource() == this.okButton) {
            this.onOK();
        } else if (actionEvent.getSource() == this.enableButton) {
            this.onEnable();
        } else if (actionEvent.getSource() == this.disableButton) {
            this.onDisable();
        } else if (actionEvent.getSource() == this.moveUpButton) {
            this.onMoveUp();
        } else if (actionEvent.getSource() == this.moveDownButton) {
            this.onMoveDown();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.onCancel();
        }
        if (this.dirty) {
            this.okButton.setEnabled(true);
        }
    }

    private void onHelp() {
        D.out("Help for PageOptions not enabled yet.");
        ShellStubs.launchHelp("novellconsoleone", "pageoptions", this);
    }

    private void onOK() {
        NMsgBox nMsgBox = new NMsgBox(this, MPEC.res.getString("WarningTitleKey"), MPEC.res.getString("WarningTextKey"), 1);
        int n = nMsgBox.launch();
        this.result = 0;
        this.dispose();
        this.getParent().requestFocus();
    }

    private void onEnable() {
        this.dirty = true;
        TreeSelectionModel treeSelectionModel = this.tabsTree.getSelectionModel();
        TreePath treePath = treeSelectionModel.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PropertyBookNode propertyBookNode = (PropertyBookNode)defaultMutableTreeNode.getUserObject();
        propertyBookNode.setEnabled(true);
        if (propertyBookNode instanceof PropertyBookTab) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                propertyBookNode = (PropertyBookNode)defaultMutableTreeNode2.getUserObject();
                propertyBookNode.setEnabled(true);
            }
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            propertyBookNode = (PropertyBookNode)defaultMutableTreeNode3.getUserObject();
            if (!propertyBookNode.isEnabled()) {
                propertyBookNode.setEnabled(true);
            }
        }
        this.disableButton.setEnabled(true);
        this.enableButton.setEnabled(false);
        this.tabsTree.requestFocus();
        this.repaint();
    }

    private void onDisable() {
        this.dirty = true;
        TreeSelectionModel treeSelectionModel = this.tabsTree.getSelectionModel();
        TreePath treePath = treeSelectionModel.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PropertyBookNode propertyBookNode = (PropertyBookNode)defaultMutableTreeNode.getUserObject();
        if (!this.thePBModel.canDisableNode(propertyBookNode)) {
            NMsgBox nMsgBox = new NMsgBox(this, MPEC.res.getString("DisableErrorTitleKey"), MPEC.res.getString("DisableErrorTextKey"), 1);
            int n = nMsgBox.launch();
            return;
        }
        propertyBookNode.setEnabled(false);
        if (propertyBookNode instanceof PropertyBookTab) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                propertyBookNode = (PropertyBookNode)defaultMutableTreeNode2.getUserObject();
                propertyBookNode.setEnabled(false);
            }
        } else {
            boolean bl = true;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            DefaultMutableTreeNode defaultMutableTreeNode4 = null;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode3.children();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
                propertyBookNode = (PropertyBookNode)defaultMutableTreeNode4.getUserObject();
                if (!propertyBookNode.isEnabled()) continue;
                bl = false;
                break;
            }
            if (bl) {
                propertyBookNode = (PropertyBookNode)defaultMutableTreeNode3.getUserObject();
                propertyBookNode.setEnabled(false);
            }
        }
        this.disableButton.setEnabled(false);
        this.enableButton.setEnabled(true);
        this.tabsTree.requestFocus();
        this.repaint();
    }

    private void onMoveUp() {
        this.dirty = true;
        TreeSelectionModel treeSelectionModel = this.tabsTree.getSelectionModel();
        TreePath treePath = treeSelectionModel.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PropertyBookNode propertyBookNode = (PropertyBookNode)defaultMutableTreeNode.getUserObject();
        this.thePBModel.moveNode(propertyBookNode, 1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
        defaultMutableTreeNode2.insert(defaultMutableTreeNode, n - 1);
        ((DefaultTreeModel)this.tabsTree.getModel()).reload(defaultMutableTreeNode2);
        this.tabsTree.setSelectionPath(treePath);
        this.tabsTree.makeVisible(treePath);
        this.tabsTree.requestFocus();
        this.repaint();
    }

    private void onMoveDown() {
        this.dirty = true;
        TreeSelectionModel treeSelectionModel = this.tabsTree.getSelectionModel();
        TreePath treePath = treeSelectionModel.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PropertyBookNode propertyBookNode = (PropertyBookNode)defaultMutableTreeNode.getUserObject();
        this.thePBModel.moveNode(propertyBookNode, 2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
        defaultMutableTreeNode2.insert(defaultMutableTreeNode, n + 1);
        ((DefaultTreeModel)this.tabsTree.getModel()).reload(defaultMutableTreeNode2);
        this.tabsTree.setSelectionPath(treePath);
        this.tabsTree.makeVisible(treePath);
        this.tabsTree.requestFocus();
        this.repaint();
    }

    private void onCancel() {
        this.result = 1;
        this.dispose();
        this.getParent().requestFocus();
    }

    public int getResult() {
        return this.result;
    }

    public Insets getInsets() {
        return new Insets(30, 10, 10, 10);
    }

    static /* synthetic */ int access$0() {
        return TREE_PANEL_WIDTH;
    }

    static /* synthetic */ int access$1() {
        return TREE_PANEL_HEIGHT;
    }

    public PageOptions(Frame frame, String string, PropertyBookModel propertyBookModel) {
        super(frame, string, true);
        this.layoutControls();
        this.thePBModel = propertyBookModel;
        this.populateTree();
        this.addKeyListener(this);
        this.okButton.setEnabled(false);
    }
}

