/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.persistence;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.SnapinObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class Persistence {
    private Hashtable m_table = new Hashtable();
    private File prefDir = null;
    private String filename = null;

    public String setValue(String string, String string2) {
        return this.m_table.put(string, string2);
    }

    public String getValue(String string) {
        return (String)this.m_table.get(string);
    }

    public boolean containsObject(String string) {
        return this.m_table.containsKey(string);
    }

    public Object removeObject(String string) {
        return this.m_table.remove(string);
    }

    public Object getObject(String string) {
        return this.m_table.get(string);
    }

    public void setObject(String string, Serializable serializable) {
        this.m_table.put(string, serializable);
    }

    public void save() {
        try {
            boolean bl = true;
            if (!this.prefDir.exists() && !this.prefDir.mkdirs()) {
                D.out("Could not make preferences directory:" + this.prefDir);
                bl = false;
            }
            if (bl) {
                File file = new File(this.prefDir, this.filename);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(this.m_table);
                objectOutputStream.close();
            }
        }
        catch (Exception exception) {
            D.out("Exception trying to write preferences:" + this.filename);
        }
    }

    public Persistence(File file, String string) {
        try {
            this.prefDir = file;
            File file2 = new File(file, string);
            this.filename = string;
            SnapinObjectInputStream snapinObjectInputStream = new SnapinObjectInputStream(new FileInputStream(file2));
            this.m_table = (Hashtable)snapinObjectInputStream.readObject();
            snapinObjectInputStream.close();
            D.out("Read persistant data from '" + string + "'.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            D.out("Couldn't read persistant data from '" + string + "' -- file not found.");
        }
        catch (Exception exception) {
            D.reportSnapinError(exception);
        }
    }
}

