/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.gwcheck;

import com.novell.gw.admin.config.GWServiceSnapin;
import com.novell.gw.admin.gwcheck.CheckApp;
import com.novell.gw.admin.gwcheck.CheckPanel;
import com.novell.gw.admin.gwcheck.GWObjectsPanel;
import com.novell.gw.admin.gwcheck.Resource;
import com.novell.gw.util.Debug;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ButtonPanel
extends JPanel {
    private CheckApp ckApp = null;
    private CheckPanel cpanel = null;
    private JButton runBtn = null;
    private JButton closeBtn = null;
    private JButton retrieveBtn = null;
    private JButton saveBtn = null;
    private JButton helpBtn = null;
    private boolean hasSysRights = true;

    public ButtonPanel(CheckApp checkApp, CheckPanel checkPanel) {
        this.ckApp = checkApp;
        this.cpanel = checkPanel;
        if (checkApp.inConsoleOne()) {
            this.hasSysRights = GWServiceSnapin.hasSystemLevelRights();
        }
        Dimension dimension = new Dimension(1, 15);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(0, 10, 0, 0));
        if (checkApp.doingSchedEvents()) {
            this.runBtn = Resource.getButton("OKKey");
            this.closeBtn = Resource.getButton("CancelKey");
        } else {
            this.runBtn = Resource.getButton("RunKey");
            this.closeBtn = Resource.getButton("CloseKey");
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPanel.this.doRun();
            }
        };
        this.runBtn.addActionListener(actionListener);
        this.runBtn.setEnabled(false);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPanel.this.doClose();
            }
        };
        this.closeBtn.addActionListener(actionListener);
        this.retrieveBtn = Resource.getButton("RetrieveKey");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPanel.this.doRetrieve();
            }
        };
        this.retrieveBtn.addActionListener(actionListener);
        this.saveBtn = Resource.getButton("SaveKey");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPanel.this.doSave();
            }
        };
        this.saveBtn.addActionListener(actionListener);
        this.helpBtn = Resource.getButton("HelpKey");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPanel.this.doHelp();
            }
        };
        if (!checkApp.inConsoleOne()) {
            HelpBroker helpBroker = checkApp.getHelpBroker();
            if (helpBroker != null) {
                Debug.trace((String)"gwcheck.ButtonPanel.CSH.DisplayHelpFromSource");
                this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
            }
        } else {
            this.helpBtn.addActionListener(actionListener);
        }
        this.add(this.runBtn);
        this.add(Box.createRigidArea(dimension));
        this.add(this.closeBtn);
        if (!checkApp.doingSchedEvents() && !checkApp.isInvokeFromClient()) {
            this.add(Box.createRigidArea(dimension));
            this.add(this.retrieveBtn);
            this.add(Box.createRigidArea(dimension));
            this.add(this.saveBtn);
        }
        this.add(Box.createRigidArea(dimension));
        this.add(this.helpBtn);
    }

    public void doRun() {
        Debug.trace((String)"gwcheck.ButtonPanel.doRun");
        this.cpanel.getProcessor().doRun();
        if (this.ckApp.doingSchedEvents() || this.ckApp.getBatchMode()) {
            this.ckApp.closeApp(0, false);
        }
    }

    private void doClose() {
        Debug.trace((String)"gwcheck.ButtonPanel.doClose");
        this.ckApp.closeApp(1, false);
    }

    private void doRetrieve() {
        Debug.trace((String)"gwcheck.ButtonPanel.doRetrieve");
        this.cpanel.getProcessor().doRetrieve();
    }

    public JButton getDefaultFocusButton() {
        return this.runBtn;
    }

    private void doSave() {
        Debug.trace((String)"gwcheck.ButtonPanel.doSave");
        this.cpanel.getProcessor().doSave();
    }

    private void doHelp() {
        if (this.ckApp.doingSchedEvents()) {
            this.cpanel.getProcessor().showHelp("poaschactdlg", this.ckApp.getDialog());
        } else {
            String string = "BOGUS_mlmaintdlg";
            int n = this.cpanel.getActionPanel().getCurrentActionIndex();
            switch (n) {
                case 0: 
                case 17: 
                case 22: {
                    string = "urafdbdlg";
                    break;
                }
                case 1: 
                case 18: {
                    string = "urermsgdlg";
                    break;
                }
                case 2: 
                case 19: {
                    string = "urstatsdlg";
                    break;
                }
                case 3: {
                    string = "urrcoptdlg";
                    break;
                }
                case 4: 
                case 20: {
                    string = "urrudbdlg";
                    break;
                }
                case 5: 
                case 21: 
                case 23: {
                    string = "ursrblddlg";
                    break;
                }
                case 6: {
                    string = "libafdbdlg";
                    break;
                }
                case 7: {
                    string = "libaddocdlg";
                    break;
                }
                case 8: {
                    string = "libdlogdlg";
                    break;
                }
                case 9: {
                    string = "libaflibdlg";
                    break;
                }
                case 10: {
                    string = "poafdbdlg";
                    break;
                }
                case 11: {
                    string = "poermsgdlg";
                    break;
                }
                case 12: {
                    string = "postatsdlg";
                    break;
                }
                case 13: {
                    string = "poaddocdlg";
                    break;
                }
                case 14: {
                    string = "podlogdlg";
                    break;
                }
                case 15: {
                    string = "poaflibdlg";
                    break;
                }
                case 16: {
                    string = "poauditdlg";
                }
            }
            this.cpanel.getProcessor().showHelp(string, this.ckApp.getDialog());
        }
        if (Debug.trace) {
            Debug.trace((String)"gwcheck.ButtonPanel.doHelp: Calling doDump");
            this.cpanel.getProcessor().doDump();
        }
    }

    public void enableRunButton(boolean bl) {
        this.runBtn.setEnabled(bl);
    }

    public void enableRunButton(int n, String string) {
        Debug.trace((String)("          ButtonPanel.enableRunButton called by " + string + ": " + n));
        boolean bl = false;
        if (this.cpanel.getActionPanel() == null) {
            this.runBtn.setEnabled(false);
            return;
        }
        if (this.ckApp.doingSchedEvents()) {
            if (!this.hasSysRights) {
                this.runBtn.setEnabled(false);
                Debug.trace((String)"ButtonPanel.enableRunButton: no system rights, no ok button");
                return;
            }
            String string2 = this.cpanel.getActionPanel().getEventName();
            if (string2 == null || string2.equals("")) {
                this.runBtn.setEnabled(false);
                return;
            }
        } else {
            GWObjectsPanel gWObjectsPanel = this.cpanel.getLeftPanel();
            if (gWObjectsPanel != null && !gWObjectsPanel.somethingValidSelected()) {
                this.runBtn.setEnabled(false);
                return;
            }
        }
        if (n == -1) {
            n = this.cpanel.getActionPanel().getCurrentActionIndex();
        }
        switch (n) {
            case 0: 
            case 6: 
            case 10: 
            case 17: 
            case 22: {
                bl = this.cpanel.getActionPanel().getRunButtonValueForU_0();
                break;
            }
            case 1: 
            case 11: 
            case 18: {
                bl = this.cpanel.getActionPanel().getRunButtonValueForU_1();
                break;
            }
            case 2: 
            case 12: 
            case 19: {
                bl = this.cpanel.getActionPanel().getRunButtonValueForU_2();
                break;
            }
            case 5: 
            case 21: 
            case 23: {
                bl = this.cpanel.getTabbedPanel().isAnyDBSelected();
                break;
            }
            case 9: 
            case 15: {
                bl = this.cpanel.getActionPanel().getRunButtonValueForP_5();
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                bl = true;
            }
        }
        this.runBtn.setEnabled(bl);
    }
}

