/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.gwcheck;

import com.novell.gw.admin.config.GWObjectSelector;
import com.novell.gw.admin.gwcheck.CheckApp;
import com.novell.gw.admin.gwcheck.CheckPanel;
import com.novell.gw.admin.gwcheck.ExcludePanel;
import com.novell.gw.admin.gwcheck.Misc;
import com.novell.gw.admin.gwcheck.Resource;
import com.novell.gw.admin.gwcheck.myObjectEntry;
import com.novell.gw.admin.widgets.GWComboBox;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ExcludeDialog
implements ItemListener {
    private CheckApp ckApp = null;
    private CheckPanel cpanel = null;
    private JComponent ppan = null;
    private GWComboBox combo = null;
    private JScrollPane scrollPane = null;
    private JRadioButton usersRB = null;
    private JRadioButton resRB = null;
    private JButton infoBtn = null;
    private JButton okBtn = Resource.getButton("OKKey");
    private JButton cancelBtn = Resource.getButton("CancelKey");
    private boolean libOption = false;
    private GWObjectSelector selector;
    private static final String[] userColHdrs = new String[]{Resource.getString("csObjectID"), Resource.getString("csDomain"), Resource.getString("csPostOffice"), Resource.getString("csLastName"), Resource.getString("csFirstName")};
    private static final String[] userColAttrs = new String[]{String.valueOf(50073), String.valueOf(50035), String.valueOf(50062), String.valueOf(50093), String.valueOf(50091)};
    private static final String[] resColHdrs = new String[]{Resource.getString("csObjectID"), Resource.getString("csDomain"), Resource.getString("csPostOffice"), Resource.getString("csOwner")};
    private static final String[] resColAttrs = new String[]{String.valueOf(50073), String.valueOf(50035), String.valueOf(50062), String.valueOf(50081)};

    public ExcludeDialog(CheckApp checkApp, CheckPanel checkPanel, JComponent jComponent, Object[] objectArray) {
        this.ckApp = checkApp;
        this.cpanel = checkPanel;
        this.ppan = jComponent;
        Frame frame = checkApp.getParentFrame();
        this.libOption = jComponent instanceof JTextField;
        this.selector = new GWObjectSelector(frame, (Object[])userColHdrs, checkApp.getContext());
        if (this.libOption) {
            Debug.trace((String)"In ExcludeDialog for LIB author");
        } else {
            Debug.trace((String)"In ExcludeDialog for PO exclusions");
            this.combo = new GWComboBox(objectArray);
            this.combo.setLightWeightPopupEnabled(false);
            this.combo.setEditable(false);
            this.combo.setSelectedIndex(0);
            this.combo.addItemListener((ItemListener)this);
            JPanel jPanel = new JPanel(new GridLayout(0, 1), true);
            jPanel.setBorder(new EmptyBorder(0, 10, 10, 105));
            jPanel.add((Component)this.combo);
            this.selector.setSouthPanel((Component)jPanel);
            Dimension dimension = new Dimension(1, 10);
            JPanel jPanel2 = Misc.getVerticalLayoutPanel();
            jPanel2.add(Box.createRigidArea(new Dimension(2, 20)));
            this.usersRB = Resource.getRadioButton("csUsers");
            this.usersRB.setSelected(true);
            this.usersRB.addItemListener(this);
            jPanel2.add(this.usersRB);
            this.resRB = Resource.getRadioButton("csResources");
            this.resRB.addItemListener(this);
            jPanel2.add(this.resRB);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.usersRB);
            buttonGroup.add(this.resRB);
            this.selector.setRightPanel((Component)jPanel2);
        }
        this.selector.setLocationRelativeTo((Component)frame);
        this.resetTable();
    }

    private void resetTable() {
        BasicAttributes basicAttributes;
        String[] stringArray;
        Object[] objectArray;
        if (this.libOption) {
            objectArray = userColHdrs;
            stringArray = userColAttrs;
            basicAttributes = this.getAttrsAllUsers();
            this.selector.setSelectionMode(0);
        } else {
            this.selector.setSelectionMode(1);
            myObjectEntry myObjectEntry2 = (myObjectEntry)this.combo.getSelectedItem();
            if (this.usersRB.isSelected()) {
                objectArray = userColHdrs;
                stringArray = userColAttrs;
                basicAttributes = this.getAttrsPOUsers(myObjectEntry2);
            } else {
                objectArray = resColHdrs;
                stringArray = resColAttrs;
                basicAttributes = this.getAttrsPOResources(myObjectEntry2);
            }
        }
        int n = this.selector.resetTable(objectArray, (Attributes)basicAttributes, stringArray, 0);
        if (n == 0) {
            this.doOK();
        }
    }

    private BasicAttributes getAttrsPOResources(myObjectEntry myObjectEntry2) {
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("Search Index", new Integer(248));
        basicAttributes.put(String.valueOf("Search New Record Type"), new Integer(106));
        basicAttributes.put(String.valueOf(50075), new Integer(5));
        basicAttributes.put(String.valueOf(50035), myObjectEntry2.getDomain());
        basicAttributes.put(String.valueOf(50062), myObjectEntry2.getHost());
        return basicAttributes;
    }

    private BasicAttributes getAttrsAllUsers() {
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("Search Index", new Integer(249));
        basicAttributes.put(String.valueOf("Search New Record Type"), new Integer(106));
        basicAttributes.put(String.valueOf(50075), new Integer(6));
        return basicAttributes;
    }

    private BasicAttributes getAttrsPOUsers(myObjectEntry myObjectEntry2) {
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put("Search Index", new Integer(248));
        basicAttributes.put(String.valueOf("Search New Record Type"), new Integer(106));
        basicAttributes.put(String.valueOf(50075), new Integer(6));
        basicAttributes.put(String.valueOf(50035), myObjectEntry2.getDomain());
        basicAttributes.put(String.valueOf(50062), myObjectEntry2.getHost());
        return basicAttributes;
    }

    private void doOK() {
        Object[] objectArray = this.selector.getSelectedRowData();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            String string = (String)objectArray2[0];
            if (this.libOption) {
                ((JTextField)this.ppan).setText(string);
                continue;
            }
            ((ExcludePanel)this.ppan).updatePanel(string);
        }
        this.selector.dispose();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JRadioButton jRadioButton;
        Debug.trace((String)"ExcludeDialog.itemStateChanged");
        Object object = itemEvent.getSource();
        if (object instanceof GWComboBox) {
            if (itemEvent.getStateChange() == 1) {
                this.resetTable();
            }
        } else if (object instanceof JRadioButton && (jRadioButton = (JRadioButton)itemEvent.getSource()).isSelected()) {
            this.resetTable();
        }
    }
}

