/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.gwcheck;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.Shell;
import com.novell.gw.admin.gwcheck.CheckApp;
import com.novell.gw.admin.gwcheck.CheckPanel;
import com.novell.gw.admin.gwcheck.ExcludeDialog;
import com.novell.gw.admin.gwcheck.GlueObject;
import com.novell.gw.admin.gwcheck.Misc;
import com.novell.gw.admin.gwcheck.Resource;
import com.novell.gw.admin.gwcheck.SimpleExcludeDialog;
import com.novell.gw.admin.gwcheck.myJList;
import com.novell.gw.admin.gwcheck.myObjectEntry;
import com.novell.gw.ds.assoc.GwAssocContext;
import com.novell.gw.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;

public class ExcludePanel
extends JPanel {
    private CheckApp ckApp = null;
    private CheckPanel cpanel = null;
    private StringVector vec = null;
    private JButton addBtn = Resource.getButton("AddKey");
    private JButton removeBtn = Resource.getButton("RemoveKey");
    private JList jlist = new JList();

    public ExcludePanel(CheckApp checkApp, CheckPanel checkPanel) {
        this.ckApp = checkApp;
        this.cpanel = checkPanel;
        this.setLayout(new BorderLayout());
        this.setBorder(Misc.EMPTY_BORDER_10);
        this.jlist.setModel(new myListModel());
        this.jlist.setCellRenderer(new myListCellRenderer());
        JPanel jPanel = Misc.getVerticalLayoutPanel();
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExcludePanel.this.doAdd();
            }
        };
        this.addBtn.addActionListener(actionListener);
        if (!checkApp.doingSchedEvents()) {
            this.addBtn.setEnabled(false);
        }
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExcludePanel.this.doRemove();
            }
        };
        this.removeBtn.addActionListener(actionListener);
        this.removeBtn.setEnabled(false);
        jPanel.add(this.addBtn);
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel.add(this.removeBtn);
        this.add("Center", new JScrollPane(this.jlist));
        this.add("East", jPanel);
    }

    public void reInitData() {
        Object object;
        boolean bl = false;
        bl = this.ckApp.doingSchedEvents() ? true : (this.ckApp.isRunningStandalone() ? true : (object = this.cpanel.getLeftPanel().getSelectedValues()) != null && ((Object[])object).length != 0);
        if (!bl) {
            this.addBtn.setEnabled(false);
        } else {
            this.addBtn.setEnabled(true);
            if (this.vec == null) {
                this.vec = new StringVector();
                object = this.ckApp.getMyChkOpts();
                String[] stringArray = ((GlueObject)object).getExclude();
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.vec.addString(stringArray[i]);
                    }
                }
            }
        }
        if (this.ckApp.doingSchedEvents()) {
            this.addBtn.setEnabled(true);
        }
        this.redrawJList(-1);
    }

    public void saveData(GlueObject glueObject) {
        if (this.vec != null) {
            int n = this.vec.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < this.vec.size(); ++i) {
                stringArray[i] = (String)this.vec.elementAt(i);
            }
            glueObject.setExclude(stringArray);
        }
    }

    public void updatePanel(String string) {
        Debug.trace((String)("ExcludePanel.updatePanel: str = " + string));
        if (string != null && !string.equals("")) {
            if (this.vec == null) {
                this.vec = new StringVector();
                this.vec.addElement(string);
            } else {
                this.vec.addString(string);
            }
            this.redrawJList(this.vec.size() - 1);
        }
    }

    private void redrawJList(int n) {
        this.jlist.setModel(new myListModel());
        if (n > -1) {
            this.jlist.ensureIndexIsVisible(n);
        }
        this.jlist.updateUI();
    }

    private void doAdd() {
        Object[] objectArray = null;
        if (this.ckApp.doingSchedEvents()) {
            Vector vector = null;
            Shell shell = this.ckApp.getShell();
            if (shell != null) {
                vector = this.ckApp.getCurrentSelections();
            }
            if (vector != null) {
                ObjectEntry objectEntry = (ObjectEntry)vector.elementAt(0);
                GwAssocContext gwAssocContext = com.novell.gw.admin.config.Misc.getGlueAndDisplayErrorsOnObject((Window)this.ckApp.getDialog(), (ObjectEntry)objectEntry.getParent());
                objectArray = new Object[]{new myObjectEntry(this.ckApp, gwAssocContext)};
            }
        } else if (!this.ckApp.isRunningStandalone()) {
            objectArray = this.cpanel.getLeftPanel().getSelectedValues();
        }
        if (objectArray == null || objectArray.length == 0) {
            if (this.ckApp.isRunningStandalone()) {
                new SimpleExcludeDialog(this.ckApp, this.cpanel, this);
            } else {
                Debug.traceDlg((String)"No post office is selected to add on.");
            }
        } else {
            new ExcludeDialog(this.ckApp, this.cpanel, this, objectArray);
        }
    }

    private void doRemove() {
        int n = this.jlist.getSelectedIndex();
        if (n > -1) {
            this.vec.removeElementAt(n);
            this.redrawJList(n - 1);
        }
    }

    class myListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        myListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText((String)object);
            this.setBackground(bl ? myJList.darkBlue : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            int[] nArray = jList.getSelectedIndices();
            if (nArray.length > 0) {
                ExcludePanel.this.removeBtn.setEnabled(true);
            } else {
                ExcludePanel.this.removeBtn.setEnabled(false);
            }
            return this;
        }
    }

    class myListModel
    implements ListModel {
        myListModel() {
        }

        public int getSize() {
            int n = 0;
            if (ExcludePanel.this.vec != null) {
                n = ExcludePanel.this.vec.size();
            }
            return n;
        }

        public Object getElementAt(int n) {
            Object var2_2 = null;
            if (ExcludePanel.this.vec != null) {
                var2_2 = ExcludePanel.this.vec.elementAt(n);
            }
            return var2_2;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    public class StringVector
    extends Vector {
        public StringVector() {
            super(10, 10);
        }

        public int addString(String string) {
            int n;
            if (string == null) {
                return -1;
            }
            for (n = 0; n < this.size(); ++n) {
                String string2 = (String)this.elementAt(n);
                int n2 = string.compareToIgnoreCase(string2);
                if (n2 == 0) {
                    return -1;
                }
                if (n2 < 0) break;
            }
            this.insertElementAt(string, n);
            return n;
        }
    }
}

