/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.gwcheck;

import com.novell.gw.admin.common.MsgDisplayer;
import com.novell.gw.admin.gwcheck.SchedEventObject;
import com.novell.gw.directory.ActionDirContext;
import com.novell.gw.directory.ChkOpts;
import com.novell.gw.directory.FDoc;
import com.novell.gw.directory.GwCallBack;
import com.novell.gw.directory.GwDirContext;
import com.novell.gw.ds.ExtendedDirContext;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import javax.naming.NamingException;

public class GlueObject {
    private Frame parent;
    private ChkOpts chkOpts = null;
    private GwDirContext gctx;
    private boolean doTrace = Debug.trace;
    private boolean isRunningStandalone = false;

    public GlueObject(Frame frame, GwDirContext gwDirContext, SchedEventObject schedEventObject, boolean bl) {
        this.parent = frame;
        this.gctx = gwDirContext;
        this.isRunningStandalone = bl;
        if (gwDirContext == null) {
            if (!bl) {
                Debug.traceDlg((String)"GlueObject.Constructor: NULL gctx");
            } else {
                Debug.trace((String)"GlueObject constructor ");
                this.chkOpts = FDoc.getChkOpts();
                this.setDefaults();
            }
        } else {
            this.chkOpts = gwDirContext.getChkOpts("");
            this.chkOpts.enableDebug(this.doTrace);
            String string = "\n WHAT?? chkOpts created ";
            if (schedEventObject == null) {
                string = "\n chkOpts created with default path";
            } else {
                ActionDirContext actionDirContext = schedEventObject.getContext();
                if (schedEventObject.isNew()) {
                    string = "\n chkOpts created for NEW ActionDirContext";
                } else {
                    string = "\n chkOpts created from moveFOBJToCKOPTS";
                    try {
                        actionDirContext.moveFObjToCKOPTS(this.chkOpts);
                        if (Debug.trace) {
                            Debug.trace((String)"After call to moveFObjToCKOPTS");
                            this.dumpCKOPT();
                        }
                    }
                    catch (NamingException namingException) {
                        Debug.traceException((Throwable)namingException);
                        MsgDisplayer.handleException((Component)frame, (Exception)namingException, null);
                    }
                }
            }
            string = string + "\n ----------------------------------------------------------------";
            Debug.trace((String)string);
        }
    }

    private void trace(String string) {
        if (this.doTrace && Debug.trace) {
            Debug.trace((String)("*********** GlueObject *** " + string));
        }
    }

    private boolean getAnalyze(int n) {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getAnalyze(n);
        }
        this.trace("getAnalyze(" + n + ") returning " + bl);
        return bl;
    }

    private void setAnalyze(int n, boolean bl) {
        this.trace("setAnalyze: " + n + ", " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setAnalyze(n, bl);
        }
    }

    private int getExpire(int n) {
        int n2 = 0;
        if (this.chkOpts != null) {
            n2 = this.chkOpts.getExpire(n);
        }
        this.trace("getExpire(" + n + ") returning " + n2);
        return n2;
    }

    private void setExpire(int n, int n2) {
        this.trace("setExpire: " + n + ", " + n2);
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(n, n2);
        }
    }

    private int getStats(int n) {
        int n2 = 0;
        if (this.chkOpts != null) {
            n2 = this.chkOpts.getStats(n);
        }
        this.trace("getStats(" + n + ") returning " + n2);
        return n2;
    }

    private void setStats(int n, int n2) {
        this.trace("setStats: " + n + ", " + n2);
        if (this.chkOpts != null) {
            this.chkOpts.setStats(n, n2);
        }
    }

    private boolean getFixLib(int n) {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(n);
        }
        this.trace("getFixLib(" + n + ") returning " + bl);
        return bl;
    }

    private void setFixLib(int n, boolean bl) {
        this.trace("setFixLib: " + n + ", " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(n, bl);
        }
    }

    public ChkOpts getChkOpts() {
        return this.chkOpts;
    }

    public void close() {
        this.trace("\n*********************************************************");
        this.trace("close");
        this.parent = null;
        this.chkOpts = null;
        this.gctx = null;
    }

    public void setDefaults() {
        this.trace("setDefaults");
        if (this.chkOpts != null) {
            this.chkOpts.setDefaults();
        }
    }

    private int getObjectVersion(String string, String string2) {
        int n = 0;
        String string3 = string + "." + string2;
        ExtendedDirContext extendedDirContext = null;
        Integer n2 = null;
        try {
            extendedDirContext = (ExtendedDirContext)this.gctx.getObject(string3);
            Debug.assrt((extendedDirContext != null ? 1 : 0) != 0, (String)("GlueObject.getObjectVersion: NULL poObj for " + string3));
            n2 = (Integer)extendedDirContext.getAttrValue(String.valueOf(63110));
        }
        catch (NamingException namingException) {
            Debug.traceException((Throwable)namingException);
            MsgDisplayer.handleException((Component)this.parent, (Exception)namingException, null);
        }
        if (n2 == null) {
            Debug.traceDlg((String)("GlueObject.getObjectVersion: NULL VERSION attribute for " + string3));
        } else {
            n = n2;
        }
        Debug.trace((String)("GlueObject.getObjectVersion: version = " + n));
        return n;
    }

    public int setTarget(String string, String string2, String string3) {
        int n = 0;
        Debug.trace((String)("GlueObject.setTarget on " + string + "." + string2 + "." + string3));
        if (this.chkOpts != null) {
            int n2 = this.getObjectVersion(string, string2);
            if (n2 < 500) {
                Debug.traceDlg((String)("GlueObject.setTarget WARNING: INCOMPATIBLE version= " + n2));
            }
            if ((n = this.chkOpts.setTarget(string, string2, string3, n2)) != 0) {
                Debug.traceDlg((String)("GlueObject.setTarget: ERROR 0x" + Integer.toHexString(n)));
            }
        }
        return n;
    }

    public void setTargetStandalone(String string, String string2, String string3, String string4, boolean bl) {
        Debug.trace((String)"GlueObject.setTargetStandalone");
        if (this.chkOpts != null) {
            this.chkOpts.setTargetStandalone(string, string2, string3, string4, bl);
        }
    }

    public int run() {
        int n = 0;
        if (this.chkOpts != null && (n = this.chkOpts.run()) != 0 && Debug.trace) {
            Debug.traceDlg((String)("GlueObject.run returning " + n + ", hex = 0x" + Integer.toHexString(n)));
        }
        return n;
    }

    public int save() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.save();
        }
        this.trace("save returning " + n);
        return n;
    }

    public int loadOptions(String string) {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.loadOptions(string, !this.isRunningStandalone);
        }
        this.trace("loadOptions(" + string + ") returning " + n);
        return n;
    }

    public boolean getVerbose() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getVerbose();
        }
        this.trace("getVerbose returning " + bl);
        return bl;
    }

    public void setVerbose(boolean bl) {
        this.trace("setVerbose: " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setVerbose(bl);
        }
    }

    public void setUserDB(boolean bl) {
        this.trace("setUserDB: " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setUserDB(bl);
        }
    }

    public void setMsgDB(boolean bl) {
        this.trace("setMsgDB: " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setMsgDB(bl);
        }
    }

    public void setDocDB(boolean bl) {
        this.trace("setDocDB: " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setDocDB(bl);
        }
    }

    public boolean getUserDB() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getUserDB();
        }
        this.trace("getUserDB returning " + bl);
        return bl;
    }

    public boolean getMsgDB() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getMsgDB();
        }
        this.trace("getMsgDB returning " + bl);
        return bl;
    }

    public boolean getDocDB() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getDocDB();
        }
        this.trace("getDocDB returning " + bl);
        return bl;
    }

    private String getOptionsFilename() {
        String string = null;
        if (this.chkOpts != null) {
            string = this.chkOpts.getOptionsFilename();
        }
        this.trace("getOptionsFilename returning [" + string + "]");
        return string;
    }

    private void setOptionsFilename(String string) {
        this.trace("setOptionsFilename: [" + string + "]");
        if (this.chkOpts != null) {
            if (string == null) {
                this.chkOpts.setOptionsFilename("");
            } else {
                this.chkOpts.setOptionsFilename(string);
            }
        }
    }

    public File getOptnFile() {
        this.trace("getOptnFile");
        String string = this.getOptionsFilename();
        if (string == null || string.equals("")) {
            return null;
        }
        return new File(string);
    }

    public void setOptnFile(File file) {
        this.trace("setOptnFile");
        if (file == null) {
            this.setOptionsFilename("");
        } else {
            this.setOptionsFilename(file.getAbsolutePath());
        }
    }

    public int getAction() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getAction();
        }
        this.trace("getAction returning " + n);
        return n;
    }

    public void setAction(int n) {
        this.trace("setAction: " + n);
        if (this.chkOpts != null) {
            this.chkOpts.setAction(n);
        }
    }

    public String getLogFilename() {
        String string = null;
        if (this.chkOpts != null) {
            string = this.chkOpts.getLogFilename();
        }
        this.trace("getLogFilename returning " + string);
        return string;
    }

    public void setLogFileName(String string) {
        this.trace("setLogFilename: [" + string + "]");
        if (this.chkOpts != null) {
            this.chkOpts.setLogFileName(string);
        }
    }

    public boolean getResults(int n) {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getResults(n);
        }
        this.trace("getResults(" + n + ") returning " + bl);
        return bl;
    }

    public void setResults(int n, boolean bl) {
        this.trace("setResults " + n + ", " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setResults(n, bl);
        }
    }

    public boolean getDiskSpaceMan(int n) {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getDiskSpaceMan(n);
        }
        this.trace("getDiskSpaceMan (" + n + ") returning " + bl);
        return bl;
    }

    public void setDiskSpaceMan(int n, boolean bl) {
        this.trace("setDiskSpaceMan " + n + ", " + bl);
        if (this.chkOpts != null) {
            this.chkOpts.setDiskSpaceMan(n, bl);
        }
    }

    private void showExcludeArray(String[] stringArray) {
        if (Debug.trace) {
            if (stringArray == null) {
                Debug.trace((String)"   NULL excludeList");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    Debug.trace((String)("   excludeList[" + i + "]= " + stringArray[i]));
                }
            }
        }
    }

    public String[] getExclude() {
        String[] stringArray = null;
        if (this.chkOpts != null) {
            stringArray = this.chkOpts.getExclude();
        }
        if (Debug.trace) {
            Debug.trace((String)"GlueObject.getExclude: ");
            this.showExcludeArray(stringArray);
        }
        return stringArray;
    }

    public void setExclude(String[] stringArray) {
        if (Debug.trace) {
            Debug.trace((String)"GlueObject.setExclude: ");
            this.showExcludeArray(stringArray);
        }
        if (this.chkOpts != null) {
            this.chkOpts.setExclude(stringArray);
        }
    }

    public boolean getAFStructure() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getAnalyze(1);
        }
        return bl;
    }

    public void setAFStructure(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setAnalyze(1, bl);
        }
    }

    public boolean getAFIndex() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getAnalyze(3);
        }
        return bl;
    }

    public void setAFIndex(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setAnalyze(3, bl);
        }
    }

    public boolean getAFContents() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getAnalyze(2);
        }
        return bl;
    }

    public void setAFContents(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setAnalyze(2, bl);
        }
    }

    public boolean getAFStats() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getAnalyze(4);
        }
        return bl;
    }

    public void setAFStats(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setAnalyze(4, bl);
        }
    }

    public boolean getAFFix() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getAnalyze(5);
        }
        return bl;
    }

    public void setAFFix(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setAnalyze(5, bl);
        }
    }

    public boolean getAFResetUserTotals() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getAnalyze(6);
        }
        return bl;
    }

    public void setAFResetUserTotals(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setAnalyze(6, bl);
        }
    }

    public boolean getERReduceOnly() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(11);
        }
        return n == 0;
    }

    public void setERReduceOnly(boolean bl) {
        if (this.chkOpts != null) {
            if (bl) {
                this.chkOpts.setExpire(10, 0);
            } else {
                this.chkOpts.setExpire(11, 0);
            }
        }
    }

    public int getERDays() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(12);
        }
        return n;
    }

    public void setERDays(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(12, n);
        }
    }

    public int getERDownloadedDays() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(23);
        }
        return n;
    }

    public void setERDownloadedDays(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(23, n);
        }
    }

    public int getERSizeLimit() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(13);
        }
        return n;
    }

    public void setERSizeLimit(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(13, n);
        }
    }

    public int getERReduceTo() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(14);
        }
        return n;
    }

    public void setERReduceTo(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(14, n);
        }
    }

    public boolean getERReduceToMailboxSizeLimit() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(22);
        }
        return n != 0;
    }

    public void setERReduceToMailboxSizeLimit(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(22, bl ? 1 : 0);
        }
    }

    public int getERExpireTrash() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(15);
        }
        return n;
    }

    public void setERExpireTrash(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(15, n);
        }
    }

    public boolean getMSExpireStats() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(32);
        }
        return n == 0;
    }

    public void setMSExpireStats(boolean bl) {
        if (this.chkOpts != null) {
            if (bl) {
                this.chkOpts.setStats(31, 0);
            } else {
                this.chkOpts.setStats(32, 0);
            }
        }
    }

    public int getMSDays() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(34);
        }
        return n;
    }

    public void setMSDays(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(34, n);
        }
    }

    public int getMSDownloadedDays() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(43);
        }
        return n;
    }

    public void setMSDownloadedDays(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(43, n);
        }
    }

    public int getMSSizeLimit() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(35);
        }
        return n;
    }

    public void setMSSizeLimit(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(35, n);
        }
    }

    public int getMSReduceTo() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(36);
        }
        return n;
    }

    public void setMSReduceTo(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(36, n);
        }
    }

    public boolean getMSReduceToMailboxSizeLimit() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(42);
        }
        return n != 0;
    }

    public void setMSReduceToMailboxSizeLimit(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(42, bl ? 1 : 0);
        }
    }

    public int getMSBoxLimit() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(33);
        }
        return n;
    }

    public void setMSBoxLimit(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(33, n);
        }
    }

    public boolean getClearUserPassword() {
        boolean bl = false;
        if (this.chkOpts != null) {
            int n = this.chkOpts.getClientOpts(90);
            bl = n != 0;
        }
        return bl;
    }

    public void setClearUserPassword(boolean bl) {
        if (this.chkOpts != null) {
            int n = bl ? 1 : 0;
            this.chkOpts.setClientOpts(90, n);
        }
    }

    public int getERActivityLogDays() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(20);
        }
        return n;
    }

    public void setERActivityLogDays(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(20, n);
        }
    }

    public int getInactivityDays() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getAuditReportDays();
        }
        return n;
    }

    public void setInactivityDays(int n) {
        if (this.chkOpts != null) {
            this.chkOpts.setAuditReportDays(n);
        }
    }

    public boolean getFLVerifyLib() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(60);
        }
        return bl;
    }

    public void setFLVerifyLib(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(60, bl);
        }
    }

    public boolean getFLDocVerElement() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(61);
        }
        return bl;
    }

    public void setFLDocVerElement(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(61, bl);
        }
    }

    public boolean getFLVerifyDocFiles() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(62);
        }
        return bl;
    }

    public void setFLVerifyDocFiles(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(62, bl);
        }
    }

    public boolean getFLSecurity() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(63);
        }
        return bl;
    }

    public void setFLSecurity(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(63, bl);
        }
    }

    public boolean getFLAllSecurity() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(66);
        }
        return bl;
    }

    public void setFLAllSecurity(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(66, bl);
        }
    }

    public boolean getFLSyncUserName() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(64);
        }
        return bl;
    }

    public void setFLSyncUserName(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(64, bl);
        }
    }

    public boolean getFLRemoveAreas() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(68);
        }
        return bl;
    }

    public void setFLRemoveAreas(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(68, bl);
        }
    }

    public boolean getFLMoveDocsFirst() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(69);
        }
        return bl;
    }

    public void setFLMoveDocsFirst(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(69, bl);
        }
    }

    public boolean getFLReassignOrphDocs() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(65);
        }
        return bl;
    }

    public void setFLReassignOrphDocs(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(65, bl);
        }
    }

    public String getDocAuthor() {
        String string = null;
        if (this.chkOpts != null) {
            string = this.chkOpts.getNewUserName();
        }
        return string;
    }

    public void setDocAuthor(String string) {
        if (string != null && this.chkOpts != null) {
            this.chkOpts.setNewUserName(string);
        }
    }

    public boolean getFLResetWordLists() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getFixLib(67);
        }
        return bl;
    }

    public void setFLResetWordLists(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setFixLib(67, bl);
        }
    }

    public boolean getRTAdmin() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getResults(55);
        }
        return bl;
    }

    public void setRTAdmin(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setResults(55, bl);
        }
    }

    public boolean getRTIndividualUsers() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getResults(56);
        }
        return bl;
    }

    public void setRTIndividualUsers(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setResults(56, bl);
        }
    }

    public String getRTCCList() {
        String string = null;
        if (this.chkOpts != null) {
            string = this.chkOpts.getCCUserList();
        }
        return string;
    }

    public void setRTCCList(String string) {
        if (string != null && this.chkOpts != null) {
            this.chkOpts.setCCUserList(string);
        }
    }

    public String getRTMessage() {
        String string = null;
        if (this.chkOpts != null) {
            string = this.chkOpts.getMessage();
        }
        return string;
    }

    public void setRTMessage(String string) {
        if (string != null && this.chkOpts != null) {
            this.chkOpts.setMessage(string);
        }
    }

    public boolean getIncExpInbox() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(16);
        }
        return n != 0;
    }

    public void setIncExpInbox(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(16, bl ? 1 : 0);
        }
    }

    public boolean getIncExpOutbox() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(17);
        }
        return n != 0;
    }

    public void setIncExpOutbox(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(17, bl ? 1 : 0);
        }
    }

    public boolean getIncExpCal() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(18);
        }
        return n != 0;
    }

    public void setIncExpCal(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(18, bl ? 1 : 0);
        }
    }

    public boolean getIncExpDocRefs() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(19);
        }
        return n != 0;
    }

    public void setIncExpDocRefs(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(19, bl ? 1 : 0);
        }
    }

    public boolean getIncExpOnlyBackedupItems() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(21);
        }
        return n != 0;
    }

    public void setIncExpOnlyBackedupItems(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(21, bl ? 1 : 0);
        }
    }

    public boolean getIncExpOnlyRetainedItems() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getExpire(24);
        }
        return n != 0;
    }

    public void setIncExpOnlyRetainedItems(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setExpire(24, bl ? 1 : 0);
        }
    }

    public boolean getIncStatsInbox() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(37);
        }
        return n != 0;
    }

    public void setIncStatsInbox(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(37, bl ? 1 : 0);
        }
    }

    public boolean getIncStatsOutbox() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(38);
        }
        return n != 0;
    }

    public void setIncStatsOutbox(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(38, bl ? 1 : 0);
        }
    }

    public boolean getIncStatsCal() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(39);
        }
        return n != 0;
    }

    public void setIncStatsCal(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(39, bl ? 1 : 0);
        }
    }

    public boolean getIncStatsDocRefs() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(40);
        }
        return n != 0;
    }

    public void setIncStatsDocRefs(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(40, bl ? 1 : 0);
        }
    }

    public boolean getIncStatsOnlyBackedupItems() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(41);
        }
        return n != 0;
    }

    public void setIncStatsOnlyBackedupItems(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(41, bl ? 1 : 0);
        }
    }

    public boolean getIncStatsOnlyRetainedItems() {
        int n = 0;
        if (this.chkOpts != null) {
            n = this.chkOpts.getStats(44);
        }
        return n != 0;
    }

    public void setIncStatsOnlyRetainedItems(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setStats(44, bl ? 1 : 0);
        }
    }

    public boolean getNotifyBegin() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getSchedEvNotify(201);
        }
        return bl;
    }

    public void setNotifyBegin(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setSchedEvNotify(201, bl);
        }
    }

    public boolean getNotifyFail() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getSchedEvNotify(202);
        }
        return bl;
    }

    public void setNotifyFail(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setSchedEvNotify(202, bl);
        }
    }

    public boolean getNotifyEnd() {
        boolean bl = false;
        if (this.chkOpts != null) {
            bl = this.chkOpts.getSchedEvNotify(203);
        }
        return bl;
    }

    public void setNotifyEnd(boolean bl) {
        if (this.chkOpts != null) {
            this.chkOpts.setSchedEvNotify(203, bl);
        }
    }

    public String getOptConfig() {
        String string = null;
        if (this.chkOpts != null) {
            string = this.chkOpts.getOptConfig();
        }
        return string;
    }

    public void setOptConfig(String string) {
        if (string != null && this.chkOpts != null) {
            this.chkOpts.setOptConfig(string);
        }
    }

    public String getObjectName() {
        String string = null;
        if (this.chkOpts != null && (string = this.chkOpts.getObjectName()) == null) {
            string = "";
        }
        return string;
    }

    public String getPOName() {
        String string = null;
        if (this.chkOpts != null && (string = this.chkOpts.getPOName()) == null) {
            string = "";
        }
        return string;
    }

    public String getPathToPo() {
        String string = null;
        if (this.chkOpts != null && (string = this.chkOpts.getPOPath()) == null) {
            string = "";
        }
        return string;
    }

    public int getProgram() {
        int n = -1;
        if (this.chkOpts != null) {
            n = this.chkOpts.getProgram();
        }
        return n;
    }

    public int getCkObjType() {
        int n = -1;
        if (this.chkOpts != null) {
            n = this.chkOpts.getCkObjType();
        }
        return n;
    }

    public int runStandalone(boolean bl) {
        int n = -1;
        if (this.chkOpts != null) {
            n = this.chkOpts.runStandalone(bl);
        }
        return n;
    }

    public int gwCheckCallBacksOn(GwCallBack gwCallBack) {
        int n = -1;
        if (this.chkOpts != null) {
            n = this.chkOpts.gwCheckCallBacksOn(gwCallBack);
        }
        return n;
    }

    public void gwCheckCallBacksOff() {
        if (this.chkOpts != null) {
            this.chkOpts.gwCheckCallBacksOff();
        }
    }

    public void dumpCKOPT() {
        if (Debug.trace && this.chkOpts != null) {
            Debug.trace((String)"\ndumpCKOPT");
            Debug.trace((String)("getObjectName= [" + this.chkOpts.getObjectName() + "]\n"));
            String[] stringArray = this.chkOpts.dumpCKOPT();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                Debug.trace((String)("strA[" + i + "] =" + stringArray[i]));
            }
        }
    }
}

