/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.BooleanArray;
import com.objectspace.jgl.adapters.BooleanBuffer;
import com.objectspace.jgl.adapters.ByteBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class BooleanIterator
implements RandomAccessIterator,
Serializable {
    byte offset;
    int index;
    Sequence original;
    static final long serialVersionUID = 9093107050268453497L;

    public static BooleanIterator begin(boolean[] blArray) {
        return new BooleanIterator(blArray, 0);
    }

    public static BooleanIterator end(boolean[] blArray) {
        return new BooleanIterator(blArray, blArray.length);
    }

    public BooleanIterator() {
        this(new BooleanArray(), 0);
    }

    public BooleanIterator(BooleanIterator booleanIterator) {
        this.offset = booleanIterator.offset;
        this.index = booleanIterator.index;
        this.original = booleanIterator.original;
    }

    BooleanIterator(boolean[] blArray, int n) {
        this(new BooleanArray(blArray), n);
    }

    BooleanIterator(BooleanArray booleanArray, int n) {
        this.offset = (byte)-1;
        this.index = n;
        this.original = booleanArray;
    }

    public BooleanIterator(BooleanBuffer booleanBuffer, int n) {
        this.original = booleanBuffer;
        this.index = n / 8;
        this.offset = (byte)(n % 8);
    }

    public Object clone() {
        return new BooleanIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof BooleanIterator)) break block2;
                BooleanIterator booleanIterator = (BooleanIterator)object;
                if (this.index == booleanIterator.index && this.offset == booleanIterator.offset && (this.isCompatibleWith(booleanIterator) || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(BooleanIterator booleanIterator) {
        return this.index == booleanIterator.index && this.offset == booleanIterator.offset && this.isCompatibleWith(booleanIterator);
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        if (this.offset == -1 && this.index == ((BooleanIterator)randomAccessIterator).index) {
            return this.offset < ((BooleanIterator)randomAccessIterator).offset;
        }
        return this.index < ((BooleanIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0 && (this.offset == -1 || this.offset == 0);
    }

    public boolean atEnd() {
        block5: {
            block4: {
                if (this.offset == -1) {
                    return this.index == this.original.size();
                }
                ForwardIterator forwardIterator = this.original.finish();
                if (!(forwardIterator instanceof BooleanIterator)) break block4;
                BooleanIterator booleanIterator = (BooleanIterator)forwardIterator;
                if (this.index == booleanIterator.index && this.offset == booleanIterator.offset && (this.isCompatibleWith(booleanIterator) || false)) break block5;
            }
            return false;
        }
        return true;
    }

    public boolean hasMoreElements() {
        block5: {
            block3: {
                boolean bl;
                block4: {
                    block2: {
                        if (this.offset != -1) break block2;
                        if (this.index == this.original.size()) break block3;
                        bl = false;
                        break block4;
                    }
                    ForwardIterator forwardIterator = this.original.finish();
                    if (!(forwardIterator instanceof BooleanIterator)) break block5;
                    BooleanIterator booleanIterator = (BooleanIterator)forwardIterator;
                    if (this.index != booleanIterator.index || this.offset != booleanIterator.offset) break block5;
                    if (this.isCompatibleWith(booleanIterator) || false) break block3;
                    bl = false;
                }
                if (!bl) break block5;
            }
            return false;
        }
        return true;
    }

    public void advance() {
        if (this.offset == -1) {
            ++this.index;
            return;
        }
        this.offset = (byte)(this.offset + 1);
        if (this.offset == 8) {
            this.offset = 0;
            ++this.index;
        }
    }

    public void advance(int n) {
        if (this.offset == -1) {
            this.index += n;
            return;
        }
        byte by = this.offset;
        this.offset = (byte)(n % 8);
        this.index += n / 8;
        if (by > this.offset) {
            ++this.index;
        }
    }

    public void retreat() {
        if (this.offset == -1) {
            --this.index;
            return;
        }
        if (this.offset == 0) {
            this.offset = (byte)7;
            --this.index;
            return;
        }
        this.offset = (byte)(this.offset - 1);
    }

    public void retreat(int n) {
        if (this.offset == -1) {
            this.index -= n;
            return;
        }
        byte by = this.offset;
        this.offset = (byte)((this.offset + 8 - n % 8) % 8);
        this.index += n / 8;
        if (by < this.offset) {
            ++this.index;
        }
    }

    public Object nextElement() {
        try {
            Boolean bl = new Boolean(this.getBoolean(0));
            this.advance();
            return bl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("BooleanIterator");
        }
    }

    public Object get() {
        return new Boolean(this.getBoolean(0));
    }

    public boolean getBoolean() {
        return this.getBoolean(0);
    }

    public Object get(int n) {
        return new Boolean(this.getBoolean(n));
    }

    public boolean getBoolean(int n) {
        if (this.original instanceof BooleanArray) {
            return ((BooleanArray)this.original).booleanAt(this.index + n);
        }
        return (((BooleanBuffer)this.original).storage.byteAt(this.index) & (byte)(1 << this.offset)) > 0;
    }

    public void put(Object object) {
        this.put(0, (Boolean)object);
    }

    public void put(boolean bl) {
        this.put(0, bl);
    }

    public void put(int n, Object object) {
        this.put(n, (Boolean)object);
    }

    public void put(int n, boolean bl) {
        if (this.original instanceof BooleanArray) {
            ((BooleanArray)this.original).put(n, bl);
            return;
        }
        ByteBuffer byteBuffer = ((BooleanBuffer)this.original).storage;
        byte by = byteBuffer.byteAt(this.index);
        by = bl ? (byte)(by | (byte)(1 << this.offset)) : (byte)(by & ~((byte)(1 << this.offset)));
        byteBuffer.put(this.index, by);
    }

    public int distance(ForwardIterator forwardIterator) {
        if (!this.isCompatibleWith(forwardIterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        BooleanIterator booleanIterator = (BooleanIterator)forwardIterator;
        return (booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset) - (this.offset == -1 ? this.index : this.index * 8 + this.offset);
    }

    public int index() {
        if (this.offset == -1) {
            return this.index;
        }
        return this.index * 8 + this.offset;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        if (inputIterator instanceof BooleanIterator) {
            BooleanIterator booleanIterator = (BooleanIterator)inputIterator;
            if (this.original instanceof BooleanArray) {
                return booleanIterator.original instanceof BooleanArray && ((BooleanArray)this.original).array == ((BooleanArray)booleanIterator.original).array;
            }
            return this.original instanceof BooleanBuffer && booleanIterator.original instanceof BooleanBuffer && ((BooleanBuffer)this.original).storage == ((BooleanBuffer)booleanIterator.original).storage;
        }
        return false;
    }

    final byte mask() {
        return (byte)(1 << this.offset);
    }
}

