/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.VectorIterator;
import java.util.Enumeration;
import java.util.Vector;

public class VectorArray
extends ArrayAdapter {
    Vector array;
    static final long serialVersionUID = -7811353276265744416L;

    public VectorArray() {
        this(new Vector());
    }

    public VectorArray(Vector vector) {
        Vector vector2 = vector;
        synchronized (vector2) {
            this.array = vector;
            return;
        }
    }

    public VectorArray(VectorArray vectorArray) {
        this(vectorArray.array);
    }

    public synchronized Object clone() {
        return new VectorArray(this);
    }

    public synchronized String toString() {
        return this.array.toString();
    }

    public boolean equals(Object object) {
        return object instanceof VectorArray && ((Object)this.array).equals(((VectorArray)object).array) || object instanceof Vector && ((Object)this.array).equals(object);
    }

    public Vector get() {
        return this.array;
    }

    public int size() {
        return this.array.size();
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized VectorIterator begin() {
        return new VectorIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized VectorIterator end() {
        return new VectorIterator(this, this.array.size());
    }

    public synchronized Object at(int n) {
        return this.array.elementAt(n);
    }

    public synchronized void put(int n, Object object) {
        this.array.setElementAt(object, n);
    }

    public void clear() {
        this.array.removeAllElements();
    }

    public synchronized Object add(Object object) {
        this.array.addElement(object);
        return null;
    }

    public synchronized void pushFront(Object object) {
        this.array.insertElementAt(object, 0);
    }

    public synchronized Object popFront() {
        Object e = this.array.firstElement();
        this.array.removeElementAt(0);
        return e;
    }

    public void pushBack(Object object) {
        this.add(object);
    }

    public synchronized Object popBack() {
        Object e = this.array.lastElement();
        this.array.removeElementAt(this.array.size() - 1);
        return e;
    }

    public synchronized int remove(Object object) {
        int n = 0;
        while (this.array.removeElement(object)) {
            ++n;
        }
        return n;
    }

    public synchronized int remove(Object object, int n) {
        int n2 = 0;
        while (n > 0 && this.array.removeElement(object)) {
            ++n2;
            --n;
        }
        return n2;
    }

    public synchronized int remove(int n, int n2, Object object) {
        if (n < 0 || n2 > this.array.size() - 1) {
            throw new IndexOutOfBoundsException("index out of range for this Vector.");
        }
        int n3 = 0;
        int n4 = n;
        int n5 = n;
        while (n5 < n2) {
            if (this.array.elementAt(n4).equals(object)) {
                this.array.removeElementAt(n4);
                ++n3;
            } else {
                ++n4;
            }
            ++n5;
        }
        return n3;
    }
}

