/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.UnaryPredicate;
import com.objectspace.jgl.algorithms.Finding;
import com.objectspace.jgl.util.InsertIterator;

public final class Removing {
    private Removing() {
    }

    public static ForwardIterator remove(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, Object object) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(forwardIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)(forwardIterator = (ForwardIterator)Finding.find(forwardIterator, forwardIterator2, object)).clone();
        if (forwardIterator3.equals(forwardIterator2)) {
            return forwardIterator3;
        }
        forwardIterator3.advance();
        return (ForwardIterator)Removing.removeCopy(forwardIterator3, forwardIterator2, forwardIterator, object);
    }

    public static ForwardIterator remove(Sequence sequence, Object object) {
        return Removing.remove(sequence.start(), sequence.finish(), object);
    }

    public static ForwardIterator removeIf(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, UnaryPredicate unaryPredicate) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(forwardIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        if ((forwardIterator = (ForwardIterator)Finding.findIf(forwardIterator, forwardIterator2, unaryPredicate)).equals(forwardIterator2)) {
            return forwardIterator;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        forwardIterator3.advance();
        return (ForwardIterator)Removing.removeCopyIf(forwardIterator3, forwardIterator2, forwardIterator, unaryPredicate);
    }

    public static ForwardIterator removeIf(Sequence sequence, UnaryPredicate unaryPredicate) {
        return Removing.removeIf(sequence.start(), sequence.finish(), unaryPredicate);
    }

    public static OutputIterator removeCopy(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator, Object object) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            if (!inputIterator3.get().equals(object)) {
                outputIterator2.put(inputIterator3.get());
                outputIterator2.advance();
            }
            inputIterator3.advance();
        }
        return outputIterator2;
    }

    public static OutputIterator removeCopy(Container container, OutputIterator outputIterator, Object object) {
        return Removing.removeCopy(container.start(), container.finish(), outputIterator, object);
    }

    public static void removeCopy(Container container, Container container2, Object object) {
        Removing.removeCopy(container.start(), container.finish(), new InsertIterator(container2), object);
    }

    public static OutputIterator removeCopyIf(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator, UnaryPredicate unaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            if (!unaryPredicate.execute(inputIterator3.get())) {
                outputIterator2.put(inputIterator3.get());
                outputIterator2.advance();
            }
            inputIterator3.advance();
        }
        return outputIterator2;
    }

    public static OutputIterator removeCopyIf(Container container, OutputIterator outputIterator, UnaryPredicate unaryPredicate) {
        return Removing.removeCopyIf(container.start(), container.finish(), outputIterator, unaryPredicate);
    }

    public static void removeCopyIf(Container container, Container container2, UnaryPredicate unaryPredicate) {
        Removing.removeCopyIf(container.start(), container.finish(), new InsertIterator(container2), unaryPredicate);
    }
}

