/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.widgets;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class NCheckBox
extends JLabel
implements MouseListener,
KeyListener,
FocusListener {
    public static final int STATE_TRUE = 1;
    public static final int STATE_FALSE = 2;
    public static final int STATE_TRI = 3;
    private boolean isTriState = false;
    private boolean isChecked = false;
    private boolean isModified = false;
    private boolean triStateSelected = false;
    Vector listeners;
    private Border originalBorder;
    private Border focusBorder;
    private boolean isEditable = true;

    private void commonInit() {
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.listeners = new Vector(5);
        if (this.isTriState) {
            this.setIcon(widgets.getImageIcon("RightsGrayed.gif"));
            this.triStateSelected = true;
        } else if (this.isChecked) {
            this.setIcon(widgets.getImageIcon("RightsChecked.gif"));
        } else {
            this.setIcon(widgets.getImageIcon("RightsUnchecked.gif"));
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.focusBorder = BorderFactory.createLineBorder(Color.black);
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.addElement(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    private void dispatch() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "TRI_STATE_CHANGE");
        int n = 0;
        while (n < this.listeners.size()) {
            ((ActionListener)this.listeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isSelected() {
        return this.isChecked;
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.setSelectedState(1, false);
        } else {
            this.setSelectedState(2, false);
        }
    }

    public void setSelectedAndModified(boolean bl) {
        if (bl) {
            this.setSelectedState(1, true);
        } else {
            this.setSelectedState(2, true);
        }
    }

    public void setSelectedState(int n, boolean bl) {
        if (n == 1) {
            if (this.isEditable) {
                this.setIcon(widgets.getImageIcon("RightsChecked.gif"));
            } else {
                this.setIcon(widgets.getImageIcon("RightsGrayed.gif"));
            }
            this.isChecked = true;
            this.triStateSelected = false;
        } else if (n == 2 || !this.isTriState) {
            if (this.isEditable) {
                this.setIcon(widgets.getImageIcon("RightsUnchecked.gif"));
            } else {
                this.setIcon(widgets.getImageIcon("RightsUncheckedGrayed.gif"));
            }
            this.isChecked = false;
            this.triStateSelected = false;
        } else if (n == 3) {
            this.setIcon(widgets.getImageIcon("RightsGrayed.gif"));
            this.isChecked = false;
            this.triStateSelected = true;
        }
        if (bl) {
            this.isModified = true;
            this.dispatch();
        }
        this.repaint();
    }

    public boolean isModified() {
        if (this.triStateSelected) {
            return false;
        }
        return this.isModified;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
    }

    public void startTriState() {
        this.isTriState = true;
        this.setIcon(widgets.getImageIcon("RightsGrayed.gif"));
        this.triStateSelected = true;
    }

    public void stopTriState() {
        this.isTriState = false;
        this.triStateSelected = false;
        if (this.isChecked) {
            this.setIcon(widgets.getImageIcon("RightsChecked.gif"));
        } else {
            this.setIcon(widgets.getImageIcon("RightsUnchecked.gif"));
        }
    }

    public boolean isTriStateSelected() {
        return this.triStateSelected;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isEditable) {
            if (this.isChecked) {
                NConeFactory.novellJLabel((JLabel)this, (String)(this.getText() + widgets.getString("checkedKey")), (String)"");
            } else if (this.isTriStateSelected()) {
                NConeFactory.novellJLabel((JLabel)this, (String)(this.getText() + "," + widgets.getString("nochangeKey")), (String)"");
            } else {
                NConeFactory.novellJLabel((JLabel)this, (String)(this.getText() + widgets.getString("notcheckedKey")), (String)"");
            }
        } else if (this.isChecked) {
            NConeFactory.novellJLabel((JLabel)this, (String)(this.getText() + "," + widgets.getString("nochangeKey")), (String)"");
        } else {
            NConeFactory.novellJLabel((JLabel)this, (String)(this.getText() + "," + widgets.getString("NotEnabledKey")), (String)"");
        }
        this.originalBorder = this.getBorder();
        this.setBorder(this.focusBorder);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(this.originalBorder);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEditable) {
            this.changeIcon();
        }
    }

    public void setEnabled(boolean bl) {
        this.isEditable = bl;
        super.setEnabled(true);
        if (this.isEditable) {
            if (this.isChecked) {
                this.setIcon(widgets.getImageIcon("RightsChecked.gif"));
            } else {
                this.setIcon(widgets.getImageIcon("RightsUnchecked.gif"));
            }
        } else if (this.isChecked) {
            this.setIcon(widgets.getImageIcon("RightsGrayed.gif"));
        } else {
            this.setIcon(widgets.getImageIcon("RightsUncheckedGrayed.gif"));
        }
    }

    private void setMyFocus() {
        this.getParent().requestFocus();
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (this.isEditable && ((n = keyEvent.getKeyCode()) == 10 || n == 32)) {
            this.changeIcon();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void changeIcon() {
        if (this.triStateSelected) {
            this.setSelectedState(2, true);
        } else if (this.isChecked) {
            if (this.isTriState) {
                this.setSelectedState(3, true);
            } else {
                this.setSelectedState(2, true);
            }
        } else {
            this.setSelectedState(1, true);
        }
        this.setMyFocus();
    }

    public NCheckBox() {
        this.isChecked = false;
        this.isTriState = false;
        this.commonInit();
    }

    public NCheckBox(boolean bl) {
        this.isChecked = false;
        this.isTriState = bl;
        this.commonInit();
    }

    public NCheckBox(String string) {
        super(string);
        this.isChecked = false;
        this.isTriState = false;
        this.commonInit();
    }

    public NCheckBox(String string, boolean bl, boolean bl2) {
        super(string);
        this.isChecked = bl;
        this.isTriState = bl2;
        this.commonInit();
    }
}

