/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NDateTimeDlg;
import com.novell.application.console.widgets.NTextField;
import com.novell.application.console.widgets.events.TimeControlEvent;
import com.novell.application.console.widgets.events.TimeControlListener;
import com.novell.application.console.widgets.widgets;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NDateTimeControl
extends JPanel
implements ActionListener,
FocusListener {
    private NTextField textField;
    private JButton button;
    private Calendar calendar;
    private DateFormat dateTimeFormat;
    private int maxYear = 2037;
    private int minYear = 1970;
    private Vector listeners;
    private boolean modified;
    private boolean enabled;
    private Component parentComponent = null;

    public JTextField getTextField() {
        return this.textField;
    }

    public void requestFocus() {
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void paint(Graphics graphics) {
        this.textField.changeBackgroundColor(!this.enabled);
        super.paint(graphics);
    }

    public long getMilliSeconds() {
        return this.calendar.getTime().getTime();
    }

    public Calendar getCalendar() {
        try {
            this.syncCalendar();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Date getDate() {
        try {
            this.syncCalendar();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.calendar.getTime();
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
    }

    public void setMaxYear(int n) {
        this.maxYear = n;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMinYear(int n) {
        this.minYear = n;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.textField.setEnabled(bl);
        this.button.setEnabled(bl);
        this.repaint();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void displayError() {
        String string = widgets.getString("timeDateFormatErrorMessageKey");
        string = string + "\n\n" + this.dateTimeFormat.format(this.calendar.getTime());
        NMsgBox nMsgBox = new NMsgBox((Component)widgets.getFrame(this), widgets.getString("timeDateFormatErrorCaptionKey"), string, 3);
        this.getToolkit().beep();
        nMsgBox.setVisible(true);
        this.textField.selectAll();
        this.textField.requestFocus();
    }

    public boolean isDataValid() {
        try {
            this.dateTimeFormat.parse(this.textField.getText());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public void clear() {
        this.textField.setText("");
    }

    public void reset() {
        this.updateTextField();
    }

    public void setDateTimeFormat(DateFormat dateFormat) {
        this.dateTimeFormat = dateFormat;
    }

    public void addTimeControlListener(TimeControlListener timeControlListener) {
        if (!this.listeners.contains(timeControlListener)) {
            this.listeners.addElement(timeControlListener);
        }
    }

    public void removeTimeControlListener(TimeControlListener timeControlListener) {
        if (this.listeners.contains(timeControlListener)) {
            this.listeners.removeElement(timeControlListener);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.textField && this.textField.isModified()) {
            try {
                this.syncCalendar();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.button) {
            NDateTimeDlg nDateTimeDlg = new NDateTimeDlg(this.parentComponent, this.calendar);
            if (this.maxYear != -1) {
                nDateTimeDlg.setMaxYear(this.maxYear);
            }
            if (this.minYear != -1) {
                nDateTimeDlg.setMinYear(this.minYear);
            }
            int n = nDateTimeDlg.launch();
            this.parentComponent.requestFocus();
            if (n == 1) {
                this.calendar = nDateTimeDlg.getCalendar();
                this.updateTextField();
                this.dispatch();
                this.modified = true;
            }
        }
    }

    private void updateTextField() {
        this.textField.setText(this.dateTimeFormat.format(this.calendar.getTime()));
    }

    private void syncCalendar() throws ParseException {
        if (this.textField.isModified()) {
            Date date = this.dateTimeFormat.parse(this.textField.getText());
            this.setDate(date);
        }
    }

    private void layoutControls() {
        this.listeners = new Vector();
        this.modified = false;
        this.setLayout(new BorderLayout(5, 0));
        this.dateTimeFormat = DateFormat.getDateTimeInstance(1, 1);
        this.dateTimeFormat.setTimeZone(TimeZone.getDefault());
        this.calendar.set(13, 0);
        this.textField = new NTextField(25);
        this.textField.setEditable(false);
        this.updateTextField();
        this.textField.changeBackgroundColor(false);
        this.textField.addFocusListener(this);
        NDateTimeControl nDateTimeControl = this;
        if (nDateTimeControl == null) {
            throw null;
        }
        this.button = NConeFactory.novellJButton((JButton)new JButton(nDateTimeControl, (Icon)widgets.getImageIcon("DateTime.gif")){
            private final /* synthetic */ NDateTimeControl this$0;

            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
            {
                this.this$0 = nDateTimeControl;
                this.constructor$0(nDateTimeControl, icon);
            }

            private final void constructor$0(NDateTimeControl nDateTimeControl, Icon icon) {
            }
        }, (String)widgets.getString("TimeKey"), (String)"This is a Button");
        this.button.addActionListener(this);
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
    }

    private void dispatch() {
        TimeControlEvent timeControlEvent = new TimeControlEvent(this);
        int n = 0;
        while (n < this.listeners.size()) {
            ((TimeControlListener)this.listeners.elementAt(n)).timeControlChanged(timeControlEvent);
            ++n;
        }
    }

    public NDateTimeControl(Calendar calendar, Component component) {
        this.calendar = calendar;
        this.parentComponent = component;
        this.layoutControls();
    }

    public NDateTimeControl(long l, Component component) {
        this.parentComponent = component;
        this.calendar = Calendar.getInstance(TimeZone.getDefault());
        this.calendar.setTime(new Date(l));
        this.layoutControls();
    }

    public NDateTimeControl(Date date, Component component) {
        this.calendar = Calendar.getInstance(TimeZone.getDefault());
        this.parentComponent = component;
        this.calendar.setTime(date);
        this.layoutControls();
    }

    public NDateTimeControl(Component component) {
        this.parentComponent = component;
        this.calendar = Calendar.getInstance(TimeZone.getDefault());
        this.layoutControls();
    }
}

