/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NDualListLayout;
import com.novell.application.console.widgets.NList;
import com.novell.application.console.widgets.NListNode;
import com.novell.application.console.widgets.widgets;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NDualList
extends JPanel
implements ActionListener {
    public static final int ITEM_ADDED_TO_TARGET = 0;
    public static final int ITEM_DELETED_FROM_TARGET = 1;
    private JButton addButton;
    private JButton removeButton;
    private NList sourceList;
    private NList targetList;
    private JLabel sourceLabel;
    private JLabel targetLabel;
    private Vector listeners = new Vector(5);

    private void fillSourceList(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.sourceList.addNode((NListNode)vector.elementAt(n));
            ++n;
        }
        this.sourceList.slowSort();
    }

    private void fillTargetList(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.targetList.addNode((NListNode)vector.elementAt(n));
            ++n;
        }
        this.targetList.slowSort();
    }

    private void initControls(String string, String string2) {
        this.sourceList = new NList();
        this.targetList = new NList();
        this.sourceList.setName("List1");
        this.targetList.setName("List2");
        this.sourceLabel = new JLabel();
        Loc.setText((JLabel)this.sourceLabel, (Component)this.sourceList, (String)string);
        NConeFactory.makeRelation((JLabel)this.sourceLabel, (NList)this.sourceList);
        this.targetLabel = new JLabel();
        Loc.setText((JLabel)this.targetLabel, (Component)this.targetList, (String)string2);
        NConeFactory.makeRelation((JLabel)this.targetLabel, (NList)this.targetList);
        this.sourceList.getList().setSelectionMode(2);
        this.targetList.getList().setSelectionMode(2);
        NDualList nDualList = this;
        if (nDualList == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(nDualList){
            private final /* synthetic */ NDualList this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Object object = mouseEvent.getSource();
                    if (object == NDualList.access$0(this.this$0).getList()) {
                        NDualList.access$1(this.this$0);
                    } else if (object == NDualList.access$2(this.this$0).getList()) {
                        NDualList.access$3(this.this$0);
                    }
                }
            }
            {
                this.this$0 = nDualList;
                this.constructor$0(nDualList);
            }

            private final void constructor$0(NDualList nDualList) {
            }
        };
        this.sourceList.getList().addMouseListener(mouseAdapter);
        this.targetList.getList().addMouseListener(mouseAdapter);
        Image image = widgets.getImage("addArrow.gif");
        Image image2 = widgets.getImage("removeArrow.gif");
        NDualList nDualList2 = this;
        if (nDualList2 == null) {
            throw null;
        }
        this.addButton = NConeFactory.novellJButton((JButton)new JButton(nDualList2, (Icon)new ImageIcon(image)){
            private final /* synthetic */ NDualList this$0;

            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
            {
                this.this$0 = nDualList;
                this.constructor$0(nDualList, icon);
            }

            private final void constructor$0(NDualList nDualList, Icon icon) {
            }
        }, (String)widgets.getString("addKey"), (String)"This is a Button");
        NDualList nDualList3 = this;
        if (nDualList3 == null) {
            throw null;
        }
        this.removeButton = NConeFactory.novellJButton((JButton)new JButton(nDualList3, (Icon)new ImageIcon(image2)){
            private final /* synthetic */ NDualList this$0;

            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
            {
                this.this$0 = nDualList;
                this.constructor$0(nDualList, icon);
            }

            private final void constructor$0(NDualList nDualList, Icon icon) {
            }
        }, (String)widgets.getString("removeKey"), (String)"This is a button");
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addButton.setName("Add");
        this.removeButton.setName("Remove");
        this.add(NDualListLayout.LEFTLABEL, this.sourceLabel);
        this.add(NDualListLayout.RIGHTLABEL, this.targetLabel);
        this.add(NDualListLayout.LEFTLIST, this.sourceList);
        this.add(NDualListLayout.RIGHTLIST, this.targetList);
        this.add(NDualListLayout.TOPBUTTON, this.addButton);
        this.add(NDualListLayout.BOTTOMBUTTON, this.removeButton);
        this.sourceList.setNextFocusableComponent(this.addButton);
        this.addButton.setNextFocusableComponent(this.targetList);
        this.targetList.setNextFocusableComponent(this.removeButton);
    }

    public void addSourceNode(NListNode nListNode) {
        this.sourceList.addNode(nListNode);
        this.sourceList.slowSort();
    }

    public void addSourceNodes(Vector vector) {
        this.fillSourceList(vector);
    }

    public void addTargetNode(NListNode nListNode) {
        this.targetList.addNode(nListNode);
        this.targetList.slowSort();
    }

    public void addTargetNodes(Vector vector) {
        this.fillTargetList(vector);
    }

    public void clearSourceList() {
        this.sourceList.removeAllNodes();
    }

    public void clearTargetList() {
        this.targetList.removeAllNodes();
    }

    public void clearLists() {
        this.clearSourceList();
        this.clearTargetList();
    }

    public void refresh() {
        this.sourceList.getList().repaint();
        this.targetList.getList().repaint();
    }

    public int getTargetCount() {
        return this.targetList.getNumNodes();
    }

    public String[] getTargetItems() {
        int n = this.targetList.getNumNodes();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.targetList.getNodeAt(n2).getText();
            ++n2;
        }
        return stringArray;
    }

    public void setVisibleRowCount(int n) {
        this.sourceList.getList().setVisibleRowCount(n);
        this.targetList.getList().setVisibleRowCount(n);
    }

    public void requestFocus() {
        super.requestFocus();
        this.sourceList.getList().requestFocus();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        boolean bl = false;
        int n = 0;
        while (n < this.listeners.size()) {
            if ((ActionListener)this.listeners.elementAt(n) == actionListener) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.listeners.addElement(actionListener);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.listeners.contains(actionListener)) {
            this.listeners.removeElement(actionListener);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.addPressed();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.removePressed();
        }
    }

    private void addPressed() {
        NListNode[] nListNodeArray = this.sourceList.getSelectedNodes();
        int n = 0;
        while (n < nListNodeArray.length) {
            NListNode nListNode = nListNodeArray[n];
            if (nListNode.isEnabled()) {
                this.sourceList.removeNode(nListNode);
                this.targetList.addNode(nListNode);
            }
            ++n;
        }
        this.sourceList.getList().clearSelection();
        this.targetList.slowSort();
        this.repaint();
        this.dispatch(0);
    }

    private void removePressed() {
        NListNode[] nListNodeArray = this.targetList.getSelectedNodes();
        int n = 0;
        while (n < nListNodeArray.length) {
            NListNode nListNode = nListNodeArray[n];
            if (nListNode.isEnabled()) {
                this.targetList.removeNode(nListNode);
                this.sourceList.addNode(nListNode);
            }
            ++n;
        }
        this.targetList.getList().clearSelection();
        this.sourceList.slowSort();
        this.repaint();
        this.dispatch(1);
    }

    private void dispatch(int n) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ActionEvent actionEvent = new ActionEvent(this, n, "");
            ((ActionListener)this.listeners.elementAt(n2)).actionPerformed(actionEvent);
            ++n2;
        }
    }

    static /* synthetic */ NList access$0(NDualList nDualList) {
        return nDualList.sourceList;
    }

    static /* synthetic */ void access$1(NDualList nDualList) {
        nDualList.addPressed();
    }

    static /* synthetic */ NList access$2(NDualList nDualList) {
        return nDualList.targetList;
    }

    static /* synthetic */ void access$3(NDualList nDualList) {
        nDualList.removePressed();
    }

    public NDualList(Vector vector, Vector vector2, String string, String string2) {
        this.setLayout(new NDualListLayout());
        this.initControls(string, string2);
        this.fillSourceList(vector);
        this.fillTargetList(vector2);
    }
}

