/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NDualListScroller
extends JPanel
implements AdjustmentListener,
ListSelectionListener {
    private NList leftList = new NList();
    private JLabel leftLabel;
    private JScrollPane leftScroller;
    private JScrollBar leftVBar;
    private JScrollBar leftHBar;
    private NList rightList;
    private JLabel rightLabel;
    private JScrollPane rightScroller;
    private JScrollBar rightVBar;
    private JScrollBar rightHBar;
    private boolean editable = false;

    public void setLeftItems(String[] stringArray) {
        this.leftList.removeAllNodes();
        int n = 0;
        while (n < stringArray.length) {
            this.leftList.addNode(stringArray[n]);
            ++n;
        }
    }

    public void appendLeftList(String string) {
        this.leftList.addNode(string);
    }

    public void setRightItems(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.rightList.addNode(stringArray[n]);
            ++n;
        }
    }

    public void appendRightList(String string) {
        this.rightList.addNode(string);
    }

    public void setLeftTitle(String string) {
        this.leftLabel.setText(string);
    }

    public void setRightTitle(String string) {
        this.rightLabel.setText(string);
    }

    public void setEnabled(boolean bl) {
        this.leftList.setEnabled(bl);
        this.rightList.setEnabled(bl);
    }

    public Dimension getMinimumSize() {
        return new Dimension(600, 300);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.leftVBar) {
            this.rightVBar.setValue(this.leftVBar.getValue());
        } else if (object == this.leftHBar) {
            this.rightHBar.setValue(this.leftHBar.getValue());
        } else if (object == this.rightHBar) {
            this.leftHBar.setValue(this.rightHBar.getValue());
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.leftList.getList()) {
            this.rightList.setSelectedIndex(this.leftList.getSelectedIndex());
        } else if (object == this.rightList.getList()) {
            this.leftList.setSelectedIndex(this.rightList.getSelectedIndex());
        }
    }

    public NList getNListleft() {
        return this.leftList;
    }

    public NList getNListright() {
        return this.rightList;
    }

    public NDualListScroller() {
        super(new GridLayout(1, 2, 0, 0));
        this.leftList.setSelectionMode(0);
        this.leftList.getList().addListSelectionListener(this);
        this.leftScroller = new JScrollPane(this.leftList, 22, 30);
        this.leftVBar = this.leftScroller.getVerticalScrollBar();
        this.leftVBar.addAdjustmentListener(this);
        this.leftHBar = this.leftScroller.getHorizontalScrollBar();
        this.leftHBar.addAdjustmentListener(this);
        this.rightList = new NList();
        this.rightList.setSelectionMode(0);
        this.rightList.getList().addListSelectionListener(this);
        this.rightScroller = new JScrollPane(this.rightList, 21, 30);
        this.rightVBar = this.rightScroller.getVerticalScrollBar();
        this.rightHBar = this.rightScroller.getHorizontalScrollBar();
        this.rightHBar.addAdjustmentListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(0, 1));
        this.leftLabel = new JLabel("");
        jPanel.add((Component)this.leftLabel, "North");
        jPanel.add((Component)this.leftScroller, "Center");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 1));
        this.rightLabel = new JLabel("");
        jPanel2.add((Component)this.rightLabel, "North");
        jPanel2.add((Component)this.rightScroller, "Center");
        this.add(jPanel2);
    }

    public NDualListScroller(String[] stringArray, String string, String[] stringArray2, String string2) {
        this();
        this.setLeftItems(stringArray);
        this.setRightItems(stringArray2);
        this.leftLabel.setText(string);
        this.rightLabel.setText(string2);
    }
}

