/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.widgets;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NDualScroller
extends JPanel
implements AdjustmentListener {
    private JTextArea leftTA = new JTextArea();
    private JScrollPane leftScroller = new JScrollPane(this.leftTA, 22, 30);
    private JScrollBar leftVBar = this.leftScroller.getVerticalScrollBar();
    private JScrollBar leftHBar;
    private JTextArea rightTA;
    private JScrollPane rightScroller;
    private JScrollBar rightVBar;
    private JScrollBar rightHBar;
    private boolean editable = false;

    public void setLeftText(String string) {
        this.leftTA.setText(string);
    }

    public void appendLeftText(String string) {
        this.leftTA.append(string);
    }

    public void setRightText(String string) {
        this.rightTA.setText(string);
    }

    public void appendRightText(String string) {
        this.rightTA.append(string);
    }

    public void setEditable(boolean bl) {
        this.leftTA.setEditable(bl);
        this.rightTA.setEditable(bl);
        this.editable = bl;
    }

    public void setEnabled(boolean bl) {
        this.leftTA.setEnabled(bl);
        this.rightTA.setEnabled(bl);
    }

    public Dimension getMinimumSize() {
        return new Dimension(600, 300);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        if (!this.editable) {
            this.leftTA.setBackground(widgets.bgColor);
            this.leftTA.setForeground(SystemColor.controlText);
            this.rightTA.setBackground(widgets.bgColor);
            this.rightTA.setForeground(SystemColor.controlText);
        } else {
            this.leftTA.setBackground(SystemColor.window);
            this.leftTA.setForeground(SystemColor.windowText);
            this.rightTA.setBackground(SystemColor.window);
            this.rightTA.setForeground(SystemColor.windowText);
        }
        super.paint(graphics);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.leftVBar) {
            this.rightVBar.setValue(this.leftVBar.getValue());
        } else if (object == this.leftHBar) {
            this.rightHBar.setValue(this.leftHBar.getValue());
        } else if (object == this.rightHBar) {
            this.leftHBar.setValue(this.rightHBar.getValue());
        }
    }

    private String readFile(File file) throws FileNotFoundException, IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public JTextArea getTextArealeft() {
        return this.leftTA;
    }

    public JTextArea getTextArearight() {
        return this.rightTA;
    }

    public NDualScroller() {
        super(new GridLayout(1, 2, 0, 0));
        this.leftVBar.addAdjustmentListener(this);
        this.leftHBar = this.leftScroller.getHorizontalScrollBar();
        this.leftHBar.addAdjustmentListener(this);
        this.rightTA = new JTextArea();
        this.rightScroller = new JScrollPane(this.rightTA, 21, 30);
        this.rightVBar = this.rightScroller.getVerticalScrollBar();
        this.rightHBar = this.rightScroller.getHorizontalScrollBar();
        this.rightHBar.addAdjustmentListener(this);
        this.add(this.leftScroller);
        this.add(this.rightScroller);
        this.setEditable(false);
    }

    public NDualScroller(String string, String string2) {
        this();
        this.setLeftText(string);
        this.setRightText(string2);
    }

    public NDualScroller(File file, File file2) throws FileNotFoundException, IOException {
        this();
        this.setLeftText(this.readFile(file));
        this.setRightText(this.readFile(file2));
    }
}

