/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public final class NLabelLayout
implements LayoutManager,
Serializable {
    public static int LEFT = 0;
    public static int RIGHT = 1;
    private static int MAX_ROWS = 40;
    public static String maxChar = "W";
    private int hgap = 0;
    private int vgap = 3;
    private int rows;
    private int widestLabelWidth;
    private int widestItemWidth;
    private int h;
    private int alignment = RIGHT;
    private boolean uniformItemWidths = true;
    private Integer[] numCols = new Integer[MAX_ROWS];

    public void setLabelAlignment(int n) {
        this.alignment = n;
    }

    public int getHorizGap() {
        return this.hgap;
    }

    public void setHorizGap(int n) {
        this.hgap = n;
    }

    public int getVertGap() {
        return this.vgap;
    }

    public void setVertGap(int n) {
        this.vgap = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setCol(int n, int n2) {
        if (n < MAX_ROWS) {
            this.numCols[n] = new Integer(n2);
        }
        this.uniformItemWidths = false;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        if (n < 2) {
            return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        }
        this.rows = n / 2;
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2).getPreferredSize();
            if (this.widestLabelWidth < ((Dimension)serializable).width) {
                this.widestLabelWidth = ((Dimension)serializable).width;
            }
            if (this.h < ((Dimension)serializable).height) {
                this.h = ((Dimension)serializable).height;
            }
            n2 += 2;
        }
        if (this.uniformItemWidths) {
            n2 = 1;
            while (n2 < n) {
                serializable = container.getComponent(n2).getPreferredSize();
                if (this.widestItemWidth < ((Dimension)serializable).width) {
                    this.widestItemWidth = ((Dimension)serializable).width;
                }
                if (this.h < ((Dimension)serializable).height) {
                    this.h = ((Dimension)serializable).height;
                }
                n2 += 2;
            }
        } else {
            n2 = 1;
            while (n2 < n) {
                serializable = container.getComponent(n2);
                if (this.numCols[(n2 + 1) / 2 - 1] != null) {
                    int n3 = this.numCols[(n2 + 1) / 2 - 1];
                    FontMetrics fontMetrics = ((Component)serializable).getFontMetrics(((Component)serializable).getFont());
                    int n4 = fontMetrics.stringWidth(maxChar) * n3;
                    Dimension dimension = container.getComponent(n2).getPreferredSize();
                    if (this.widestItemWidth < n4) {
                        this.widestItemWidth = n4;
                    }
                    if (this.h < dimension.height) {
                        this.h = dimension.height;
                    }
                } else {
                    Dimension dimension = ((Component)serializable).getPreferredSize();
                    if (this.widestItemWidth < dimension.width) {
                        this.widestItemWidth = dimension.width;
                    }
                    if (this.h < dimension.height) {
                        this.h = dimension.height;
                    }
                }
                n2 += 2;
            }
        }
        return new Dimension(insets.left + insets.right + this.widestLabelWidth + this.hgap + this.widestItemWidth, insets.top + insets.bottom + this.rows * this.h + (this.rows - 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        int n2 = insets.left;
        int n3 = insets.top;
        int n4 = 0;
        while (n4 < n) {
            int n5 = n2 + this.widestLabelWidth;
            Component component = container.getComponent(n4);
            if (this.alignment == RIGHT) {
                component.setBounds(n2 + this.widestLabelWidth - component.getPreferredSize().width, n3, component.getPreferredSize().width, this.h);
            } else {
                component.setBounds(n2, n3, component.getPreferredSize().width, this.h);
            }
            n4 += 2;
            n3 += this.h + this.vgap;
        }
        if (this.uniformItemWidths) {
            n3 = insets.top;
            n4 = 1;
            while (n4 < n) {
                Component component = container.getComponent(n4);
                component.setBounds(n2 + this.widestLabelWidth + this.hgap, n3, this.widestItemWidth, this.h);
                n4 += 2;
                n3 += this.h + this.vgap;
            }
        } else {
            n3 = insets.top;
            n4 = 1;
            while (n4 < n) {
                Component component = container.getComponent(n4);
                if (this.numCols[(n4 + 1) / 2 - 1] != null) {
                    int n6 = this.numCols[(n4 + 1) / 2 - 1];
                    FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
                    int n7 = fontMetrics.stringWidth(maxChar) * n6;
                    component.setBounds(n2 + this.widestLabelWidth + this.hgap, n3, n7, this.h);
                } else {
                    component.setBounds(n2 + this.widestLabelWidth + this.hgap, n3, component.getPreferredSize().width, this.h);
                }
                n4 += 2;
                n3 += this.h + this.vgap;
            }
        }
    }

    public NLabelLayout() {
    }

    public NLabelLayout(int n) {
        this.alignment = n;
    }

    public NLabelLayout(int n, int n2, int n3) {
        this.alignment = n;
        this.vgap = n2;
        int n4 = 0;
        while (n4 < MAX_ROWS) {
            this.numCols[n4] = new Integer(n3);
            ++n4;
        }
        this.uniformItemWidths = false;
    }
}

