/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class NMultiLineLabel
extends JComponent {
    private FontMetrics m_metrics;
    private Font m_font;
    private Color m_foreground = Color.black;
    private Color m_background;
    private boolean m_bSomethingChanged = false;
    private ArrayList m_rows = null;
    private int m_rowCount = -1;
    private int m_widestLine = -1;
    private int m_margin;
    private Insets m_insets = new Insets(0, 0, 0, 0);
    private Image m_image;
    private Dimension m_imageSize = null;

    public void setForeground(Color color) {
        if (color != null) {
            this.m_foreground = color;
            this.resetBufferImage();
            this.repaint();
        }
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.m_background = color;
            this.resetBufferImage();
            this.repaint();
        }
    }

    public void setBorder(Border border, int n) {
        if (n > -1) {
            this.m_margin = n;
        }
        super.setBorder(border);
        this.resetBufferImage();
        this.repaint();
    }

    public void setText(String string) {
        if (string != null) {
            this.init(string);
            this.resetBufferImage();
            this.repaint();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.m_font = font;
        this.m_metrics = ((Component)this).getFontMetrics(this.m_font);
        this.resetBufferImage();
        this.repaint();
    }

    public void setMargin(int n) {
        if (n > -1) {
            this.m_margin = n;
            this.resetBufferImage();
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        Border border = this.getBorder();
        this.m_insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        dimension.height = this.m_rowCount * this.m_metrics.getHeight() + this.m_margin * 2 + this.m_insets.top + this.m_insets.bottom;
        dimension.width = this.m_widestLine + this.m_margin * 2 + this.m_insets.left + this.m_insets.right;
        return dimension;
    }

    private synchronized void paintRows(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.m_metrics.getMaxDescent();
        int n2 = this.m_metrics.getHeight();
        int n3 = 0;
        Graphics graphics2 = null;
        if (graphics != null) {
            boolean bl;
            boolean bl2 = bl = this.m_image == null || this.m_imageSize == null || this.m_imageSize.width != dimension.width || this.m_imageSize.height != dimension.height;
            dimension.width = dimension.width < 1 ? this.m_widestLine : (dimension.width -= this.m_margin * 2 + this.m_insets.left + this.m_insets.right);
            dimension.height = dimension.height < 1 ? this.m_rowCount * n2 : (dimension.height -= this.m_margin * 2 + this.m_insets.top + this.m_insets.bottom);
            if (bl) {
                this.m_image = this.createImage(dimension.width, dimension.height);
                graphics2 = this.m_image.getGraphics();
                graphics2.setColor(this.m_background);
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
                graphics2.setFont(this.m_font);
                graphics2.setColor(this.m_foreground);
            }
            int n4 = 0;
            while (n4 < this.m_rowCount) {
                n3 += n2;
                if (bl) {
                    graphics2.drawString((String)this.m_rows.get(n4), 0, n3 - n);
                }
                ++n4;
            }
            if (bl) {
                graphics2.dispose();
            }
            graphics.drawImage(this.m_image, this.m_insets.left + this.m_margin, this.m_insets.top + this.m_margin, this);
            this.m_imageSize = this.getSize();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintRows(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void resetBufferImage() {
        if (this.m_image != null) {
            this.m_image.flush();
        }
        this.m_image = null;
    }

    private void init(String string) {
        int n = 0;
        int[] nArray = new int[]{0};
        this.m_rowCount = 0;
        this.m_widestLine = 0;
        if (string == null) {
            this.m_rows = null;
        } else {
            this.m_rows = new ArrayList();
            while (n < string.length()) {
                String string2 = this.getRowText(string, n, nArray);
                this.m_rows.add(string2);
                this.m_widestLine = Math.max(this.m_widestLine, this.m_metrics.stringWidth(string2));
                ++this.m_rowCount;
                n = nArray[0];
            }
        }
    }

    private String getRowText(String string, int n, int[] nArray) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n2 = 0;
        n2 = n;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') break;
            ++n2;
        }
        nArray[0] = n2 + 1;
        return string.substring(n, n2);
    }

    public NMultiLineLabel(String string) {
        this.m_font = new Font("SansSerif", 0, 12);
        this.setFont(this.m_font);
        this.m_metrics = ((Component)this).getFontMetrics(this.m_font);
        this.m_background = new JLabel().getBackground();
        this.init(string);
        this.setName("MultiLineLabel");
    }
}

