/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NJTextField;
import com.novell.application.console.widgets.events.MvedEvent;
import com.novell.application.console.widgets.events.MvedListener;
import com.novell.application.console.widgets.widgets;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class NMved
extends JPanel
implements MouseListener,
AncestorListener,
KeyListener,
ComponentListener,
FocusListener,
ActionListener {
    private String displayString;
    protected JList list = null;
    protected NJTextField textField = null;
    protected JButton button;
    protected DefaultListModel listModel = new DefaultListModel();
    protected JWindow listWindow = null;
    protected JScrollPane scrollPane;
    protected JFrame frame;
    protected Component parentComponent;
    protected Component parentDialog;
    private boolean isListVisible;
    private boolean isModified;
    private boolean changeBackground;
    private boolean haveFocus;
    private boolean bMouseOverButton = false;
    private boolean bFirstIn = true;
    private boolean bParentComponent = true;
    private Vector listeners;
    private boolean paintCalled = false;
    private boolean onLinux = System.getProperty("os.name").startsWith("Linux");
    private boolean shouldListBeVisible = false;
    private boolean dontShowListWindow = false;
    int focusLeft = 0;
    int TEXTFIELD = 1;
    int BUTTON = 2;
    int WINDOW = 3;
    private boolean focusFlag = false;

    private void setFocusOnButton() {
        if (!this.focusFlag) {
            this.focusFlag = true;
            this.button.requestFocus();
            this.textField.requestFocus();
            this.focusFlag = false;
        }
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void addMvedListener(MvedListener mvedListener) {
        if (!this.listeners.contains(mvedListener)) {
            this.listeners.addElement(mvedListener);
        }
    }

    public void removeMvedListener(MvedListener mvedListener) {
        if (this.listeners.contains(mvedListener)) {
            this.listeners.removeElement(mvedListener);
        }
    }

    protected void dispatch() {
        MvedEvent mvedEvent = new MvedEvent(this);
        int n = 0;
        while (n < this.listeners.size()) {
            ((MvedListener)this.listeners.elementAt(n)).mvedChanged(mvedEvent);
            ++n;
        }
    }

    private void showList() {
        Object object;
        if (!this.isListVisible) {
            this.frame = widgets.getFrame(this);
            this.frame.addComponentListener(this);
            this.listWindow = new JWindow(this.frame);
            this.listWindow.addFocusListener(this);
            this.listWindow.getContentPane().add(this.scrollPane);
        }
        if (this.bFirstIn) {
            try {
                this.parentComponent = this.getParent().getParent().getParent();
                this.parentComponent.addMouseListener(this);
            }
            catch (Exception exception) {
                this.bParentComponent = false;
            }
            this.parentDialog = this.getParent();
            boolean bl = false;
            this.bFirstIn = false;
            while (this.parentDialog != null) {
                if (this.parentDialog instanceof JDialog) {
                    bl = true;
                    NMved nMved = this;
                    if (nMved == null) {
                        throw null;
                    }
                    object = nMved.new MVEDWindowAdapter(this);
                    ((JDialog)this.parentDialog).addWindowListener((WindowListener)object);
                    break;
                }
                try {
                    this.parentDialog = this.parentDialog.getParent();
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        this.textField.setText("");
        Point point = this.getLocationOnScreen();
        object = new Rectangle(point.x, point.y + this.getSize().height, this.getSize().width, this.list.getVisibleRowCount() * 10);
        ((Component)this.listWindow).setBounds((Rectangle)object);
        this.listWindow.show();
        this.isListVisible = true;
    }

    private void redrawList() {
        this.hideList();
        this.showList();
    }

    public void hideList() {
        if (this.shouldListBeVisible && !this.isListVisible) {
            this.updateTextField();
            this.shouldListBeVisible = false;
            return;
        }
        this.shouldListBeVisible = false;
        if (!this.isListVisible) {
            return;
        }
        this.listWindow.dispose();
        this.isListVisible = false;
        this.updateTextField();
    }

    private void setMyFocus() {
        Container container = this;
        while (container != null) {
            if (container instanceof JDialog) {
                ((Component)container).requestFocus();
                break;
            }
            container = container.getParent();
        }
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
        this.button.setEnabled(bl);
    }

    public void setButtonEnabled(boolean bl) {
        this.button.setEnabled(bl);
    }

    private void updateTextField() {
        String string = new String();
        int n = 0;
        while (n < this.listModel.size()) {
            string = n == 0 ? (String)this.listModel.getElementAt(0) : string + "; " + this.listModel.getElementAt(n);
            ++n;
        }
        this.textField.setText(string);
        this.textField.setCaretPosition(0);
    }

    public void addItem(String string) {
        if (!this.exists(string)) {
            this.listModel.addElement(string);
            this.updateTextField();
        }
    }

    public void addItems(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.exists(stringArray[n])) {
                this.listModel.addElement(stringArray[n]);
            }
            ++n;
        }
        this.hideList();
        this.updateTextField();
    }

    public void addItems(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (!this.exists(string)) {
                this.listModel.addElement(string);
            }
            ++n;
        }
        this.hideList();
        this.updateTextField();
    }

    public void clear() {
        this.listModel.clear();
        this.updateTextField();
    }

    public String[] getStrings() {
        if (this.listModel.size() == 0 && this.textField.getText().length() > 0) {
            this.addItem(this.textField.getText());
        }
        String[] stringArray = new String[this.listModel.size()];
        int n = 0;
        while (n < this.listModel.size()) {
            stringArray[n] = (String)this.listModel.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
    }

    public void changeBackgroundColor(boolean bl) {
        this.changeBackground = bl;
    }

    public void paint(Graphics graphics) {
        if (!this.textField.isEditable() && this.changeBackground) {
            this.textField.setBackground(widgets.bgColor);
            this.textField.setForeground(SystemColor.controlText);
        } else {
            this.textField.setBackground(SystemColor.window);
            this.textField.setForeground(SystemColor.windowText);
        }
        super.paint(graphics);
        if (!this.paintCalled) {
            this.paintCalled = true;
            this.textField.setCaretPosition(0);
        }
    }

    public boolean exists(String string) {
        int n = 0;
        while (n < this.listModel.size()) {
            if (string.equalsIgnoreCase((String)this.listModel.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.haveFocus = true;
        if (mouseEvent.getSource() == this.button) {
            this.bMouseOverButton = true;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.haveFocus = false;
        if (mouseEvent.getSource() == this.button) {
            this.bMouseOverButton = false;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        Object object;
        Object object2;
        Object object3 = mouseEvent.getSource();
        if (object3 == this.textField && this.isListVisible) {
            this.listWindow.dispose();
            if (!this.onLinux) {
                this.listWindow = new JWindow(this.frame);
                this.listWindow.addFocusListener(this);
                this.listWindow.getContentPane().add(this.scrollPane);
                object2 = this.getLocationOnScreen();
                object = new Rectangle(((Point)object2).x, ((Point)object2).y + this.getSize().height, this.getSize().width, this.list.getVisibleRowCount() * 10);
                ((Component)this.listWindow).setBounds((Rectangle)object);
                this.listWindow.show();
            }
        }
        if (object3 == this.list && this.textField.isEditable() && mouseEvent.getClickCount() > 1 && (n = this.list.getSelectedIndex()) != -1) {
            object = (String)this.listModel.elementAt(n);
            this.listModel.removeElementAt(n);
            this.scrollPane.repaint();
            this.textField.setText((String)object);
            this.textField.requestFocus();
            this.textField.selectAll();
            this.dispatch();
        }
        if (this.bParentComponent && object3 == this.parentComponent && (this.isListVisible || this.shouldListBeVisible)) {
            object2 = this.textField.getText();
            if (((String)object2).length() != 0 && this.textField.isEditable()) {
                this.addItem((String)object2);
            }
            this.hideList();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
        if (this.isListVisible || this.shouldListBeVisible) {
            String string = this.textField.getText();
            if (string.length() != 0 && this.textField.isEditable()) {
                this.addItem(string);
            }
            this.hideList();
        }
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        Object object = keyEvent.getSource();
        if (object == this.list) {
            if (n == 127) {
                if (this.textField.isEditable()) {
                    int n2 = this.list.getSelectedIndex();
                    if (this.listModel.size() > 0 && n2 < this.listModel.size() && n2 != -1) {
                        this.listModel.removeElementAt(n2);
                        this.scrollPane.repaint();
                        this.list.setSelectedIndex(n2);
                    }
                }
            } else if (n == 27) {
                if (this.isListVisible || this.shouldListBeVisible) {
                    this.hideList();
                    this.setMyFocus();
                    this.textField.requestFocus();
                }
            } else if (n == 10) {
                if (!this.shouldListBeVisible) {
                    int n3 = this.list.getSelectedIndex();
                    if (this.listModel.size() > 0 && n3 < this.listModel.size() && n3 != -1 && this.textField.isEditable()) {
                        String string = (String)this.listModel.elementAt(n3);
                        this.listModel.removeElementAt(n3);
                        this.scrollPane.repaint();
                        this.textField.setText(string);
                        this.textField.selectAll();
                        this.textField.requestFocus();
                    }
                } else {
                    this.shouldListBeVisible = false;
                }
            }
        } else if (object == this.textField) {
            if (n == 27) {
                if (this.textField.isEnabled() && !this.textField.isEditable()) {
                    this.textField.setText("");
                }
                if (this.isListVisible || this.shouldListBeVisible) {
                    this.hideList();
                }
            }
            if (n == 10 || n == 9) {
                String string = this.textField.getText();
                if (string.length() > 0) {
                    this.addItem(string);
                    this.textField.setText("");
                    this.setFocusOnButton();
                }
                if (!this.isListVisible) {
                    if (!this.onLinux) {
                        this.showList();
                    } else {
                        this.shouldListBeVisible = true;
                    }
                } else {
                    this.list.repaint();
                    this.scrollPane.repaint();
                }
            }
        }
        this.isModified = true;
        this.dispatch();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n2 != 2 && n2 != 4 && n2 != 8 && n2 != 1 && keyEvent.getSource() == this.textField && n != 36 && n != 35 && n != 37 && n != 39 && !this.shouldListBeVisible && !this.isListVisible && this.listModel.size() > 0) {
            this.textField.setText("");
            if (this.onLinux) {
                this.shouldListBeVisible = true;
            } else {
                this.showList();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.isListVisible) {
            this.redrawList();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.textField) {
            if (this.onLinux && (this.isListVisible || this.shouldListBeVisible)) {
                String string = this.textField.getText();
                if (string.length() != 0 && this.textField.isEditable()) {
                    this.addItem(string);
                }
                this.hideList();
            }
            this.focusLeft = this.TEXTFIELD;
        } else {
            this.focusLeft = focusEvent.getSource() == this.button ? this.BUTTON : (focusEvent.getSource() == this.listWindow ? this.WINDOW : -1);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if ((this.isListVisible || this.shouldListBeVisible) && this.focusLeft == this.TEXTFIELD && focusEvent.getSource() == this.button && !this.bMouseOverButton) {
            this.focusLeft = -1;
            String string = this.textField.getText();
            if (string.length() != 0 && this.textField.isEditable()) {
                this.addItem(string);
            }
            this.hideList();
        }
        if (focusEvent.getSource() == this.listWindow) {
            this.setFocusOnList();
        }
    }

    public void setFocusOnList() {
        this.list.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button) {
            if (this.isListVisible || this.shouldListBeVisible) {
                String string = this.textField.getText();
                if (string.length() != 0 && this.textField.isEditable()) {
                    this.addItem(string);
                }
                this.hideList();
            } else {
                String string;
                if (this.list.getModel().getSize() == 0 && (string = this.textField.getText()).length() != 0 && this.textField.isEditable()) {
                    this.addItem(string);
                }
                this.showList();
                if (this.list.getModel().getSize() > 0) {
                    this.list.setSelectedIndex(0);
                }
                this.listWindow.requestFocus();
                this.bMouseOverButton = false;
                this.shouldListBeVisible = true;
            }
        }
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getButton() {
        return this.button;
    }

    public NMved() {
        super(new BorderLayout(3, 0));
        this.textField = new NJTextField();
        this.textField.addFocusListener(this);
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this);
        this.list.setBackground(SystemColor.window);
        this.list.setForeground(SystemColor.windowText);
        this.list.addKeyListener(this);
        this.list.addFocusListener(this);
        this.scrollPane = new JScrollPane(this.list, 20, 30);
        this.scrollPane.setBorder(new LineBorder(Color.black));
        this.scrollPane.addMouseListener(this);
        this.scrollPane.getVerticalScrollBar().addMouseListener(this);
        this.scrollPane.getHorizontalScrollBar().addMouseListener(this);
        this.isListVisible = false;
        this.isModified = false;
        this.changeBackground = true;
        this.haveFocus = false;
        this.listeners = new Vector();
        NMved nMved = this;
        if (nMved == null) {
            throw null;
        }
        this.button = new JButton(nMved, (Icon)widgets.getImageIcon("mved.gif")){
            private final /* synthetic */ NMved this$0;

            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
            {
                this.this$0 = nMved;
                this.constructor$0(nMved, icon);
            }

            private final void constructor$0(NMved nMved, Icon icon) {
            }
        };
        this.button.addActionListener(this);
        this.button.addKeyListener(this);
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
        this.textField.addMouseListener(this);
        this.button.addMouseListener(this);
        this.textField.addKeyListener(this);
        this.addAncestorListener(this);
        this.button.addFocusListener(this);
        this.list.setName("List1");
        NConeFactory.novellJList((JList)this.list, (String)this.list.getName(), (String)"");
        this.textField.setName("TextField1");
        this.button.setName("Button1");
    }

    public NMved(String[] stringArray) {
        this();
        this.addItems(stringArray);
    }

    public class MVEDWindowAdapter
    extends WindowAdapter {
        NMved ownedMVed;

        public void windowClosing(WindowEvent windowEvent) {
            this.ownedMVed.hideList();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.ownedMVed.hideList();
        }

        public MVEDWindowAdapter(NMved nMved2) {
            this.ownedMVed = nMved2;
        }
    }
}

