/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NTabs;
import com.novell.application.console.widgets.Page;
import com.objectspace.jgl.Array;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

class NTab {
    private String tabID = null;
    public String tabTitle = null;
    private String defaultPage = null;
    private Array thePages = null;
    private boolean isExtensible = true;
    private boolean isExtended = false;
    private boolean isSelected = false;
    private int selectHeight = 0;
    private int selectWidth = 0;
    private int normalHeight = 0;
    private int normalWidth = 0;
    private Rectangle bounds = null;

    void setBounds(Rectangle rectangle) {
        this.bounds.setBounds(rectangle);
    }

    void setBounds(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
    }

    Rectangle getBounds() {
        return this.bounds;
    }

    boolean existsPage(String string) {
        Page page = null;
        Enumeration enumeration = this.thePages.elements();
        while (enumeration.hasMoreElements()) {
            page = (Page)enumeration.nextElement();
            if (!string.equals(page.getPageID())) continue;
            return true;
        }
        return false;
    }

    Page findPage(String string) {
        Page page = null;
        Enumeration enumeration = this.thePages.elements();
        while (enumeration.hasMoreElements()) {
            page = (Page)enumeration.nextElement();
            if (string.equals(page.getPageID())) break;
            page = null;
        }
        return page;
    }

    public void addPage(String string, String string2) throws IllegalArgumentException {
        Page page = this.findPage(string);
        if (page != null) {
            throw new IllegalArgumentException(string + " already exists.");
        }
        if (this.thePages.size() > 1 && !this.isExtensible) {
            throw new IllegalArgumentException("This NTab is not extensible.");
        }
        page = new Page(string, string2);
        this.thePages.add((Object)page);
        if (this.thePages.size() > 1) {
            this.isExtended = true;
        } else {
            this.defaultPage = string;
        }
    }

    String getTabID() {
        return this.tabID;
    }

    String getTabTitle() {
        return this.tabTitle;
    }

    String getDefaultPage() {
        return this.defaultPage;
    }

    String getDefaultPageTitle() {
        Page page = this.findPage(this.defaultPage);
        return page.getPageTitle();
    }

    void setDefaultPage(String string) throws IllegalArgumentException {
        if (this.findPage(string) == null) {
            throw new IllegalArgumentException(string + " not found.");
        }
        this.defaultPage = string;
    }

    Array getPages() {
        return this.thePages;
    }

    boolean isExtensible() {
        return this.isExtensible;
    }

    boolean isExtended() {
        return this.isExtended;
    }

    boolean isSelected() {
        return this.isSelected;
    }

    void select(boolean bl) {
        this.isSelected = bl;
    }

    void computeTabBounds(Graphics graphics, Point point) {
        FontMetrics fontMetrics = graphics.getFontMetrics(NTabs.normalFont);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(NTabs.selectFont);
        this.normalWidth = fontMetrics.stringWidth(this.tabTitle) + 14;
        this.normalHeight = 21;
        this.selectWidth = fontMetrics2.stringWidth(this.tabTitle) + 14;
        this.selectHeight = 21;
        this.bounds.setLocation(point);
        if (this.isSelected()) {
            this.bounds.height = this.selectHeight;
            this.bounds.width = this.selectWidth;
            if (this.isExtensible()) {
                int n = fontMetrics.stringWidth(this.getDefaultPageTitle()) + 14;
                if (this.isExtended()) {
                    this.bounds.width += 14;
                }
                if (n > this.bounds.width) {
                    this.bounds.width = n;
                }
            }
        } else {
            this.bounds.height = this.normalHeight;
            this.bounds.width = this.normalWidth;
            if (this.isExtended()) {
                this.bounds.width += 14;
            }
        }
    }

    void drawCaption(Graphics graphics, boolean bl) {
        FontMetrics fontMetrics;
        if (this.isSelected()) {
            graphics.setFont(NTabs.selectFont);
            fontMetrics = graphics.getFontMetrics(NTabs.selectFont);
        } else {
            graphics.setFont(NTabs.normalFont);
            fontMetrics = graphics.getFontMetrics(NTabs.normalFont);
        }
        int n = this.getBounds().x + 7;
        int n2 = this.getBounds().y + this.getBounds().height / 2 - fontMetrics.getDescent() + fontMetrics.getHeight() / 2;
        --n2;
        graphics.setColor(NTabs.fgColor);
        if (this.isExtensible()) {
            int n3 = this.getBounds().x + this.getBounds().width - 14;
            int n4 = n2;
            graphics.drawString(this.tabTitle, n, n2);
            fontMetrics = graphics.getFontMetrics(NTabs.normalFont);
            if (this.isSelected()) {
                int n5 = this.getBounds().y + this.getBounds().height + 15;
                graphics.setColor(Color.white);
                if (this.getBounds().x != 2) {
                    graphics.drawLine(this.getBounds().x, n5, this.getBounds().x + this.getBounds().width - 1, n5);
                } else {
                    graphics.drawLine(this.getBounds().x - 1, n5, this.getBounds().x + this.getBounds().width - 1, n5);
                }
                graphics.drawLine(this.getBounds().x + this.getBounds().width, n5 - 1, this.getBounds().x + this.getBounds().width, n5 - 1);
                graphics.drawLine(this.getBounds().x + this.getBounds().width + 1, n5 - 2, this.getBounds().x + this.getBounds().width + 1, n5 - 2);
                graphics.drawLine(this.getBounds().x + this.getBounds().width + 2, n5 - 3, this.getBounds().x + this.getBounds().width + 2, n5 - 16);
                graphics.setColor(Color.gray);
                graphics.drawLine(this.getBounds().x - 1, n5 - 1, this.getBounds().x + this.getBounds().width - 1, n5 - 1);
                graphics.drawLine(this.getBounds().x + this.getBounds().width, n5 - 2, this.getBounds().x + this.getBounds().width, n5 - 2);
                graphics.drawLine(this.getBounds().x + this.getBounds().width + 1, n5 - 3, this.getBounds().x + this.getBounds().width + 1, n5 - 18);
                if (this.getBounds().x != 2) {
                    graphics.drawLine(this.getBounds().x - 2, n5 - 2, this.getBounds().x - 2, n5 - 2);
                    graphics.drawLine(this.getBounds().x - 3, n5 - 3, this.getBounds().x - 3, n5 - 16);
                    graphics.setColor(Color.white);
                    graphics.drawLine(this.getBounds().x - 2, n5 - 3, this.getBounds().x - 2, n5 - 18);
                    graphics.drawLine(this.getBounds().x - 1, n5 - 2, this.getBounds().x - 1, n5 - 2);
                }
                graphics.setColor(Color.black);
                graphics.setFont(NTabs.normalFont);
                fontMetrics = graphics.getFontMetrics(NTabs.normalFont);
                int n6 = 0;
                int n7 = n2 + fontMetrics.getHeight();
                graphics.drawString(this.getDefaultPageTitle(), n6 + n, n7);
            }
            if (this.isExtended()) {
                graphics.setColor(NTabs.fgColor);
                graphics.drawLine(n3, n4 - 5, n3 + 6, n4 - 5);
                graphics.drawLine(n3 + 1, n4 - 4, n3 + 5, n4 - 4);
                graphics.drawLine(n3 + 2, n4 - 3, n3 + 4, n4 - 3);
                graphics.drawLine(n3 + 3, n4 - 2, n3 + 3, n4 - 2);
            }
        } else {
            graphics.drawString(this.tabTitle, n, n2);
        }
        if (bl) {
            Rectangle rectangle = new Rectangle(this.getBounds());
            rectangle.grow(-2, -2);
            rectangle.height -= 2;
            if (this.isExtensible()) {
                rectangle.height += 15;
            }
            this.myDrawRect(graphics, rectangle);
        }
    }

    void myDrawRect(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        while (n < rectangle.x + rectangle.width) {
            graphics.drawLine(n, rectangle.y, n, rectangle.y);
            n += 2;
        }
        n = rectangle.y;
        while (n < rectangle.y + rectangle.height) {
            graphics.drawLine(rectangle.x, n, rectangle.x, n);
            n += 2;
        }
        n = rectangle.x;
        while (n < rectangle.x + rectangle.width) {
            graphics.drawLine(n, rectangle.y + rectangle.height, n, rectangle.y + rectangle.height);
            n += 2;
        }
        n = rectangle.y;
        while (n < rectangle.y + rectangle.height) {
            graphics.drawLine(rectangle.x + rectangle.width, n, rectangle.x + rectangle.width, n);
            n += 2;
        }
    }

    void drawTab(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        boolean bl = false;
        Page page = this.findPage(this.defaultPage);
        if (page != null) {
            bl = page.isDirty();
        }
        graphics.setColor(NTabs.bgColor);
        if (this.isSelected) {
            graphics.fillRect(rectangle.x - 1, rectangle.y, rectangle.width + 2, rectangle.height);
        } else {
            graphics.fillRect(rectangle.x, rectangle.y + 2, rectangle.width, rectangle.height - 2);
        }
        graphics.setColor(Color.white);
        if (this.isSelected) {
            graphics.drawLine(rectangle.x - 2, rectangle.y + rectangle.height - 2, rectangle.x - 2, rectangle.y);
            graphics.drawLine(rectangle.x - 2, rectangle.y, rectangle.x, rectangle.y - 2);
            if (bl) {
                graphics.drawLine(rectangle.x, rectangle.y - 2, rectangle.x + rectangle.width - 2, rectangle.y - 2);
            } else {
                graphics.drawLine(rectangle.x, rectangle.y - 2, rectangle.x + rectangle.width, rectangle.y - 2);
            }
        } else {
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 4, rectangle.x, rectangle.y + 2);
            graphics.drawLine(rectangle.x, rectangle.y + 2, rectangle.x + 2, rectangle.y);
            if (bl) {
                graphics.drawLine(rectangle.x + 2, rectangle.y, rectangle.x + rectangle.width - 4, rectangle.y);
            } else {
                graphics.drawLine(rectangle.x + 2, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
            }
        }
        if (this.isSelected) {
            graphics.setColor(Color.gray);
            if (bl) {
                graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y + 2, rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height - 4);
            } else {
                graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y - 2, rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height - 4);
            }
            graphics.setColor(Color.black);
            if (bl) {
                graphics.drawLine(rectangle.x + rectangle.width + 2, rectangle.y + 1, rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height - 4);
                graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y - 2, rectangle.x + rectangle.width - 2, rectangle.y + 1);
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y - 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + 1);
            } else {
                graphics.drawLine(rectangle.x + rectangle.width + 2, rectangle.y, rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height - 4);
            }
            graphics.setColor(NTabs.bgColor);
            graphics.drawLine(rectangle.x - 2 + 1, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        } else {
            graphics.setColor(Color.gray);
            if (bl) {
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 4, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 4);
            } else {
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 4);
            }
            graphics.setColor(Color.black);
            if (bl) {
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + 3, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 4);
                graphics.drawLine(rectangle.x + rectangle.width - 3, rectangle.y, rectangle.x + rectangle.width - 3, rectangle.y + 3);
                graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 3);
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + 3);
            } else {
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + 2, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 4);
            }
        }
    }

    int getHotZone() {
        return this.bounds.x + this.bounds.width - 18;
    }

    int getShowingZone() {
        return this.bounds.x + this.bounds.width;
    }

    int getTabWidth() {
        return this.bounds.width;
    }

    String getCaption() {
        return this.tabTitle;
    }

    Point getEndPoint() {
        return new Point(this.bounds.x + this.bounds.width + 2, this.bounds.y);
    }

    int getHeight() {
        return this.bounds.height;
    }

    public boolean contains(int n, int n2) {
        return this.bounds.contains(n, n2);
    }

    public void paint(Graphics graphics, boolean bl) {
        if (this.bounds.x >= 0) {
            this.drawTab(graphics);
            this.drawCaption(graphics, bl);
        }
    }

    public NTab(String string, String string2) {
        this(string, string2, true);
    }

    public NTab(String string, String string2, boolean bl) {
        this.tabID = string;
        this.tabTitle = string2;
        this.isExtensible = bl;
        this.thePages = new Array();
        this.bounds = new Rectangle();
    }
}

