/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.ContentPane;
import com.novell.application.console.widgets.NTab;
import com.novell.application.console.widgets.NTabs;
import com.novell.application.console.widgets.NTabsListener;
import com.novell.application.console.widgets.Page;
import com.novell.application.console.widgets.widgets;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class NTabbedPane
extends JPanel {
    private ContentPane contents = null;
    private NTabs nTabs = null;
    private Hashtable contentHash = null;

    public void addNTabsListener(NTabsListener nTabsListener) {
        this.nTabs.addNTabsListener(nTabsListener);
    }

    public void removeNTabsListener(NTabsListener nTabsListener) {
        this.nTabs.removeNTabsListener(nTabsListener);
    }

    public void createTab(String string, String string2) throws IllegalArgumentException {
        this.nTabs.addTab(string, string2, true);
    }

    public boolean existsTab(String string) {
        return this.nTabs.existsTab(string);
    }

    public void addPage(String string, String string2, Component component) throws IllegalArgumentException {
        String string3 = string;
        String string4 = string2;
        this.nTabs.addTab(string3, string4, false);
        this.addPage(string3, string, string2, component);
    }

    public void addPage(String string, String string2, String string3, Component component) throws IllegalArgumentException {
        this.nTabs.addPage(string, string2, string3);
        if (component != null) {
            this.contents.add(string2, component);
            this.contentHash.put(string2, component);
        }
    }

    public void setMyFocus() {
        this.nTabs.requestFocus();
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 50);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 50);
    }

    public String getCurrentPage() {
        return this.nTabs.getCurrentPage();
    }

    public void setCurrentPage(String string) {
        this.nTabs.showThisPage(string);
    }

    public void addContent(String string, Component component) throws IllegalArgumentException {
        if (!this.nTabs.existsPage(string)) {
            throw new IllegalArgumentException(string + " dosn't exist.");
        }
        this.contents.add(string, component);
        this.contentHash.put(string, component);
    }

    public Component getContent(String string) {
        return (Component)this.contentHash.get(string);
    }

    public void clearPage() {
        ((CardLayout)this.contents.getLayout()).show(this.contents, "BlankPage");
    }

    public void displayPage(String string) throws IllegalArgumentException {
        if (this.nTabs.existsPage(string)) {
            if (this.getContent(string).isVisible()) {
                Component component = this.getContent(string);
                component.invalidate();
                component.repaint();
            } else {
                ((CardLayout)this.contents.getLayout()).show(this.contents, string);
            }
        } else {
            throw new IllegalArgumentException(string + " dosn't exist.");
        }
    }

    public void showThisPage(String string) throws IllegalArgumentException {
        if (!this.nTabs.setClickedTab(string)) {
            throw new IllegalArgumentException(string + " dosn't exist.");
        }
    }

    public void dirtyPage(String string, boolean bl) {
        this.nTabs.dirtyPage(string, bl);
    }

    public Hashtable getMPECPageIDs() {
        int n = 0;
        int n2 = 0;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.nTabs.getTabs().elements();
        while (enumeration.hasMoreElements()) {
            NTab nTab = (NTab)enumeration.nextElement();
            ++n;
            Enumeration enumeration2 = nTab.getPages().elements();
            n2 = 0;
            while (enumeration2.hasMoreElements()) {
                Page page = (Page)enumeration2.nextElement();
                Integer n3 = new Integer(n);
                Integer n4 = new Integer(++n2);
                hashtable.put(n3.toString() + "," + n4.toString(), page.getPageID());
            }
        }
        return hashtable;
    }

    public NTabbedPane(Color color, Color color2) {
        this.setLayout(new BorderLayout());
        this.setBackground(color2);
        this.nTabs = new NTabs(color, color2);
        this.add("North", this.nTabs);
        this.contentHash = new Hashtable();
        this.contents = new ContentPane();
        this.contents.setLayout(new CardLayout(5, 5));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(color2);
        Label label = new Label(widgets.getString("NTabbedPaneLoading"), 1);
        jPanel.add("Center", label);
        panel.add("Center", jPanel);
        this.contents.add("BlankPage", panel);
        this.add("Center", this.contents);
    }

    public NTabbedPane() {
        this(UIManager.getColor("Panel.foreground"), UIManager.getColor("Panel.background"));
    }
}

