/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NJTextField;
import com.novell.application.console.widgets.widgets;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class NTextField
extends NJTextField
implements DocumentListener {
    private Dimension preferredSize = new Dimension(-1, -1);
    private boolean isModified = false;
    private boolean paintCalled = false;
    private boolean changeBackground = true;

    public void changeBackgroundColor(boolean bl) {
        this.changeBackground = bl;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredSize.width >= 0) {
            dimension.width = Math.max(dimension.width, this.preferredSize.width);
        }
        if (this.preferredSize.height >= 0) {
            dimension.height = Math.max(dimension.height, this.preferredSize.height);
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        if (!this.isEditable() && this.changeBackground) {
            this.setBackground(widgets.bgColor);
            this.setForeground(SystemColor.controlText);
        } else {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.windowText);
        }
        super.paint(graphics);
        if (!this.paintCalled) {
            this.paintCalled = true;
            this.setCaretPosition(this.getCaretPosition());
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.setModified(false);
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getLength() > 0) {
            this.isModified = true;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getLength() > 0) {
            this.isModified = true;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getLength() > 0) {
            this.isModified = true;
        }
    }

    public NTextField() {
        PlainDocument plainDocument = new PlainDocument();
        ((JTextComponent)this).setDocument(plainDocument);
        plainDocument.addDocumentListener(this);
    }

    public NTextField(String string) {
        super("");
        PlainDocument plainDocument = new PlainDocument();
        ((JTextComponent)this).setDocument(plainDocument);
        this.setText(string);
        plainDocument.addDocumentListener(this);
    }

    public NTextField(String string, int n) {
        super("", n);
        PlainDocument plainDocument = new PlainDocument();
        ((JTextComponent)this).setDocument(plainDocument);
        this.setText(string);
        plainDocument.addDocumentListener(this);
    }

    public NTextField(int n) {
        super(n);
        PlainDocument plainDocument = new PlainDocument();
        ((JTextComponent)this).setDocument(plainDocument);
        plainDocument.addDocumentListener(this);
    }

    public NTextField(Dimension dimension) {
        this.preferredSize.setSize(dimension);
        PlainDocument plainDocument = new PlainDocument();
        ((JTextComponent)this).setDocument(plainDocument);
        plainDocument.addDocumentListener(this);
    }
}

