/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NTree;
import com.novell.application.console.widgets.NTreeNode;
import com.novell.application.console.widgets.widgets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public final class NTreeRenderer
extends JPanel
implements TreeCellRenderer {
    private static final int afterImageGap = 2;
    private static final int afterCheckGap = 3;
    private static final int checkBoxHeight = 10;
    private static final int checkBoxWidth = 10;
    private static NTree tree;
    private NTreeNode node;
    private String text;
    private JLabel label = new JLabel("");
    private JCheckBox checkbox = new JCheckBox("");
    private boolean selected;
    private Font font;
    private FontMetrics metrics;
    private Image checkImage;
    private Image notCheckedImage;
    private Image partialCheckImage;

    public void paint(Graphics graphics) {
        if (!tree.isCheckBoxModeOn()) {
            super.paint(graphics);
            return;
        }
        Image image = this.node.getImage();
        int n = 0;
        int n2 = 0;
        int n3 = (this.getHeight() + this.metrics.getHeight()) / 2 - 1;
        int n4 = (this.getHeight() - 10) / 2 - 1;
        int n5 = (this.getHeight() + n2) / 2 - 1;
        int n6 = 0;
        if (image != null) {
            n = image.getWidth(this);
            n2 = image.getHeight(this);
        }
        if (this.selected) {
            graphics.setColor(Color.yellow);
            graphics.fillRect(0, this.getHeight() - n3, this.metrics.stringWidth(this.text) + 10 + 3 + n + 2, this.getHeight() - 1);
        }
        this.drawCheckBox(graphics, this.node, n4);
        n6 = 13;
        if (image != null) {
            graphics.drawImage(image, n6, this.getHeight() - n5, this);
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.text, n6 + n + 2, n3);
    }

    private void drawCheckBox(Graphics graphics, NTreeNode nTreeNode, int n) {
        if (nTreeNode.isChecked()) {
            graphics.drawImage(this.checkImage, 0, n, this);
        } else if (nTreeNode.isPartiallyChecked()) {
            graphics.drawImage(this.partialCheckImage, 0, n, this);
        } else {
            graphics.drawImage(this.notCheckedImage, 0, n, this);
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.text = jTree.convertValueToText(object, bl, bl2, bl3, n, bl);
        if (!(object instanceof NTreeNode)) {
            return this;
        }
        this.node = (NTreeNode)object;
        this.selected = bl;
        this.label.setText(this.text + "                     ");
        return this;
    }

    public NTreeRenderer(NTree nTree) {
        tree = nTree;
        this.font = tree.getFont();
        this.metrics = ((Component)this).getFontMetrics(this.font);
        this.checkImage = widgets.getImage("checked.gif");
        this.notCheckedImage = widgets.getImage("not_checked.gif");
        this.partialCheckImage = widgets.getImage("partial_checked.gif");
        this.add(this.checkbox);
        this.add(this.label);
    }
}

