/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ab;

import com.novell.gw.ab.Contact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListFilter;

public abstract class AddressBook {
    protected int pGWAddressBook;

    private native void dispose(int var1);

    private native int findContactByEmail(int var1, String var2) throws EngineException;

    private native int findContactByName(int var1, String var2) throws EngineException;

    private native int findContactsByName(int var1, String var2) throws EngineException;

    private native int getContact(int var1, int var2) throws EngineException;

    private native int getContents(int var1, int var2, boolean var3, int var4);

    private native int getId(int var1);

    private native int[] getIndexedFields(int var1);

    private native String getName(int var1);

    private native String getUserDefinedFieldName(int var1, int var2);

    private native int[] getUserDefinedFields(int var1);

    private native boolean isFrequentContacts(int var1);

    private native boolean isReadOnly(int var1);

    private native boolean isSharedByMe(int var1);

    private native boolean isSharedToMe(int var1);

    public static native boolean isSystemBook(int var0);

    public AddressBook() {
        this.pGWAddressBook = 0;
    }

    AddressBook(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWAddressBook = n;
    }

    int getPointer() {
        return this.pGWAddressBook;
    }

    public String getName() {
        return this.getName(this.pGWAddressBook);
    }

    public int getId() {
        return this.getId(this.pGWAddressBook);
    }

    public boolean isReadOnly() {
        return this.isReadOnly(this.pGWAddressBook);
    }

    public boolean isSystemBook() {
        return AddressBook.isSystemBook(this.pGWAddressBook);
    }

    public boolean isSharedByMe() {
        return this.isSharedByMe(this.pGWAddressBook);
    }

    public boolean isSharedToMe() {
        return this.isSharedToMe(this.pGWAddressBook);
    }

    public boolean isFrequentContacts() {
        return this.isFrequentContacts(this.pGWAddressBook);
    }

    public ItemList getContents() {
        return this.getContents(-1, true, null);
    }

    public ItemList getContents(int n, boolean bl) {
        return this.getContents(n, bl, null);
    }

    public ItemList getContents(ItemListFilter itemListFilter) {
        return this.getContents(-1, true, itemListFilter);
    }

    public ItemList getContents(int n, boolean bl, ItemListFilter itemListFilter) {
        ItemList itemList = null;
        int n2 = this.getContents(this.pGWAddressBook, n, bl, itemListFilter != null ? itemListFilter.getPointer() : 0);
        if (n2 != 0) {
            itemList = ItemList.createItemList(n2);
        }
        return itemList;
    }

    public Contact getContact(int n) throws EngineException {
        Contact contact = null;
        int n2 = this.getContact(this.pGWAddressBook, n);
        if (n2 != 0) {
            contact = Contact.createContact(n2);
        }
        return contact;
    }

    public int[] getUserDefinedFields() {
        return this.getUserDefinedFields(this.pGWAddressBook);
    }

    public String getUserDefinedFieldName(int n) {
        return this.getUserDefinedFieldName(this.pGWAddressBook, n);
    }

    public int[] getIndexedFields() {
        return this.getIndexedFields(this.pGWAddressBook);
    }

    public ItemList findContactsByName(String string) throws EngineException {
        ItemList itemList = null;
        int n = this.findContactsByName(this.pGWAddressBook, string);
        if (n != 0) {
            itemList = ItemList.createItemList(n);
        }
        return itemList;
    }

    public Contact findContactByName(String string) throws EngineException {
        Contact contact = null;
        int n = this.findContactByName(this.pGWAddressBook, string);
        if (n != 0) {
            contact = Contact.createContact(n);
        }
        return contact;
    }

    public Contact findContactByEmail(String string) throws EngineException {
        Contact contact = null;
        int n = this.findContactByEmail(this.pGWAddressBook, string);
        if (n != 0) {
            contact = Contact.createContact(n);
        }
        return contact;
    }

    public void dispose() {
        if (this.pGWAddressBook != 0) {
            this.dispose(this.pGWAddressBook);
            this.pGWAddressBook = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

