/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.Addressable;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.DataStoreListener;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.DisplayColumnInfo;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.JunkMail;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.folder.Folder;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.message.Message;
import com.novell.gw.rules.RuleList;
import com.novell.gw.util.Debug;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class DataStore {
    public static final int ACCESS_REQUEST_TYPE_ITEM_CREATE = 1;
    public static final int ACCESS_REQUEST_TYPE_ITEM_DELETE = 2;
    public static final int ACCESS_REQUEST_TYPE_ITEM_READ = 3;
    public static final int ACCESS_REQUEST_TYPE_ITEM_WRITE = 4;
    public static final int ACCESS_REQUEST_TYPE_OPEN_ARCHIVEDB = 5;
    public static final int ACCESS_REQUEST_TYPE_SET_ALARM = 6;
    public static final int ACCESS_REQUEST_TYPE_EDIT_PREFS = 7;
    public static final int ACCESS_REQUEST_TYPE_EDIT_RULES = 8;
    public static final int ACCESS_REQUEST_TYPE_EDIT_PERS_GROUPS = 9;
    public static final int ACCESS_REQUEST_TYPE_ITEM_ARCHIVE = 10;
    public static final int ACCESS_REQUEST_TYPE_ADD_FOLDER = 11;
    public static final int ACCESS_REQUEST_TYPE_RENAME_FOLDER = 12;
    public static final int ACCESS_REQUEST_TYPE_DELETE_FOLDER = 13;
    public static final int ACCESS_REQUEST_TYPE_MOVE_FOLDER = 14;
    public static final int ACCESS_REQUEST_TYPE_XTD_CLIENT = 15;
    private int pGWDataStore = 0;
    private int pEvents = 0;
    private EventListenerList listenerList = new EventListenerList();
    private AddressBookManager abManager;
    private Account[] accounts;
    private JunkMail junkMail;
    private static HashMap folderCache;
    private int displaySettingsIndex;
    public static final int DS_SUBTYPE_NORMAL = 0;
    public static final int DS_SUBTYPE_CONTACTS = 1;
    public static final int DS_SUBTYPE_ALL_VISIBLE = 2;
    static /* synthetic */ Class class$com$novell$gw$engine$DataStoreListener;

    private static native void initIds();

    private native void dispose(int var1, int var2);

    private native void flushSettings(int var1);

    private native int getAddressBookManager(int var1);

    private native int getAccount(int var1, String var2);

    private native int getGroupWiseAccount(int var1);

    private native int[] getAccounts(int var1);

    private native int getAccountSettings(int var1);

    private native boolean hasMailboxSpace(int var1);

    private native boolean isOnline(int var1);

    private native boolean isCaching(int var1);

    private native boolean isRemote(int var1);

    private native void sync(int var1);

    private native int subscribeToEvents(int var1);

    private native int[] getDisplayColumnFields(int var1, boolean var2);

    private native int getDisplaySettings(int var1, String var2);

    private native int getDisplaySettingsCount(int var1, int var2);

    private native int getDisplaySettingsNextElement(int var1, int var2, int var3);

    private native int getJunkMail(int var1);

    private native int getProxyAccessList(int var1);

    private native int getProxyHistoryList(int var1);

    private native boolean checkAccess(int var1, int var2, int var3, int var4);

    private native String getHost(int var1);

    private native String getPathToHost(int var1);

    private native String getTcpIpAddress(int var1);

    private native int getTcpIpPort(int var1);

    private native String getFileId(int var1);

    private native String getUserId(int var1);

    private native String getUserFullName(int var1);

    private native int getUserFields(int var1);

    private native int createFolder(int var1, String var2, String var3, int var4, int var5);

    private native int createSharedFolder(int var1, String var2, String var3, int var4, int var5, int var6);

    private native int find(int var1, int var2);

    private native int find(int var1, String var2, String var3, String var4, String var5, String var6);

    private native int findFolder(int var1, int var2, int var3);

    private native int[] getRootFolders(int var1);

    private native int getSystemFolder(int var1, int var2);

    private native void emptyJunkMail(int var1);

    private native void emptyTrash(int var1);

    private native boolean isArchiveDB(int var1);

    private native int openArchiveDB(int var1, boolean var2);

    private native boolean isBackupDB(int var1);

    private native int openBackupDB(int var1);

    private native boolean performBackupOnDB(int var1, boolean var2, boolean var3);

    private native boolean canSetOnlineMailboxPassword(int var1);

    private native void reprimeCache(int var1);

    private native void requestContacts(int var1);

    private native void setOnlineMailboxPassword(int var1, String var2, String var3);

    private native boolean isGWCheckAvailable(int var1);

    private native String getGWCheckCommandArgs(int var1);

    private native String getGWCheckPath(int var1);

    private native boolean backupCheck(int var1);

    private native int findItem(int var1, String var2);

    DataStore(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWDataStore = n;
        this.pEvents = this.subscribeToEvents(n);
    }

    public DataStore() {
    }

    public void addDataStoreListener(DataStoreListener dataStoreListener) {
        this.listenerList.add(class$com$novell$gw$engine$DataStoreListener == null ? (class$com$novell$gw$engine$DataStoreListener = DataStore.class$("com.novell.gw.engine.DataStoreListener")) : class$com$novell$gw$engine$DataStoreListener, dataStoreListener);
    }

    public void removeDataStoreListener(DataStoreListener dataStoreListener) {
        this.listenerList.remove(class$com$novell$gw$engine$DataStoreListener == null ? (class$com$novell$gw$engine$DataStoreListener = DataStore.class$("com.novell.gw.engine.DataStoreListener")) : class$com$novell$gw$engine$DataStoreListener, dataStoreListener);
    }

    public Folder createFolder(String string, String string2, Folder folder, int n) {
        Folder folder2 = null;
        if (string == null) {
            throw new NullPointerException();
        }
        int n2 = this.createFolder(this.pGWDataStore, string, string2, folder.getPointer(), n);
        if (n2 != 0) {
            folder2 = DataStore.getFolder(n2);
        }
        return folder2;
    }

    public Folder createSharedFolder(String string, String string2, Folder folder, int n, FolderSharedList folderSharedList) {
        Folder folder2 = null;
        if (string == null) {
            throw new NullPointerException();
        }
        int n2 = this.createSharedFolder(this.pGWDataStore, string, string2, folder.getPointer(), n, folderSharedList.getPointer());
        if (n2 != 0) {
            folder2 = DataStore.getFolder(n2);
        }
        return folder2;
    }

    public RuleList getRuleList() {
        RuleList ruleList = RuleList.get(this);
        return ruleList;
    }

    public DataStoreSettings getSettings() {
        return new DataStoreSettings(this);
    }

    public JunkMail getJunkMail() {
        if (this.junkMail == null) {
            int n = this.getJunkMail(this.pGWDataStore);
            this.junkMail = new JunkMail(n);
        }
        return this.junkMail;
    }

    public boolean hasMailboxSpace() {
        return this.hasMailboxSpace(this.pGWDataStore);
    }

    public boolean isOnline() {
        return this.isOnline(this.pGWDataStore);
    }

    public boolean isCaching() {
        return this.isCaching(this.pGWDataStore);
    }

    public boolean isRemote() {
        return this.isRemote(this.pGWDataStore);
    }

    public void sync() {
        this.sync(this.pGWDataStore);
    }

    public void emptyJunkMail() {
        this.emptyJunkMail(this.pGWDataStore);
    }

    public void emptyTrash() {
        this.emptyTrash(this.pGWDataStore);
    }

    public Folder find(ItemListFilter itemListFilter) {
        int n = this.find(this.pGWDataStore, itemListFilter.getPointer());
        return Folder.createFolder(n);
    }

    public Folder find(String string, String string2, String string3, String string4, String string5) {
        int n = this.find(this.pGWDataStore, string, string2, string3, string4, string5);
        return Folder.createFolder(n);
    }

    public Item findItem(String string) {
        int n = this.findItem(this.pGWDataStore, string);
        return Message.createMessage(n);
    }

    public Folder getSystemFolder(int n) {
        Folder folder = null;
        int n2 = this.getSystemFolder(this.pGWDataStore, n);
        if (n2 != 0) {
            folder = DataStore.getFolder(n2);
        }
        return folder;
    }

    public int getPointer() {
        return this.pGWDataStore;
    }

    public Folder[] getRootFolders() {
        int[] nArray = this.getRootFolders(this.pGWDataStore);
        Folder[] folderArray = new Folder[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            folderArray[i] = Folder.createFolder(nArray[i]);
        }
        return folderArray;
    }

    public AddressBookManager getAddressBookManager() {
        int n;
        if (this.abManager == null && (n = this.getAddressBookManager(this.pGWDataStore)) != 0) {
            this.abManager = new AddressBookManager(n);
        }
        return this.abManager;
    }

    public Account[] getAccounts() {
        int[] nArray = this.getAccounts(this.pGWDataStore);
        Account[] accountArray = new Account[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            accountArray[i] = Account.createAccount(nArray[i], this);
        }
        return accountArray;
    }

    public Account getAccount(String string) {
        int n = this.getAccount(this.pGWDataStore, string);
        return Account.createAccount(n, this);
    }

    public Account getGroupWiseAccount() {
        int n = this.getGroupWiseAccount(this.pGWDataStore);
        return Account.createAccount(n, this);
    }

    public AccountSettings getAccountSettings() {
        int n = this.getAccountSettings(this.pGWDataStore);
        return new AccountSettings(n);
    }

    public Folder findFolder(String string) {
        Folder folder = null;
        Folder[] folderArray = this.getRootFolders();
        if (folderArray != null) {
            folder = Folder.findFolder(folderArray, string);
        }
        return folder;
    }

    public Folder findFolder(Folder folder, DataStore dataStore) {
        int n = this.findFolder(this.pGWDataStore, folder.getPointer(), dataStore.getPointer());
        return DataStore.getFolder(n);
    }

    public String getHost() {
        return this.getHost(this.pGWDataStore);
    }

    public String getPathToHost() {
        return this.getPathToHost(this.pGWDataStore);
    }

    public String getTcpIpAddress() {
        return this.getTcpIpAddress(this.pGWDataStore);
    }

    public String getTcpIpPort() {
        int n = this.getTcpIpPort(this.pGWDataStore);
        String string = String.valueOf(n);
        return string;
    }

    public static Folder getFolder(int n) {
        Folder folder = null;
        if (n != 0) {
            folder = (Folder)folderCache.get(new Integer(n));
            if (folder == null) {
                folder = Folder.createFolder(n);
                folderCache.put(new Integer(n), folder);
            } else {
                folder.releasePtr();
            }
        }
        return folder;
    }

    public String getUserFileId() {
        return this.getFileId(this.pGWDataStore);
    }

    public String getUserId() {
        return this.getUserId(this.pGWDataStore);
    }

    public String getUserFullName() {
        return this.getUserFullName(this.pGWDataStore);
    }

    public Addressable getUserFields() {
        Address address = null;
        int n = this.getUserFields(this.pGWDataStore);
        if (n != 0) {
            address = new Address(n);
        }
        return address;
    }

    public boolean isArchiveDB() {
        return this.isArchiveDB(this.pGWDataStore);
    }

    public DataStore openArchiveDB(boolean bl) {
        DataStore dataStore = null;
        int n = this.openArchiveDB(this.pGWDataStore, bl);
        if (n != 0) {
            dataStore = new DataStore(n);
        }
        return dataStore;
    }

    public boolean canSetOnlineMailboxPassword() {
        return this.canSetOnlineMailboxPassword(this.pGWDataStore);
    }

    public void reprimeCache() {
        this.reprimeCache(this.pGWDataStore);
    }

    public void requestContacts() {
        this.requestContacts(this.pGWDataStore);
    }

    public void setOnlineMailboxPassword(String string, String string2) {
        this.setOnlineMailboxPassword(this.pGWDataStore, string, string2);
    }

    public boolean isBackupDB() {
        return this.isBackupDB(this.pGWDataStore);
    }

    public DataStore openBackupDB() {
        DataStore dataStore = null;
        int n = this.openBackupDB(this.pGWDataStore);
        if (n != 0) {
            dataStore = new DataStore(n);
        }
        return dataStore;
    }

    public boolean performBackupOnDB(boolean bl, boolean bl2) {
        boolean bl3 = this.performBackupOnDB(this.pGWDataStore, bl, bl2);
        return bl3;
    }

    public DisplayColumnInfo[] getDisplayColumnFields(boolean bl) {
        int[] nArray = this.getDisplayColumnFields(this.pGWDataStore, bl);
        int n = nArray != null ? nArray.length : 0;
        DisplayColumnInfo[] displayColumnInfoArray = new DisplayColumnInfo[n];
        for (int i = 0; i < n; ++i) {
            displayColumnInfoArray[i] = new DisplayColumnInfo(nArray[i]);
        }
        return displayColumnInfoArray;
    }

    public DisplaySettings getDisplaySettings(String string) {
        DisplaySettings displaySettings = null;
        int n = this.getDisplaySettings(this.pGWDataStore, string);
        if (n != 0) {
            displaySettings = new DisplaySettings(n);
        }
        return displaySettings;
    }

    public Enumeration getDisplaySettingsEnumeration(int n) {
        return new DisplaySettingsEnumeration(-1, n);
    }

    public ProxyAccessList getProxyAccessList() {
        int n = this.getProxyAccessList(this.pGWDataStore);
        return new ProxyAccessList(n);
    }

    public ProxyHistoryList getProxyHistoryList() {
        int n = this.getProxyHistoryList(this.pGWDataStore);
        return new ProxyHistoryList(n);
    }

    public boolean checkAccess(int n, int n2, int n3) {
        return this.checkAccess(this.pGWDataStore, n, n2, n3);
    }

    public boolean isGWCheckAvailable() {
        return this.isGWCheckAvailable(this.pGWDataStore);
    }

    private static Process _launchGWCheck(String[] stringArray) {
        try {
            return Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void flushSettings() {
        this.flushSettings(this.pGWDataStore);
    }

    public void dispose() {
        if (this.pGWDataStore != 0 || this.pEvents != 0) {
            this.dispose(this.pGWDataStore, this.pEvents);
            this.pEvents = 0;
            this.pGWDataStore = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void foldersChanged() {
        Debug.trace("DataStoreEvent[" + this.pGWDataStore + "].FOLDERS_CHANGED: ");
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataStore.this.doFoldersChanged(objectArray);
                }
            });
        }
    }

    private void doFoldersChanged(Object[] objectArray) {
        for (int i = 1; i < objectArray.length; i += 2) {
            DataStoreListener dataStoreListener = (DataStoreListener)objectArray[i];
            dataStoreListener.foldersChanged();
        }
    }

    private void settingsChanged(int n) {
        Debug.trace("DataStoreEvent[" + this.pGWDataStore + "].SETTINGS_CHANGED: ");
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            final int n2 = n;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataStore.this.doSettingsChanged(objectArray, n2);
                }
            });
        }
    }

    private void doSettingsChanged(Object[] objectArray, int n) {
        for (int i = 1; i < objectArray.length; i += 2) {
            DataStoreListener dataStoreListener = (DataStoreListener)objectArray[i];
            dataStoreListener.settingsChanged(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DataStore.initIds();
        folderCache = new HashMap();
    }

    private class DisplaySettingsEnumeration
    implements Enumeration {
        int index;
        int subType;
        int numLeft;

        public DisplaySettingsEnumeration(int n, int n2) {
            this.index = n;
            this.subType = n2;
            this.numLeft = DataStore.this.getDisplaySettingsCount(DataStore.this.pGWDataStore, n2);
        }

        public boolean hasMoreElements() {
            return this.numLeft > 0;
        }

        public synchronized Object nextElement() {
            --this.numLeft;
            DisplaySettings displaySettings = null;
            int n = DataStore.this.getDisplaySettingsNextElement(DataStore.this.pGWDataStore, this.index, this.subType);
            if (n != 0) {
                this.index = DataStore.this.displaySettingsIndex;
                displaySettings = new DisplaySettings(n);
            } else {
                this.numLeft = 0;
            }
            return displaySettings;
        }
    }
}

