/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import java.io.IOException;
import java.io.InputStream;

public class EngineInputStream
extends InputStream {
    public static final int DEF_BUF_SIZE = 8192;
    private int pStream = 0;
    private int index = 0;
    private int count = 0;
    private byte[] buffer;

    private native int read(int var1, byte[] var2, int var3, int var4);

    private native void dispose(int var1);

    public EngineInputStream(int n) {
        this(n, 8192);
    }

    EngineInputStream(int n, int n2) {
        this.pStream = n;
        this.buffer = new byte[n2];
    }

    public int read() throws IOException {
        if (this.index >= this.count) {
            this.refill();
            if (this.count == -1) {
                return -1;
            }
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.index >= this.count) {
            if (n2 >= this.buffer.length) {
                return this.read(this.pStream, byArray, n, n2);
            }
            this.refill();
            if (this.count == -1) {
                return -1;
            }
        }
        int n3 = Math.min(this.count - this.index, n2);
        System.arraycopy(this.buffer, this.index, byArray, n, n3);
        this.index += n3;
        return n3;
    }

    private void refill() {
        this.index = 0;
        this.count = this.read(this.pStream, this.buffer, 0, this.buffer.length);
    }

    public void close() throws IOException {
        this.dispose();
    }

    private void dispose() {
        if (this.pStream != 0) {
            this.dispose(this.pStream);
            this.pStream = 0;
            this.buffer = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

