/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import java.util.Locale;

public class EngineLocale {
    private static final EngineLocale[] suppLocales = new EngineLocale[]{new EngineLocale("US", "en", "US"), new EngineLocale("AF", "af"), new EngineLocale("AR", "ar"), new EngineLocale("CA", "ca"), new EngineLocale("HR", "hr"), new EngineLocale("CZ", "cs"), new EngineLocale("DK", "da"), new EngineLocale("NL", "nl"), new EngineLocale("OZ", "en", "AU"), new EngineLocale("CE", "en", "CA"), new EngineLocale("UK", "en", "GB"), new EngineLocale("FA", "fa"), new EngineLocale("SU", "fi"), new EngineLocale("CF", "fr", "CA"), new EngineLocale("FR", "fr", "FR"), new EngineLocale("GA", "gl"), new EngineLocale("DE", "de", "DE"), new EngineLocale("SD", "de", "CH"), new EngineLocale("GR", "el"), new EngineLocale("HE", "he"), new EngineLocale("MA", "hu"), new EngineLocale("IS", "is"), new EngineLocale("IT", "it"), new EngineLocale("NO", "no"), new EngineLocale("PL", "pl"), new EngineLocale("BR", "pt", "BR"), new EngineLocale("PO", "pt", "PT"), new EngineLocale("RU", "ru"), new EngineLocale("SL", "sk"), new EngineLocale("ES", "es"), new EngineLocale("SV", "sv"), new EngineLocale("YK", "uk"), new EngineLocale("UR", "ur"), new EngineLocale("TR", "tr"), new EngineLocale("JP", "ja"), new EngineLocale("KR", "ko"), new EngineLocale("CT", "zh", "TW"), new EngineLocale("CS", "zh", "CN"), new EngineLocale("LA", "en", "US"), new EngineLocale("ET", "et"), new EngineLocale("LT", "lt"), new EngineLocale("LV", "lv"), new EngineLocale("TH", "th")};
    private static EngineLocale currentLocale;
    private Locale locale;
    private String displayName;
    private String code;

    private static native String getLangCode();

    private static native String getAvailableLangs();

    private static native String getLangDisplayStr(String var0);

    public static EngineLocale[] getAvailableLocales() {
        String string = EngineLocale.getAvailableLangs();
        EngineLocale[] engineLocaleArray = new EngineLocale[string.length() / 2];
        for (int i = 0; i < engineLocaleArray.length; ++i) {
            int n = i * 2;
            String string2 = string.substring(n, n + 2);
            engineLocaleArray[i] = EngineLocale.getLocale(string2);
        }
        return engineLocaleArray;
    }

    public static EngineLocale getCurrent() {
        if (currentLocale == null) {
            String string = EngineLocale.getLangCode();
            currentLocale = EngineLocale.getLocale(string);
        }
        return currentLocale;
    }

    public static EngineLocale getLocale(String string) {
        if (string != null) {
            string = string.toUpperCase();
            for (int i = 0; i < suppLocales.length; ++i) {
                EngineLocale engineLocale = suppLocales[i];
                if (!string.equals(engineLocale.getCode())) continue;
                return engineLocale;
            }
        }
        return suppLocales[0];
    }

    private EngineLocale(String string, String string2) {
        this(string, string2, "");
    }

    private EngineLocale(String string, String string2, String string3) {
        this.locale = new Locale(string2, string3, "");
        this.code = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = EngineLocale.getLangDisplayStr(this.code);
            if (this.displayName == null || this.displayName.length() == 0) {
                this.displayName = this.locale.getDisplayName();
            }
        }
        return this.displayName;
    }
}

