/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.ab.AddressBookItemList;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.ItemListListener;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.util.Debug;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class ItemList {
    protected int pGWItemList;
    private int pEvents = 0;
    private volatile Item[] items;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$novell$gw$engine$ItemListListener;

    private static native void initIds();

    private static native boolean isAddressBookList(int var0);

    public static ItemList createItemList(int n) {
        ItemList itemList = null;
        itemList = !ItemList.isAddressBookList(n) ? new ItemList(n) : new AddressBookItemList(n);
        return itemList;
    }

    private native boolean canDeleteItem(int var1, int var2);

    private native boolean canDeleteItems(int var1, int[] var2);

    private native boolean canDeleteItemAt(int var1, int var2);

    private native boolean canDeleteItemsAt(int var1, int[] var2);

    private native boolean canDeleteAndEmptyItem(int var1, int var2);

    private native boolean canDeleteAndEmptyItems(int var1, int[] var2);

    private native boolean canDeleteAndEmptyItemAt(int var1, int var2);

    private native boolean canDeleteAndEmptyItemsAt(int var1, int[] var2);

    private native boolean canMarkItemPrivate(int var1, int var2);

    private native boolean canMarkItemsPrivate(int var1, int[] var2);

    private native boolean canMarkItemPrivateAt(int var1, int var2);

    private native boolean canMarkItemsPrivateAt(int var1, int[] var2);

    private native boolean canMarkItemRead(int var1, int var2);

    private native boolean canMarkItemsRead(int var1, int[] var2);

    private native boolean canMarkItemReadAt(int var1, int var2);

    private native boolean canMarkItemsReadAt(int var1, int[] var2);

    private native boolean canMarkItemReadLater(int var1, int var2);

    private native boolean canMarkItemsReadLater(int var1, int[] var2);

    private native boolean canMarkItemReadLaterAt(int var1, int var2);

    private native boolean canMarkItemsReadLaterAt(int var1, int[] var2);

    private native boolean canPurgeItem(int var1, int var2);

    private native boolean canPurgeItems(int var1, int[] var2);

    private native boolean canPurgeItemAt(int var1, int var2);

    private native boolean canPurgeItemsAt(int var1, int[] var2);

    private native boolean canRestoreItem(int var1, int var2);

    private native boolean canRestoreItems(int var1, int[] var2);

    private native boolean canRestoreItemAt(int var1, int var2);

    private native boolean canRestoreItemsAt(int var1, int[] var2);

    private native boolean canUndeleteItem(int var1, int var2);

    private native boolean canUndeleteItems(int var1, int[] var2);

    private native boolean canUndeleteItemAt(int var1, int var2);

    private native boolean canUndeleteItemsAt(int var1, int[] var2);

    private native boolean deleteItem(int var1, int var2);

    private native boolean deleteItems(int var1, int[] var2);

    private native boolean deleteItemAt(int var1, int var2);

    private native boolean deleteItemsAt(int var1, int[] var2);

    private native boolean deleteAndEmptyItem(int var1, int var2);

    private native boolean deleteAndEmptyItems(int var1, int[] var2);

    private native boolean deleteAndEmptyItemAt(int var1, int var2);

    private native boolean deleteAndEmptyItemsAt(int var1, int[] var2);

    private native boolean undeleteItem(int var1, int var2);

    private native boolean undeleteItems(int var1, int[] var2);

    private native boolean undeleteItemAt(int var1, int var2);

    private native boolean undeleteItemsAt(int var1, int[] var2);

    private native boolean markItemPrivate(int var1, int var2);

    private native boolean markItemsPrivate(int var1, int[] var2);

    private native boolean markItemPrivateAt(int var1, int var2);

    private native boolean markItemsPrivateAt(int var1, int[] var2);

    private native boolean markItemRead(int var1, int var2);

    private native boolean markItemsRead(int var1, int[] var2);

    private native boolean markItemReadAt(int var1, int var2);

    private native boolean markItemsReadAt(int var1, int[] var2);

    private native boolean markItemReadLater(int var1, int var2);

    private native boolean markItemsReadLater(int var1, int[] var2);

    private native boolean markItemReadLaterAt(int var1, int var2);

    private native boolean markItemsReadLaterAt(int var1, int[] var2);

    private native boolean purgeItem(int var1, int var2);

    private native boolean purgeItems(int var1, int[] var2);

    private native boolean purgeItemAt(int var1, int var2);

    private native boolean purgeItemsAt(int var1, int[] var2);

    private native boolean restoreItem(int var1, int var2);

    private native boolean restoreItems(int var1, int[] var2);

    private native boolean restoreItemAt(int var1, int var2);

    private native boolean restoreItemsAt(int var1, int[] var2);

    private native boolean canChecklistMoveDown(int var1, int var2);

    private native boolean canChecklistMoveUp(int var1, int var2);

    private native boolean canChecklistMoveToBottom(int var1, int var2);

    private native boolean canChecklistMoveToTop(int var1, int var2);

    private native boolean checklistMoveDown(int var1, int var2);

    private native boolean checklistMoveUp(int var1, int var2);

    private native boolean checklistMoveToBottom(int var1, int var2);

    private native boolean checklistMoveToTop(int var1, int var2);

    private native boolean checklistMoveTo(int var1, int var2, int var3);

    private native boolean canShowInChecklist(int var1, int[] var2);

    private native boolean isInChecklist(int var1, int[] var2);

    private native boolean showInChecklist(int var1, int[] var2, boolean var3);

    private native int handleJunkMailItem(int var1, int var2, int var3);

    private native int handleJunkMailItems(int var1, int var2, int[] var3);

    private native int handleJunkMailItemAt(int var1, int var2, int var3);

    private native int handleJunkMailItemsAt(int var1, int var2, int[] var3);

    private native int canHandleJunkMailItem(int var1, int var2, int var3);

    private native int canHandleJunkMailItems(int var1, int var2, int[] var3);

    private native int canHandleJunkMailItemAt(int var1, int var2, int var3);

    private native int canHandleJunkMailItemsAt(int var1, int var2, int[] var3);

    private native int[] getCalendarItemsAll(int var1, int var2);

    private native int[] getCalendarItemsTypes(int var1, int var2, int var3);

    private native int[] getAllDayEvents(int var1, int var2);

    private native int[] getAppointments(int var1, int var2);

    private native int[] getNotes(int var1, int var2);

    private native int[] getTasks(int var1, int var2);

    private native void dispose(int var1, int var2);

    private native int findItem(int var1, int var2, String var3);

    private native int getFirstUnreadItem(int var1, boolean var2);

    private native int getItemAt(int var1, int var2);

    private native int getDisplayItemCount(int var1);

    private native int getSize(int var1);

    private native int getSortField(int var1);

    private native int getTransferItems(int var1, int[] var2);

    private native boolean isSortAscending(int var1);

    private native boolean queryStop(int var1);

    private native boolean setFilter(int var1, int var2);

    private native boolean sort(int var1, int var2, boolean var3);

    private native int subscribeToEvents(int var1);

    private native int indexOf(int var1, int var2);

    private native int indexOf(int var1, String var2, int var3);

    private native void sabPreScrollAction(int var1);

    protected ItemList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWItemList = n;
        int n2 = this.getSize(n);
        this.items = new Item[n2];
        this.pEvents = this.subscribeToEvents(n);
    }

    public int getPointer() {
        return this.pGWItemList;
    }

    protected ItemList() {
        this.items = new Item[0];
    }

    public void addItemListListener(ItemListListener itemListListener) {
        this.listenerList.add(class$com$novell$gw$engine$ItemListListener == null ? (class$com$novell$gw$engine$ItemListListener = ItemList.class$("com.novell.gw.engine.ItemListListener")) : class$com$novell$gw$engine$ItemListListener, itemListListener);
    }

    public void removeItemListListener(ItemListListener itemListListener) {
        this.listenerList.remove(class$com$novell$gw$engine$ItemListListener == null ? (class$com$novell$gw$engine$ItemListListener = ItemList.class$("com.novell.gw.engine.ItemListListener")) : class$com$novell$gw$engine$ItemListListener, itemListListener);
    }

    public boolean setFilter(ItemListFilter itemListFilter) {
        return this.setFilter(this.pGWItemList, itemListFilter != null ? itemListFilter.getPointer() : 0);
    }

    public void sort(int n, boolean bl) {
        this.sort(this.pGWItemList, n, bl);
    }

    public int getSortField() {
        return this.getSortField(this.pGWItemList);
    }

    public boolean isSortAscending() {
        return this.isSortAscending(this.pGWItemList);
    }

    public int getDisplayItemCount() {
        return this.getDisplayItemCount(this.pGWItemList);
    }

    public synchronized int getSize() {
        return this.items.length;
    }

    public int getFirstUnreadItemIndex(boolean bl) {
        return this.getFirstUnreadItem(this.pGWItemList, bl);
    }

    protected void sabPreScrollAction() {
        this.sabPreScrollAction(this.pGWItemList);
    }

    public Item getItemAt(int n) {
        Item[] itemArray = this.items;
        Item item = null;
        if (itemArray.length > 0) {
            if (n >= itemArray.length) {
                n = itemArray.length - 1;
            } else if (n < 0) {
                n = 0;
            }
            item = itemArray[n];
            if (item == null) {
                int n2 = this.getItemAt(this.pGWItemList, n);
                if (n2 == 0) {
                    throw new NoSuchElementException("List size: " + itemArray.length + ", Index: " + n);
                }
                itemArray[n] = item = this.createItem(n2);
            }
        }
        return item;
    }

    protected Item createItem(int n) {
        return Item.createItem(n);
    }

    public TransferItems getTransferItems(int[] nArray) {
        TransferItems transferItems = null;
        int n = this.getTransferItems(this.pGWItemList, nArray);
        if (n != 0) {
            transferItems = new TransferItems(n);
        }
        return transferItems;
    }

    public boolean canDeleteItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canDeleteItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canDeleteItem(Item item) {
        boolean bl = this.canDeleteItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canDeleteItemAt(int n) {
        return this.canDeleteItemAt(this.pGWItemList, n);
    }

    public boolean canDeleteItemsAt(int[] nArray) {
        boolean bl = this.canDeleteItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean deleteItem(Item item) {
        boolean bl = this.deleteItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public static int[] getPointers(Item[] itemArray) {
        int[] nArray = null;
        if (itemArray != null && itemArray.length > 0) {
            nArray = new int[itemArray.length];
            int n = 0;
            for (int i = 0; i < itemArray.length && (n = itemArray[i].getPointer()) != 0; ++i) {
                nArray[i] = n;
            }
            if (n == 0) {
                nArray = null;
            }
        }
        return nArray;
    }

    public boolean deleteItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.deleteItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean deleteItemAt(int n) {
        this.rangeCheck(n);
        return this.deleteItemAt(this.pGWItemList, n);
    }

    public boolean deleteItemsAt(int[] nArray) {
        boolean bl = this.deleteItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canDeleteAndEmptyItem(Item item) {
        boolean bl = this.canDeleteAndEmptyItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canDeleteAndEmptyItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canDeleteAndEmptyItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canDeleteAndEmptyItemAt(int n) {
        return this.canDeleteAndEmptyItemAt(this.pGWItemList, n);
    }

    public boolean canDeleteAndEmptyItemsAt(int[] nArray) {
        boolean bl = this.canDeleteAndEmptyItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public void deleteAndEmptyItem(Item item) {
        this.deleteAndEmptyItem(this.pGWItemList, item.getPointer());
    }

    public boolean deleteAndEmptyItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.deleteAndEmptyItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean deleteAndEmptyItemAt(int n) {
        this.rangeCheck(n);
        return this.deleteAndEmptyItemAt(this.pGWItemList, n);
    }

    public boolean deleteAndEmptyItemsAt(int[] nArray) {
        boolean bl = this.deleteAndEmptyItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canUndeleteItem(Item item) {
        boolean bl = this.canUndeleteItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canUndeleteItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canUndeleteItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canUndeleteItemAt(int n) {
        return this.canUndeleteItemAt(this.pGWItemList, n);
    }

    public boolean canUndeleteItemsAt(int[] nArray) {
        boolean bl = this.canUndeleteItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean undeleteItem(Item item) {
        boolean bl = this.undeleteItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean undeleteItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.undeleteItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean undeleteItemAt(int n) {
        this.rangeCheck(n);
        boolean bl = this.undeleteItemAt(this.pGWItemList, n);
        return bl;
    }

    public boolean undeleteItemsAt(int[] nArray) {
        boolean bl = this.undeleteItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canMarkItemPrivate(Item item) {
        boolean bl = this.canMarkItemPrivate(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canMarkItemsPrivate(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canMarkItemsPrivate(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canMarkItemPrivateAt(int n) {
        boolean bl = this.canMarkItemPrivateAt(this.pGWItemList, n);
        return bl;
    }

    public boolean canMarkItemsPrivateAt(int[] nArray) {
        boolean bl = this.canMarkItemsPrivateAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean markItemPrivate(Item item) {
        boolean bl = this.markItemPrivate(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean markItemsPrivate(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.markItemsPrivate(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean markItemPrivateAt(int n) {
        boolean bl = this.markItemPrivateAt(this.pGWItemList, n);
        return bl;
    }

    public boolean markItemsPrivateAt(int[] nArray) {
        boolean bl = this.markItemsPrivateAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canMarkItemRead(Item item) {
        boolean bl = this.canMarkItemRead(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canMarkItemsRead(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canMarkItemsRead(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canMarkItemReadAt(int n) {
        boolean bl = this.canMarkItemReadAt(this.pGWItemList, n);
        return bl;
    }

    public boolean canMarkItemsReadAt(int[] nArray) {
        boolean bl = this.canMarkItemsReadAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean markItemRead(Item item) {
        boolean bl = this.markItemRead(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean markItemsRead(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.markItemsRead(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean markItemReadAt(int n) {
        boolean bl = this.markItemReadAt(this.pGWItemList, n);
        return bl;
    }

    public boolean markItemsReadAt(int[] nArray) {
        boolean bl = this.markItemsReadAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canPurgeItem(Item item) {
        boolean bl = this.canPurgeItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canPurgeItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canPurgeItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canPurgeItemAt(int n) {
        boolean bl = this.canPurgeItemAt(this.pGWItemList, n);
        return bl;
    }

    public boolean canPurgeItemsAt(int[] nArray) {
        boolean bl = this.canPurgeItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean purgeItem(Item item) {
        boolean bl = this.purgeItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean purgeItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.purgeItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean purgeItemAt(int n) {
        boolean bl = this.purgeItemAt(this.pGWItemList, n);
        return bl;
    }

    public boolean purgeItemsAt(int[] nArray) {
        boolean bl = this.purgeItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canRestoreItem(Item item) {
        boolean bl = this.canRestoreItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canRestoreItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canRestoreItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canRestoreItemAt(int n) {
        boolean bl = this.canRestoreItemAt(this.pGWItemList, n);
        return bl;
    }

    public boolean canRestoreItemsAt(int[] nArray) {
        boolean bl = this.canRestoreItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean restoreItem(Item item) {
        boolean bl = this.restoreItem(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean restoreItems(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.restoreItems(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean restoreItemAt(int n) {
        boolean bl = this.restoreItemAt(this.pGWItemList, n);
        return bl;
    }

    public boolean restoreItemsAt(int[] nArray) {
        boolean bl = this.restoreItemsAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canMarkItemReadLater(Item item) {
        boolean bl = this.canMarkItemReadLater(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean canMarkItemsReadLater(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canMarkItemsReadLater(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean canMarkItemReadLaterAt(int n) {
        boolean bl = this.canMarkItemReadLaterAt(this.pGWItemList, n);
        return bl;
    }

    public boolean canMarkItemsReadLaterAt(int[] nArray) {
        boolean bl = this.canMarkItemsReadLaterAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean markItemReadLater(Item item) {
        boolean bl = this.markItemReadLater(this.pGWItemList, item.getPointer());
        return bl;
    }

    public boolean markItemsReadLater(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.markItemsReadLater(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean markItemReadLaterAt(int n) {
        boolean bl = this.markItemReadLaterAt(this.pGWItemList, n);
        return bl;
    }

    public boolean markItemsReadLaterAt(int[] nArray) {
        boolean bl = this.markItemsReadLaterAt(this.pGWItemList, nArray);
        return bl;
    }

    public boolean canShowInChecklist(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.canShowInChecklist(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean isInChecklist(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.isInChecklist(this.pGWItemList, nArray);
        }
        return bl;
    }

    public boolean showInChecklist(Item[] itemArray, boolean bl) {
        boolean bl2 = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl2 = this.showInChecklist(this.pGWItemList, nArray, bl);
        }
        return bl2;
    }

    public Enumeration getEnumeration() {
        return new ItemEnumeration();
    }

    public void queryStop() {
        this.queryStop(this.pGWItemList);
    }

    public int findItem(int n, String string) {
        return this.findItem(this.pGWItemList, n, string);
    }

    public int indexOf(Item item) {
        return this.indexOf(this.pGWItemList, item.getPointer());
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return this.indexOf(this.pGWItemList, string, n);
    }

    public boolean canChecklistMoveDown(int n) {
        return this.canChecklistMoveDown(this.pGWItemList, n);
    }

    public boolean checklistMoveDown(int n) {
        return this.checklistMoveDown(this.pGWItemList, n);
    }

    public boolean canChecklistMoveUp(int n) {
        return this.canChecklistMoveUp(this.pGWItemList, n);
    }

    public boolean checklistMoveUp(int n) {
        return this.checklistMoveUp(this.pGWItemList, n);
    }

    public boolean canChecklistMoveToBottom(int n) {
        return this.canChecklistMoveToBottom(this.pGWItemList, n);
    }

    public boolean checklistMoveToBottom(int n) {
        return this.checklistMoveToBottom(this.pGWItemList, n);
    }

    public boolean canChecklistMoveToTop(int n) {
        return this.canChecklistMoveToTop(this.pGWItemList, n);
    }

    public boolean checklistMoveToTop(int n) {
        return this.checklistMoveToTop(this.pGWItemList, n);
    }

    public boolean checklistMoveTo(int n, int n2) {
        return this.checklistMoveTo(this.pGWItemList, n, n2);
    }

    public int handleJunkMailItem(int n, Item item) {
        return this.handleJunkMailItem(n, this.pGWItemList, item.getPointer());
    }

    public int handleJunkMailItems(int n, Item[] itemArray) {
        int n2 = 0;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            n2 = this.handleJunkMailItems(n, this.pGWItemList, nArray);
        }
        return n2;
    }

    public int handleJunkMailItemAt(int n, int n2) {
        return this.handleJunkMailItemAt(n, this.pGWItemList, n2);
    }

    public int handleJunkMailItemsAt(int n, int[] nArray) {
        return this.handleJunkMailItemsAt(n, this.pGWItemList, nArray);
    }

    public boolean canHandleJunkMailItem(int n, Item item) {
        int n2 = this.canHandleJunkMailItem(n, this.pGWItemList, item.getPointer());
        return n2 != 0;
    }

    public boolean canHandleJunkMailItems(int n, Item[] itemArray) {
        int n2 = 0;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            n2 = this.canHandleJunkMailItems(n, this.pGWItemList, nArray);
        }
        return n2 != 0;
    }

    public boolean canHandleJunkMailItemAt(int n, int n2) {
        int n3 = this.canHandleJunkMailItemAt(n, this.pGWItemList, n2);
        return n3 != 0;
    }

    public boolean canHandleJunkMailItemsAt(int n, int[] nArray) {
        int n2 = this.canHandleJunkMailItemsAt(n, this.pGWItemList, nArray);
        return n2 != 0;
    }

    public int canHandleJunkMailItem(Item item) {
        int n = this.canHandleJunkMailItem(0, this.pGWItemList, item.getPointer());
        return n;
    }

    public int canHandleJunkMailItems(Item[] itemArray) {
        int n = 0;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            n = this.canHandleJunkMailItems(0, this.pGWItemList, nArray);
        }
        return n;
    }

    public int canHandleJunkMailItemAt(int n) {
        int n2 = this.canHandleJunkMailItemAt(0, this.pGWItemList, n);
        return n2;
    }

    public int canHandleJunkMailItemsAt(int[] nArray) {
        int n = this.canHandleJunkMailItemsAt(0, this.pGWItemList, nArray);
        return n;
    }

    private Item[] createItemArray(int[] nArray) {
        Item[] itemArray = null;
        if (nArray != null) {
            itemArray = new Item[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                itemArray[i] = this.createItem(nArray[i]);
            }
        }
        return itemArray;
    }

    public Item[] getCalendarItems(Date date) {
        Item[] itemArray = this.createItemArray(this.getCalendarItemsAll(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getCalendarItems(Date date, int n) {
        Item[] itemArray = this.createItemArray(this.getCalendarItemsTypes(this.pGWItemList, EngineUtils.DateToFlaimTime(date), n));
        return itemArray;
    }

    public Item[] getAllDayEvents(Date date) {
        Item[] itemArray = this.createItemArray(this.getAllDayEvents(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getAppointments(Date date) {
        Item[] itemArray = this.createItemArray(this.getAppointments(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getNotes(Date date) {
        Item[] itemArray = this.createItemArray(this.getNotes(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getTasks(Date date) {
        Item[] itemArray = this.createItemArray(this.getTasks(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public void dispose() {
        if (this.pGWItemList != 0 || this.pEvents != 0) {
            this.dispose(this.pGWItemList, this.pEvents);
            this.pGWItemList = 0;
            this.pEvents = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void rangeCheck(int n) {
        if (n >= this.items.length || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.items.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contentsChanged(int n, int n2, int n3, int n4, int n5) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 0: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].CONTENTS_CHANGED (start/endTime): " + EngineUtils.flaimTimeToDate(n4) + ", " + EngineUtils.flaimTimeToDate(n5));
                    this.refreshItemList(n4, n5);
                    break;
                }
                case 3: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].ITEM_INSERTED (index): " + n2);
                    this.itemInserted(n2);
                    break;
                }
                case 5: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].ITEM_REMOVED (index): " + n2);
                    this.itemRemoved(n2);
                    break;
                }
                case 4: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].ITEM_MODIFIED (index): " + n2);
                    this.itemModified(n2);
                    break;
                }
                case 7: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].RANGE_INVALIDATED (start/endIndex): " + n2 + ", " + n3);
                    this.redrawItems(n2, n3);
                    break;
                }
                case 9: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].NOTIFY_DELETE_ALL_ITEMS");
                    this.deleteAllItems();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moreResultsAvailable(int n, int n2) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 1: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].MORE_RESULTS_AVAILABLE");
                    this.updateQueryResults();
                    break;
                }
                case 6: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].UPDATE_ITEM_COUNT (start): " + n2);
                    this.updateItemCount(n2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEmptyList(int n, int n2) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 8: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].NOTIFY_EMPTY_LIST (promptCode): " + n2);
                    this.notifyEmptyList(n2);
                }
            }
        }
    }

    private void notifyEmptyList(int n) {
        this.fireItemListEvent(8, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryResultsDone(int n) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 2: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].QUERY_RESULTS_DONE");
                    this.updateQueryDone();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemCount(int n) {
        ItemList itemList = this;
        synchronized (itemList) {
            Item[] itemArray = new Item[n];
            System.arraycopy(this.items, 0, itemArray, 0, this.items.length);
            this.items = itemArray;
        }
        this.fireItemListEvent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemInserted(int n) {
        if (n >= 0) {
            ItemList itemList = this;
            synchronized (itemList) {
                Item[] itemArray = new Item[this.items.length + 1];
                System.arraycopy(this.items, 0, itemArray, 0, n);
                itemArray[n] = null;
                int n2 = this.items.length - n;
                System.arraycopy(this.items, n, itemArray, n + 1, n2);
                this.items = itemArray;
            }
            this.fireItemListEvent(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemModified(int n) {
        boolean bl = false;
        ItemList itemList = this;
        synchronized (itemList) {
            if (n >= 0 && n < this.items.length) {
                this.items[n] = null;
                bl = true;
            }
        }
        if (bl) {
            this.fireItemListEvent(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemRemoved(int n) {
        boolean bl = false;
        ItemList itemList = this;
        synchronized (itemList) {
            if (this.items.length > 0 && n >= 0 && n < this.items.length) {
                Item[] itemArray = new Item[this.items.length - 1];
                System.arraycopy(this.items, 0, itemArray, 0, n);
                int n2 = itemArray.length - n;
                System.arraycopy(this.items, n + 1, itemArray, n, n2);
                this.items = itemArray;
                bl = true;
            }
        }
        if (bl) {
            this.fireItemListEvent(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawItems(int n, int n2) {
        int n3 = n < 0 ? 0 : n;
        int n4 = n2 < 0 || n2 >= this.items.length ? this.items.length : n2 + 1;
        int n5 = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            if (n5 != this.items.length || n == -1 && n2 == -1) {
                this.items = new Item[n5];
            } else {
                for (int i = n3; i < n4; ++i) {
                    this.items[i] = null;
                }
            }
        }
        this.fireItemListEvent(7, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshItemList(int n, int n2) {
        int n3 = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            this.items = new Item[n3];
        }
        this.fireItemListEvent(0, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllItems() {
        int n = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            this.items = new Item[n];
        }
        this.fireItemListEvent(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQueryResults() {
        int n = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            if (n != this.items.length) {
                this.items = new Item[n];
            }
        }
        this.fireItemListEvent(1);
    }

    private void updateQueryDone() {
        this.fireItemListEvent(2);
    }

    private void fireItemListEvent(int n) {
        this.fireItemListEvent(new ItemListEvent(this, n, 0));
    }

    private void fireItemListEvent(int n, int n2) {
        this.fireItemListEvent(new ItemListEvent(this, n, n2));
    }

    private void fireItemListEvent(int n, int n2, int n3) {
        this.fireItemListEvent(new ItemListEvent(this, n, n2, n3));
    }

    private void fireItemListEvent(final ItemListEvent itemListEvent) {
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ItemList.this.doFireItemListEvent(objectArray, itemListEvent);
                }
            });
        }
    }

    private void doFireItemListEvent(Object[] objectArray, ItemListEvent itemListEvent) {
        block6: for (int i = 1; i < objectArray.length; i += 2) {
            ItemListListener itemListListener = (ItemListListener)objectArray[i];
            switch (itemListEvent.getType()) {
                case 0: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    itemListListener.contentsChanged(itemListEvent);
                    continue block6;
                }
                case 1: {
                    itemListListener.moreResultsAvailable(itemListEvent);
                    continue block6;
                }
                case 2: {
                    itemListListener.queryResultsDone(itemListEvent);
                    continue block6;
                }
                case 8: {
                    continue block6;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ItemList.initIds();
    }

    private class ItemEnumeration
    implements Enumeration {
        int index = 0;

        private ItemEnumeration() {
        }

        public boolean hasMoreElements() {
            return this.index < ItemList.this.items.length;
        }

        public Object nextElement() {
            Item item = ItemList.this.getItemAt(this.index);
            ++this.index;
            return item;
        }
    }
}

