/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.engine.EngineUtils;
import java.util.Date;

public class JunkMailList {
    private int pJunkMailList = 0;

    private native int addItem(int var1, String var2);

    private native boolean deleteItem(int var1, int var2);

    private native void dispose(int var1);

    private native int getSize(int var1);

    private native boolean moveItem(int var1, int var2, int var3);

    private native int setAddressTypeFilter(int var1, int var2);

    private native boolean sort(int var1, int var2, boolean var3);

    private native String getItemAddress(int var1, int var2);

    private native int getItemAddressType(int var1, int var2);

    private native int getItemListType(int var1, int var2);

    private native int getItemUseCount(int var1, int var2);

    private native int getItemLastUsedDate(int var1, int var2);

    private native String getItemLastUsedDateString(int var1, int var2);

    public JunkMailList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pJunkMailList = n;
    }

    public int getSize() {
        return this.getSize(this.pJunkMailList);
    }

    public int setAddressTypeFilter(int n) {
        int n2 = this.setAddressTypeFilter(this.pJunkMailList, n);
        return n2;
    }

    public boolean sort(int n, boolean bl) {
        return this.sort(this.pJunkMailList, n, bl);
    }

    public int addItem(String string) {
        return this.addItem(this.pJunkMailList, string);
    }

    public boolean deleteItem(int n) {
        this.rangeCheck(n);
        return this.deleteItem(this.pJunkMailList, n);
    }

    public boolean moveItem(int n, int n2) {
        this.rangeCheck(n);
        return this.moveItem(this.pJunkMailList, n, n2);
    }

    public String getItemAddress(int n) {
        this.rangeCheck(n);
        return this.getItemAddress(this.pJunkMailList, n);
    }

    public int getItemAddressType(int n) {
        this.rangeCheck(n);
        return this.getItemAddressType(this.pJunkMailList, n);
    }

    public int getItemListType(int n) {
        this.rangeCheck(n);
        return this.getItemListType(this.pJunkMailList, n);
    }

    public int getItemUseCount(int n) {
        this.rangeCheck(n);
        return this.getItemUseCount(this.pJunkMailList, n);
    }

    public Date getItemLastUsedDate(int n) {
        this.rangeCheck(n);
        int n2 = this.getItemLastUsedDate(this.pJunkMailList, n);
        return EngineUtils.flaimTimeToDate(n2);
    }

    public String getItemLastUsedDateString(int n) {
        this.rangeCheck(n);
        return this.getItemLastUsedDateString(this.pJunkMailList, n);
    }

    private void rangeCheck(int n) {
        int n2 = this.getSize(this.pJunkMailList);
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    public void dispose() {
        if (this.pJunkMailList != 0) {
            this.dispose(this.pJunkMailList);
            this.pJunkMailList = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

