/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.folder;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.folder.CalendarFolder;
import com.novell.gw.folder.ContactsFolder;
import com.novell.gw.folder.FolderCountInfo;
import com.novell.gw.folder.FolderEvent;
import com.novell.gw.folder.FolderListener;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.folder.JunkMailFolder;
import com.novell.gw.folder.SharedFolderReference;
import com.novell.gw.folder.TrashFolder;
import com.novell.gw.message.Message;
import com.novell.gw.util.Debug;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class Folder
extends Item {
    public static final int FOLDER_TYPE_NORMAL = 0;
    public static final int FOLDER_TYPE_QUERY = 4;
    public static final int FOLDER_TYPE_USER = 6;
    public static final int FOLDER_TYPE_UNIVERSAL = 7;
    public static final int FOLDER_TYPE_TRASH = 9;
    public static final int FOLDER_TYPE_CALENDAR = 10;
    public static final int FOLDER_TYPE_CABINET = 12;
    public static final int FOLDER_TYPE_WORK_IN_PROGRESS = 13;
    public static final int FOLDER_TYPE_DOCUMENTS = 16;
    public static final int FOLDER_TYPE_OUTBOX = 25;
    public static final int FOLDER_TYPE_CHECKLIST = 26;
    public static final int FOLDER_TYPE_CONTACTS = 27;
    private int iTmpReceivedCount;
    private int iTmpSentCount;
    private int iTmpPostedCount;
    private int iTmpDraftCount;
    private int iTmpFoldersCount;
    private int pGWFolder = 0;
    private int pEvents = 0;
    private int iUniqueId = -1;
    private int iType = -1;
    private String ownerName = null;
    private int iDisplayCount = 0;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$novell$gw$folder$FolderListener;

    private static native void initIds();

    private native boolean canDelete(int var1);

    private native boolean canHaveChildren(int var1);

    private native boolean canRename(int var1);

    private native boolean canSelectFirstUnreadPropertyOption(int var1);

    private native boolean canShare(int var1);

    private native boolean canSortSubFolders(int var1);

    private native int createSubFolder(int var1, String var2, int var3);

    private native boolean delete(int var1);

    private native boolean deleteItems(int var1);

    private native void releasePtr(int var1);

    private native void releaseEvents(int var1, int var2);

    private native void emptyJunkMail(int var1);

    private native void emptyTrash(int var1);

    private native void executeRules(int var1, boolean var2) throws EngineException;

    private native int getContents(int var1, int var2);

    private native boolean getCountOfContents(int var1);

    private native String getDescription(int var1);

    private native int getDisplayCount(int var1);

    private native String getFullPath(int var1);

    private native int getId(int var1);

    private native int getMonthBusyDays(int var1, int var2, int var3, int var4);

    private native String getName(int var1);

    private native String getOwnerName(int var1);

    private native int getParent(int var1);

    private native boolean getSelectFirstUnreadItemState(int var1);

    private native int getSharedList(int var1);

    private native int[] getSubFolders(int var1);

    private static native int getType(int var0);

    private native boolean hasUnreadItems(int var1);

    private native boolean isDeleted(int var1);

    private static native boolean isJunkMailFolder(int var0);

    private native boolean isJunkMailFolderAndActive(int var1);

    private native boolean isSharedFolder(int var1);

    private static native boolean isSharedFolderReference(int var0);

    private native boolean isCalendarFolder(int var1);

    private native boolean isCalendarChildFolder(int var1);

    private native boolean isSystemFolder(int var1);

    private native int getSequenceNumber(int var1);

    private native boolean moveTo(int var1, int var2, int var3, int var4);

    private native boolean setDescription(int var1, String var2);

    private native boolean setName(int var1, String var2);

    private native boolean setSelectFirstUnreadItemState(int var1, boolean var2);

    private native boolean setSharedList(int var1, int var2) throws EngineException;

    private native boolean sortSubFolders(int var1);

    private native int subscribeToEvents(int var1);

    private native int getAttachTransferOptions(int var1, int var2);

    private native int getItemTransferOptions(int var1, int var2);

    private native int getTransferItems(int var1);

    private native boolean transferAttachData(int var1, int var2, int var3);

    private native boolean transferItemData(int var1, int var2, int var3);

    private native int getCustomDisplaySettings(int var1);

    private native int getDisplaySettings(int var1);

    private native boolean linkTo(int var1, int var2);

    public Folder() {
    }

    Folder(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWFolder = n;
        this.iDisplayCount = this.getDisplayCount(n);
        this.pEvents = this.subscribeToEvents(n);
    }

    public static Folder createFolder(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        Folder folder = null;
        int n2 = Folder.getType(n);
        folder = n2 == 10 ? new CalendarFolder(n) : (n2 == 27 ? new ContactsFolder(n) : (n2 == 9 ? new TrashFolder(n) : (n2 == 0 && Folder.isJunkMailFolder(n) ? new JunkMailFolder(n) : (n2 == 0 && Folder.isSharedFolderReference(n) ? new SharedFolderReference(n) : new Folder(n)))));
        return folder;
    }

    public void addFolderListener(FolderListener folderListener) {
        this.listenerList.add(class$com$novell$gw$folder$FolderListener == null ? (class$com$novell$gw$folder$FolderListener = Folder.class$("com.novell.gw.folder.FolderListener")) : class$com$novell$gw$folder$FolderListener, folderListener);
    }

    public void removeFolderListener(FolderListener folderListener) {
        this.listenerList.remove(class$com$novell$gw$folder$FolderListener == null ? (class$com$novell$gw$folder$FolderListener = Folder.class$("com.novell.gw.folder.FolderListener")) : class$com$novell$gw$folder$FolderListener, folderListener);
    }

    public boolean canDelete() {
        return this.canDelete(this.pGWFolder);
    }

    public boolean canHaveChildren() {
        return this.canHaveChildren(this.pGWFolder);
    }

    public boolean canRename() {
        return this.canRename(this.pGWFolder);
    }

    public boolean canSelectFirstUnreadPropertyOption() {
        return this.canSelectFirstUnreadPropertyOption(this.pGWFolder);
    }

    public boolean canShare() {
        return this.canShare(this.pGWFolder);
    }

    public boolean canSortSubFolders() {
        return this.canSortSubFolders(this.pGWFolder);
    }

    public Folder createSubFolder(String string, int n) {
        Folder folder = null;
        int n2 = this.createSubFolder(this.pGWFolder, string, n);
        if (n2 != 0) {
            folder = DataStore.getFolder(n2);
        }
        return folder;
    }

    public boolean delete() {
        return this.delete(this.pGWFolder);
    }

    public boolean deleteItems() {
        return this.deleteItems(this.pGWFolder);
    }

    public void releasePtr() {
        if (this.pGWFolder != 0) {
            this.releasePtr(this.pGWFolder);
        }
    }

    public void releaseEvents() {
        if (this.pGWFolder != 0) {
            this.releaseEvents(this.pGWFolder, this.pEvents);
        }
    }

    public void dispose() {
        this.releaseEvents(this.pGWFolder, this.pEvents);
        this.releasePtr(this.pGWFolder);
        this.pGWFolder = 0;
        this.pEvents = 0;
    }

    protected void emptyJunkMail() {
        this.emptyJunkMail(this.pGWFolder);
    }

    protected void emptyTrash() {
        this.emptyTrash(this.pGWFolder);
    }

    public void executeRules(boolean bl) throws EngineException {
        this.executeRules(this.pGWFolder, bl);
    }

    public static Folder findFolder(Folder[] folderArray, int n) {
        for (int i = 0; i < folderArray.length; ++i) {
            Folder folder = folderArray[i];
            if (folder.getId() == n) {
                return folder;
            }
            if ((folder = Folder.findFolder(folder.getSubFolders(), n)) == null) continue;
            return folder;
        }
        return null;
    }

    public Folder findFolder(int n) {
        Folder[] folderArray = this.getSubFolders();
        return Folder.findFolder(folderArray, n);
    }

    public static Folder findFolder(Folder[] folderArray, String string) {
        for (int i = 0; i < folderArray.length; ++i) {
            Folder folder = folderArray[i];
            if (folder.getName().equalsIgnoreCase(string)) {
                return folder;
            }
            if ((folder = Folder.findFolder(folder.getSubFolders(), string)) == null) continue;
            return folder;
        }
        return null;
    }

    public Item findItem(int n) {
        ItemList itemList = this.getContents();
        int n2 = itemList.getSize();
        for (int i = 0; i < n2; ++i) {
            Folder folder;
            Item item;
            Message message;
            Item item2 = itemList.getItemAt(i);
            if (item2.getId() == n) {
                return item2;
            }
            if (!(item2 instanceof Message) || 512 != (message = (Message)item2).getItemType() || (item = (folder = (Folder)item2).findItem(n)) == null) continue;
            return item;
        }
        return null;
    }

    public ItemList getContents() {
        return this.getContents(null);
    }

    public ItemList getContents(ItemListFilter itemListFilter) {
        int n = 0;
        if (itemListFilter != null) {
            n = itemListFilter.getPointer();
        }
        int n2 = this.getContents(this.pGWFolder, n);
        return ItemList.createItemList(n2);
    }

    public FolderCountInfo getCountOfContents() {
        this.iTmpReceivedCount = 0;
        this.iTmpSentCount = 0;
        this.iTmpPostedCount = 0;
        this.iTmpDraftCount = 0;
        this.iTmpFoldersCount = 0;
        this.getCountOfContents(this.pGWFolder);
        return new FolderCountInfo(this.iTmpReceivedCount, this.iTmpSentCount, this.iTmpPostedCount, this.iTmpDraftCount, this.iTmpFoldersCount);
    }

    public int getMonthBusyDays(ItemListFilter itemListFilter, int n, int n2) {
        int n3 = 0;
        if (itemListFilter != null) {
            n3 = itemListFilter.getPointer();
        }
        int n4 = this.getMonthBusyDays(this.pGWFolder, n3, n, n2);
        return n4;
    }

    public String getDescription() {
        return this.getDescription(this.pGWFolder);
    }

    public int getDisplayCount() {
        return this.iDisplayCount;
    }

    public boolean getSelectFirstUnreadItemState() {
        return this.getSelectFirstUnreadItemState(this.pGWFolder);
    }

    public FolderSharedList getSharedList() {
        FolderSharedList folderSharedList = null;
        int n = this.getSharedList(this.pGWFolder);
        if (n != 0) {
            folderSharedList = new FolderSharedList(n);
        }
        return folderSharedList;
    }

    public String getFullPath() {
        return this.getFullPath(this.pGWFolder);
    }

    public int getId() {
        if (this.iUniqueId == -1) {
            this.iUniqueId = this.getId(this.pGWFolder);
        }
        return this.iUniqueId;
    }

    public String getName() {
        return this.getName(this.pGWFolder);
    }

    public String getOwnerName() {
        if (this.ownerName == null) {
            this.ownerName = this.getOwnerName(this.pGWFolder);
        }
        return this.ownerName;
    }

    public Folder getParent() {
        Folder folder = null;
        int n = this.getParent(this.pGWFolder);
        if (n > 0) {
            folder = DataStore.getFolder(n);
        }
        return folder;
    }

    public int getPointer() {
        return this.pGWFolder;
    }

    public Folder[] getSubFolders() {
        int[] nArray = this.getSubFolders(this.pGWFolder);
        int n = nArray != null ? nArray.length : 0;
        Folder[] folderArray = new Folder[n];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                folderArray[i] = DataStore.getFolder(nArray[i]);
            }
        }
        return folderArray;
    }

    public int getType() {
        if (this.iType == -1) {
            this.iType = Folder.getType(this.pGWFolder);
        }
        return this.iType;
    }

    public TransferItems getTransferItems() {
        TransferItems transferItems = null;
        int n = this.getTransferItems(this.pGWFolder);
        if (n != 0) {
            transferItems = new TransferItems(n);
        }
        return transferItems;
    }

    public int getTransferOptions(TransferAttachments transferAttachments) {
        return this.getAttachTransferOptions(this.pGWFolder, transferAttachments != null ? transferAttachments.getPointer() : 0);
    }

    public int getTransferOptions(TransferItems transferItems) {
        return this.getItemTransferOptions(this.pGWFolder, transferItems != null ? transferItems.getHandle() : 0);
    }

    public boolean transfer(TransferAttachments transferAttachments, int n) {
        return this.transferAttachData(this.pGWFolder, transferAttachments != null ? transferAttachments.getPointer() : 0, n);
    }

    public boolean transfer(TransferItems transferItems, int n) {
        return this.transferItemData(this.pGWFolder, transferItems != null ? transferItems.getHandle() : 0, n);
    }

    public boolean hasUnreadItems() {
        return this.hasUnreadItems(this.pGWFolder);
    }

    public boolean isDeleted() {
        return this.isDeleted(this.pGWFolder);
    }

    public boolean isJunkMailFolder() {
        return Folder.isJunkMailFolder(this.pGWFolder);
    }

    public boolean isJunkMailFolderAndActive() {
        return this.isJunkMailFolderAndActive(this.pGWFolder);
    }

    public boolean isSharedFolder() {
        return this.isSharedFolder(this.pGWFolder);
    }

    public boolean isSharedFolderReference() {
        return Folder.isSharedFolderReference(this.pGWFolder);
    }

    public boolean isCalendarFolder() {
        return this.isCalendarFolder(this.pGWFolder);
    }

    public boolean isCalendarChildFolder() {
        return this.isCalendarChildFolder(this.pGWFolder);
    }

    public boolean isSystemFolder() {
        return this.isSystemFolder(this.pGWFolder);
    }

    public int getSequenceNumber() {
        return this.getSequenceNumber(this.pGWFolder);
    }

    public boolean moveTo(Folder folder, int n) {
        boolean bl = this.moveTo(this.pGWFolder, folder != null ? folder.getPointer() : 0, n, 0);
        return bl;
    }

    public boolean moveTo(Folder folder, Folder folder2) {
        boolean bl = this.moveTo(this.pGWFolder, folder != null ? folder.getPointer() : 0, 0, folder2 != null ? folder2.getPointer() : 0);
        return bl;
    }

    public boolean setDescription(String string) {
        return this.setDescription(this.pGWFolder, string);
    }

    public boolean setSelectFirstUnreadItemState(boolean bl) {
        return this.setSelectFirstUnreadItemState(this.pGWFolder, bl);
    }

    public boolean setName(String string) {
        return this.setName(this.pGWFolder, string);
    }

    public boolean setSharedList(FolderSharedList folderSharedList) {
        boolean bl = false;
        try {
            bl = this.setSharedList(this.pGWFolder, folderSharedList != null ? folderSharedList.getPointer() : 0);
        }
        catch (EngineException engineException) {
            // empty catch block
        }
        return bl;
    }

    public boolean sortSubFolders() {
        return this.sortSubFolders(this.pGWFolder);
    }

    public DisplaySettings getDisplaySettings() {
        DisplaySettings displaySettings = null;
        int n = this.getDisplaySettings(this.pGWFolder);
        if (n != 0) {
            displaySettings = new DisplaySettings(n);
        }
        return displaySettings;
    }

    public DisplaySettings getCustomDisplaySettings() {
        DisplaySettings displaySettings = null;
        int n = this.getCustomDisplaySettings(this.pGWFolder);
        if (n != 0) {
            displaySettings = new DisplaySettings(n);
        }
        return displaySettings;
    }

    public boolean linkTo(DisplaySettings displaySettings) {
        if (displaySettings != null) {
            return this.linkTo(this.pGWFolder, displaySettings != null ? displaySettings.getPointer() : 0);
        }
        return false;
    }

    private void updateDisplayCount(int n) {
        this.iDisplayCount = n;
        Debug.trace("FolderEvent[" + this.pGWFolder + "].DISPLAY_COUNT_CHANGED (newCount): " + n);
        this.fireFolderEvent(n);
    }

    private void fireFolderEvent(int n) {
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            final FolderEvent folderEvent = new FolderEvent(this, 0, n);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Folder.this.doFireFolderEvent(objectArray, folderEvent);
                }
            });
        }
    }

    private void doFireFolderEvent(Object[] objectArray, FolderEvent folderEvent) {
        for (int i = 1; i < objectArray.length; i += 2) {
            FolderListener folderListener = (FolderListener)objectArray[i];
            folderListener.updateDisplayCount(folderEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Folder.initIds();
    }
}

